/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai;

import java.util.ArrayList;
import zombie.ai.KnownBlockedEdges;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;

public final class MapKnowledge {
    private final ArrayList<KnownBlockedEdges> knownBlockedEdges = new ArrayList();

    public ArrayList<KnownBlockedEdges> getKnownBlockedEdges() {
        return this.knownBlockedEdges;
    }

    public KnownBlockedEdges getKnownBlockedEdges(int n, int n2, int n3) {
        for (int i = 0; i < this.knownBlockedEdges.size(); ++i) {
            KnownBlockedEdges knownBlockedEdges = this.knownBlockedEdges.get(i);
            if (knownBlockedEdges.x != n || knownBlockedEdges.y != n2 || knownBlockedEdges.z != n3) continue;
            return knownBlockedEdges;
        }
        return null;
    }

    private KnownBlockedEdges createKnownBlockedEdges(int n, int n2, int n3) {
        assert (this.getKnownBlockedEdges(n, n2, n3) == null);
        KnownBlockedEdges knownBlockedEdges = KnownBlockedEdges.alloc();
        knownBlockedEdges.init(n, n2, n3);
        this.knownBlockedEdges.add(knownBlockedEdges);
        return knownBlockedEdges;
    }

    public KnownBlockedEdges getOrCreateKnownBlockedEdges(int n, int n2, int n3) {
        KnownBlockedEdges knownBlockedEdges = this.getKnownBlockedEdges(n, n2, n3);
        if (knownBlockedEdges == null) {
            knownBlockedEdges = this.createKnownBlockedEdges(n, n2, n3);
        }
        return knownBlockedEdges;
    }

    private void releaseIfEmpty(KnownBlockedEdges knownBlockedEdges) {
        if (!knownBlockedEdges.n && !knownBlockedEdges.w) {
            this.knownBlockedEdges.remove(knownBlockedEdges);
            knownBlockedEdges.release();
        }
    }

    public void setKnownBlockedEdgeW(int n, int n2, int n3, boolean bl) {
        KnownBlockedEdges knownBlockedEdges = this.getOrCreateKnownBlockedEdges(n, n2, n3);
        knownBlockedEdges.w = bl;
        this.releaseIfEmpty(knownBlockedEdges);
    }

    public void setKnownBlockedEdgeN(int n, int n2, int n3, boolean bl) {
        KnownBlockedEdges knownBlockedEdges = this.getOrCreateKnownBlockedEdges(n, n2, n3);
        knownBlockedEdges.n = bl;
        this.releaseIfEmpty(knownBlockedEdges);
    }

    public void setKnownBlockedDoor(IsoDoor isoDoor, boolean bl) {
        IsoGridSquare isoGridSquare = isoDoor.getSquare();
        if (isoDoor.getNorth()) {
            this.setKnownBlockedEdgeN(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        } else {
            this.setKnownBlockedEdgeW(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        }
    }

    public void setKnownBlockedDoor(IsoThumpable isoThumpable, boolean bl) {
        if (!isoThumpable.isDoor()) {
            return;
        }
        IsoGridSquare isoGridSquare = isoThumpable.getSquare();
        if (isoThumpable.getNorth()) {
            this.setKnownBlockedEdgeN(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        } else {
            this.setKnownBlockedEdgeW(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        }
    }

    public void setKnownBlockedWindow(IsoWindow isoWindow, boolean bl) {
        IsoGridSquare isoGridSquare = isoWindow.getSquare();
        if (isoWindow.getNorth()) {
            this.setKnownBlockedEdgeN(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        } else {
            this.setKnownBlockedEdgeW(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        }
    }

    public void setKnownBlockedWindowFrame(IsoObject isoObject, boolean bl) {
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (IsoWindowFrame.isWindowFrame(isoObject, true)) {
            this.setKnownBlockedEdgeN(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        } else if (IsoWindowFrame.isWindowFrame(isoObject, false)) {
            this.setKnownBlockedEdgeW(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        }
    }

    public void forget() {
        KnownBlockedEdges.releaseAll(this.knownBlockedEdges);
        this.knownBlockedEdges.clear();
    }
}

