/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.logger.LoggerManager;
import zombie.core.logger.ZLogger;
import zombie.iso.IsoGridSquare;
import zombie.iso.areas.IsoRoom;

public final class ZombieSpawnRecorder {
    public static final ZombieSpawnRecorder instance = new ZombieSpawnRecorder();
    public ZLogger m_logger;
    private final StringBuilder m_stringBuilder = new StringBuilder();

    public void init() {
        if (this.m_logger != null) {
            this.m_logger.write("================================================================================");
            return;
        }
        LoggerManager.init();
        LoggerManager.createLogger("ZombieSpawn", Core.bDebug);
        this.m_logger = LoggerManager.getLogger("ZombieSpawn");
    }

    public void quit() {
        if (this.m_logger == null) {
            return;
        }
        if (this.m_stringBuilder.length() > 0) {
            this.m_logger.write(this.m_stringBuilder.toString());
            this.m_stringBuilder.setLength(0);
        }
    }

    public void record(IsoZombie isoZombie, String string) {
        if (isoZombie == null || isoZombie.getCurrentSquare() == null) {
            return;
        }
        if (this.m_logger == null) {
            return;
        }
        IsoGridSquare isoGridSquare = isoZombie.getCurrentSquare();
        this.m_stringBuilder.append("reason = ");
        this.m_stringBuilder.append(string);
        this.m_stringBuilder.append(" x,y,z = ");
        this.m_stringBuilder.append(isoGridSquare.x);
        this.m_stringBuilder.append(',');
        this.m_stringBuilder.append(isoGridSquare.y);
        this.m_stringBuilder.append(',');
        this.m_stringBuilder.append(isoGridSquare.z);
        IsoRoom isoRoom = isoGridSquare.getRoom();
        if (isoRoom != null && isoRoom.def != null) {
            this.m_stringBuilder.append(" room = ");
            this.m_stringBuilder.append(isoRoom.def.name);
        }
        this.m_stringBuilder.append(System.lineSeparator());
        if (this.m_stringBuilder.length() >= 1024) {
            this.m_logger.write(this.m_stringBuilder.toString());
            this.m_stringBuilder.setLength(0);
        }
    }

    public void record(ArrayList<IsoZombie> arrayList, String string) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.record(arrayList.get(i), string);
        }
    }
}

