/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import java.util.Stack;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.popman.MPDebugInfo;
import zombie.popman.ZombiePopulationManager;

public final class WorldSoundManager {
    public static final WorldSoundManager instance = new WorldSoundManager();
    public final ArrayList<WorldSound> SoundList = new ArrayList();
    private final Stack<WorldSound> freeSounds = new Stack();
    private static final ResultBiggestSound resultBiggestSound = new ResultBiggestSound();

    public void init(IsoCell isoCell) {
    }

    public void initFrame() {
    }

    public void KillCell() {
        this.freeSounds.addAll(this.SoundList);
        this.SoundList.clear();
    }

    public WorldSound getNew() {
        if (this.freeSounds.isEmpty()) {
            return new WorldSound();
        }
        return this.freeSounds.pop();
    }

    public WorldSound addSound(Object object, int n, int n2, int n3, int n4, int n5) {
        return this.addSound(object, n, n2, n3, n4, n5, false, 0.0f, 1.0f);
    }

    public WorldSound addSound(Object object, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return this.addSound(object, n, n2, n3, n4, n5, bl, 0.0f, 1.0f);
    }

    public WorldSound addSound(Object object, int n, int n2, int n3, int n4, int n5, boolean bl, float f, float f2) {
        return this.addSound(object, n, n2, n3, n4, n5, bl, f, f2, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldSound addSound(Object object, int n, int n2, int n3, int n4, int n5, boolean bl, float f, float f2, boolean bl2, boolean bl3, boolean bl4) {
        WorldSound worldSound;
        if (n4 <= 0) {
            return null;
        }
        ArrayList<WorldSound> arrayList = this.SoundList;
        synchronized (arrayList) {
            worldSound = this.getNew().init(object, n, n2, n3, n4, n5, bl, f, f2);
            if (object == null) {
                worldSound.sourceIsZombie = bl2;
            }
            if (!GameServer.bServer) {
                int n6 = SandboxOptions.instance.Lore.Hearing.getValue();
                if (n6 == 4) {
                    n6 = 1;
                }
                int n7 = (int)PZMath.ceil((float)n4 * this.getHearingMultiplier(n6));
                int n8 = (n - n7) / 10;
                int n9 = (n2 - n7) / 10;
                int n10 = (int)Math.ceil(((float)n + (float)n7) / 10.0f);
                int n11 = (int)Math.ceil(((float)n2 + (float)n7) / 10.0f);
                for (int i = n8; i < n10; ++i) {
                    for (int j = n9; j < n11; ++j) {
                        IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunk(i, j);
                        if (isoChunk == null) continue;
                        isoChunk.SoundList.add(worldSound);
                    }
                }
            }
            this.SoundList.add(worldSound);
            ZombiePopulationManager.instance.addWorldSound(worldSound, bl3);
        }
        if (bl3) {
            if (GameClient.bClient) {
                GameClient.instance.sendWorldSound(worldSound);
            } else if (GameServer.bServer) {
                GameServer.sendWorldSound(worldSound, null);
            }
        }
        if (Core.bDebug && GameClient.bClient) {
            MPDebugInfo.AddDebugSound(worldSound);
        }
        return worldSound;
    }

    public WorldSound addSoundRepeating(Object object, int n, int n2, int n3, int n4, int n5, boolean bl) {
        WorldSound worldSound = this.addSound(object, n, n2, n3, n4, n5, bl, 0.0f, 1.0f);
        if (worldSound != null) {
            worldSound.bRepeating = true;
        }
        return worldSound;
    }

    public WorldSound getSoundZomb(IsoZombie isoZombie) {
        IsoChunk isoChunk = null;
        if (isoZombie.soundSourceTarget == null) {
            return null;
        }
        if (isoZombie.getCurrentSquare() == null) {
            return null;
        }
        isoChunk = isoZombie.getCurrentSquare().chunk;
        ArrayList<WorldSound> arrayList = null;
        arrayList = isoChunk == null || GameServer.bServer ? this.SoundList : isoChunk.SoundList;
        for (int i = 0; i < arrayList.size(); ++i) {
            WorldSound worldSound = arrayList.get(i);
            if (isoZombie.soundSourceTarget != worldSound.source) continue;
            return worldSound;
        }
        return null;
    }

    public ResultBiggestSound getBiggestSoundZomb(int n, int n2, int n3, boolean bl, IsoZombie isoZombie) {
        float f = -1000000.0f;
        WorldSound worldSound = null;
        IsoChunk isoChunk = null;
        if (isoZombie != null) {
            if (isoZombie.getCurrentSquare() == null) {
                return resultBiggestSound.init(null, 0.0f);
            }
            isoChunk = isoZombie.getCurrentSquare().chunk;
        }
        ArrayList<WorldSound> arrayList = null;
        arrayList = isoChunk == null || GameServer.bServer ? this.SoundList : isoChunk.SoundList;
        for (int i = 0; i < arrayList.size(); ++i) {
            float f2;
            float f3;
            float f4;
            WorldSound worldSound2 = arrayList.get(i);
            if (worldSound2 == null || worldSound2.radius == 0 || (f4 = IsoUtils.DistanceToSquared(n, n2, worldSound2.x, worldSound2.y)) > (f3 = (float)worldSound2.radius * this.getHearingMultiplier(isoZombie)) * f3 || f4 < worldSound2.zombieIgnoreDist * worldSound2.zombieIgnoreDist && n3 == worldSound2.z || bl && worldSound2.sourceIsZombie) continue;
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(worldSound2.x, worldSound2.y, worldSound2.z);
            IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            float f5 = f4 / (f3 * f3);
            if (isoGridSquare != null && isoGridSquare2 != null && isoGridSquare.getRoom() != isoGridSquare2.getRoom()) {
                f5 *= 1.2f;
                if (isoGridSquare2.getRoom() == null || isoGridSquare.getRoom() == null) {
                    f5 *= 1.4f;
                }
            }
            if ((f5 = 1.0f - f5) <= 0.0f) continue;
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            if (!((f2 = (float)worldSound2.volume * f5) > f)) continue;
            f = f2;
            worldSound = worldSound2;
        }
        return resultBiggestSound.init(worldSound, f);
    }

    public float getSoundAttract(WorldSound worldSound, IsoZombie isoZombie) {
        float f;
        if (worldSound == null) {
            return 0.0f;
        }
        if (worldSound.radius == 0) {
            return 0.0f;
        }
        float f2 = IsoUtils.DistanceToSquared(isoZombie.x, isoZombie.y, worldSound.x, worldSound.y);
        if (f2 > (f = (float)worldSound.radius * this.getHearingMultiplier(isoZombie)) * f) {
            return 0.0f;
        }
        if (f2 < worldSound.zombieIgnoreDist * worldSound.zombieIgnoreDist && isoZombie.z == (float)worldSound.z) {
            return 0.0f;
        }
        if (worldSound.sourceIsZombie) {
            return 0.0f;
        }
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(worldSound.x, worldSound.y, worldSound.z);
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(isoZombie.x, isoZombie.y, isoZombie.z);
        float f3 = f2 / (f * f);
        if (isoGridSquare != null && isoGridSquare2 != null && isoGridSquare.getRoom() != isoGridSquare2.getRoom()) {
            f3 *= 1.2f;
            if (isoGridSquare2.getRoom() == null || isoGridSquare.getRoom() == null) {
                f3 *= 1.4f;
            }
        }
        if ((f3 = 1.0f - f3) <= 0.0f) {
            return 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        float f4 = (float)worldSound.volume * f3;
        return f4;
    }

    public float getStressFromSounds(int n, int n2, int n3) {
        float f = 0.0f;
        for (int i = 0; i < this.SoundList.size(); ++i) {
            WorldSound worldSound = this.SoundList.get(i);
            if (!worldSound.stresshumans || worldSound.radius == 0) continue;
            float f2 = IsoUtils.DistanceManhatten(n, n2, worldSound.x, worldSound.y);
            float f3 = f2 / (float)worldSound.radius;
            if ((f3 = 1.0f - f3) <= 0.0f) continue;
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            float f4 = f3 * worldSound.stressMod;
            f += f4;
        }
        return f;
    }

    public void update() {
        int n;
        if (!GameServer.bServer) {
            for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[n];
                if (isoChunkMap.ignore) continue;
                for (int i = 0; i < IsoChunkMap.ChunkGridWidth; ++i) {
                    for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                        IsoChunk isoChunk = isoChunkMap.getChunk(j, i);
                        if (isoChunk == null) continue;
                        isoChunk.updateSounds();
                    }
                }
            }
        }
        n = this.SoundList.size();
        for (int i = 0; i < n; ++i) {
            WorldSound worldSound = this.SoundList.get(i);
            if (worldSound == null || worldSound.life <= 0) {
                this.SoundList.remove(i);
                this.freeSounds.push(worldSound);
                --i;
                --n;
                continue;
            }
            --worldSound.life;
        }
    }

    public void render() {
        if (!Core.bDebug || !DebugOptions.instance.WorldSoundRender.getValue()) {
            return;
        }
        if (GameClient.bClient) {
            return;
        }
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return;
        }
        int n = SandboxOptions.instance.Lore.Hearing.getValue();
        if (n == 4) {
            n = 2;
        }
        float f = this.getHearingMultiplier(n);
        for (int i = 0; i < this.SoundList.size(); ++i) {
            WorldSound worldSound = this.SoundList.get(i);
            float f2 = (float)worldSound.radius * f;
            for (double d = 0.0; d < Math.PI * 2; d += 0.15707963267948966) {
                this.DrawIsoLine((float)worldSound.x + f2 * (float)Math.cos(d), (float)worldSound.y + f2 * (float)Math.sin(d), (float)worldSound.x + f2 * (float)Math.cos(d + 0.15707963267948966), (float)worldSound.y + f2 * (float)Math.sin(d + 0.15707963267948966), worldSound.z, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            }
        }
        if (GameServer.bServer) {
            return;
        }
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.getChunkMap(0);
        if (isoChunkMap == null || isoChunkMap.ignore) {
            return;
        }
        for (int i = 0; i < IsoChunkMap.ChunkGridWidth; ++i) {
            for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                IsoChunk isoChunk = isoChunkMap.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.SoundList.size(); ++k) {
                    WorldSound worldSound = isoChunk.SoundList.get(k);
                    float f3 = (float)worldSound.radius * f;
                    for (double d = 0.0; d < Math.PI * 2; d += 0.15707963267948966) {
                        this.DrawIsoLine((float)worldSound.x + f3 * (float)Math.cos(d), (float)worldSound.y + f3 * (float)Math.sin(d), (float)worldSound.x + f3 * (float)Math.cos(d + 0.15707963267948966), (float)worldSound.y + f3 * (float)Math.sin(d + 0.15707963267948966), worldSound.z, 0.0f, 1.0f, 1.0f, 1.0f, 1);
                        float f4 = (float)(isoChunk.wx * 10) + 0.1f;
                        float f5 = (float)(isoChunk.wy * 10) + 0.1f;
                        float f6 = (float)((isoChunk.wx + 1) * 10) - 0.1f;
                        float f7 = (float)((isoChunk.wy + 1) * 10) - 0.1f;
                        this.DrawIsoLine(f4, f5, f6, f5, worldSound.z, 0.0f, 1.0f, 1.0f, 1.0f, 1);
                        this.DrawIsoLine(f6, f5, f6, f7, worldSound.z, 0.0f, 1.0f, 1.0f, 1.0f, 1);
                        this.DrawIsoLine(f6, f7, f4, f7, worldSound.z, 0.0f, 1.0f, 1.0f, 1.0f, 1);
                        this.DrawIsoLine(f4, f7, f4, f5, worldSound.z, 0.0f, 1.0f, 1.0f, 1.0f, 1);
                    }
                }
            }
        }
    }

    private void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n) {
        float f10 = IsoUtils.XToScreenExact(f, f2, f5, 0);
        float f11 = IsoUtils.YToScreenExact(f, f2, f5, 0);
        float f12 = IsoUtils.XToScreenExact(f3, f4, f5, 0);
        float f13 = IsoUtils.YToScreenExact(f3, f4, f5, 0);
        LineDrawer.drawLine(f10, f11, f12, f13, f6, f7, f8, f9, n);
    }

    public float getHearingMultiplier(IsoZombie isoZombie) {
        if (isoZombie == null) {
            return this.getHearingMultiplier(2);
        }
        return this.getHearingMultiplier(isoZombie.hearing);
    }

    public float getHearingMultiplier(int n) {
        if (n == 1) {
            return 3.0f;
        }
        if (n == 3) {
            return 0.45f;
        }
        return 1.0f;
    }

    public class WorldSound {
        public Object source = null;
        public int life = 1;
        public int radius;
        public boolean stresshumans;
        public int volume;
        public int x;
        public int y;
        public int z;
        public float zombieIgnoreDist = 0.0f;
        public boolean sourceIsZombie;
        public float stressMod = 1.0f;
        public boolean bRepeating;

        public WorldSound init(Object object, int n, int n2, int n3, int n4, int n5) {
            return this.init(object, n, n2, n3, n4, n5, false, 0.0f, 1.0f);
        }

        public WorldSound init(Object object, int n, int n2, int n3, int n4, int n5, boolean bl) {
            return this.init(object, n, n2, n3, n4, n5, bl, 0.0f, 1.0f);
        }

        public WorldSound init(Object object, int n, int n2, int n3, int n4, int n5, boolean bl, float f, float f2) {
            this.source = object;
            this.life = 1;
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.radius = n4;
            this.volume = n5;
            this.stresshumans = bl;
            this.zombieIgnoreDist = f;
            this.stressMod = f2;
            this.sourceIsZombie = object instanceof IsoZombie;
            this.bRepeating = false;
            LuaEventManager.triggerEvent("OnWorldSound", n, n2, n3, n4, n5, object);
            return this;
        }

        public WorldSound init(boolean bl, int n, int n2, int n3, int n4, int n5, boolean bl2, float f, float f2) {
            WorldSound worldSound = this.init(null, n, n2, n3, n4, n5, bl2, f, f2);
            worldSound.sourceIsZombie = bl;
            return worldSound;
        }
    }

    public static final class ResultBiggestSound {
        public WorldSound sound;
        public float attract;

        public ResultBiggestSound init(WorldSound worldSound, float f) {
            this.sound = worldSound;
            this.attract = f;
            return this;
        }
    }
}

