/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import zombie.debug.DebugLog;
import zombie.network.GameServer;

public class TimeDebugger {
    ArrayList<Long> records = new ArrayList();
    ArrayList<String> recordStrings = new ArrayList();
    String name = "";

    public TimeDebugger(String string) {
        this.name = string;
    }

    public void clear() {
        if (GameServer.bServer) {
            this.records.clear();
            this.recordStrings.clear();
        }
    }

    public void start() {
        if (GameServer.bServer) {
            this.records.clear();
            this.recordStrings.clear();
            this.records.add(System.currentTimeMillis());
            this.recordStrings.add("Start");
        }
    }

    public void record() {
        if (GameServer.bServer) {
            this.records.add(System.currentTimeMillis());
            this.recordStrings.add(String.valueOf(this.records.size()));
        }
    }

    public void record(String string) {
        if (GameServer.bServer) {
            this.records.add(System.currentTimeMillis());
            this.recordStrings.add(string);
        }
    }

    public void recordTO(String string, int n) {
        if (GameServer.bServer && this.records.get(this.records.size() - 1) - this.records.get(this.records.size() - 2) > (long)n) {
            this.records.add(System.currentTimeMillis());
            this.recordStrings.add(string);
        }
    }

    public void add(TimeDebugger timeDebugger) {
        if (GameServer.bServer) {
            String string = timeDebugger.name;
            for (int i = 0; i < timeDebugger.records.size(); ++i) {
                this.records.add(timeDebugger.records.get(i));
                this.recordStrings.add(string + "|" + timeDebugger.recordStrings.get(i));
            }
            timeDebugger.clear();
        }
    }

    public void print() {
        if (GameServer.bServer) {
            this.records.add(System.currentTimeMillis());
            this.recordStrings.add("END");
            if (this.records.size() > 1) {
                DebugLog.log("=== DBG " + this.name + " ===");
                long l = this.records.get(0);
                for (int i = 1; i < this.records.size(); ++i) {
                    long l2 = this.records.get(i - 1);
                    long l3 = this.records.get(i);
                    String string = this.recordStrings.get(i);
                    DebugLog.log("RECORD " + i + " " + string + " A:" + (l3 - l) + " D:" + (l3 - l2));
                }
                DebugLog.log("=== END " + this.name + " (" + (this.records.get(this.records.size() - 1) - l) + ") ===");
            } else {
                DebugLog.log("<<< DBG " + this.name + " ERROR >>>");
            }
        }
    }

    public long getExecTime() {
        if (this.records.size() == 0) {
            return 0L;
        }
        return System.currentTimeMillis() - this.records.get(0);
    }
}

