/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import fmod.fmod.Audio;
import fmod.fmod.FMODAudio;
import fmod.fmod.FMODManager;
import fmod.fmod.FMODSoundEmitter;
import fmod.fmod.FMOD_STUDIO_EVENT_CALLBACK;
import fmod.fmod.FMOD_STUDIO_EVENT_CALLBACK_TYPE;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PLAYBACK_STATE;
import fmod.fmod.IFMODParameterUpdater;
import fmod.javafmod;
import fmod.javafmodJNI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import zombie.AmbientStreamManager;
import zombie.BaseSoundManager;
import zombie.GameSounds;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.FMODParameter;
import zombie.audio.FMODParameterList;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.audio.parameters.ParameterMusicActionStyle;
import zombie.audio.parameters.ParameterMusicLibrary;
import zombie.audio.parameters.ParameterMusicState;
import zombie.audio.parameters.ParameterMusicWakeState;
import zombie.audio.parameters.ParameterMusicZombiesTargeting;
import zombie.audio.parameters.ParameterMusicZombiesVisible;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.gameStates.MainScreenState;
import zombie.input.GameKeyboard;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.ScriptModule;
import zombie.ui.TutorialManager;
import zombie.util.StringUtils;

public final class SoundManager
extends BaseSoundManager
implements IFMODParameterUpdater {
    public float SoundVolume = 0.8f;
    public float MusicVolume = 0.36f;
    public float AmbientVolume = 0.8f;
    public float VehicleEngineVolume = 0.5f;
    private final ParameterMusicActionStyle parameterMusicActionStyle = new ParameterMusicActionStyle();
    private final ParameterMusicLibrary parameterMusicLibrary = new ParameterMusicLibrary();
    private final ParameterMusicState parameterMusicState = new ParameterMusicState();
    private final ParameterMusicWakeState parameterMusicWakeState = new ParameterMusicWakeState();
    private final ParameterMusicZombiesTargeting parameterMusicZombiesTargeting = new ParameterMusicZombiesTargeting();
    private final ParameterMusicZombiesVisible parameterMusicZombiesVisible = new ParameterMusicZombiesVisible();
    private final FMODParameterList fmodParameters = new FMODParameterList();
    private boolean initialized = false;
    private long inGameGroupBus = 0L;
    private long musicGroupBus = 0L;
    private FMODSoundEmitter musicEmitter = null;
    private long musicCombinedEvent = 0L;
    private FMODSoundEmitter uiEmitter = null;
    private final Music music = new Music();
    public ArrayList<Audio> ambientPieces = new ArrayList();
    private boolean muted = false;
    private long[] bankList = new long[32];
    private long[] eventDescList = new long[256];
    private long[] eventInstList = new long[256];
    private long[] pausedEventInstances = new long[128];
    private float[] pausedEventVolumes = new float[128];
    private int pausedEventCount;
    private final HashSet<BaseSoundEmitter> emitters = new HashSet();
    private static ArrayList<AmbientSoundEffect> ambientSoundEffects = new ArrayList();
    public static BaseSoundManager instance;
    private String currentMusicName;
    private String currentMusicLibrary;
    private final FMOD_STUDIO_EVENT_CALLBACK musicEventCallback = new FMOD_STUDIO_EVENT_CALLBACK(){

        public void timelineMarker(long l, String string, int n) {
            DebugLog.Sound.debugln("timelineMarker %s %d", string, n);
            if ("Lightning".equals(string)) {
                MainScreenState.getInstance().lightningTimelineMarker = true;
            }
        }
    };

    public FMODParameterList getFMODParameters() {
        return this.fmodParameters;
    }

    public void startEvent(long l, GameSoundClip gameSoundClip, BitSet bitSet) {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        ArrayList arrayList = gameSoundClip.eventDescription.parameters;
        for (int i = 0; i < arrayList.size(); ++i) {
            FMODParameter fMODParameter;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = (FMOD_STUDIO_PARAMETER_DESCRIPTION)arrayList.get(i);
            if (bitSet.get(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex) || (fMODParameter = fMODParameterList.get(fMOD_STUDIO_PARAMETER_DESCRIPTION)) == null) continue;
            fMODParameter.startEventInstance(l);
        }
    }

    public void updateEvent(long l, GameSoundClip gameSoundClip) {
    }

    public void stopEvent(long l, GameSoundClip gameSoundClip, BitSet bitSet) {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        ArrayList arrayList = gameSoundClip.eventDescription.parameters;
        for (int i = 0; i < arrayList.size(); ++i) {
            FMODParameter fMODParameter;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = (FMOD_STUDIO_PARAMETER_DESCRIPTION)arrayList.get(i);
            if (bitSet.get(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex) || (fMODParameter = fMODParameterList.get(fMOD_STUDIO_PARAMETER_DESCRIPTION)) == null) continue;
            fMODParameter.stopEventInstance(l);
        }
    }

    @Override
    public boolean isRemastered() {
        int n = Core.getInstance().getOptionMusicLibrary();
        return n == 1 || n == 3 && Rand.Next(2) == 0;
    }

    @Override
    public void BlendVolume(Audio audio, float f) {
    }

    @Override
    public void BlendVolume(Audio audio, float f, float f2) {
    }

    @Override
    public Audio BlendThenStart(Audio audio, float f, String string) {
        return null;
    }

    @Override
    public void FadeOutMusic(String string, int n) {
    }

    @Override
    public void PlayAsMusic(String string, Audio audio, float f, boolean bl) {
    }

    @Override
    public long playUISound(String string) {
        GameSound gameSound = GameSounds.getSound(string);
        if (gameSound == null || gameSound.clips.isEmpty()) {
            return 0L;
        }
        GameSoundClip gameSoundClip = gameSound.getRandomClip();
        long l = this.uiEmitter.playClip(gameSoundClip, null);
        this.uiEmitter.tick();
        javafmod.FMOD_System_Update();
        return l;
    }

    @Override
    public boolean isPlayingUISound(String string) {
        return this.uiEmitter.isPlaying(string);
    }

    @Override
    public boolean isPlayingUISound(long l) {
        return this.uiEmitter.isPlaying(l);
    }

    @Override
    public void stopUISound(long l) {
        this.uiEmitter.stopSound(l);
    }

    @Override
    public boolean IsMusicPlaying() {
        return false;
    }

    @Override
    public boolean isPlayingMusic() {
        return this.music.isPlaying();
    }

    @Override
    public ArrayList<Audio> getAmbientPieces() {
        return this.ambientPieces;
    }

    private void gatherInGameEventInstances() {
        this.pausedEventCount = 0;
        int n = javafmodJNI.FMOD_Studio_System_GetBankCount();
        if (this.bankList.length < n) {
            this.bankList = new long[n];
        }
        n = javafmodJNI.FMOD_Studio_System_GetBankList((long[])this.bankList);
        for (int i = 0; i < n; ++i) {
            int n2 = javafmodJNI.FMOD_Studio_Bank_GetEventCount((long)this.bankList[i]);
            if (this.eventDescList.length < n2) {
                this.eventDescList = new long[n2];
            }
            n2 = javafmodJNI.FMOD_Studio_Bank_GetEventList((long)this.bankList[i], (long[])this.eventDescList);
            for (int j = 0; j < n2; ++j) {
                int n3 = javafmodJNI.FMOD_Studio_EventDescription_GetInstanceCount((long)this.eventDescList[j]);
                if (this.eventInstList.length < n3) {
                    this.eventInstList = new long[n3];
                }
                n3 = javafmodJNI.FMOD_Studio_EventDescription_GetInstanceList((long)this.eventDescList[j], (long[])this.eventInstList);
                for (int k = 0; k < n3; ++k) {
                    boolean bl;
                    int n4 = javafmod.FMOD_Studio_GetPlaybackState((long)this.eventInstList[k]);
                    if (n4 == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPED.index || (bl = javafmodJNI.FMOD_Studio_EventInstance_GetPaused((long)this.eventInstList[k]))) continue;
                    if (this.pausedEventInstances.length < this.pausedEventCount + 1) {
                        this.pausedEventInstances = Arrays.copyOf(this.pausedEventInstances, this.pausedEventCount + 128);
                        this.pausedEventVolumes = Arrays.copyOf(this.pausedEventVolumes, this.pausedEventInstances.length);
                    }
                    this.pausedEventInstances[this.pausedEventCount] = this.eventInstList[k];
                    this.pausedEventVolumes[this.pausedEventCount] = javafmodJNI.FMOD_Studio_EventInstance_GetVolume((long)this.eventInstList[k]);
                    ++this.pausedEventCount;
                }
            }
        }
    }

    @Override
    public void pauseSoundAndMusic() {
        boolean bl = true;
        if (GameClient.bClient) {
            this.muted = true;
            if (bl) {
                javafmod.FMOD_Studio_Bus_SetMute((long)this.inGameGroupBus, (boolean)true);
                javafmod.FMOD_Studio_Bus_SetMute((long)this.musicGroupBus, (boolean)true);
            } else {
                this.setSoundVolume(0.0f);
                this.setMusicVolume(0.0f);
                this.setAmbientVolume(0.0f);
                this.setVehicleEngineVolume(0.0f);
            }
            GameSounds.soundIsPaused = true;
            return;
        }
        if (bl) {
            javafmod.FMOD_Studio_Bus_SetPaused((long)this.inGameGroupBus, (boolean)true);
            javafmod.FMOD_Studio_Bus_SetPaused((long)this.musicGroupBus, (boolean)true);
            javafmod.FMOD_Channel_SetPaused((long)FMODManager.instance.channelGroupInGameNonBankSounds, (boolean)true);
            GameSounds.soundIsPaused = true;
            return;
        }
        long l = javafmod.FMOD_System_GetMasterChannelGroup();
        javafmod.FMOD_ChannelGroup_SetPaused((long)l, (boolean)true);
        javafmod.FMOD_ChannelGroup_SetVolume((long)l, (float)0.0f);
        javafmodJNI.FMOD_Studio_System_FlushCommands();
        this.gatherInGameEventInstances();
        for (int i = 0; i < this.pausedEventCount; ++i) {
            javafmodJNI.FMOD_Studio_EventInstance_SetPaused((long)this.pausedEventInstances[i], (boolean)true);
        }
        javafmod.FMOD_Channel_SetPaused((long)FMODManager.instance.channelGroupInGameNonBankSounds, (boolean)true);
        javafmod.FMOD_ChannelGroup_SetPaused((long)l, (boolean)false);
        javafmodJNI.FMOD_Studio_System_FlushCommands();
        javafmod.FMOD_ChannelGroup_SetVolume((long)l, (float)1.0f);
        GameSounds.soundIsPaused = true;
    }

    @Override
    public void resumeSoundAndMusic() {
        boolean bl = true;
        if (this.muted) {
            this.muted = false;
            if (bl) {
                javafmod.FMOD_Studio_Bus_SetMute((long)this.inGameGroupBus, (boolean)false);
                javafmod.FMOD_Studio_Bus_SetMute((long)this.musicGroupBus, (boolean)false);
                javafmod.FMOD_ChannelGroup_SetPaused((long)FMODManager.instance.channelGroupInGameNonBankSounds, (boolean)false);
            } else {
                this.setSoundVolume((float)Core.getInstance().getOptionSoundVolume() / 10.0f);
                this.setMusicVolume((float)Core.getInstance().getOptionMusicVolume() / 10.0f);
                this.setAmbientVolume((float)Core.getInstance().getOptionAmbientVolume() / 10.0f);
                this.setVehicleEngineVolume((float)Core.getInstance().getOptionVehicleEngineVolume() / 10.0f);
            }
            GameSounds.soundIsPaused = false;
            return;
        }
        if (bl) {
            javafmod.FMOD_Studio_Bus_SetPaused((long)this.inGameGroupBus, (boolean)false);
            javafmod.FMOD_Studio_Bus_SetPaused((long)this.musicGroupBus, (boolean)false);
            javafmod.FMOD_ChannelGroup_SetPaused((long)FMODManager.instance.channelGroupInGameNonBankSounds, (boolean)false);
            GameSounds.soundIsPaused = false;
            return;
        }
        long l = javafmod.FMOD_System_GetMasterChannelGroup();
        javafmod.FMOD_ChannelGroup_SetPaused((long)l, (boolean)true);
        javafmodJNI.FMOD_Studio_System_FlushCommands();
        for (int i = 0; i < this.pausedEventCount; ++i) {
            try {
                javafmodJNI.FMOD_Studio_EventInstance_SetPaused((long)this.pausedEventInstances[i], (boolean)false);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.pausedEventCount = 0;
        javafmod.FMOD_ChannelGroup_SetPaused((long)l, (boolean)false);
        javafmod.FMOD_ChannelGroup_SetVolume((long)l, (float)1.0f);
        javafmod.FMOD_ChannelGroup_SetPaused((long)FMODManager.instance.channelGroupInGameNonBankSounds, (boolean)false);
        GameSounds.soundIsPaused = false;
    }

    private void debugScriptSound(Item item, String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (!GameSounds.isKnownSound(string)) {
            DebugLog.General.warn("no such sound \"" + string + "\" in item " + item.getFullName());
        }
    }

    @Override
    public void debugScriptSounds() {
        if (!Core.bDebug) {
            return;
        }
        for (ScriptModule scriptModule : ScriptManager.instance.ModuleMap.values()) {
            for (Item item : scriptModule.ItemMap.values()) {
                this.debugScriptSound(item, item.getBreakSound());
                this.debugScriptSound(item, item.getBulletOutSound());
                this.debugScriptSound(item, item.getCloseSound());
                this.debugScriptSound(item, item.getCustomEatSound());
                this.debugScriptSound(item, item.getDoorHitSound());
                this.debugScriptSound(item, item.getCountDownSound());
                this.debugScriptSound(item, item.getExplosionSound());
                this.debugScriptSound(item, item.getImpactSound());
                this.debugScriptSound(item, item.getOpenSound());
                this.debugScriptSound(item, item.getPutInSound());
                this.debugScriptSound(item, item.getPlaceOneSound());
                this.debugScriptSound(item, item.getPlaceMultipleSound());
                this.debugScriptSound(item, item.getShellFallSound());
                this.debugScriptSound(item, item.getSwingSound());
                this.debugScriptSound(item, item.getInsertAmmoSound());
                this.debugScriptSound(item, item.getInsertAmmoStartSound());
                this.debugScriptSound(item, item.getInsertAmmoStopSound());
                this.debugScriptSound(item, item.getEjectAmmoSound());
                this.debugScriptSound(item, item.getEjectAmmoStartSound());
                this.debugScriptSound(item, item.getEjectAmmoStopSound());
            }
        }
    }

    @Override
    public void registerEmitter(BaseSoundEmitter baseSoundEmitter) {
        this.emitters.add(baseSoundEmitter);
    }

    @Override
    public void unregisterEmitter(BaseSoundEmitter baseSoundEmitter) {
        this.emitters.remove(baseSoundEmitter);
    }

    @Override
    public boolean isListenerInRange(float f, float f2, float f3) {
        if (GameServer.bServer) {
            return false;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.Traits.Deaf.isSet() || !(IsoUtils.DistanceToSquared(isoPlayer.x, isoPlayer.y, f, f2) < f3 * f3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void playNightAmbient(String string) {
        DebugLog.log("playNightAmbient: " + string);
        for (int i = 0; i < ambientSoundEffects.size(); ++i) {
            AmbientSoundEffect ambientSoundEffect = ambientSoundEffects.get(i);
            if (!ambientSoundEffect.getName().equals(string)) continue;
            ambientSoundEffect.setVolume((float)Rand.Next(700, 1500) / 1000.0f);
            ambientSoundEffect.start();
            this.ambientPieces.add(ambientSoundEffect);
            return;
        }
        AmbientSoundEffect ambientSoundEffect = new AmbientSoundEffect(string);
        ambientSoundEffect.setVolume((float)Rand.Next(700, 1500) / 1000.0f);
        ambientSoundEffect.setName(string);
        ambientSoundEffect.start();
        this.ambientPieces.add(ambientSoundEffect);
        ambientSoundEffects.add(ambientSoundEffect);
    }

    @Override
    public void playMusic(String string) {
        this.DoMusic(string, false);
    }

    @Override
    public void playAmbient(String string) {
    }

    @Override
    public void playMusicNonTriggered(String string, float f) {
    }

    @Override
    public void stopMusic(String string) {
        if (!this.isPlayingMusic()) {
            return;
        }
        if (StringUtils.isNullOrWhitespace(string) || string.equalsIgnoreCase(this.getCurrentMusicName())) {
            this.StopMusic();
        }
    }

    @Override
    public void CheckDoMusic() {
    }

    @Override
    public float getMusicPosition() {
        if (this.isPlayingMusic()) {
            return this.music.getPosition();
        }
        return 0.0f;
    }

    @Override
    public void DoMusic(String string, boolean bl) {
        long l;
        int n;
        if (!this.AllowMusic || Core.getInstance().getOptionMusicVolume() == 0) {
            return;
        }
        if (this.isPlayingMusic()) {
            this.StopMusic();
        }
        boolean bl2 = (n = Core.getInstance().getOptionMusicLibrary()) == 1;
        GameSound gameSound = GameSounds.getSound(string);
        GameSoundClip gameSoundClip = null;
        if (gameSound != null && !gameSound.clips.isEmpty()) {
            gameSoundClip = gameSound.getRandomClip();
        }
        if (gameSoundClip != null && gameSoundClip.getEvent() != null) {
            if (gameSoundClip.eventDescription != null) {
                long l2 = gameSoundClip.eventDescription.address;
                javafmod.FMOD_Studio_LoadEventSampleData((long)l2);
                this.music.instance = javafmod.FMOD_Studio_System_CreateEventInstance((long)l2);
                this.music.clip = gameSoundClip;
                this.music.effectiveVolume = gameSoundClip.getEffectiveVolume();
                javafmod.FMOD_Studio_EventInstance_SetParameterByName((long)this.music.instance, (String)"Volume", (float)10.0f);
                javafmod.FMOD_Studio_EventInstance_SetVolume((long)this.music.instance, (float)this.music.effectiveVolume);
                javafmod.FMOD_Studio_StartEvent((long)this.music.instance);
            }
        } else if (gameSoundClip != null && gameSoundClip.getFile() != null && (l = FMODManager.instance.loadSound(gameSoundClip.getFile())) > 0L) {
            this.music.channel = javafmod.FMOD_System_PlaySound((long)l, (boolean)true);
            this.music.clip = gameSoundClip;
            this.music.effectiveVolume = gameSoundClip.getEffectiveVolume();
            javafmod.FMOD_Channel_SetVolume((long)this.music.channel, (float)this.music.effectiveVolume);
            javafmod.FMOD_Channel_SetPitch((long)this.music.channel, (float)gameSoundClip.pitch);
            javafmod.FMOD_Channel_SetPaused((long)this.music.channel, (boolean)false);
        }
        this.currentMusicName = string;
        this.currentMusicLibrary = bl2 ? "official" : "earlyaccess";
    }

    @Override
    public void PlayAsMusic(String string, Audio audio, boolean bl, float f) {
    }

    @Override
    public void setMusicState(String string) {
        switch (string) {
            case "MainMenu": {
                this.parameterMusicState.setState(ParameterMusicState.State.MainMenu);
                break;
            }
            case "Loading": {
                this.parameterMusicState.setState(ParameterMusicState.State.Loading);
                break;
            }
            case "InGame": {
                this.parameterMusicState.setState(ParameterMusicState.State.InGame);
                break;
            }
            case "PauseMenu": {
                this.parameterMusicState.setState(ParameterMusicState.State.PauseMenu);
                break;
            }
            case "Tutorial": {
                this.parameterMusicState.setState(ParameterMusicState.State.Tutorial);
                break;
            }
            default: {
                DebugLog.General.warn("unknown MusicState \"%s\"", string);
            }
        }
    }

    @Override
    public void setMusicWakeState(IsoPlayer isoPlayer, String string) {
        switch (string) {
            case "Awake": {
                this.parameterMusicWakeState.setState(isoPlayer, ParameterMusicWakeState.State.Awake);
                break;
            }
            case "Sleeping": {
                this.parameterMusicWakeState.setState(isoPlayer, ParameterMusicWakeState.State.Sleeping);
                break;
            }
            case "WakeNormal": {
                this.parameterMusicWakeState.setState(isoPlayer, ParameterMusicWakeState.State.WakeNormal);
                break;
            }
            case "WakeNightmare": {
                this.parameterMusicWakeState.setState(isoPlayer, ParameterMusicWakeState.State.WakeNightmare);
                break;
            }
            case "WakeZombies": {
                this.parameterMusicWakeState.setState(isoPlayer, ParameterMusicWakeState.State.WakeZombies);
                break;
            }
            default: {
                DebugLog.General.warn("unknown MusicWakeState \"%s\"", string);
            }
        }
    }

    @Override
    public Audio PlayMusic(String string, String string2, boolean bl, float f) {
        return null;
    }

    @Override
    public Audio PlaySound(String string, boolean bl, float f, float f2) {
        return null;
    }

    @Override
    public Audio PlaySound(String string, boolean bl, float f) {
        if (GameServer.bServer) {
            return null;
        }
        if (IsoWorld.instance == null) {
            return null;
        }
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter();
        baseSoundEmitter.setPos(0.0f, 0.0f, 0.0f);
        long l = baseSoundEmitter.playSound(string);
        if (l != 0L) {
            return new FMODAudio(baseSoundEmitter);
        }
        return null;
    }

    @Override
    public Audio PlaySoundEvenSilent(String string, boolean bl, float f) {
        return null;
    }

    @Override
    public Audio PlayJukeboxSound(String string, boolean bl, float f) {
        return null;
    }

    @Override
    public Audio PlaySoundWav(String string, boolean bl, float f, float f2) {
        return null;
    }

    @Override
    public Audio PlaySoundWav(String string, boolean bl, float f) {
        return null;
    }

    @Override
    public Audio PlaySoundWav(String string, int n, boolean bl, float f) {
        return null;
    }

    @Override
    public void update3D() {
    }

    @Override
    public Audio PlayWorldSound(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl) {
        return this.PlayWorldSound(string, false, isoGridSquare, f, f2, f3, bl);
    }

    @Override
    public Audio PlayWorldSound(String string, boolean bl, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl2) {
        if (GameServer.bServer || isoGridSquare == null) {
            return null;
        }
        if (GameClient.bClient) {
            GameClient.instance.PlayWorldSound(string, isoGridSquare.x, isoGridSquare.y, (byte)isoGridSquare.z);
        }
        return this.PlayWorldSoundImpl(string, bl, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), f, f2, f3, bl2);
    }

    @Override
    public Audio PlayWorldSoundImpl(String string, boolean bl, int n, int n2, int n3, float f, float f2, float f3, boolean bl2) {
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)n + 0.5f, (float)n2 + 0.5f, n3);
        long l = baseSoundEmitter.playSoundImpl(string, (IsoObject)null);
        return new FMODAudio(baseSoundEmitter);
    }

    @Override
    public Audio PlayWorldSound(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3, int n, boolean bl) {
        return this.PlayWorldSound(string, isoGridSquare, f, f2, f3, bl);
    }

    @Override
    public Audio PlayWorldSoundWav(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl) {
        return this.PlayWorldSoundWav(string, false, isoGridSquare, f, f2, f3, bl);
    }

    @Override
    public Audio PlayWorldSoundWav(String string, boolean bl, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl2) {
        if (GameServer.bServer || isoGridSquare == null) {
            return null;
        }
        if (GameClient.bClient) {
            GameClient.instance.PlayWorldSound(string, isoGridSquare.getX(), isoGridSquare.getY(), (byte)isoGridSquare.getZ());
        }
        return this.PlayWorldSoundWavImpl(string, bl, isoGridSquare, f, f2, f3, bl2);
    }

    @Override
    public Audio PlayWorldSoundWavImpl(String string, boolean bl, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl2) {
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)isoGridSquare.getX() + 0.5f, (float)isoGridSquare.getY() + 0.5f, isoGridSquare.getZ());
        baseSoundEmitter.playSound(string);
        return new FMODAudio(baseSoundEmitter);
    }

    @Override
    public void PlayWorldSoundWav(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3, int n, boolean bl) {
        Integer n2 = Rand.Next(n) + 1;
        this.PlayWorldSoundWav(string + n2.toString(), isoGridSquare, f, f2, f3, bl);
    }

    @Override
    public Audio PrepareMusic(String string) {
        return null;
    }

    @Override
    public Audio Start(Audio audio, float f, String string) {
        return null;
    }

    @Override
    public void Update() {
        if (!this.initialized) {
            this.initialized = true;
            this.inGameGroupBus = javafmod.FMOD_Studio_System_GetBus((String)"bus:/InGame");
            this.musicGroupBus = javafmod.FMOD_Studio_System_GetBus((String)"bus:/Music");
            this.musicEmitter = new FMODSoundEmitter();
            this.unregisterEmitter((BaseSoundEmitter)this.musicEmitter);
            this.musicEmitter.parameterUpdater = this;
            this.fmodParameters.add(this.parameterMusicActionStyle);
            this.fmodParameters.add(this.parameterMusicLibrary);
            this.fmodParameters.add(this.parameterMusicState);
            this.fmodParameters.add(this.parameterMusicWakeState);
            this.fmodParameters.add(this.parameterMusicZombiesTargeting);
            this.fmodParameters.add(this.parameterMusicZombiesVisible);
            this.uiEmitter = new FMODSoundEmitter();
        }
        FMODSoundEmitter.update();
        this.updateMusic();
        this.uiEmitter.tick();
        for (int i = 0; i < this.ambientPieces.size(); ++i) {
            Audio audio = this.ambientPieces.get(i);
            if (IsoPlayer.allPlayersDead()) {
                audio.stop();
            }
            if (!audio.isPlaying()) {
                audio.stop();
                this.ambientPieces.remove(audio);
                --i;
                continue;
            }
            if (!(audio instanceof AmbientSoundEffect)) continue;
            ((AmbientSoundEffect)audio).update();
        }
        AmbientStreamManager.instance.update();
        if (!this.AllowMusic) {
            this.StopMusic();
        }
        if (this.music.isPlaying()) {
            this.music.update();
        }
        FMODManager.instance.tick();
    }

    @Override
    protected boolean HasMusic(Audio audio) {
        return false;
    }

    @Override
    public void Purge() {
    }

    @Override
    public void stop() {
        for (BaseSoundEmitter baseSoundEmitter : this.emitters) {
            baseSoundEmitter.stopAll();
        }
        this.emitters.clear();
        long l = javafmod.FMOD_System_GetMasterChannelGroup();
        javafmod.FMOD_ChannelGroup_Stop((long)l);
        this.pausedEventCount = 0;
    }

    @Override
    public void StopMusic() {
        this.music.stop();
    }

    @Override
    public void StopSound(Audio audio) {
        audio.stop();
    }

    @Override
    public void CacheSound(String string) {
    }

    @Override
    public void update4() {
    }

    @Override
    public void update2() {
    }

    @Override
    public void update3() {
    }

    @Override
    public void update1() {
    }

    @Override
    public void setSoundVolume(float f) {
        this.SoundVolume = f;
    }

    @Override
    public float getSoundVolume() {
        return this.SoundVolume;
    }

    @Override
    public void setAmbientVolume(float f) {
        this.AmbientVolume = f;
    }

    @Override
    public float getAmbientVolume() {
        return this.AmbientVolume;
    }

    @Override
    public void setMusicVolume(float f) {
        this.MusicVolume = f;
        if (this.muted) {
            return;
        }
    }

    @Override
    public float getMusicVolume() {
        return this.MusicVolume;
    }

    @Override
    public void setVehicleEngineVolume(float f) {
        this.VehicleEngineVolume = f;
    }

    @Override
    public float getVehicleEngineVolume() {
        return this.VehicleEngineVolume;
    }

    @Override
    public String getCurrentMusicName() {
        if (this.isPlayingMusic()) {
            return this.currentMusicName;
        }
        return null;
    }

    @Override
    public String getCurrentMusicLibrary() {
        if (this.isPlayingMusic()) {
            return this.currentMusicLibrary;
        }
        return null;
    }

    private void updateMusic() {
        this.fmodParameters.update();
        if (GameKeyboard.isKeyPressed(Core.getInstance().getKey("Toggle Music"))) {
            boolean bl = this.AllowMusic = !this.AllowMusic;
            if (!this.AllowMusic) {
                this.StopMusic();
                TutorialManager.instance.PrefMusic = null;
            }
        }
        if (!this.musicEmitter.isPlaying(this.musicCombinedEvent)) {
            this.musicCombinedEvent = this.musicEmitter.playSoundImpl("MusicCombined", (IsoObject)null);
            if (this.musicCombinedEvent != 0L && !System.getProperty("os.name").contains("OS X")) {
                javafmod.FMOD_Studio_EventInstance_SetCallback((long)this.musicCombinedEvent, (FMOD_STUDIO_EVENT_CALLBACK)this.musicEventCallback, (int)FMOD_STUDIO_EVENT_CALLBACK_TYPE.FMOD_STUDIO_EVENT_CALLBACK_TIMELINE_MARKER.bit);
            }
        }
        if (this.musicEmitter.isPlaying(this.musicCombinedEvent)) {
            this.musicEmitter.setVolume(this.musicCombinedEvent, this.AllowMusic ? 1.0f : 0.0f);
        }
        this.musicEmitter.tick();
    }

    private static final class Music {
        public GameSoundClip clip;
        public long instance;
        public long channel;
        public long sound;
        public float effectiveVolume;

        private Music() {
        }

        public boolean isPlaying() {
            if (this.instance != 0L) {
                int n = javafmod.FMOD_Studio_GetPlaybackState((long)this.instance);
                return n != FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPED.index && n != FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPING.index;
            }
            return this.channel != 0L && javafmod.FMOD_Channel_IsPlaying((long)this.channel);
        }

        public void update() {
            this.clip = this.clip.checkReloaded();
            float f = this.clip.getEffectiveVolume();
            if (this.effectiveVolume == f) {
                return;
            }
            this.effectiveVolume = f;
            if (this.instance != 0L) {
                javafmod.FMOD_Studio_EventInstance_SetVolume((long)this.instance, (float)this.effectiveVolume);
            }
            if (this.channel != 0L) {
                javafmod.FMOD_Channel_SetVolume((long)this.channel, (float)this.effectiveVolume);
            }
        }

        public float getPosition() {
            if (this.instance != 0L) {
                long l = javafmod.FMOD_Studio_GetTimelinePosition((long)this.instance);
                return l;
            }
            if (this.channel != 0L) {
                long l = javafmod.FMOD_Channel_GetPosition((long)this.channel, (int)FMODManager.FMOD_TIMEUNIT_MS);
                return l;
            }
            return 0.0f;
        }

        public void stop() {
            if (this.instance != 0L) {
                javafmod.FMOD_Studio_EventInstance_Stop((long)this.instance, (boolean)false);
                javafmod.FMOD_Studio_ReleaseEventInstance((long)this.instance);
                this.instance = 0L;
            }
            if (this.channel != 0L) {
                javafmod.FMOD_Channel_Stop((long)this.channel);
                this.channel = 0L;
                javafmod.FMOD_Sound_Release((long)this.sound);
                this.sound = 0L;
            }
        }
    }

    public static final class AmbientSoundEffect
    implements Audio {
        public String name;
        public long eventInstance;
        public float gain;
        public GameSoundClip clip;
        public float effectiveVolume;

        public AmbientSoundEffect(String string) {
            GameSound gameSound = GameSounds.getSound(string);
            if (gameSound == null || gameSound.clips.isEmpty()) {
                return;
            }
            GameSoundClip gameSoundClip = gameSound.getRandomClip();
            if (gameSoundClip.getEvent() == null) {
                return;
            }
            if (gameSoundClip.eventDescription == null) {
                return;
            }
            this.eventInstance = javafmod.FMOD_Studio_System_CreateEventInstance((long)gameSoundClip.eventDescription.address);
            if (this.eventInstance < 0L) {
                return;
            }
            this.clip = gameSoundClip;
        }

        public void setVolume(float f) {
            if (this.eventInstance <= 0L) {
                return;
            }
            this.gain = f;
            this.effectiveVolume = this.clip.getEffectiveVolume();
            javafmod.FMOD_Studio_EventInstance_SetVolume((long)this.eventInstance, (float)(this.gain * this.effectiveVolume));
        }

        public void start() {
            if (this.eventInstance <= 0L) {
                return;
            }
            javafmod.FMOD_Studio_StartEvent((long)this.eventInstance);
        }

        public void pause() {
        }

        public void stop() {
            DebugLog.log("stop ambient " + this.name);
            if (this.eventInstance <= 0L) {
                return;
            }
            javafmod.FMOD_Studio_EventInstance_Stop((long)this.eventInstance, (boolean)false);
        }

        public boolean isPlaying() {
            if (this.eventInstance <= 0L) {
                return false;
            }
            int n = javafmod.FMOD_Studio_GetPlaybackState((long)this.eventInstance);
            return n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STARTING.index || n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_PLAYING.index || n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_SUSTAINING.index;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void update() {
            if (this.clip == null) {
                return;
            }
            this.clip = this.clip.checkReloaded();
            float f = this.clip.getEffectiveVolume();
            if (this.effectiveVolume != f) {
                this.effectiveVolume = f;
                javafmod.FMOD_Studio_EventInstance_SetVolume((long)this.eventInstance, (float)(this.gain * this.effectiveVolume));
            }
        }
    }
}

