/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.File;
import java.util.function.Predicate;
import zombie.ZomboidFileSystem;
import zombie.debug.DebugLog;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;

public final class PredicatedFileWatcher {
    private final String m_path;
    private final Predicate<String> m_predicate;
    private final IPredicatedFileWatcherCallback m_callback;

    public PredicatedFileWatcher(Predicate<String> predicate, IPredicatedFileWatcherCallback iPredicatedFileWatcherCallback) {
        this(null, predicate, iPredicatedFileWatcherCallback);
    }

    public PredicatedFileWatcher(String string, IPredicatedFileWatcherCallback iPredicatedFileWatcherCallback) {
        this(string, null, iPredicatedFileWatcherCallback);
    }

    public <T> PredicatedFileWatcher(String string, Class<T> clazz, IPredicatedDataPacketFileWatcherCallback<T> iPredicatedDataPacketFileWatcherCallback) {
        this(string, null, new GenericPredicatedFileWatcherCallback<T>(clazz, iPredicatedDataPacketFileWatcherCallback));
    }

    public PredicatedFileWatcher(String string, Predicate<String> predicate, IPredicatedFileWatcherCallback iPredicatedFileWatcherCallback) {
        this.m_path = this.processPath(string);
        this.m_predicate = predicate != null ? predicate : this::pathsEqual;
        this.m_callback = iPredicatedFileWatcherCallback;
    }

    public String getPath() {
        return this.m_path;
    }

    private String processPath(String string) {
        if (string != null) {
            return ZomboidFileSystem.processFilePath(string, File.separatorChar);
        }
        return null;
    }

    private boolean pathsEqual(String string) {
        return string.equals(this.m_path);
    }

    public void onModified(String string) {
        if (this.m_predicate.test(string)) {
            this.m_callback.call(string);
        }
    }

    public static interface IPredicatedFileWatcherCallback {
        public void call(String var1);
    }

    public static class GenericPredicatedFileWatcherCallback<T>
    implements IPredicatedFileWatcherCallback {
        private final Class<T> m_class;
        private final IPredicatedDataPacketFileWatcherCallback<T> m_callback;

        public GenericPredicatedFileWatcherCallback(Class<T> clazz, IPredicatedDataPacketFileWatcherCallback<T> iPredicatedDataPacketFileWatcherCallback) {
            this.m_class = clazz;
            this.m_callback = iPredicatedDataPacketFileWatcherCallback;
        }

        @Override
        public void call(String string) {
            T t;
            try {
                t = PZXmlUtil.parse(this.m_class, string);
            }
            catch (PZXmlParserException pZXmlParserException) {
                DebugLog.General.error("Exception thrown. " + pZXmlParserException);
                return;
            }
            this.m_callback.call(t);
        }
    }

    public static interface IPredicatedDataPacketFileWatcherCallback<T> {
        public void call(T var1);
    }
}

