/*
 * Decompiled with CFR 0.152.
 */
package zombie.Lua;

import se.krka.kahlua.converter.JavaToLuaConverter;
import se.krka.kahlua.converter.KahluaConverterManager;
import se.krka.kahlua.converter.LuaToJavaConverter;

public final class KahluaNumberConverter {
    private KahluaNumberConverter() {
    }

    public static void install(KahluaConverterManager kahluaConverterManager) {
        kahluaConverterManager.addLuaConverter((LuaToJavaConverter)new LuaToJavaConverter<Double, Long>(){

            public Long fromLuaToJava(Double d, Class<Long> clazz) {
                return d.longValue();
            }

            public Class<Long> getJavaType() {
                return Long.class;
            }

            public Class<Double> getLuaType() {
                return Double.class;
            }
        });
        kahluaConverterManager.addLuaConverter((LuaToJavaConverter)new LuaToJavaConverter<Double, Integer>(){

            public Integer fromLuaToJava(Double d, Class<Integer> clazz) {
                return d.intValue();
            }

            public Class<Integer> getJavaType() {
                return Integer.class;
            }

            public Class<Double> getLuaType() {
                return Double.class;
            }
        });
        kahluaConverterManager.addLuaConverter((LuaToJavaConverter)new LuaToJavaConverter<Double, Float>(){

            public Float fromLuaToJava(Double d, Class<Float> clazz) {
                return new Float(d.floatValue());
            }

            public Class<Float> getJavaType() {
                return Float.class;
            }

            public Class<Double> getLuaType() {
                return Double.class;
            }
        });
        kahluaConverterManager.addLuaConverter((LuaToJavaConverter)new LuaToJavaConverter<Double, Byte>(){

            public Byte fromLuaToJava(Double d, Class<Byte> clazz) {
                return d.byteValue();
            }

            public Class<Byte> getJavaType() {
                return Byte.class;
            }

            public Class<Double> getLuaType() {
                return Double.class;
            }
        });
        kahluaConverterManager.addLuaConverter((LuaToJavaConverter)new LuaToJavaConverter<Double, Character>(){

            public Character fromLuaToJava(Double d, Class<Character> clazz) {
                return Character.valueOf((char)d.intValue());
            }

            public Class<Character> getJavaType() {
                return Character.class;
            }

            public Class<Double> getLuaType() {
                return Double.class;
            }
        });
        kahluaConverterManager.addLuaConverter((LuaToJavaConverter)new LuaToJavaConverter<Double, Short>(){

            public Short fromLuaToJava(Double d, Class<Short> clazz) {
                return d.shortValue();
            }

            public Class<Short> getJavaType() {
                return Short.class;
            }

            public Class<Double> getLuaType() {
                return Double.class;
            }
        });
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Double>(Double.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Float>(Float.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Integer>(Integer.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Long>(Long.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Short>(Short.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Byte>(Byte.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Character>(Character.class));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Double>(Double.TYPE));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Float>(Float.TYPE));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Integer>(Integer.TYPE));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Long>(Long.TYPE));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Short>(Short.TYPE));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Byte>(Byte.TYPE));
        kahluaConverterManager.addJavaConverter(new NumberToLuaConverter<Character>(Character.TYPE));
        kahluaConverterManager.addJavaConverter((JavaToLuaConverter)new JavaToLuaConverter<Boolean>(){

            public Object fromJavaToLua(Boolean bl) {
                return (boolean)bl;
            }

            public Class<Boolean> getJavaType() {
                return Boolean.class;
            }
        });
    }

    private static final class NumberToLuaConverter<T extends Number>
    implements JavaToLuaConverter<T> {
        private final Class<T> clazz;

        public NumberToLuaConverter(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Object fromJavaToLua(T t) {
            if (t instanceof Double) {
                return t;
            }
            return DoubleCache.valueOf(((Number)t).doubleValue());
        }

        public Class<T> getJavaType() {
            return this.clazz;
        }
    }

    private static final class DoubleCache {
        static final int low = -128;
        static final int high = 10000;
        static final Double[] cache = new Double[10129];

        private DoubleCache() {
        }

        public static Double valueOf(double d) {
            if (d == (double)((int)d) && d >= -128.0 && d <= 10000.0) {
                return cache[(int)(d + 128.0)];
            }
            return new Double(d);
        }

        static {
            int n = -128;
            for (int i = 0; i < cache.length; ++i) {
                DoubleCache.cache[i] = new Double(n++);
            }
        }
    }
}

