/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import zombie.characters.IsoPlayer;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.iso.ContainerOverlays;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.TileOverlays;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class LoadGridsquarePerformanceWorkaround {
    public static void init(int n, int n2) {
        if (GameClient.bClient) {
            return;
        }
        ItemPicker.instance.init();
    }

    public static void LoadGridsquare(IsoGridSquare isoGridSquare) {
        if (ItemPicker.instance.begin(isoGridSquare)) {
            IsoObject[] isoObjectArray = isoGridSquare.getObjects().getElements();
            int n = isoGridSquare.getObjects().size();
            for (int i = 0; i < n; ++i) {
                IsoObject isoObject = isoObjectArray[i];
                if (isoObject instanceof IsoWorldInventoryObject) continue;
                if (!GameClient.bClient) {
                    ItemPicker.instance.checkObject(isoObject);
                }
                if (isoObject.sprite == null || isoObject.sprite.name == null || ContainerOverlays.instance.hasOverlays(isoObject)) continue;
                TileOverlays.instance.updateTileOverlaySprite(isoObject);
            }
        }
        ItemPicker.instance.end(isoGridSquare);
    }

    private static class ItemPicker {
        public static final ItemPicker instance = new ItemPicker();
        private IsoGridSquare square;

        private ItemPicker() {
        }

        public void init() {
        }

        public boolean begin(IsoGridSquare isoGridSquare) {
            if (isoGridSquare.isOverlayDone()) {
                this.square = null;
                return false;
            }
            this.square = isoGridSquare;
            return true;
        }

        public void checkObject(IsoObject isoObject) {
            IsoSprite isoSprite = isoObject.getSprite();
            if (isoSprite == null || isoSprite.getName() == null) {
                return;
            }
            ItemContainer itemContainer = isoObject.getContainer();
            if (itemContainer != null && !itemContainer.isExplored()) {
                ItemPickerJava.fillContainer(itemContainer, IsoPlayer.getInstance());
                itemContainer.setExplored(true);
                if (GameServer.bServer) {
                    GameServer.sendItemsInContainer(isoObject, itemContainer);
                }
            }
            if (itemContainer != null && itemContainer.isEmpty()) {
                return;
            }
            ItemPickerJava.updateOverlaySprite(isoObject);
        }

        public void end(IsoGridSquare isoGridSquare) {
            isoGridSquare.setOverlayDone(true);
        }
    }
}

