/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.Stack;
import org.lwjgl.opengl.GL11;
import zombie.ShaderStackEntry;
import zombie.core.SpriteRenderer;
import zombie.core.math.Vector4;
import zombie.core.opengl.GLState;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.core.textures.Texture;
import zombie.iso.IsoCamera;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.util.Lambda;
import zombie.util.lambda.Invokers;

public final class IndieGL {
    public static int nCount = 0;
    private static final GLState.CIntValue tempInt = new GLState.CIntValue();
    private static final GLState.C2IntsValue temp2Ints = new GLState.C2IntsValue();
    private static final GLState.C3IntsValue temp3Ints = new GLState.C3IntsValue();
    private static final GLState.C4IntsValue temp4Ints = new GLState.C4IntsValue();
    private static final GLState.C4BooleansValue temp4Booleans = new GLState.C4BooleansValue();
    private static final GLState.CIntFloatValue tempIntFloat = new GLState.CIntFloatValue();
    private static final Stack<ShaderStackEntry> m_shaderStack = new Stack();

    public static void glBlendFunc(int n, int n2) {
        if (SpriteRenderer.instance != null && SpriteRenderer.GL_BLENDFUNC_ENABLED) {
            GLState.BlendFuncSeparate.set(temp4Ints.set(n, n2, n, n2));
        }
    }

    public static void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        if (SpriteRenderer.instance != null && SpriteRenderer.GL_BLENDFUNC_ENABLED) {
            GLState.BlendFuncSeparate.set(temp4Ints.set(n, n2, n3, n4));
        }
    }

    public static void StartShader(Shader shader) {
        int n = IsoCamera.frameState.playerIndex;
        IndieGL.StartShader(shader, n);
    }

    public static void StartShader(Shader shader, int n) {
        if (shader != null) {
            IndieGL.StartShader(shader.getID(), n);
        } else {
            IndieGL.EndShader();
        }
    }

    public static void StartShader(int n) {
        int n2 = IsoCamera.frameState.playerIndex;
        IndieGL.StartShader(n, n2);
    }

    public static void StartShader(int n, int n2) {
        SpriteRenderer.instance.StartShader(n, n2);
    }

    public static void EndShader() {
        SpriteRenderer.instance.EndShader();
    }

    public static void pushShader(Shader shader) {
        int n = IsoCamera.frameState.playerIndex;
        m_shaderStack.push(ShaderStackEntry.alloc(shader, n));
        IndieGL.StartShader(shader, n);
    }

    public static void popShader(Shader shader) {
        if (m_shaderStack.isEmpty()) {
            throw new RuntimeException("Push/PopShader mismatch. Cannot pop. Stack is empty.");
        }
        if (m_shaderStack.peek().getShader() != shader) {
            throw new RuntimeException("Push/PopShader mismatch. The popped shader != the pushed shader.");
        }
        ShaderStackEntry shaderStackEntry = m_shaderStack.pop();
        shaderStackEntry.release();
        if (m_shaderStack.isEmpty()) {
            IndieGL.EndShader();
            return;
        }
        ShaderStackEntry shaderStackEntry2 = m_shaderStack.peek();
        IndieGL.StartShader(shaderStackEntry2.getShader(), shaderStackEntry2.getPlayerIndex());
    }

    public static void bindShader(Shader shader, Runnable runnable) {
        IndieGL.pushShader(shader);
        try {
            runnable.run();
        }
        finally {
            IndieGL.popShader(shader);
        }
    }

    public static <T1> void bindShader(Shader shader2, T1 T1, Invokers.Params1.ICallback<T1> iCallback2) {
        Lambda.capture(shader2, T1, iCallback2, (genericStack, shader, object, iCallback) -> IndieGL.bindShader(shader, genericStack.invoker(object, iCallback)));
    }

    public static <T1, T2> void bindShader(Shader shader2, T1 T1, T2 T2, Invokers.Params2.ICallback<T1, T2> iCallback2) {
        Lambda.capture(shader2, T1, T2, iCallback2, (genericStack, shader, object, object2, iCallback) -> IndieGL.bindShader(shader, genericStack.invoker(object, object2, iCallback)));
    }

    public static <T1, T2, T3> void bindShader(Shader shader2, T1 T1, T2 T2, T3 T3, Invokers.Params3.ICallback<T1, T2, T3> iCallback2) {
        Lambda.capture(shader2, T1, T2, T3, iCallback2, (genericStack, shader, object, object2, object3, iCallback) -> IndieGL.bindShader(shader, genericStack.invoker(object, object2, object3, iCallback)));
    }

    public static <T1, T2, T3, T4> void bindShader(Shader shader2, T1 T1, T2 T2, T3 T3, T4 T4, Invokers.Params4.ICallback<T1, T2, T3, T4> iCallback2) {
        Lambda.capture(shader2, T1, T2, T3, T4, iCallback2, (genericStack, shader, object, object2, object3, object4, iCallback) -> IndieGL.bindShader(shader, genericStack.invoker(object, object2, object3, object4, iCallback)));
    }

    private static ShaderProgram.Uniform getShaderUniform(Shader shader, String string, int n) {
        if (shader == null) {
            return null;
        }
        ShaderProgram shaderProgram = shader.getProgram();
        if (shaderProgram == null) {
            return null;
        }
        ShaderProgram.Uniform uniform = shaderProgram.getUniform(string, n, false);
        return uniform;
    }

    public static void shaderSetSamplerUnit(Shader shader, String string, int n) {
        ShaderProgram.Uniform uniform = IndieGL.getShaderUniform(shader, string, 35678);
        if (uniform != null) {
            uniform.sampler = n;
            IndieGL.ShaderUpdate1i(shader.getID(), uniform.loc, n);
        }
    }

    public static void shaderSetValue(Shader shader, String string, float f) {
        ShaderProgram.Uniform uniform = IndieGL.getShaderUniform(shader, string, 5126);
        if (uniform != null) {
            IndieGL.ShaderUpdate1f(shader.getID(), uniform.loc, f);
        }
    }

    public static void shaderSetValue(Shader shader, String string, int n) {
        ShaderProgram.Uniform uniform = IndieGL.getShaderUniform(shader, string, 5124);
        if (uniform != null) {
            IndieGL.ShaderUpdate1i(shader.getID(), uniform.loc, n);
        }
    }

    public static void shaderSetValue(Shader shader, String string, Vector2 vector22) {
        IndieGL.shaderSetVector2(shader, string, vector22.x, vector22.y);
    }

    public static void shaderSetValue(Shader shader, String string, Vector3 vector3) {
        IndieGL.shaderSetVector3(shader, string, vector3.x, vector3.y, vector3.z);
    }

    public static void shaderSetValue(Shader shader, String string, Vector4 vector4) {
        IndieGL.shaderSetVector4(shader, string, vector4.x, vector4.y, vector4.z, vector4.w);
    }

    public static void shaderSetVector2(Shader shader, String string, float f, float f2) {
        ShaderProgram.Uniform uniform = IndieGL.getShaderUniform(shader, string, 35664);
        if (uniform != null) {
            IndieGL.ShaderUpdate2f(shader.getID(), uniform.loc, f, f2);
        }
    }

    public static void shaderSetVector3(Shader shader, String string, float f, float f2, float f3) {
        ShaderProgram.Uniform uniform = IndieGL.getShaderUniform(shader, string, 35665);
        if (uniform != null) {
            IndieGL.ShaderUpdate3f(shader.getID(), uniform.loc, f, f2, f3);
        }
    }

    public static void shaderSetVector4(Shader shader, String string, float f, float f2, float f3, float f4) {
        ShaderProgram.Uniform uniform = IndieGL.getShaderUniform(shader, string, 35666);
        if (uniform != null) {
            IndieGL.ShaderUpdate4f(shader.getID(), uniform.loc, f, f2, f3, f4);
        }
    }

    public static void ShaderUpdate1i(int n, int n2, int n3) {
        SpriteRenderer.instance.ShaderUpdate1i(n, n2, n3);
    }

    public static void ShaderUpdate1f(int n, int n2, float f) {
        SpriteRenderer.instance.ShaderUpdate1f(n, n2, f);
    }

    public static void ShaderUpdate2f(int n, int n2, float f, float f2) {
        SpriteRenderer.instance.ShaderUpdate2f(n, n2, f, f2);
    }

    public static void ShaderUpdate3f(int n, int n2, float f, float f2, float f3) {
        SpriteRenderer.instance.ShaderUpdate3f(n, n2, f, f2, f3);
    }

    public static void ShaderUpdate4f(int n, int n2, float f, float f2, float f3, float f4) {
        SpriteRenderer.instance.ShaderUpdate4f(n, n2, f, f2, f3, f4);
    }

    public static void glBlendFuncA(int n, int n2) {
        GL11.glBlendFunc((int)n, (int)n2);
    }

    public static void glEnable(int n) {
        SpriteRenderer.instance.glEnable(n);
    }

    public static void glDoStartFrame(int n, int n2, float f, int n3) {
        IndieGL.glDoStartFrame(n, n2, f, n3, false);
    }

    public static void glDoStartFrame(int n, int n2, float f, int n3, boolean bl) {
        SpriteRenderer.instance.glDoStartFrame(n, n2, f, n3, bl);
    }

    public static void glDoEndFrame() {
        SpriteRenderer.instance.glDoEndFrame();
    }

    public static void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GLState.ColorMask.set(temp4Booleans.set(bl, bl2, bl3, bl4));
    }

    public static void glColorMaskA(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GL11.glColorMask((boolean)bl, (boolean)bl, (boolean)bl4, (boolean)bl4);
    }

    public static void glEnableA(int n) {
        GL11.glEnable((int)n);
    }

    public static void glAlphaFunc(int n, float f) {
        GLState.AlphaFunc.set(tempIntFloat.set(n, f));
    }

    public static void glAlphaFuncA(int n, float f) {
        GL11.glAlphaFunc((int)n, (float)f);
    }

    public static void glStencilFunc(int n, int n2, int n3) {
        GLState.StencilFunc.set(temp3Ints.set(n, n2, n3));
    }

    public static void glStencilFuncA(int n, int n2, int n3) {
        GL11.glStencilFunc((int)n, (int)n2, (int)n3);
    }

    public static void glStencilOp(int n, int n2, int n3) {
        GLState.StencilOp.set(temp3Ints.set(n, n2, n3));
    }

    public static void glStencilOpA(int n, int n2, int n3) {
        GL11.glStencilOp((int)n, (int)n2, (int)n3);
    }

    public static void glTexParameteri(int n, int n2, int n3) {
        SpriteRenderer.instance.glTexParameteri(n, n2, n3);
    }

    public static void glTexParameteriActual(int n, int n2, int n3) {
        GL11.glTexParameteri((int)n, (int)n2, (int)n3);
    }

    public static void glStencilMask(int n) {
        GLState.StencilMask.set(tempInt.set(n));
    }

    public static void glStencilMaskA(int n) {
        GL11.glStencilMask((int)n);
    }

    public static void glDisable(int n) {
        SpriteRenderer.instance.glDisable(n);
    }

    public static void glClear(int n) {
        SpriteRenderer.instance.glClear(n);
    }

    public static void glClearA(int n) {
        GL11.glClear((int)n);
    }

    public static void glDisableA(int n) {
        GL11.glDisable((int)n);
    }

    public static void glLoadIdentity() {
        SpriteRenderer.instance.glLoadIdentity();
    }

    public static void glBind(Texture texture) {
        SpriteRenderer.instance.glBind(texture.getID());
    }

    public static void enableAlphaTest() {
        GLState.AlphaTest.set(GLState.CBooleanValue.TRUE);
    }

    public static void disableAlphaTest() {
        GLState.AlphaTest.set(GLState.CBooleanValue.FALSE);
    }

    public static void enableStencilTest() {
        GLState.StencilTest.set(GLState.CBooleanValue.TRUE);
    }

    public static void disableStencilTest() {
        GLState.StencilTest.set(GLState.CBooleanValue.FALSE);
    }

    public static boolean isMaxZoomLevel() {
        return SpriteRenderer.instance.isMaxZoomLevel();
    }

    public static boolean isMinZoomLevel() {
        return SpriteRenderer.instance.isMinZoomLevel();
    }
}

