/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import zombie.DebugFileWatcher;
import zombie.GameProfileRecording;
import zombie.PredicatedFileWatcher;
import zombie.ZomboidFileSystem;
import zombie.core.profiling.TriggerGameProfilerFile;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.IsoCamera;
import zombie.ui.TextManager;
import zombie.util.IPooledObject;
import zombie.util.Lambda;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.lambda.Invokers;

public final class GameProfiler {
    private static final String s_currentSessionUUID = UUID.randomUUID().toString();
    private static final ThreadLocal<GameProfiler> s_instance = ThreadLocal.withInitial(GameProfiler::new);
    private final Stack<ProfileArea> m_stack = new Stack();
    private final RecordingFrame m_currentFrame = new RecordingFrame();
    private final RecordingFrame m_previousFrame = new RecordingFrame();
    private boolean m_isInFrame;
    private final GameProfileRecording m_recorder;
    private static final Object m_gameProfilerRecordingTriggerLock = "Game Profiler Recording Watcher, synchronization lock";
    private static PredicatedFileWatcher m_gameProfilerRecordingTriggerWatcher;

    private GameProfiler() {
        String string = Thread.currentThread().getName();
        String string2 = string.replace("-", "").replace(" ", "");
        String string3 = String.format("%s_GameProfiler_%s", this.getCurrentSessionUUID(), string2);
        this.m_recorder = new GameProfileRecording(string3);
    }

    private static void onTrigger_setAnimationRecorderTriggerFile(TriggerGameProfilerFile triggerGameProfilerFile) {
        DebugOptions.instance.GameProfilerEnabled.setValue(triggerGameProfilerFile.isRecording);
    }

    private String getCurrentSessionUUID() {
        return s_currentSessionUUID;
    }

    public static GameProfiler getInstance() {
        return s_instance.get();
    }

    public void startFrame(String string) {
        if (this.m_isInFrame) {
            throw new RuntimeException("Already inside a frame.");
        }
        this.m_isInFrame = true;
        if (!this.m_stack.empty()) {
            throw new RuntimeException("Recording stack should be empty.");
        }
        int n = IsoCamera.frameState.frameCount;
        if (this.m_currentFrame.FrameNo != n) {
            this.m_previousFrame.transferFrom(this.m_currentFrame);
            if (this.m_previousFrame.FrameNo != -1) {
                this.m_recorder.writeLine();
            }
            long l = GameProfiler.getTimeNs();
            this.m_currentFrame.FrameNo = n;
            this.m_currentFrame.m_frameInvokerKey = string;
            this.m_currentFrame.m_startTime = l;
            this.m_recorder.reset();
            this.m_recorder.setFrameNumber(this.m_currentFrame.FrameNo);
            this.m_recorder.setStartTime(this.m_currentFrame.m_startTime);
        }
    }

    public void endFrame() {
        this.m_currentFrame.m_endTime = GameProfiler.getTimeNs();
        this.m_currentFrame.m_totalTime = this.m_currentFrame.m_endTime - this.m_currentFrame.m_startTime;
        this.m_isInFrame = false;
    }

    public void invokeAndMeasureFrame(String string, Runnable runnable) {
        if (!GameProfiler.isRunning()) {
            runnable.run();
            return;
        }
        this.startFrame(string);
        try {
            this.invokeAndMeasure(string, runnable);
        }
        finally {
            this.endFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndMeasure(String string, Runnable runnable) {
        if (!GameProfiler.isRunning()) {
            runnable.run();
            return;
        }
        if (!this.m_isInFrame) {
            DebugLog.General.warn("Not inside in a frame. Find the root caller function for this thread, and add call to invokeAndMeasureFrame.");
            return;
        }
        ProfileArea profileArea = this.start(string);
        try {
            runnable.run();
        }
        finally {
            this.end(profileArea);
        }
    }

    public static boolean isRunning() {
        return DebugOptions.instance.GameProfilerEnabled.getValue();
    }

    public <T1> void invokeAndMeasure(String string2, T1 T1, Invokers.Params1.ICallback<T1> iCallback2) {
        if (!GameProfiler.isRunning()) {
            iCallback2.accept(T1);
            return;
        }
        Lambda.capture(this, string2, T1, iCallback2, (genericStack, gameProfiler, string, object, iCallback) -> gameProfiler.invokeAndMeasure((String)string, genericStack.invoker(object, iCallback)));
    }

    public <T1, T2> void invokeAndMeasure(String string2, T1 T1, T2 T2, Invokers.Params2.ICallback<T1, T2> iCallback2) {
        if (!GameProfiler.isRunning()) {
            iCallback2.accept(T1, T2);
            return;
        }
        Lambda.capture(this, string2, T1, T2, iCallback2, (genericStack, gameProfiler, string, object, object2, iCallback) -> gameProfiler.invokeAndMeasure((String)string, genericStack.invoker(object, object2, iCallback)));
    }

    public <T1, T2, T3> void invokeAndMeasure(String string2, T1 T1, T2 T2, T3 T3, Invokers.Params3.ICallback<T1, T2, T3> iCallback2) {
        if (!GameProfiler.isRunning()) {
            iCallback2.accept(T1, T2, T3);
            return;
        }
        Lambda.capture(this, string2, T1, T2, T3, iCallback2, (genericStack, gameProfiler, string, object, object2, object3, iCallback) -> gameProfiler.invokeAndMeasure((String)string, genericStack.invoker(object, object2, object3, iCallback)));
    }

    public ProfileArea start(String string) {
        long l = GameProfiler.getTimeNs();
        ProfileArea profileArea = ProfileArea.alloc();
        profileArea.Key = string;
        return this.start(profileArea, l);
    }

    public ProfileArea start(ProfileArea profileArea) {
        long l = GameProfiler.getTimeNs();
        return this.start(profileArea, l);
    }

    public ProfileArea start(ProfileArea profileArea, long l) {
        profileArea.StartTime = l;
        profileArea.Depth = this.m_stack.size();
        if (!this.m_stack.isEmpty()) {
            ProfileArea profileArea2 = this.m_stack.peek();
            profileArea2.Children.add(profileArea);
        }
        this.m_stack.push(profileArea);
        return profileArea;
    }

    public void end(ProfileArea profileArea) {
        profileArea.EndTime = GameProfiler.getTimeNs();
        profileArea.Total = profileArea.EndTime - profileArea.StartTime;
        if (this.m_stack.peek() != profileArea) {
            throw new RuntimeException("Incorrect exit. ProfileArea " + profileArea + " is not at the top of the stack: " + this.m_stack.peek());
        }
        this.m_stack.pop();
        if (this.m_stack.isEmpty()) {
            this.m_recorder.logTimeSpan(profileArea);
            profileArea.release();
        }
    }

    private void renderPercent(String string, long l, int n, int n2, float f, float f2, float f3) {
        float f4 = (float)l / (float)this.m_previousFrame.m_totalTime;
        f4 *= 100.0f;
        f4 = (float)((int)(f4 * 10.0f)) / 10.0f;
        TextManager.instance.DrawString(n, n2, string, f, f2, f3, 1.0);
        TextManager.instance.DrawString(n + 300, n2, String.valueOf(f4) + "%", f, f2, f3, 1.0);
    }

    public void render(int n, int n2) {
        this.renderPercent(this.m_previousFrame.m_frameInvokerKey, this.m_previousFrame.m_totalTime, n, n2, 1.0f, 1.0f, 1.0f);
    }

    public static long getTimeNs() {
        return System.nanoTime();
    }

    public static void init() {
        GameProfiler.initTriggerWatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTriggerWatcher() {
        if (m_gameProfilerRecordingTriggerWatcher == null) {
            Object object = m_gameProfilerRecordingTriggerLock;
            synchronized (object) {
                if (m_gameProfilerRecordingTriggerWatcher == null) {
                    m_gameProfilerRecordingTriggerWatcher = new PredicatedFileWatcher(ZomboidFileSystem.instance.getMessagingDirSub("Trigger_PerformanceProfiler.xml"), TriggerGameProfilerFile.class, GameProfiler::onTrigger_setAnimationRecorderTriggerFile);
                    DebugFileWatcher.instance.add(m_gameProfilerRecordingTriggerWatcher);
                }
            }
        }
    }

    public static class RecordingFrame {
        private String m_frameInvokerKey = "";
        private int FrameNo = -1;
        private long m_startTime = 0L;
        private long m_endTime = 0L;
        private long m_totalTime = 0L;

        public void transferFrom(RecordingFrame recordingFrame) {
            this.clear();
            this.FrameNo = recordingFrame.FrameNo;
            this.m_frameInvokerKey = recordingFrame.m_frameInvokerKey;
            this.m_startTime = recordingFrame.m_startTime;
            this.m_endTime = recordingFrame.m_endTime;
            this.m_totalTime = recordingFrame.m_totalTime;
            recordingFrame.clear();
        }

        public void clear() {
            this.FrameNo = -1;
            this.m_frameInvokerKey = "";
            this.m_startTime = 0L;
            this.m_endTime = 0L;
            this.m_totalTime = 0L;
        }
    }

    public static class ProfileArea
    extends PooledObject {
        public String Key;
        public long StartTime;
        public long EndTime;
        public long Total;
        public int Depth;
        public float r = 1.0f;
        public float g = 1.0f;
        public float b = 1.0f;
        public final List<ProfileArea> Children = new ArrayList<ProfileArea>();
        private static final Pool<ProfileArea> s_pool = new Pool<ProfileArea>(ProfileArea::new);

        @Override
        public void onReleased() {
            super.onReleased();
            this.clear();
        }

        public void clear() {
            this.StartTime = 0L;
            this.EndTime = 0L;
            this.Total = 0L;
            this.Depth = 0;
            IPooledObject.release(this.Children);
        }

        public static ProfileArea alloc() {
            return s_pool.alloc();
        }
    }
}

