/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import zombie.GameTime;
import zombie.GameWindow;
import zombie.core.PerformanceSettings;

public final class FPSTracking {
    private final double[] lastFPS = new double[20];
    private int lastFPSCount = 0;
    private long timeAtLastUpdate;
    private final long[] last10 = new long[10];
    private int last10index = 0;

    public void init() {
        for (int i = 0; i < 20; ++i) {
            this.lastFPS[i] = PerformanceSettings.getLockFPS();
        }
        this.timeAtLastUpdate = System.nanoTime();
    }

    public long frameStep() {
        long l = System.nanoTime();
        long l2 = l - this.timeAtLastUpdate;
        if (l2 > 0L) {
            double d;
            float f = 0.0f;
            double d2 = (double)l2 / 1.0E9;
            this.lastFPS[this.lastFPSCount] = d = 1.0 / d2;
            ++this.lastFPSCount;
            if (this.lastFPSCount >= 5) {
                this.lastFPSCount = 0;
            }
            for (int i = 0; i < 5; ++i) {
                f = (float)((double)f + this.lastFPS[i]);
            }
            GameWindow.averageFPS = f /= 5.0f;
            GameTime.instance.FPSMultiplier = (float)(60.0 / d);
            if (GameTime.instance.FPSMultiplier > 5.0f) {
                GameTime.instance.FPSMultiplier = 5.0f;
            }
        }
        this.timeAtLastUpdate = l;
        this.updateFPS(l2);
        return l2;
    }

    public void updateFPS(long l) {
        this.last10[this.last10index++] = l;
        if (this.last10index >= this.last10.length) {
            this.last10index = 0;
        }
        float f = 11110.0f;
        float f2 = -11110.0f;
        for (long l2 : this.last10) {
            if (l2 == 0L) continue;
            if ((float)l2 < f) {
                f = l2;
            }
            if (!((float)l2 > f2)) continue;
            f2 = l2;
        }
    }
}

