/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.PredicatedFileWatcher;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;

public final class DebugFileWatcher {
    private final HashMap<Path, String> m_watchedFiles = new HashMap();
    private final HashMap<WatchKey, Path> m_watchkeyMapping = new HashMap();
    private final ArrayList<PredicatedFileWatcher> m_predicateWatchers = new ArrayList();
    private final ArrayList<PredicatedFileWatcher> m_predicateWatchersInvoking = new ArrayList();
    private final FileSystem m_fs = FileSystems.getDefault();
    private WatchService m_watcher;
    private boolean m_predicateWatchersInvokingDirty = true;
    private long m_modificationTime = -1L;
    private final ArrayList<String> m_modifiedFiles = new ArrayList();
    public static final DebugFileWatcher instance = new DebugFileWatcher();

    private DebugFileWatcher() {
    }

    public void init() {
        try {
            this.m_watcher = this.m_fs.newWatchService();
            this.registerDirRecursive(this.m_fs.getPath(ZomboidFileSystem.instance.getMediaRootPath(), new String[0]));
            this.registerDirRecursive(this.m_fs.getPath(ZomboidFileSystem.instance.getMessagingDir(), new String[0]));
        }
        catch (IOException iOException) {
            this.m_watcher = null;
        }
    }

    private void registerDirRecursive(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    DebugFileWatcher.this.registerDir(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            ExceptionLogger.logException(iOException);
            this.m_watcher = null;
        }
    }

    private void registerDir(Path path) {
        try {
            WatchKey watchKey = path.register(this.m_watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.m_watchkeyMapping.put(watchKey, path);
        }
        catch (IOException iOException) {
            ExceptionLogger.logException(iOException);
            this.m_watcher = null;
        }
    }

    private void addWatchedFile(String string) {
        if (string != null) {
            this.m_watchedFiles.put(this.m_fs.getPath(string, new String[0]), string);
        }
    }

    public void add(PredicatedFileWatcher predicatedFileWatcher) {
        if (!this.m_predicateWatchers.contains(predicatedFileWatcher)) {
            this.addWatchedFile(predicatedFileWatcher.getPath());
            this.m_predicateWatchers.add(predicatedFileWatcher);
            this.m_predicateWatchersInvokingDirty = true;
        }
    }

    public void addDirectory(String string) {
        if (string != null) {
            this.registerDir(this.m_fs.getPath(string, new String[0]));
        }
    }

    public void addDirectoryRecurse(String string) {
        if (string != null) {
            this.registerDirRecursive(this.m_fs.getPath(string, new String[0]));
        }
    }

    public void remove(PredicatedFileWatcher predicatedFileWatcher) {
        this.m_predicateWatchers.remove(predicatedFileWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object;
        if (this.m_watcher == null) {
            return;
        }
        WatchKey watchKey = this.m_watcher.poll();
        while (watchKey != null) {
            try {
                object = this.m_watchkeyMapping.getOrDefault(watchKey, null);
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    String string;
                    Path path;
                    Path path2;
                    WatchEvent<?> watchEvent2;
                    if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                        watchEvent2 = watchEvent;
                        path2 = (Path)watchEvent2.context();
                        path = object.resolve(path2);
                        string = this.m_watchedFiles.getOrDefault(path, path.toString());
                        this.m_modificationTime = System.currentTimeMillis();
                        if (this.m_modifiedFiles.contains(string)) continue;
                        this.m_modifiedFiles.add(string);
                        continue;
                    }
                    if (watchEvent.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
                    watchEvent2 = watchEvent;
                    path2 = (Path)watchEvent2.context();
                    path = object.resolve(path2);
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.registerDirRecursive(path);
                        continue;
                    }
                    string = this.m_watchedFiles.getOrDefault(path, path.toString());
                    this.m_modificationTime = System.currentTimeMillis();
                    if (this.m_modifiedFiles.contains(string)) continue;
                    this.m_modifiedFiles.add(string);
                }
            }
            finally {
                if (!watchKey.reset()) {
                    this.m_watchkeyMapping.remove(watchKey);
                }
            }
            watchKey = this.m_watcher.poll();
        }
        if (this.m_modifiedFiles.isEmpty()) {
            return;
        }
        if (this.m_modificationTime + 2000L > System.currentTimeMillis()) {
            return;
        }
        for (int i = this.m_modifiedFiles.size() - 1; i >= 0; --i) {
            object = this.m_modifiedFiles.remove(i);
            this.swapWatcherArrays();
            for (PredicatedFileWatcher predicatedFileWatcher : this.m_predicateWatchersInvoking) {
                predicatedFileWatcher.onModified((String)object);
            }
        }
    }

    private void swapWatcherArrays() {
        if (this.m_predicateWatchersInvokingDirty) {
            this.m_predicateWatchersInvoking.clear();
            this.m_predicateWatchersInvoking.addAll(this.m_predicateWatchers);
            this.m_predicateWatchersInvokingDirty = false;
        }
    }
}

