/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import zombie.MovingObjectUpdateScheduler;
import zombie.characters.IsoSurvivor;
import zombie.characters.ZombieFootstepManager;
import zombie.characters.ZombieThumpManager;
import zombie.characters.ZombieVocalsManager;
import zombie.core.collision.Polygon;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoPushableObject;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;

public final class CollisionManager {
    static Vector2 temp = new Vector2();
    static Vector2 axis = new Vector2();
    static Polygon polygonA = new Polygon();
    static Polygon polygonB = new Polygon();
    float minA = 0.0f;
    float minB = 0.0f;
    float maxA = 0.0f;
    float maxB = 0.0f;
    PolygonCollisionResult result = new PolygonCollisionResult();
    public ArrayList<Contact> ContactMap = new ArrayList();
    Long[] longArray = new Long[1000];
    Stack<Contact> contacts = new Stack();
    public static final CollisionManager instance = new CollisionManager();

    private void ProjectPolygonA(Vector2 vector22, Polygon polygon) {
        float f;
        this.minA = f = vector22.dot(polygon.points.get(0));
        this.maxA = f;
        for (int i = 0; i < polygon.points.size(); ++i) {
            f = polygon.points.get(i).dot(vector22);
            if (f < this.minA) {
                this.minA = f;
                continue;
            }
            if (!(f > this.maxA)) continue;
            this.maxA = f;
        }
    }

    private void ProjectPolygonB(Vector2 vector22, Polygon polygon) {
        float f;
        this.minB = f = vector22.dot(polygon.points.get(0));
        this.maxB = f;
        for (int i = 0; i < polygon.points.size(); ++i) {
            f = polygon.points.get(i).dot(vector22);
            if (f < this.minB) {
                this.minB = f;
                continue;
            }
            if (!(f > this.maxB)) continue;
            this.maxB = f;
        }
    }

    public PolygonCollisionResult PolygonCollision(Vector2 vector22) {
        this.result.Intersect = true;
        this.result.WillIntersect = true;
        this.result.MinimumTranslationVector.x = 0.0f;
        this.result.MinimumTranslationVector.y = 0.0f;
        int n = CollisionManager.polygonA.edges.size();
        int n2 = CollisionManager.polygonB.edges.size();
        float f = Float.POSITIVE_INFINITY;
        Vector2 vector23 = new Vector2();
        for (int i = 0; i < n + n2; ++i) {
            float f2;
            Vector2 vector24 = i < n ? CollisionManager.polygonA.edges.get(i) : CollisionManager.polygonB.edges.get(i - n);
            CollisionManager.axis.x = -vector24.y;
            CollisionManager.axis.y = vector24.x;
            axis.normalize();
            this.minA = 0.0f;
            this.minB = 0.0f;
            this.maxA = 0.0f;
            this.maxB = 0.0f;
            this.ProjectPolygonA(axis, polygonA);
            this.ProjectPolygonB(axis, polygonB);
            if (this.IntervalDistance(this.minA, this.maxA, this.minB, this.maxB) > 0.0f) {
                this.result.Intersect = false;
            }
            if ((f2 = axis.dot(vector22)) < 0.0f) {
                this.minA += f2;
            } else {
                this.maxA += f2;
            }
            float f3 = this.IntervalDistance(this.minA, this.maxA, this.minB, this.maxB);
            if (f3 > 0.0f) {
                this.result.WillIntersect = false;
            }
            if (!this.result.Intersect && !this.result.WillIntersect) break;
            if (!((f3 = Math.abs(f3)) < f)) continue;
            f = f3;
            vector23.x = CollisionManager.axis.x;
            vector23.y = CollisionManager.axis.y;
            CollisionManager.temp.x = CollisionManager.polygonA.Center().x - CollisionManager.polygonB.Center().x;
            CollisionManager.temp.y = CollisionManager.polygonA.Center().y - CollisionManager.polygonB.Center().y;
            if (!(temp.dot(vector23) < 0.0f)) continue;
            vector23.x = -vector23.x;
            vector23.y = -vector23.y;
        }
        if (this.result.WillIntersect) {
            this.result.MinimumTranslationVector.x = vector23.x * f;
            this.result.MinimumTranslationVector.y = vector23.y * f;
        }
        return this.result;
    }

    public float IntervalDistance(float f, float f2, float f3, float f4) {
        if (f < f3) {
            return f3 - f2;
        }
        return f - f4;
    }

    public void initUpdate() {
        int n;
        if (this.longArray[0] == null) {
            for (n = 0; n < this.longArray.length; ++n) {
                this.longArray[n] = new Long(0L);
            }
        }
        for (n = 0; n < this.ContactMap.size(); ++n) {
            this.ContactMap.get((int)n).a = null;
            this.ContactMap.get((int)n).b = null;
            this.contacts.push(this.ContactMap.get(n));
        }
        this.ContactMap.clear();
    }

    public void AddContact(IsoMovingObject isoMovingObject, IsoMovingObject isoMovingObject2) {
        if ((isoMovingObject instanceof IsoSurvivor || isoMovingObject2 instanceof IsoSurvivor) && (isoMovingObject instanceof IsoPushableObject || isoMovingObject2 instanceof IsoPushableObject)) {
            return;
        }
        if (isoMovingObject.getID() < isoMovingObject2.getID()) {
            this.ContactMap.add(this.contact(isoMovingObject, isoMovingObject2));
        }
    }

    Contact contact(IsoMovingObject isoMovingObject, IsoMovingObject isoMovingObject2) {
        if (this.contacts.isEmpty()) {
            for (int i = 0; i < 50; ++i) {
                this.contacts.push(new Contact(null, null));
            }
        }
        Contact contact = this.contacts.pop();
        contact.a = isoMovingObject;
        contact.b = isoMovingObject2;
        return contact;
    }

    public void ResolveContacts() {
        s_performance.profile_ResolveContacts.invokeAndMeasure(this, CollisionManager::resolveContactsInternal);
    }

    private void resolveContactsInternal() {
        float f;
        int n;
        int n2;
        Vector2 vector22 = l_ResolveContacts.vel;
        Vector2 vector23 = l_ResolveContacts.vel2;
        List<IsoPushableObject> list = l_ResolveContacts.pushables;
        ArrayList<IsoPushableObject> arrayList = IsoWorld.instance.CurrentCell.getPushableObjectList();
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            IsoPushableObject isoPushableObject = (IsoPushableObject)arrayList.get(n2);
            if (isoPushableObject.getImpulsex() == 0.0f && isoPushableObject.getImpulsey() == 0.0f) continue;
            if (isoPushableObject.connectList != null) {
                list.add(isoPushableObject);
                continue;
            }
            isoPushableObject.setNx(isoPushableObject.getNx() + isoPushableObject.getImpulsex());
            isoPushableObject.setNy(isoPushableObject.getNy() + isoPushableObject.getImpulsey());
            isoPushableObject.setImpulsex(isoPushableObject.getNx() - isoPushableObject.getX());
            isoPushableObject.setImpulsey(isoPushableObject.getNy() - isoPushableObject.getY());
            isoPushableObject.setNx(isoPushableObject.getX());
            isoPushableObject.setNy(isoPushableObject.getY());
        }
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            int n4;
            IsoPushableObject isoPushableObject = list.get(n);
            float f2 = 0.0f;
            f = 0.0f;
            for (n4 = 0; n4 < isoPushableObject.connectList.size(); ++n4) {
                f2 += isoPushableObject.connectList.get(n4).getImpulsex();
                f += isoPushableObject.connectList.get(n4).getImpulsey();
            }
            f2 /= (float)isoPushableObject.connectList.size();
            f /= (float)isoPushableObject.connectList.size();
            for (n4 = 0; n4 < isoPushableObject.connectList.size(); ++n4) {
                isoPushableObject.connectList.get(n4).setImpulsex(f2);
                isoPushableObject.connectList.get(n4).setImpulsey(f);
                int n5 = list.indexOf(isoPushableObject.connectList.get(n4));
                list.remove(isoPushableObject.connectList.get(n4));
                if (n5 > n) continue;
                --n;
            }
            if (n >= 0) continue;
            n = 0;
        }
        list.clear();
        n = this.ContactMap.size();
        for (int i = 0; i < n; ++i) {
            IsoPushableObject isoPushableObject;
            int n6;
            int n7;
            ArrayList<IsoPushableObject> arrayList2;
            Contact contact = this.ContactMap.get(i);
            if (Math.abs(contact.a.getZ() - contact.b.getZ()) > 0.3f) continue;
            vector22.x = contact.a.getNx() - contact.a.getX();
            vector22.y = contact.a.getNy() - contact.a.getY();
            vector23.x = contact.b.getNx() - contact.b.getX();
            vector23.y = contact.b.getNy() - contact.b.getY();
            if (vector22.x == 0.0f && vector22.y == 0.0f && vector23.x == 0.0f && vector23.y == 0.0f && contact.a.getImpulsex() == 0.0f && contact.a.getImpulsey() == 0.0f && contact.b.getImpulsex() == 0.0f && contact.b.getImpulsey() == 0.0f) continue;
            f = contact.a.getX() - contact.a.getWidth();
            float f3 = contact.a.getX() + contact.a.getWidth();
            float f4 = contact.a.getY() - contact.a.getWidth();
            float f5 = contact.a.getY() + contact.a.getWidth();
            float f6 = contact.b.getX() - contact.b.getWidth();
            float f7 = contact.b.getX() + contact.b.getWidth();
            float f8 = contact.b.getY() - contact.b.getWidth();
            float f9 = contact.b.getY() + contact.b.getWidth();
            polygonA.Set(f, f4, f3, f5);
            polygonB.Set(f6, f8, f7, f9);
            PolygonCollisionResult polygonCollisionResult = this.PolygonCollision(vector22);
            if (!polygonCollisionResult.WillIntersect) continue;
            contact.a.collideWith(contact.b);
            contact.b.collideWith(contact.a);
            float f10 = 1.0f - contact.a.getWeight(polygonCollisionResult.MinimumTranslationVector.x, polygonCollisionResult.MinimumTranslationVector.y) / (contact.a.getWeight(polygonCollisionResult.MinimumTranslationVector.x, polygonCollisionResult.MinimumTranslationVector.y) + contact.b.getWeight(polygonCollisionResult.MinimumTranslationVector.x, polygonCollisionResult.MinimumTranslationVector.y));
            if (contact.a instanceof IsoPushableObject && contact.b instanceof IsoSurvivor) {
                ((IsoSurvivor)contact.b).bCollidedWithPushable = true;
                ((IsoSurvivor)contact.b).collidePushable = (IsoPushableObject)contact.a;
            } else if (contact.b instanceof IsoPushableObject && contact.a instanceof IsoSurvivor) {
                ((IsoSurvivor)contact.a).bCollidedWithPushable = true;
                ((IsoSurvivor)contact.a).collidePushable = (IsoPushableObject)contact.b;
            }
            if (contact.a instanceof IsoPushableObject) {
                arrayList2 = ((IsoPushableObject)contact.a).connectList;
                if (arrayList2 != null) {
                    n7 = arrayList2.size();
                    for (n6 = 0; n6 < n7; ++n6) {
                        isoPushableObject = arrayList2.get(n6);
                        isoPushableObject.setImpulsex(isoPushableObject.getImpulsex() + polygonCollisionResult.MinimumTranslationVector.x * f10);
                        isoPushableObject.setImpulsey(isoPushableObject.getImpulsey() + polygonCollisionResult.MinimumTranslationVector.y * f10);
                    }
                }
            } else {
                contact.a.setImpulsex(contact.a.getImpulsex() + polygonCollisionResult.MinimumTranslationVector.x * f10);
                contact.a.setImpulsey(contact.a.getImpulsey() + polygonCollisionResult.MinimumTranslationVector.y * f10);
            }
            if (contact.b instanceof IsoPushableObject) {
                arrayList2 = ((IsoPushableObject)contact.b).connectList;
                if (arrayList2 == null) continue;
                n7 = arrayList2.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    isoPushableObject = arrayList2.get(n6);
                    isoPushableObject.setImpulsex(isoPushableObject.getImpulsex() - polygonCollisionResult.MinimumTranslationVector.x * (1.0f - f10));
                    isoPushableObject.setImpulsey(isoPushableObject.getImpulsey() - polygonCollisionResult.MinimumTranslationVector.y * (1.0f - f10));
                }
                continue;
            }
            contact.b.setImpulsex(contact.b.getImpulsex() - polygonCollisionResult.MinimumTranslationVector.x * (1.0f - f10));
            contact.b.setImpulsey(contact.b.getImpulsey() - polygonCollisionResult.MinimumTranslationVector.y * (1.0f - f10));
        }
        ArrayList<IsoMovingObject> arrayList3 = IsoWorld.instance.CurrentCell.getObjectList();
        int n8 = arrayList3.size();
        MovingObjectUpdateScheduler.instance.postupdate();
        IsoMovingObject.treeSoundMgr.update();
        ZombieFootstepManager.instance.update();
        ZombieThumpManager.instance.update();
        ZombieVocalsManager.instance.update();
    }

    public class PolygonCollisionResult {
        public boolean WillIntersect;
        public boolean Intersect;
        public Vector2 MinimumTranslationVector = new Vector2();
    }

    public class Contact {
        public IsoMovingObject a;
        public IsoMovingObject b;

        public Contact(IsoMovingObject isoMovingObject, IsoMovingObject isoMovingObject2) {
            this.a = isoMovingObject;
            this.b = isoMovingObject2;
        }
    }

    private static class s_performance {
        static final PerformanceProfileProbe profile_ResolveContacts = new PerformanceProfileProbe("CollisionManager.ResolveContacts");
        static final PerformanceProfileProbe profile_MovingObjectPostUpdate = new PerformanceProfileProbe("IsoMovingObject.postupdate");

        private s_performance() {
        }
    }

    private static class l_ResolveContacts {
        static final Vector2 vel = new Vector2();
        static final Vector2 vel2 = new Vector2();
        static final List<IsoPushableObject> pushables = new ArrayList<IsoPushableObject>();
        static IsoMovingObject[] objectListInvoking = new IsoMovingObject[1024];

        private l_ResolveContacts() {
        }
    }
}

