/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import zombie.BaseAmbientStreamManager;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.WorldSoundManager;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.Vector2;
import zombie.network.GameServer;

public final class AmbientSoundManager
extends BaseAmbientStreamManager {
    public final ArrayList<Ambient> ambient = new ArrayList();
    private final Vector2 tempo = new Vector2();
    private int electricityShutOffState = -1;
    private long electricityShutOffTime = 0L;
    public boolean initialized = false;

    @Override
    public void update() {
        if (!this.initialized) {
            return;
        }
        this.updatePowerSupply();
        this.doOneShotAmbients();
    }

    @Override
    public void addAmbient(String string, int n, int n2, int n3, float f) {
    }

    @Override
    public void addAmbientEmitter(float f, float f2, int n, String string) {
    }

    @Override
    public void addDaytimeAmbientEmitter(float f, float f2, int n, String string) {
    }

    @Override
    public void doOneShotAmbients() {
        for (int i = 0; i < this.ambient.size(); ++i) {
            Ambient ambient = this.ambient.get(i);
            if (ambient.finished()) {
                DebugLog.log(DebugType.Sound, "ambient: removing ambient sound " + ambient.name);
                this.ambient.remove(i--);
                continue;
            }
            ambient.update();
        }
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
    }

    @Override
    public void addBlend(String string, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    @Override
    protected void addRandomAmbient() {
        if (GameServer.Players.isEmpty()) {
            return;
        }
        IsoPlayer isoPlayer = GameServer.Players.get(Rand.Next(GameServer.Players.size()));
        if (isoPlayer == null) {
            return;
        }
        String string = null;
        if (GameTime.instance.getHour() > 7 && GameTime.instance.getHour() < 21) {
            switch (Rand.Next(3)) {
                case 0: {
                    if (Rand.Next(10) >= 2) break;
                    string = "MetaDogBark";
                    break;
                }
                case 1: {
                    if (Rand.Next(10) >= 3) break;
                    string = "MetaScream";
                }
            }
        } else {
            switch (Rand.Next(5)) {
                case 0: {
                    if (Rand.Next(10) >= 2) break;
                    string = "MetaDogBark";
                    break;
                }
                case 1: {
                    if (Rand.Next(13) >= 3) break;
                    string = "MetaScream";
                    break;
                }
                case 2: {
                    string = "MetaOwl";
                    break;
                }
                case 3: {
                    string = "MetaWolfHowl";
                }
            }
        }
        if (string == null) {
            return;
        }
        float f = isoPlayer.x;
        float f2 = isoPlayer.y;
        double d = Rand.Next((float)(-Math.PI), (float)Math.PI);
        this.tempo.x = (float)Math.cos(d);
        this.tempo.y = (float)Math.sin(d);
        this.tempo.setLength(1000.0f);
        Ambient ambient = new Ambient(string, f += this.tempo.x, f2 += this.tempo.y, 50.0f, Rand.Next(0.2f, 0.5f));
        this.ambient.add(ambient);
        GameServer.sendAmbient(string, (int)f, (int)f2, 50, Rand.Next(0.2f, 0.5f));
    }

    @Override
    public void doGunEvent() {
        ArrayList<IsoPlayer> arrayList = GameServer.getPlayers();
        if (arrayList.isEmpty()) {
            return;
        }
        IsoPlayer isoPlayer = arrayList.get(Rand.Next(arrayList.size()));
        String string = null;
        float f = isoPlayer.x;
        float f2 = isoPlayer.y;
        int n = 600;
        double d = Rand.Next((float)(-Math.PI), (float)Math.PI);
        this.tempo.x = (float)Math.cos(d);
        this.tempo.y = (float)Math.sin(d);
        this.tempo.setLength(n - 100);
        WorldSoundManager.instance.addSound(null, (int)(f += this.tempo.x) + Rand.Next(-10, 10), (int)(f2 += this.tempo.y) + Rand.Next(-10, 10), 0, 600, 600);
        switch (Rand.Next(6)) {
            case 0: {
                string = "MetaAssaultRifle1";
                break;
            }
            case 1: {
                string = "MetaPistol1";
                break;
            }
            case 2: {
                string = "MetaShotgun1";
                break;
            }
            case 3: {
                string = "MetaPistol2";
                break;
            }
            case 4: {
                string = "MetaPistol3";
                break;
            }
            case 5: {
                string = "MetaShotgun1";
            }
        }
        float f3 = 1.0f;
        Ambient ambient = new Ambient(string, f, f2, 700.0f, f3);
        this.ambient.add(ambient);
        GameServer.sendAmbient(string, (int)f, (int)f2, (int)Math.ceil(ambient.radius), ambient.volume);
    }

    @Override
    public void doAlarm(RoomDef roomDef) {
        if (roomDef != null && roomDef.building != null && roomDef.building.bAlarmed) {
            float f = 1.0f;
            Ambient ambient = new Ambient("burglar2", roomDef.x + roomDef.getW() / 2, roomDef.y + roomDef.getH() / 2, 700.0f, f);
            ambient.duration = 49;
            ambient.worldSoundDelay = 3;
            roomDef.building.bAlarmed = false;
            roomDef.building.setAllExplored(true);
            this.ambient.add(ambient);
            GameServer.sendAlarm(roomDef.x + roomDef.getW() / 2, roomDef.y + roomDef.getH() / 2);
        }
    }

    @Override
    public void stop() {
        this.ambient.clear();
        this.initialized = false;
    }

    private void updatePowerSupply() {
        boolean bl;
        boolean bl2 = bl = GameTime.getInstance().NightsSurvived < SandboxOptions.getInstance().getElecShutModifier();
        if (this.electricityShutOffState == -1) {
            IsoWorld.instance.setHydroPowerOn(bl);
        }
        if (this.electricityShutOffState == 0) {
            if (bl) {
                IsoWorld.instance.setHydroPowerOn(true);
                this.checkHaveElectricity();
                this.electricityShutOffTime = 0L;
            } else if (this.electricityShutOffTime != 0L && System.currentTimeMillis() >= this.electricityShutOffTime) {
                this.electricityShutOffTime = 0L;
                IsoWorld.instance.setHydroPowerOn(false);
                this.checkHaveElectricity();
            }
        }
        if (this.electricityShutOffState == 1 && !bl) {
            this.electricityShutOffTime = System.currentTimeMillis() + 2650L;
        }
        this.electricityShutOffState = bl ? 1 : 0;
    }

    private void checkHaveElectricity() {
    }

    public class Ambient {
        public float x;
        public float y;
        public String name;
        public float radius;
        public float volume;
        long startTime;
        public int duration;
        public int worldSoundDelay = 0;

        public Ambient(String string, float f, float f2, float f3, float f4) {
            this.name = string;
            this.x = f;
            this.y = f2;
            this.radius = f3;
            this.volume = f4;
            this.startTime = System.currentTimeMillis() / 1000L;
            this.duration = 2;
            this.update();
            LuaEventManager.triggerEvent("OnAmbientSound", string, Float.valueOf(f), Float.valueOf(f2));
        }

        public boolean finished() {
            long l = System.currentTimeMillis() / 1000L;
            return l - this.startTime >= (long)this.duration;
        }

        public void update() {
            long l = System.currentTimeMillis() / 1000L;
            if (l - this.startTime >= (long)this.worldSoundDelay) {
                WorldSoundManager.instance.addSound(null, (int)this.x, (int)this.y, 0, 600, 600);
            }
        }
    }
}

