/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import java.awt.Canvas;
import java.io.PrintStream;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.system.MemoryStack;
import org.lwjglx.LWJGLException;
import org.lwjglx.LWJGLUtil;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.PixelFormat;
import org.lwjglx.opengl.Sync;
import zombie.core.Clipboard;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.debug.DebugLog;

public class Display {
    private static String windowTitle = "Game";
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = true;
    private static boolean vsyncEnabled = true;
    private static DisplayMode gameWindowMode = new DisplayMode(640, 480);
    private static DisplayMode desktopDisplayMode = new DisplayMode(640, 480);
    private static int displayX = 0;
    private static int displayY = 0;
    private static boolean displayResized = false;
    private static int displayWidth = 0;
    private static int displayHeight = 0;
    private static int displayFramebufferWidth = 0;
    private static int displayFramebufferHeight = 0;
    private static GLFWImage.Buffer displayIcons;
    private static long monitor;
    private static boolean isBorderlessWindow;
    private static boolean latestResized;
    private static int latestWidth;
    private static int latestHeight;
    public static GLCapabilities capabilities;
    private static final double[] mouseCursorPosX;
    private static final double[] mouseCursorPosY;
    private static int mouseCursorState;

    public static void create(PixelFormat pixelFormat) throws LWJGLException {
        GLFW.glfwWindowHint((int)135178, (int)pixelFormat.getAccumulationBitsPerPixel());
        GLFW.glfwWindowHint((int)135172, (int)pixelFormat.getAlphaBits());
        GLFW.glfwWindowHint((int)135179, (int)pixelFormat.getAuxBuffers());
        GLFW.glfwWindowHint((int)135173, (int)pixelFormat.getDepthBits());
        GLFW.glfwWindowHint((int)135181, (int)pixelFormat.getSamples());
        GLFW.glfwWindowHint((int)135174, (int)pixelFormat.getStencilBits());
        Display.create();
    }

    public static void create() throws LWJGLException {
        int[] nArray;
        if (Window.handle != 0L) {
            GLFW.glfwDestroyWindow((long)Window.handle);
        }
        GLFWVidMode gLFWVidMode = GLFW.glfwGetVideoMode((long)monitor);
        int n = gLFWVidMode.width();
        int n2 = gLFWVidMode.height();
        int n3 = gLFWVidMode.redBits() + gLFWVidMode.greenBits() + gLFWVidMode.blueBits();
        int n4 = gLFWVidMode.refreshRate();
        desktopDisplayMode = new DisplayMode(n, n2, n3, n4);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        Callbacks.errorCallback = GLFWErrorCallback.createPrint((PrintStream)System.err);
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)Callbacks.errorCallback);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(displayResizable ? 1 : 0));
        if (LWJGLUtil.getPlatform() == 2) {
            GLFW.glfwWindowHint((int)143361, (int)0);
        }
        boolean bl = Core.bDebug && "true".equalsIgnoreCase(System.getProperty("org.lwjgl.util.Debug"));
        GLFW.glfwWindowHint((int)139271, (int)(bl ? 1 : 0));
        if (Core.getInstance().getOptionBorderlessWindow()) {
            isBorderlessWindow = true;
            GLFW.glfwWindowHint((int)131077, (int)0);
            Window.handle = GLFW.glfwCreateWindow((int)gameWindowMode.getWidth(), (int)gameWindowMode.getHeight(), (CharSequence)windowTitle, (long)0L, (long)0L);
        } else {
            Window.handle = Display.isFullscreen() ? GLFW.glfwCreateWindow((int)gameWindowMode.getWidth(), (int)gameWindowMode.getHeight(), (CharSequence)windowTitle, (long)monitor, (long)0L) : GLFW.glfwCreateWindow((int)gameWindowMode.getWidth(), (int)gameWindowMode.getHeight(), (CharSequence)windowTitle, (long)0L, (long)0L);
        }
        if (Window.handle == 0L) {
            throw new IllegalStateException("Failed to create Display window");
        }
        GLFW.glfwSetWindowIcon((long)Window.handle, (GLFWImage.Buffer)displayIcons);
        Callbacks.bNoise = bl;
        Callbacks.initCallbacks();
        Display.calcWindowPos(Display.isBorderlessWindow() || Display.isFullscreen());
        GLFW.glfwSetWindowPos((long)Window.handle, (int)displayX, (int)displayY);
        GLFW.glfwShowWindow((long)Window.handle);
        GLFW.glfwMakeContextCurrent((long)Window.handle);
        capabilities = GL.createCapabilities();
        GLFW.glfwSwapInterval((int)0);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16640);
        GLFW.glfwSwapBuffers((long)Window.handle);
        Display.setVSyncEnabled(vsyncEnabled);
        if (bl && Display.capabilities.OpenGL43) {
            nArray = new int[]{131185};
            GL43.glDebugMessageControl((int)33350, (int)33361, (int)4352, (int[])nArray, (boolean)false);
        }
        nArray = new int[1];
        int[] nArray2 = new int[1];
        GLFW.glfwGetWindowSize((long)Window.handle, (int[])nArray, (int[])nArray2);
        displayWidth = latestWidth = nArray[0];
        displayHeight = latestHeight = nArray2[0];
        displayCreated = true;
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int n, int n2) {
        System.out.println("TODO: Implement Display.setLocation(int, int)");
    }

    public static void setVSyncEnabled(boolean bl) {
        vsyncEnabled = bl;
        if (bl) {
            GLFW.glfwSwapInterval((int)1);
        } else {
            GLFW.glfwSwapInterval((int)0);
        }
    }

    public static long getWindow() {
        return Window.handle;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean bl) {
        try {
            Display.swapBuffers();
            displayDirty = false;
        }
        catch (LWJGLException lWJGLException) {
            throw new RuntimeException(lWJGLException);
        }
        if (bl) {
            Display.processMessages();
        }
    }

    private static void updateMouseCursor() {
        int n;
        int n2 = RenderThread.isCursorVisible() ? 212993 : 212994;
        boolean bl = Core.getInstance().getOptionLockCursorToWindow();
        if (bl) {
            n2 = 212995;
        }
        if (mouseCursorState != n2) {
            int n3 = n = mouseCursorState == 212995 ? 1 : 0;
            if (n != 0) {
                GLFW.glfwGetCursorPos((long)Display.getWindow(), (double[])mouseCursorPosX, (double[])mouseCursorPosY);
            }
            mouseCursorState = n2;
            GLFW.glfwSetInputMode((long)Display.getWindow(), (int)208897, (int)n2);
            if (n != 0) {
                GLFW.glfwSetCursorPos((long)Display.getWindow(), (double)mouseCursorPosX[0], (double)mouseCursorPosY[0]);
            }
        }
        if (bl) {
            GLFW.glfwGetCursorPos((long)Display.getWindow(), (double[])mouseCursorPosX, (double[])mouseCursorPosY);
            n = (int)mouseCursorPosX[0];
            int n4 = (int)mouseCursorPosY[0];
            Display.mouseCursorPosX[0] = PZMath.clamp((int)((int)mouseCursorPosX[0]), (int)0, (int)Display.getWidth());
            Display.mouseCursorPosY[0] = PZMath.clamp((int)((int)mouseCursorPosY[0]), (int)0, (int)Display.getHeight());
            if (n != (int)mouseCursorPosX[0] || n4 != (int)mouseCursorPosY[0]) {
                GLFW.glfwSetCursorPos((long)Display.getWindow(), (double)mouseCursorPosX[0], (double)mouseCursorPosY[0]);
            }
        }
    }

    public static void processMessages() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        Display.updateMouseCursor();
        if (latestResized) {
            latestResized = false;
            displayResized = true;
            displayWidth = latestWidth;
            displayHeight = latestHeight;
        } else {
            displayResized = false;
        }
    }

    public static void swapBuffers() throws LWJGLException {
        GLFW.glfwSwapBuffers((long)Window.handle);
    }

    public static void destroy() {
        Callbacks.releaseCallbacks();
        GLFW.glfwDestroyWindow((long)Window.handle);
        displayCreated = false;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode displayMode) throws LWJGLException {
        Display.setDisplayModeAndFullscreenInternal(displayMode, displayMode.isFullscreenCapable());
    }

    public static void setFullscreen(boolean bl) {
        Display.setDisplayModeAndFullscreenInternal(gameWindowMode, bl);
    }

    public static boolean isFullscreen() {
        if (!Display.isCreated()) {
            return Core.getInstance().isFullScreen();
        }
        return GLFW.glfwGetWindowMonitor((long)Window.handle) != 0L;
    }

    public static void setBorderlessWindow(boolean bl) {
        isBorderlessWindow = bl;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowAttrib((long)Display.getWindow(), (int)131077, (int)(bl ? 0 : 1));
        }
    }

    public static boolean isBorderlessWindow() {
        return isBorderlessWindow;
    }

    public static void setDisplayMode(DisplayMode displayMode) throws LWJGLException {
        if (displayMode == null) {
            throw new NullPointerException();
        }
        Display.setDisplayModeAndFullscreenInternal(displayMode, displayMode.isFullscreenCapable() && Display.isFullscreen());
    }

    private static void setDisplayModeAndFullscreenInternal(DisplayMode displayMode, boolean bl) {
        boolean bl2 = Display.isFullscreen();
        DisplayMode displayMode2 = gameWindowMode;
        gameWindowMode = displayMode;
        Core.setFullScreen((boolean)bl);
        if (Display.isCreated() && (bl2 != bl || !gameWindowMode.equals(displayMode2))) {
            GLFW.glfwHideWindow((long)Window.handle);
            Display.calcWindowPos(bl || Display.isBorderlessWindow());
            GLFW.glfwSetWindowMonitor((long)Window.handle, (long)(bl ? monitor : 0L), (int)displayX, (int)displayY, (int)gameWindowMode.getWidth(), (int)gameWindowMode.getHeight(), (int)-1);
            GLFW.glfwSetWindowIcon((long)Window.handle, (GLFWImage.Buffer)displayIcons);
            GLFW.glfwShowWindow((long)Window.handle);
            GLFW.glfwFocusWindow((long)Window.handle);
            GLFW.glfwMakeContextCurrent((long)Window.handle);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLFW.glfwSwapInterval((int)0);
            GL11.glClear((int)16640);
            GLFW.glfwSwapBuffers((long)Window.handle);
            Display.setVSyncEnabled(vsyncEnabled);
        }
    }

    private static void calcWindowPos(boolean bl) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.callocInt(1);
            IntBuffer intBuffer2 = memoryStack.callocInt(1);
            GLFW.glfwGetFramebufferSize((long)Window.handle, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
            displayFramebufferWidth = intBuffer.get(0);
            displayFramebufferHeight = intBuffer2.get(0);
            IntBuffer intBuffer3 = memoryStack.callocInt(1);
            IntBuffer intBuffer4 = memoryStack.callocInt(1);
            GLFW.glfwGetWindowFrameSize((long)Window.handle, (IntBuffer)intBuffer3, (IntBuffer)intBuffer4, null, null);
            int n = intBuffer3.get(0);
            int n2 = intBuffer4.get(0);
            displayWidth = gameWindowMode.getWidth();
            displayHeight = gameWindowMode.getHeight();
            if (bl) {
                n = 0;
                n2 = 0;
            }
            displayX = n + (desktopDisplayMode.getWidth() - gameWindowMode.getWidth()) / 2;
            displayY = n2 + (desktopDisplayMode.getHeight() - gameWindowMode.getHeight()) / 2;
            if (gameWindowMode.getWidth() > desktopDisplayMode.getWidth()) {
                displayX = n;
            }
            if (gameWindowMode.getHeight() > desktopDisplayMode.getHeight()) {
                displayY = n2;
            }
        }
    }

    public static DisplayMode getDisplayMode() {
        return gameWindowMode;
    }

    public static DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        GLFWVidMode.Buffer buffer = GLFW.glfwGetVideoModes((long)GLFW.glfwGetPrimaryMonitor());
        DisplayMode[] displayModeArray = new DisplayMode[buffer.capacity()];
        for (int i = 0; i < displayModeArray.length; ++i) {
            buffer.position(i);
            int n = buffer.width();
            int n2 = buffer.height();
            int n3 = buffer.redBits() + buffer.greenBits() + buffer.blueBits();
            int n4 = buffer.refreshRate();
            displayModeArray[i] = new DisplayMode(n, n2, n3, n4);
        }
        return displayModeArray;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static boolean wasResized() {
        return displayResized;
    }

    public static int getX() {
        return displayX;
    }

    public static int getY() {
        return displayY;
    }

    public static int getWidth() {
        return latestWidth;
    }

    public static int getHeight() {
        return latestHeight;
    }

    public static int getFramebufferWidth() {
        return displayFramebufferWidth;
    }

    public static int getFramebufferHeight() {
        return displayFramebufferHeight;
    }

    public static void setTitle(String string) {
        windowTitle = string;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle((long)Window.handle, (CharSequence)windowTitle);
        }
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)Window.handle);
    }

    public static boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float f, float f2, float f3) {
        System.out.println("TODO: Implement Display.setInitialBackground(float, float, float)");
    }

    public static void setIcon(GLFWImage.Buffer buffer) {
        displayIcons = buffer;
    }

    public static void setResizable(boolean bl) {
        displayResizable = bl;
    }

    public static boolean isResizable() {
        return displayResizable;
    }

    public static void setParent(Canvas canvas) throws LWJGLException {
    }

    public static void releaseContext() throws LWJGLException {
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    public static boolean isCurrent() throws LWJGLException {
        return GLFW.glfwGetCurrentContext() == Window.handle;
    }

    public static void makeCurrent() throws LWJGLException {
        GLFW.glfwMakeContextCurrent((long)Window.handle);
        GL.setCapabilities((GLCapabilities)capabilities);
    }

    public static String getAdapter() {
        return "GeNotSupportedAdapter";
    }

    public static String getVersion() {
        return "1.0 NOT SUPPORTED";
    }

    public static void sync(int n) {
        Sync.sync(n);
    }

    static {
        isBorderlessWindow = false;
        latestResized = false;
        latestWidth = 0;
        latestHeight = 0;
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwInitHint((int)327681, (int)0);
        Keyboard.create();
        monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode gLFWVidMode = GLFW.glfwGetVideoMode((long)monitor);
        int n = gLFWVidMode.width();
        int n2 = gLFWVidMode.height();
        int n3 = gLFWVidMode.redBits() + gLFWVidMode.greenBits() + gLFWVidMode.blueBits();
        int n4 = gLFWVidMode.refreshRate();
        desktopDisplayMode = new DisplayMode(n, n2, n3, n4);
        mouseCursorPosX = new double[1];
        mouseCursorPosY = new double[1];
        mouseCursorState = -1;
    }

    private static final class Window {
        static long handle;

        private Window() {
        }
    }

    private static final class Callbacks {
        static boolean bNoise = false;
        static GLFWErrorCallback errorCallback;
        static GLDebugMessageCallback debugMessageCallback;
        static GLFWKeyCallback keyCallback;
        static GLFWCharCallback charCallback;
        static GLFWCursorPosCallback cursorPosCallback;
        static GLFWMouseButtonCallback mouseButtonCallback;
        static GLFWScrollCallback scrollCallback;
        static GLFWWindowFocusCallback windowFocusCallback;
        static GLFWWindowIconifyCallback windowIconifyCallback;
        static GLFWWindowSizeCallback windowSizeCallback;
        static GLFWWindowPosCallback windowPosCallback;
        static GLFWWindowRefreshCallback windowRefreshCallback;
        static GLFWFramebufferSizeCallback framebufferSizeCallback;

        private Callbacks() {
        }

        static void initCallbacks() {
            cursorPosCallback = GLFWCursorPosCallback.create((l, d, d2) -> Mouse.addMoveEvent(d, d2));
            GLFW.glfwSetCursorPosCallback((long)Display.getWindow(), (GLFWCursorPosCallbackI)cursorPosCallback);
            mouseButtonCallback = GLFWMouseButtonCallback.create((l, n, n2, n3) -> Mouse.addButtonEvent(n, n2 == 1));
            GLFW.glfwSetMouseButtonCallback((long)Display.getWindow(), (GLFWMouseButtonCallbackI)mouseButtonCallback);
            windowFocusCallback = GLFWWindowFocusCallback.create((l, bl) -> {
                if (bNoise) {
                    DebugLog.log((String)("glfwSetWindowFocusCallback focused=" + bl));
                }
                displayFocused = bl;
                if (bl) {
                    Clipboard.rememberCurrentValue();
                }
            });
            GLFW.glfwSetWindowFocusCallback((long)Display.getWindow(), (GLFWWindowFocusCallbackI)windowFocusCallback);
            windowIconifyCallback = GLFWWindowIconifyCallback.create((l, bl) -> {
                if (bNoise) {
                    DebugLog.log((String)("glfwSetWindowIconifyCallback iconifed=" + bl));
                }
                displayVisible = !bl;
            });
            GLFW.glfwSetWindowIconifyCallback((long)Display.getWindow(), (GLFWWindowIconifyCallbackI)windowIconifyCallback);
            windowSizeCallback = GLFWWindowSizeCallback.create((l, n, n2) -> {
                if (bNoise) {
                    DebugLog.log((String)("glfwSetWindowSizeCallback width,height=" + n + "," + n2));
                }
                if (n + n2 == 0) {
                    return;
                }
                latestResized = true;
                latestWidth = n;
                latestHeight = n2;
            });
            GLFW.glfwSetWindowSizeCallback((long)Display.getWindow(), (GLFWWindowSizeCallbackI)windowSizeCallback);
            scrollCallback = GLFWScrollCallback.create((l, d, d2) -> Mouse.setDWheel(d, d2));
            GLFW.glfwSetScrollCallback((long)Display.getWindow(), (GLFWScrollCallbackI)scrollCallback);
            windowPosCallback = GLFWWindowPosCallback.create((l, n, n2) -> {
                if (bNoise) {
                    DebugLog.log((String)("glfwSetWindowPosCallback x,y=" + n + "," + n2));
                }
                displayX = n;
                displayY = n2;
            });
            GLFW.glfwSetWindowPosCallback((long)Display.getWindow(), (GLFWWindowPosCallbackI)windowPosCallback);
            windowRefreshCallback = GLFWWindowRefreshCallback.create(l -> {
                displayDirty = true;
            });
            GLFW.glfwSetWindowRefreshCallback((long)Display.getWindow(), (GLFWWindowRefreshCallbackI)windowRefreshCallback);
            framebufferSizeCallback = GLFWFramebufferSizeCallback.create((l, n, n2) -> {
                if (bNoise) {
                    DebugLog.log((String)("glfwSetFramebufferSizeCallback width,height=" + n + "," + n2));
                }
                displayFramebufferWidth = n;
                displayFramebufferHeight = n2;
            });
            GLFW.glfwSetFramebufferSizeCallback((long)Display.getWindow(), (GLFWFramebufferSizeCallbackI)framebufferSizeCallback);
            keyCallback = GLFWKeyCallback.create((l, n, n2, n3, n4) -> Keyboard.addKeyEvent(n, n3));
            GLFW.glfwSetKeyCallback((long)Display.getWindow(), (GLFWKeyCallbackI)keyCallback);
            charCallback = GLFWCharCallback.create((l, n) -> Keyboard.addCharEvent((char)n));
            GLFW.glfwSetCharCallback((long)Display.getWindow(), (GLFWCharCallbackI)charCallback);
        }

        static void releaseCallbacks() {
            errorCallback.free();
            if (debugMessageCallback != null) {
                debugMessageCallback.free();
            }
            keyCallback.free();
            charCallback.free();
            cursorPosCallback.free();
            mouseButtonCallback.free();
            scrollCallback.free();
            windowFocusCallback.free();
            windowIconifyCallback.free();
            windowSizeCallback.free();
            windowPosCallback.free();
            windowRefreshCallback.free();
            framebufferSizeCallback.free();
        }
    }
}

