/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjglx.BufferUtils;
import org.lwjglx.LWJGLException;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private long cursorHandle;

    public Cursor(int n, int n2, int n3, int n4, int n5, IntBuffer intBuffer, IntBuffer intBuffer2) throws LWJGLException {
        if (n5 != 1) {
            System.out.println("ANIMATED CURSORS NOT YET SUPPORTED IN LWJGLX");
            return;
        }
        IntBuffer intBuffer3 = BufferUtils.createIntBuffer(intBuffer.limit());
        Cursor.flipImages(n, n2, n5, intBuffer, intBuffer3);
        ByteBuffer byteBuffer = Cursor.convertARGBIntBuffertoRGBAByteBuffer(n, n2, intBuffer3);
        GLFWImage gLFWImage = GLFWImage.malloc();
        gLFWImage.width(n);
        gLFWImage.height(n2);
        gLFWImage.pixels(byteBuffer);
        this.cursorHandle = GLFW.glfwCreateCursor((GLFWImage)gLFWImage, (int)n3, (int)n4);
        if (this.cursorHandle == 0L) {
            throw new RuntimeException("Error creating GLFW cursor");
        }
    }

    private static ByteBuffer convertARGBIntBuffertoRGBAByteBuffer(int n, int n2, IntBuffer intBuffer) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n * n2 * 4);
        for (int i = 0; i < intBuffer.limit(); ++i) {
            int n3 = intBuffer.get(i);
            byte by = (byte)(n3 >>> 24);
            byte by2 = (byte)(n3 >>> 16);
            byte by3 = (byte)(n3 >>> 8);
            byte by4 = (byte)n3;
            byteBuffer.put(by4);
            byteBuffer.put(by3);
            byteBuffer.put(by2);
            byteBuffer.put(by);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static int getMinCursorSize() {
        return 1;
    }

    public static int getMaxCursorSize() {
        return 512;
    }

    public static int getCapabilities() {
        return 2;
    }

    private static void flipImages(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n * n2;
            Cursor.flipImage(n, n2, n4, intBuffer, intBuffer2);
        }
    }

    private static void flipImage(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        for (int i = 0; i < n2 >> 1; ++i) {
            int n4 = i * n + n3;
            int n5 = (n2 - i - 1) * n + n3;
            for (int j = 0; j < n; ++j) {
                int n6 = n4 + j;
                int n7 = n5 + j;
                int n8 = intBuffer.get(n6 + intBuffer.position());
                intBuffer2.put(n6, intBuffer.get(n7 + intBuffer.position()));
                intBuffer2.put(n7, n8);
            }
        }
    }

    public long getHandle() {
        return this.cursorHandle;
    }

    public void destroy() {
        GLFW.glfwDestroyCursor((long)this.cursorHandle);
    }
}

