/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.input.Controller;
import org.lwjglx.input.GamepadState;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;

public class Controllers {
    public static final int MAX_AXES = 6;
    public static final int MAX_BUTTONS = 15;
    public static final int MAX_CONTROLLERS = 16;
    private static final Controller[] controllers = new Controller[16];
    private static boolean isCreated = false;
    private static Consumer<Integer> controllerConnectedCallback = null;
    private static Consumer<Integer> controllerDisconnectedCallback = null;
    private static int debugToggleControllerPluggedIn = -1;

    public static void create() {
        Controllers.readGameControllerDB();
        GLFW.glfwSetJoystickCallback(Controllers::updateControllersCount);
        for (int i = 0; i < 16; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            Controllers.controllers[i] = new Controller(i);
        }
        isCreated = true;
    }

    private static void readGameControllerDB() {
        String string;
        File file = new File("./media/gamecontrollerdb.txt").getAbsoluteFile();
        if (file.exists()) {
            Controllers.readGameControllerDB(file);
        }
        if ((file = new File(string = ZomboidFileSystem.instance.getCacheDirSub("joypads" + File.separator + "gamecontrollerdb.txt"))).exists()) {
            Controllers.readGameControllerDB(file);
        }
    }

    private static void readGameControllerDB(File file) {
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                stringBuilder.append(string);
                stringBuilder.append(System.lineSeparator());
            }
            ByteBuffer byteBuffer = MemoryUtil.memUTF8((CharSequence)stringBuilder.toString());
            if (GLFW.glfwUpdateGamepadMappings((ByteBuffer)byteBuffer)) {
                // empty if block
            }
            MemoryUtil.memFree((Buffer)byteBuffer);
        }
        catch (Exception exception) {
            ExceptionLogger.logException((Throwable)exception);
        }
    }

    public static void setControllerConnectedCallback(Consumer<Integer> consumer) {
        controllerConnectedCallback = consumer;
    }

    public static void setControllerDisconnectedCallback(Consumer<Integer> consumer) {
        controllerDisconnectedCallback = consumer;
    }

    public static int getControllerCount() {
        if (!Controllers.isCreated()) {
            throw new RuntimeException("Before calling 'getJoypadCount()' you should call 'create()' method");
        }
        return controllers.length;
    }

    public static Controller getController(int n) {
        if (!Controllers.isCreated()) {
            throw new RuntimeException("Before calling 'getJoypad(int)' you should call 'create()' method");
        }
        return controllers[n];
    }

    public static boolean isCreated() {
        return isCreated;
    }

    public static void poll(GamepadState[] gamepadStateArray) {
        int n;
        if (!Controllers.isCreated()) {
            throw new RuntimeException("Before calling 'poll()' you should call 'create()' method");
        }
        if (Core.bDebug && debugToggleControllerPluggedIn >= 0 && debugToggleControllerPluggedIn < 16) {
            n = debugToggleControllerPluggedIn;
            debugToggleControllerPluggedIn = -1;
            if (controllers[n] != null) {
                Controllers.updateControllersCount(n, 262146);
            } else if (GLFW.glfwJoystickIsGamepad((int)n)) {
                Controllers.updateControllersCount(n, 262145);
            }
        }
        for (n = 0; n < controllers.length; ++n) {
            Controller controller = controllers[n];
            if (controller == null) continue;
            controller.poll(gamepadStateArray[n]);
        }
    }

    private static void updateControllersCount(int n, int n2) {
        if (n2 == 262145) {
            Controller controller;
            Controllers.controllers[n] = controller = new Controller(n);
            if (controllerConnectedCallback != null) {
                controllerConnectedCallback.accept(n);
            }
        } else if (n2 == 262146) {
            Controllers.controllers[n] = null;
            if (controllerDisconnectedCallback != null) {
                controllerDisconnectedCallback.accept(n);
            }
        }
    }

    public static void setDebugToggleControllerPluggedIn(int n) {
        debugToggleControllerPluggedIn = n;
    }
}

