/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.kahluafork.compiler;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.luaj.kahluafork.compiler.BlockCnt;
import org.luaj.kahluafork.compiler.ConsControl;
import org.luaj.kahluafork.compiler.ExpDesc;
import org.luaj.kahluafork.compiler.FuncState;
import org.luaj.kahluafork.compiler.InstructionPtr;
import org.luaj.kahluafork.compiler.LHS_assign;
import org.luaj.kahluafork.compiler.Token;
import se.krka.kahlua.vm.KahluaException;
import se.krka.kahlua.vm.Prototype;
import zombie.core.Core;

public class LexState {
    public int nCcalls;
    protected static final String RESERVED_LOCAL_VAR_FOR_CONTROL = "(for control)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STATE = "(for state)";
    protected static final String RESERVED_LOCAL_VAR_FOR_GENERATOR = "(for generator)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STEP = "(for step)";
    protected static final String RESERVED_LOCAL_VAR_FOR_LIMIT = "(for limit)";
    protected static final String RESERVED_LOCAL_VAR_FOR_INDEX = "(for index)";
    protected static final String[] RESERVED_LOCAL_VAR_KEYWORDS;
    private static final Hashtable RESERVED_LOCAL_VAR_KEYWORDS_TABLE;
    private static final int EOZ = -1;
    private static final int MAXSRC = 80;
    private static final int MAX_INT = 0x7FFFFFFD;
    private static final int UCHAR_MAX = 255;
    private static final int LUAI_MAXCCALLS = 200;
    static final int NO_JUMP = -1;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_DIV = 3;
    static final int OPR_MOD = 4;
    static final int OPR_POW = 5;
    static final int OPR_CONCAT = 6;
    static final int OPR_NE = 7;
    static final int OPR_EQ = 8;
    static final int OPR_LT = 9;
    static final int OPR_LE = 10;
    static final int OPR_GT = 11;
    static final int OPR_GE = 12;
    static final int OPR_AND = 13;
    static final int OPR_OR = 14;
    static final int OPR_NOBINOPR = 15;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    static final int VVOID = 0;
    static final int VNIL = 1;
    static final int VTRUE = 2;
    static final int VFALSE = 3;
    static final int VK = 4;
    static final int VKNUM = 5;
    static final int VLOCAL = 6;
    static final int VUPVAL = 7;
    static final int VGLOBAL = 8;
    static final int VINDEXED = 9;
    static final int VJMP = 10;
    static final int VRELOCABLE = 11;
    static final int VNONRELOC = 12;
    static final int VCALL = 13;
    static final int VVARARG = 14;
    int current;
    int linenumber;
    int lastline;
    final Token t = new Token();
    final Token lookahead = new Token();
    FuncState fs;
    Reader z;
    byte[] buff;
    int nbuff;
    String source;
    static final String[] luaX_tokens;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_IF = 266;
    static final int TK_IN = 267;
    static final int TK_LOCAL = 268;
    static final int TK_NIL = 269;
    static final int TK_NOT = 270;
    static final int TK_OR = 271;
    static final int TK_REPEAT = 272;
    static final int TK_RETURN = 273;
    static final int TK_THEN = 274;
    static final int TK_TRUE = 275;
    static final int TK_UNTIL = 276;
    static final int TK_WHILE = 277;
    static final int TK_CONCAT = 278;
    static final int TK_DOTS = 279;
    static final int TK_EQ = 280;
    static final int TK_GE = 281;
    static final int TK_LE = 282;
    static final int TK_NE = 283;
    static final int TK_NUMBER = 284;
    static final int TK_NAME = 285;
    static final int TK_STRING = 286;
    static final int TK_EOS = 287;
    static final int FIRST_RESERVED = 257;
    static final int NUM_RESERVED = 21;
    static final Hashtable RESERVED;
    static final int[] priorityLeft;
    static final int[] priorityRight;
    static final int UNARY_PRIORITY = 8;

    private static final String LUA_QS(String string) {
        return "'" + string + "'";
    }

    private static final String LUA_QL(Object object) {
        return LexState.LUA_QS(String.valueOf(object));
    }

    public static boolean isReservedKeyword(String string) {
        return RESERVED_LOCAL_VAR_KEYWORDS_TABLE.containsKey(string);
    }

    private boolean isalnum(int n) {
        return n >= 48 && n <= 57 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95;
    }

    private boolean isalpha(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    private boolean isdigit(int n) {
        return n >= 48 && n <= 57;
    }

    private boolean isspace(int n) {
        return n <= 32;
    }

    public static Prototype compile(int n, Reader reader, String string, String object) {
        if (string != null) {
            object = string;
        } else {
            string = "stdin";
            object = "[string \"" + LexState.trim((String)object, 80) + "\"]";
        }
        LexState lexState = new LexState(reader, n, (String)object);
        FuncState funcState = new FuncState(lexState);
        funcState.isVararg = 2;
        funcState.f.name = string;
        lexState.next();
        lexState.chunk();
        lexState.check(287);
        lexState.close_func();
        FuncState._assert(funcState.prev == null);
        FuncState._assert(funcState.f.numUpvalues == 0);
        FuncState._assert(lexState.fs == null);
        return funcState.f;
    }

    public LexState(Reader reader, int n, String string) {
        this.z = reader;
        this.buff = new byte[32];
        this.lookahead.token = 287;
        this.fs = null;
        this.linenumber = 1;
        this.lastline = 1;
        this.source = string;
        this.nbuff = 0;
        this.current = n;
        this.skipShebang();
    }

    void nextChar() {
        try {
            this.current = this.z.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.current = -1;
        }
    }

    boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    void save_and_next() {
        this.save(this.current);
        this.nextChar();
    }

    void save(int n) {
        if (this.buff == null || this.nbuff + 1 > this.buff.length) {
            this.buff = FuncState.realloc(this.buff, this.nbuff * 2 + 1);
        }
        this.buff[this.nbuff++] = (byte)n;
    }

    String token2str(int n) {
        if (n < 257) {
            return LexState.iscntrl(n) ? "char(" + n + ")" : String.valueOf((char)n);
        }
        return luaX_tokens[n - 257];
    }

    private static boolean iscntrl(int n) {
        return n < 32;
    }

    String txtToken(int n) {
        switch (n) {
            case 284: 
            case 285: 
            case 286: {
                return new String(this.buff, 0, this.nbuff);
            }
        }
        return this.token2str(n);
    }

    void lexerror(String string, int n) {
        String string2 = this.source;
        String string3 = n != 0 ? string2 + ":" + this.linenumber + ": " + string + " near `" + this.txtToken(n) + "`" : string2 + ":" + this.linenumber + ": " + string;
        throw new KahluaException((Object)string3);
    }

    private static String trim(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    void syntaxerror(String string) {
        this.lexerror(string, this.t.token);
    }

    String newstring(byte[] byArray, int n, int n2) {
        try {
            String string = new String(byArray, n, n2, "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    void inclinenumber() {
        int n = this.current;
        FuncState._assert(this.currIsNewline());
        this.nextChar();
        if (this.currIsNewline() && this.current != n) {
            this.nextChar();
        }
        if (++this.linenumber >= 0x7FFFFFFD) {
            this.syntaxerror("chunk has too many lines");
        }
    }

    private void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.nextChar();
            }
        }
    }

    boolean check_next(String string) {
        if (string.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    void str2d(String string, Token token) {
        try {
            double d = string.startsWith("0x") ? (double)Long.parseLong(string.substring(2), 16) : Double.parseDouble(string);
            token.r = d;
        }
        catch (NumberFormatException numberFormatException) {
            this.lexerror("malformed number", 284);
        }
    }

    void read_numeral(Token token) {
        FuncState._assert(this.isdigit(this.current));
        do {
            this.save_and_next();
        } while (this.isdigit(this.current) || this.current == 46);
        if (this.check_next("Ee")) {
            this.check_next("+-");
        }
        while (this.isalnum(this.current) || this.current == 95) {
            this.save_and_next();
        }
        String string = new String(this.buff, 0, this.nbuff);
        this.str2d(string, token);
    }

    int skip_sep() {
        int n = 0;
        int n2 = this.current;
        FuncState._assert(n2 == 91 || n2 == 93);
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++n;
        }
        return this.current == n2 ? n : -n - 1;
    }

    void read_long_string(Token token, int n) {
        int n2 = 0;
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclinenumber();
        }
        boolean bl = false;
        block6: while (!bl) {
            switch (this.current) {
                case -1: {
                    this.lexerror(token != null ? "unfinished long string" : "unfinished long comment", 287);
                    continue block6;
                }
                case 91: {
                    if (this.skip_sep() != n) continue block6;
                    this.save_and_next();
                    ++n2;
                    continue block6;
                }
                case 93: {
                    if (this.skip_sep() != n) continue block6;
                    this.save_and_next();
                    bl = true;
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclinenumber();
                    if (token != null) continue block6;
                    this.nbuff = 0;
                    continue block6;
                }
            }
            if (token != null) {
                this.save_and_next();
                continue;
            }
            this.nextChar();
        }
        if (token != null) {
            token.ts = this.newstring(this.buff, 2 + n, this.nbuff - 2 * (2 + n));
        }
    }

    void read_string(int n, Token token) {
        this.save_and_next();
        block16: while (this.current != n) {
            switch (this.current) {
                case -1: {
                    this.lexerror("unfinished string", 287);
                    continue block16;
                }
                case 10: 
                case 13: {
                    this.lexerror("unfinished string", 286);
                    continue block16;
                }
                case 92: {
                    int n2;
                    this.nextChar();
                    switch (this.current) {
                        case 97: {
                            n2 = 7;
                            break;
                        }
                        case 98: {
                            n2 = 8;
                            break;
                        }
                        case 102: {
                            n2 = 12;
                            break;
                        }
                        case 110: {
                            n2 = 10;
                            break;
                        }
                        case 114: {
                            n2 = 13;
                            break;
                        }
                        case 116: {
                            n2 = 9;
                            break;
                        }
                        case 118: {
                            n2 = 11;
                            break;
                        }
                        case 10: 
                        case 13: {
                            this.save(10);
                            this.inclinenumber();
                            continue block16;
                        }
                        case -1: {
                            continue block16;
                        }
                        default: {
                            if (!this.isdigit(this.current)) {
                                this.save_and_next();
                                continue block16;
                            }
                            int n3 = 0;
                            n2 = 0;
                            do {
                                n2 = 10 * n2 + (this.current - 48);
                                this.nextChar();
                            } while (++n3 < 3 && this.isdigit(this.current));
                            if (n2 > 255) {
                                this.lexerror("escape sequence too large", 286);
                            }
                            this.save(n2);
                            continue block16;
                        }
                    }
                    this.save(n2);
                    this.nextChar();
                    continue block16;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        token.ts = this.newstring(this.buff, 1, this.nbuff - 2);
    }

    int llex(Token token) {
        int n;
        this.nbuff = 0;
        block12: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclinenumber();
                    continue block12;
                }
                case 45: {
                    this.nextChar();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.nextChar();
                    if (this.current == 91) {
                        n = this.skip_sep();
                        this.nbuff = 0;
                        if (n >= 0) {
                            this.read_long_string(null, n);
                            this.nbuff = 0;
                            continue block12;
                        }
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block12;
                        this.nextChar();
                    }
                }
                case 91: {
                    n = this.skip_sep();
                    if (n >= 0) {
                        this.read_long_string(token, n);
                        return 286;
                    }
                    if (n == -1) {
                        return 91;
                    }
                    this.lexerror("invalid long string delimiter", 286);
                }
                case 61: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.nextChar();
                    return 280;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 60;
                    }
                    this.nextChar();
                    return 282;
                }
                case 62: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 62;
                    }
                    this.nextChar();
                    return 281;
                }
                case 126: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.nextChar();
                    return 283;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current, token);
                    return 286;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 279;
                        }
                        return 278;
                    }
                    if (!this.isdigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral(token);
                    return 284;
                }
                case -1: {
                    return 287;
                }
            }
            if (!this.isspace(this.current)) break;
            FuncState._assert(!this.currIsNewline());
            this.nextChar();
        }
        if (this.isdigit(this.current)) {
            this.read_numeral(token);
            return 284;
        }
        if (this.isalpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (this.isalnum(this.current) || this.current == 95);
            String string = this.newstring(this.buff, 0, this.nbuff);
            if (RESERVED.containsKey(string)) {
                return (Integer)RESERVED.get(string);
            }
            token.ts = string;
            return 285;
        }
        n = this.current;
        this.nextChar();
        return n;
    }

    void next() {
        this.lastline = this.linenumber;
        if (this.lookahead.token != 287) {
            this.t.set(this.lookahead);
            this.lookahead.token = 287;
        } else {
            this.t.token = this.llex(this.t);
        }
    }

    void lookahead() {
        FuncState._assert(this.lookahead.token == 287);
        this.lookahead.token = this.llex(this.lookahead);
    }

    boolean hasmultret(int n) {
        return n == 13 || n == 14;
    }

    void error_expected(int n) {
        this.syntaxerror(LexState.LUA_QS(this.token2str(n)) + " expected");
    }

    boolean testnext(int n) {
        if (this.t.token == n) {
            this.next();
            return true;
        }
        return false;
    }

    void check(int n) {
        if (this.t.token != n) {
            this.error_expected(n);
        }
    }

    void checknext(int n) {
        this.check(n);
        this.next();
    }

    void check_condition(boolean bl, String string) {
        if (!bl) {
            this.syntaxerror(string);
        }
    }

    void check_match(int n, int n2, int n3) {
        if (!this.testnext(n)) {
            if (n3 == this.linenumber) {
                this.error_expected(n);
            } else {
                this.syntaxerror(LexState.LUA_QS(this.token2str(n)) + " expected (to close " + LexState.LUA_QS(this.token2str(n2)) + " at line " + n3 + ")");
            }
        }
    }

    String str_checkname() {
        this.check(285);
        String string = this.t.ts;
        this.next();
        return string;
    }

    void codestring(ExpDesc expDesc, String string) {
        expDesc.init(4, this.fs.stringK(string));
    }

    void checkname(ExpDesc expDesc) {
        this.codestring(expDesc, this.str_checkname());
    }

    int registerlocalvar(String string) {
        FuncState funcState = this.fs;
        if (funcState.locvars == null || funcState.nlocvars + 1 > funcState.locvars.length) {
            funcState.locvars = FuncState.realloc(funcState.locvars, funcState.nlocvars * 2 + 1);
        }
        funcState.locvars[funcState.nlocvars] = string;
        return funcState.nlocvars++;
    }

    void new_localvarliteral(String string, int n) {
        this.new_localvar(string, n);
    }

    void new_localvar(String string, int n, int n2) {
        FuncState funcState = this.fs;
        funcState.checklimit(funcState.nactvar + n + 1, 200, "local variables");
        funcState.actvar[funcState.nactvar + n] = (short)this.registerlocalvar(string);
        if (Core.bDebug) {
            funcState.actvarline[funcState.actvar[funcState.nactvar + n]] = this.linenumber;
        }
    }

    void new_localvar(String string, int n) {
        FuncState funcState = this.fs;
        funcState.checklimit(funcState.nactvar + n + 1, 200, "local variables");
        funcState.actvar[funcState.nactvar + n] = (short)this.registerlocalvar(string);
        if (Core.bDebug) {
            funcState.actvarline[funcState.actvar[funcState.nactvar + n]] = this.linenumber;
        }
    }

    void adjustlocalvars(int n) {
        FuncState funcState = this.fs;
        funcState.nactvar += n;
    }

    void removevars(int n) {
        FuncState funcState = this.fs;
        funcState.nactvar = n;
    }

    void singlevar(ExpDesc expDesc) {
        FuncState funcState = this.fs;
        String string = this.str_checkname();
        if (funcState.singlevaraux(string, expDesc, 1) == 8) {
            expDesc.info = funcState.stringK(string);
        }
    }

    void adjust_assign(int n, int n2, ExpDesc expDesc) {
        FuncState funcState = this.fs;
        int n3 = n - n2;
        if (this.hasmultret(expDesc.k)) {
            if (++n3 < 0) {
                n3 = 0;
            }
            funcState.setreturns(expDesc, n3);
            if (n3 > 1) {
                funcState.reserveregs(n3 - 1);
            }
        } else {
            if (expDesc.k != 0) {
                funcState.exp2nextreg(expDesc);
            }
            if (n3 > 0) {
                int n4 = funcState.freereg;
                funcState.reserveregs(n3);
                funcState.nil(n4, n3);
            }
        }
    }

    void enterlevel() {
        if (++this.nCcalls > 200) {
            this.lexerror("chunk has too many syntax levels", 0);
        }
    }

    void leavelevel() {
        --this.nCcalls;
    }

    void pushclosure(FuncState funcState, ExpDesc expDesc) {
        FuncState funcState2 = this.fs;
        Prototype prototype = funcState2.f;
        if (prototype.prototypes == null || funcState2.np + 1 > prototype.prototypes.length) {
            prototype.prototypes = FuncState.realloc(prototype.prototypes, funcState2.np * 2 + 1);
        }
        prototype.prototypes[funcState2.np++] = funcState.f;
        expDesc.init(11, funcState2.codeABx(36, 0, funcState2.np - 1));
        for (int i = 0; i < funcState.f.numUpvalues; ++i) {
            int n = funcState.upvalues_k[i] == 6 ? 0 : 4;
            funcState2.codeABC(n, 0, funcState.upvalues_info[i], 0);
        }
    }

    void close_func() {
        FuncState funcState = this.fs;
        Prototype prototype = funcState.f;
        prototype.isVararg = funcState.isVararg != 0;
        this.removevars(0);
        funcState.ret(0, 0);
        prototype.code = FuncState.realloc(prototype.code, funcState.pc);
        prototype.lines = FuncState.realloc(prototype.lines, funcState.pc);
        prototype.constants = FuncState.realloc(prototype.constants, funcState.nk);
        prototype.prototypes = FuncState.realloc(prototype.prototypes, funcState.np);
        funcState.locvars = FuncState.realloc(funcState.locvars, funcState.nlocvars);
        if (Core.bDebug) {
            prototype.locvars = funcState.locvars;
            prototype.locvarlines = funcState.actvarline;
        }
        funcState.upvalues = FuncState.realloc(funcState.upvalues, prototype.numUpvalues);
        FuncState._assert(funcState.bl == null);
        this.fs = funcState.prev;
    }

    void field(ExpDesc expDesc) {
        FuncState funcState = this.fs;
        ExpDesc expDesc2 = new ExpDesc();
        funcState.exp2anyreg(expDesc);
        this.next();
        this.checkname(expDesc2);
        funcState.indexed(expDesc, expDesc2);
    }

    void yindex(ExpDesc expDesc) {
        this.next();
        this.expr(expDesc);
        this.fs.exp2val(expDesc);
        this.checknext(93);
    }

    void recfield(ConsControl consControl) {
        FuncState funcState = this.fs;
        int n = this.fs.freereg;
        ExpDesc expDesc = new ExpDesc();
        ExpDesc expDesc2 = new ExpDesc();
        if (this.t.token == 285) {
            funcState.checklimit(consControl.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkname(expDesc);
        } else {
            this.yindex(expDesc);
        }
        ++consControl.nh;
        this.checknext(61);
        int n2 = funcState.exp2RK(expDesc);
        this.expr(expDesc2);
        funcState.codeABC(9, consControl.t.info, n2, funcState.exp2RK(expDesc2));
        funcState.freereg = n;
    }

    void listfield(ConsControl consControl) {
        this.expr(consControl.v);
        this.fs.checklimit(consControl.na, 0x7FFFFFFD, "items in a constructor");
        ++consControl.na;
        ++consControl.tostore;
    }

    void constructor(ExpDesc expDesc) {
        FuncState funcState = this.fs;
        int n = this.linenumber;
        int n2 = funcState.codeABC(10, 0, 0, 0);
        ConsControl consControl = new ConsControl();
        consControl.tostore = 0;
        consControl.nh = 0;
        consControl.na = 0;
        consControl.t = expDesc;
        expDesc.init(11, n2);
        consControl.v.init(0, 0);
        funcState.exp2nextreg(expDesc);
        this.checknext(123);
        do {
            FuncState._assert(consControl.v.k == 0 || consControl.tostore > 0);
            if (this.t.token == 125) break;
            funcState.closelistfield(consControl);
            switch (this.t.token) {
                case 285: {
                    this.lookahead();
                    if (this.lookahead.token != 61) {
                        this.listfield(consControl);
                        break;
                    }
                    this.recfield(consControl);
                    break;
                }
                case 91: {
                    this.recfield(consControl);
                    break;
                }
                default: {
                    this.listfield(consControl);
                }
            }
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(125, 123, n);
        funcState.lastlistfield(consControl);
        InstructionPtr instructionPtr = new InstructionPtr(funcState.f.code, n2);
        FuncState.SETARG_B(instructionPtr, LexState.luaO_int2fb(consControl.na));
        FuncState.SETARG_C(instructionPtr, LexState.luaO_int2fb(consControl.nh));
    }

    static int luaO_int2fb(int n) {
        int n2 = 0;
        while (n >= 16) {
            n = n + 1 >> 1;
            ++n2;
        }
        if (n < 8) {
            return n;
        }
        return n2 + 1 << 3 | n - 8;
    }

    void parlist() {
        FuncState funcState = this.fs;
        Prototype prototype = funcState.f;
        int n = 0;
        funcState.isVararg = 0;
        if (this.t.token != 41) {
            do {
                switch (this.t.token) {
                    case 285: {
                        this.new_localvar(this.str_checkname(), n++);
                        break;
                    }
                    case 279: {
                        this.next();
                        funcState.isVararg |= 2;
                        break;
                    }
                    default: {
                        this.syntaxerror("<name> or " + LexState.LUA_QL("...") + " expected");
                    }
                }
            } while (funcState.isVararg == 0 && this.testnext(44));
        }
        this.adjustlocalvars(n);
        prototype.numParams = funcState.nactvar - (funcState.isVararg & 1);
        funcState.reserveregs(funcState.nactvar);
    }

    void body(ExpDesc expDesc, boolean bl, int n) {
        FuncState funcState = new FuncState(this, this.t.ts);
        funcState.linedefined = n;
        this.checknext(40);
        if (bl) {
            this.new_localvarliteral("self", 0);
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        this.chunk();
        funcState.lastlinedefined = this.linenumber;
        this.check_match(262, 265, n);
        this.close_func();
        this.pushclosure(funcState, expDesc);
    }

    int explist1(ExpDesc expDesc) {
        int n = 1;
        this.expr(expDesc);
        while (this.testnext(44)) {
            this.fs.exp2nextreg(expDesc);
            this.expr(expDesc);
            ++n;
        }
        return n;
    }

    void funcargs(ExpDesc expDesc) {
        int n;
        FuncState funcState = this.fs;
        ExpDesc expDesc2 = new ExpDesc();
        int n2 = this.linenumber;
        switch (this.t.token) {
            case 40: {
                if (n2 != this.lastline) {
                    this.syntaxerror("ambiguous syntax (function call x new statement)");
                }
                this.next();
                if (this.t.token == 41) {
                    expDesc2.k = 0;
                } else {
                    this.explist1(expDesc2);
                    funcState.setmultret(expDesc2);
                }
                this.check_match(41, 40, n2);
                break;
            }
            case 123: {
                this.constructor(expDesc2);
                break;
            }
            case 286: {
                this.codestring(expDesc2, this.t.ts);
                this.next();
                break;
            }
            default: {
                this.syntaxerror("function arguments expected");
                return;
            }
        }
        FuncState._assert(expDesc.k == 12);
        int n3 = expDesc.info;
        if (this.hasmultret(expDesc2.k)) {
            n = -1;
        } else {
            if (expDesc2.k != 0) {
                funcState.exp2nextreg(expDesc2);
            }
            n = funcState.freereg - (n3 + 1);
        }
        expDesc.init(13, funcState.codeABC(28, n3, n + 1, 2));
        funcState.fixline(n2);
        funcState.freereg = n3 + 1;
    }

    void prefixexp(ExpDesc expDesc) {
        switch (this.t.token) {
            case 40: {
                int n = this.linenumber;
                this.next();
                this.expr(expDesc);
                this.check_match(41, 40, n);
                this.fs.dischargevars(expDesc);
                return;
            }
            case 285: {
                this.singlevar(expDesc);
                return;
            }
        }
        this.syntaxerror("unexpected symbol");
    }

    void primaryexp(ExpDesc expDesc) {
        FuncState funcState = this.fs;
        this.prefixexp(expDesc);
        block6: while (true) {
            switch (this.t.token) {
                case 46: {
                    this.field(expDesc);
                    continue block6;
                }
                case 91: {
                    ExpDesc expDesc2 = new ExpDesc();
                    funcState.exp2anyreg(expDesc);
                    this.yindex(expDesc2);
                    funcState.indexed(expDesc, expDesc2);
                    continue block6;
                }
                case 58: {
                    ExpDesc expDesc2 = new ExpDesc();
                    this.next();
                    this.checkname(expDesc2);
                    funcState.self(expDesc, expDesc2);
                    this.funcargs(expDesc);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 286: {
                    funcState.exp2nextreg(expDesc);
                    this.funcargs(expDesc);
                    continue block6;
                }
            }
            break;
        }
    }

    void simpleexp(ExpDesc expDesc) {
        switch (this.t.token) {
            case 284: {
                expDesc.init(5, 0);
                expDesc.setNval(this.t.r);
                break;
            }
            case 286: {
                this.codestring(expDesc, this.t.ts);
                break;
            }
            case 269: {
                expDesc.init(1, 0);
                break;
            }
            case 275: {
                expDesc.init(2, 0);
                break;
            }
            case 263: {
                expDesc.init(3, 0);
                break;
            }
            case 279: {
                FuncState funcState = this.fs;
                this.check_condition(funcState.isVararg != 0, "cannot use " + LexState.LUA_QL("...") + " outside a vararg function");
                funcState.isVararg &= 0xFFFFFFFB;
                expDesc.init(14, funcState.codeABC(37, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(expDesc);
                return;
            }
            case 265: {
                this.next();
                this.body(expDesc, false, this.linenumber);
                return;
            }
            default: {
                this.primaryexp(expDesc);
                return;
            }
        }
        this.next();
    }

    int getunopr(int n) {
        switch (n) {
            case 270: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
        }
        return 3;
    }

    int getbinopr(int n) {
        switch (n) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 3;
            }
            case 37: {
                return 4;
            }
            case 94: {
                return 5;
            }
            case 278: {
                return 6;
            }
            case 283: {
                return 7;
            }
            case 280: {
                return 8;
            }
            case 60: {
                return 9;
            }
            case 282: {
                return 10;
            }
            case 62: {
                return 11;
            }
            case 281: {
                return 12;
            }
            case 257: {
                return 13;
            }
            case 271: {
                return 14;
            }
        }
        return 15;
    }

    int subexpr(ExpDesc expDesc, int n) {
        this.enterlevel();
        int n2 = this.getunopr(this.t.token);
        if (n2 != 3) {
            this.next();
            this.subexpr(expDesc, 8);
            this.fs.prefix(n2, expDesc);
        } else {
            this.simpleexp(expDesc);
        }
        int n3 = this.getbinopr(this.t.token);
        while (n3 != 15 && priorityLeft[n3] > n) {
            ExpDesc expDesc2 = new ExpDesc();
            this.next();
            this.fs.infix(n3, expDesc);
            int n4 = this.subexpr(expDesc2, priorityRight[n3]);
            this.fs.posfix(n3, expDesc, expDesc2);
            n3 = n4;
        }
        this.leavelevel();
        return n3;
    }

    void expr(ExpDesc expDesc) {
        this.subexpr(expDesc, 0);
    }

    boolean block_follow(int n) {
        switch (n) {
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 287: {
                return true;
            }
        }
        return false;
    }

    void block() {
        FuncState funcState = this.fs;
        BlockCnt blockCnt = new BlockCnt();
        funcState.enterblock(blockCnt, false);
        this.chunk();
        FuncState._assert(blockCnt.breaklist == -1);
        funcState.leaveblock();
    }

    void check_conflict(LHS_assign lHS_assign, ExpDesc expDesc) {
        FuncState funcState = this.fs;
        int n = funcState.freereg;
        boolean bl = false;
        while (lHS_assign != null) {
            if (lHS_assign.v.k == 9) {
                if (lHS_assign.v.info == expDesc.info) {
                    bl = true;
                    lHS_assign.v.info = n;
                }
                if (lHS_assign.v.aux == expDesc.info) {
                    bl = true;
                    lHS_assign.v.aux = n;
                }
            }
            lHS_assign = lHS_assign.prev;
        }
        if (bl) {
            funcState.codeABC(0, funcState.freereg, expDesc.info, 0);
            funcState.reserveregs(1);
        }
    }

    void assignment(LHS_assign lHS_assign, int n) {
        ExpDesc expDesc = new ExpDesc();
        this.check_condition(6 <= lHS_assign.v.k && lHS_assign.v.k <= 9, "syntax error");
        if (this.testnext(44)) {
            LHS_assign lHS_assign2 = new LHS_assign();
            lHS_assign2.prev = lHS_assign;
            this.primaryexp(lHS_assign2.v);
            if (lHS_assign2.v.k == 6) {
                this.check_conflict(lHS_assign, lHS_assign2.v);
            }
            this.assignment(lHS_assign2, n + 1);
        } else {
            this.checknext(61);
            int n2 = this.explist1(expDesc);
            if (n2 != n) {
                this.adjust_assign(n, n2, expDesc);
                if (n2 > n) {
                    this.fs.freereg -= n2 - n;
                }
            } else {
                this.fs.setoneret(expDesc);
                this.fs.storevar(lHS_assign.v, expDesc);
                return;
            }
        }
        expDesc.init(12, this.fs.freereg - 1);
        this.fs.storevar(lHS_assign.v, expDesc);
    }

    int cond() {
        ExpDesc expDesc = new ExpDesc();
        this.expr(expDesc);
        if (expDesc.k == 1) {
            expDesc.k = 3;
        }
        this.fs.goiftrue(expDesc);
        return expDesc.f;
    }

    void breakstat() {
        FuncState funcState = this.fs;
        BlockCnt blockCnt = funcState.bl;
        boolean bl = false;
        while (blockCnt != null && !blockCnt.isbreakable) {
            bl |= blockCnt.upval;
            blockCnt = blockCnt.previous;
        }
        if (blockCnt == null) {
            this.syntaxerror("no loop to break");
        }
        if (bl) {
            funcState.codeABC(35, blockCnt.nactvar, 0, 0);
        }
        blockCnt.breaklist = funcState.concat(blockCnt.breaklist, funcState.jump());
    }

    void whilestat(int n) {
        FuncState funcState = this.fs;
        BlockCnt blockCnt = new BlockCnt();
        this.next();
        int n2 = funcState.getlabel();
        int n3 = this.cond();
        funcState.enterblock(blockCnt, true);
        this.checknext(259);
        this.block();
        funcState.patchlist(funcState.jump(), n2);
        this.check_match(262, 277, n);
        funcState.leaveblock();
        funcState.patchtohere(n3);
    }

    void repeatstat(int n) {
        FuncState funcState = this.fs;
        int n2 = funcState.getlabel();
        BlockCnt blockCnt = new BlockCnt();
        BlockCnt blockCnt2 = new BlockCnt();
        funcState.enterblock(blockCnt, true);
        funcState.enterblock(blockCnt2, false);
        this.next();
        this.chunk();
        this.check_match(276, 272, n);
        int n3 = this.cond();
        if (!blockCnt2.upval) {
            funcState.leaveblock();
            funcState.patchlist(n3, n2);
        } else {
            this.breakstat();
            funcState.patchtohere(n3);
            funcState.leaveblock();
            funcState.patchlist(funcState.jump(), n2);
        }
        funcState.leaveblock();
    }

    int exp1() {
        ExpDesc expDesc = new ExpDesc();
        this.expr(expDesc);
        int n = expDesc.k;
        this.fs.exp2nextreg(expDesc);
        return n;
    }

    void forbody(int n, int n2, int n3, boolean bl) {
        BlockCnt blockCnt = new BlockCnt();
        FuncState funcState = this.fs;
        this.adjustlocalvars(3);
        this.checknext(259);
        int n4 = bl ? funcState.codeAsBx(32, n, -1) : funcState.jump();
        funcState.enterblock(blockCnt, false);
        this.adjustlocalvars(n3);
        funcState.reserveregs(n3);
        this.block();
        funcState.leaveblock();
        funcState.patchtohere(n4);
        int n5 = bl ? funcState.codeAsBx(31, n, -1) : funcState.codeABC(33, n, 0, n3);
        funcState.fixline(n2);
        funcState.patchlist(bl ? n5 : funcState.jump(), n4 + 1);
    }

    void fornum(String string, int n) {
        FuncState funcState = this.fs;
        int n2 = funcState.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_INDEX, 0);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_LIMIT, 1);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STEP, 2);
        this.new_localvar(string, 3);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            funcState.codeABx(1, funcState.freereg, funcState.numberK(1.0));
            funcState.reserveregs(1);
        }
        this.forbody(n2, n, 1, true);
    }

    void forlist(String string) {
        FuncState funcState = this.fs;
        ExpDesc expDesc = new ExpDesc();
        int n = 0;
        int n2 = funcState.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_GENERATOR, n++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STATE, n++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_CONTROL, n++);
        this.new_localvar(string, n++);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname(), n++);
        }
        this.checknext(267);
        int n3 = this.linenumber;
        this.adjust_assign(3, this.explist1(expDesc), expDesc);
        funcState.checkstack(3);
        this.forbody(n2, n3, n - 3, false);
    }

    void forstat(int n) {
        FuncState funcState = this.fs;
        BlockCnt blockCnt = new BlockCnt();
        funcState.enterblock(blockCnt, true);
        this.next();
        String string = this.str_checkname();
        switch (this.t.token) {
            case 61: {
                this.fornum(string, n);
                break;
            }
            case 44: 
            case 267: {
                this.forlist(string);
                break;
            }
            default: {
                this.syntaxerror(LexState.LUA_QL("=") + " or " + LexState.LUA_QL("in") + " expected");
            }
        }
        this.check_match(262, 264, n);
        funcState.leaveblock();
    }

    int test_then_block() {
        this.next();
        int n = this.cond();
        this.checknext(274);
        this.block();
        return n;
    }

    void ifstat(int n) {
        FuncState funcState = this.fs;
        int n2 = -1;
        int n3 = this.test_then_block();
        while (this.t.token == 261) {
            n2 = funcState.concat(n2, funcState.jump());
            funcState.patchtohere(n3);
            n3 = this.test_then_block();
        }
        if (this.t.token == 260) {
            n2 = funcState.concat(n2, funcState.jump());
            funcState.patchtohere(n3);
            this.next();
            this.block();
        } else {
            n2 = funcState.concat(n2, n3);
        }
        funcState.patchtohere(n2);
        this.check_match(262, 266, n);
    }

    void localfunc() {
        ExpDesc expDesc = new ExpDesc();
        ExpDesc expDesc2 = new ExpDesc();
        FuncState funcState = this.fs;
        this.new_localvar(this.str_checkname(), 0);
        expDesc.init(6, funcState.freereg);
        funcState.reserveregs(1);
        this.adjustlocalvars(1);
        this.body(expDesc2, false, this.linenumber);
        funcState.storevar(expDesc, expDesc2);
    }

    void localstat(int n) {
        int n2;
        int n3 = 0;
        ExpDesc expDesc = new ExpDesc();
        do {
            this.new_localvar(this.str_checkname(), n3++, n);
        } while (this.testnext(44));
        if (this.testnext(61)) {
            n2 = this.explist1(expDesc);
        } else {
            expDesc.k = 0;
            n2 = 0;
        }
        this.adjust_assign(n3, n2, expDesc);
        this.adjustlocalvars(n3);
    }

    boolean funcname(ExpDesc expDesc) {
        boolean bl = false;
        this.singlevar(expDesc);
        while (this.t.token == 46) {
            this.field(expDesc);
        }
        if (this.t.token == 58) {
            bl = true;
            this.field(expDesc);
        }
        return bl;
    }

    void funcstat(int n) {
        ExpDesc expDesc = new ExpDesc();
        ExpDesc expDesc2 = new ExpDesc();
        this.next();
        boolean bl = this.funcname(expDesc);
        this.body(expDesc2, bl, n);
        this.fs.storevar(expDesc, expDesc2);
        this.fs.fixline(n);
    }

    void exprstat() {
        FuncState funcState = this.fs;
        LHS_assign lHS_assign = new LHS_assign();
        this.primaryexp(lHS_assign.v);
        if (lHS_assign.v.k == 13) {
            FuncState.SETARG_C(funcState.getcodePtr(lHS_assign.v), 1);
        } else {
            lHS_assign.prev = null;
            this.assignment(lHS_assign, 1);
        }
    }

    void retstat() {
        int n;
        int n2;
        FuncState funcState = this.fs;
        ExpDesc expDesc = new ExpDesc();
        this.next();
        if (this.block_follow(this.t.token) || this.t.token == 59) {
            n2 = 0;
            n = 0;
        } else {
            n2 = this.explist1(expDesc);
            if (this.hasmultret(expDesc.k)) {
                funcState.setmultret(expDesc);
                if (expDesc.k == 13 && n2 == 1) {
                    FuncState.SET_OPCODE(funcState.getcodePtr(expDesc), 29);
                    FuncState._assert(FuncState.GETARG_A(funcState.getcode(expDesc)) == funcState.nactvar);
                }
                n = funcState.nactvar;
                n2 = -1;
            } else if (n2 == 1) {
                n = funcState.exp2anyreg(expDesc);
            } else {
                funcState.exp2nextreg(expDesc);
                n = funcState.nactvar;
                FuncState._assert(n2 == funcState.freereg - n);
            }
        }
        funcState.ret(n, n2);
    }

    boolean statement() {
        int n = this.linenumber;
        switch (this.t.token) {
            case 266: {
                this.ifstat(n);
                return false;
            }
            case 277: {
                this.whilestat(n);
                return false;
            }
            case 259: {
                this.next();
                this.block();
                this.check_match(262, 259, n);
                return false;
            }
            case 264: {
                this.forstat(n);
                return false;
            }
            case 272: {
                this.repeatstat(n);
                return false;
            }
            case 265: {
                this.funcstat(n);
                return false;
            }
            case 268: {
                this.next();
                if (this.testnext(265)) {
                    this.localfunc();
                } else {
                    this.localstat(n);
                }
                return false;
            }
            case 273: {
                this.retstat();
                return true;
            }
            case 258: {
                this.next();
                this.breakstat();
                return true;
            }
        }
        this.exprstat();
        return false;
    }

    void chunk() {
        boolean bl = false;
        this.enterlevel();
        while (!bl && !this.block_follow(this.t.token)) {
            bl = this.statement();
            this.testnext(59);
            FuncState._assert(this.fs.f.maxStacksize >= this.fs.freereg && this.fs.freereg >= this.fs.nactvar);
            this.fs.freereg = this.fs.nactvar;
        }
        this.leavelevel();
    }

    static {
        int n;
        RESERVED_LOCAL_VAR_KEYWORDS = new String[]{RESERVED_LOCAL_VAR_FOR_CONTROL, RESERVED_LOCAL_VAR_FOR_GENERATOR, RESERVED_LOCAL_VAR_FOR_INDEX, RESERVED_LOCAL_VAR_FOR_LIMIT, RESERVED_LOCAL_VAR_FOR_STATE, RESERVED_LOCAL_VAR_FOR_STEP};
        RESERVED_LOCAL_VAR_KEYWORDS_TABLE = new Hashtable();
        for (n = 0; n < RESERVED_LOCAL_VAR_KEYWORDS.length; ++n) {
            RESERVED_LOCAL_VAR_KEYWORDS_TABLE.put(RESERVED_LOCAL_VAR_KEYWORDS[n], Boolean.TRUE);
        }
        luaX_tokens = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "<number>", "<name>", "<string>", "<eof>"};
        RESERVED = new Hashtable();
        for (n = 0; n < 21; ++n) {
            String string = luaX_tokens[n];
            RESERVED.put(string, new Integer(257 + n));
        }
        priorityLeft = new int[]{6, 6, 7, 7, 7, 10, 5, 3, 3, 3, 3, 3, 3, 2, 1};
        priorityRight = new int[]{6, 6, 7, 7, 7, 9, 4, 3, 3, 3, 3, 3, 3, 2, 1};
    }
}

