/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.kahluafork.compiler;

import java.util.Hashtable;
import org.luaj.kahluafork.compiler.BlockCnt;
import org.luaj.kahluafork.compiler.ConsControl;
import org.luaj.kahluafork.compiler.ExpDesc;
import org.luaj.kahluafork.compiler.InstructionPtr;
import org.luaj.kahluafork.compiler.LexState;
import se.krka.kahlua.vm.KahluaException;
import se.krka.kahlua.vm.Prototype;

public class FuncState {
    private static final Object NULL_OBJECT = new Object();
    public String[] locvars;
    public String[] upvalues;
    public int linedefined;
    public int lastlinedefined;
    public int isVararg;
    Prototype f;
    Hashtable htable;
    FuncState prev;
    LexState ls;
    BlockCnt bl;
    int pc;
    int lasttarget;
    int jpc;
    int freereg;
    int nk;
    int np;
    int nlocvars;
    int nactvar;
    int[] upvalues_k = new int[60];
    int[] upvalues_info = new int[60];
    short[] actvar = new short[200];
    int[] actvarline = new int[200];
    public static String currentFile;
    public static String currentfullFile;
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVALUES = 60;
    static final int LUAI_MAXVARS = 200;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;
    public static final int LUA_MULTRET = -1;
    public static final int VARARG_HASARG = 1;
    public static final int VARARG_ISVARARG = 2;
    public static final int VARARG_NEEDSARG = 4;
    public static final int iABC = 0;
    public static final int iABx = 1;
    public static final int iAsBx = 2;
    public static final int SIZE_C = 9;
    public static final int SIZE_B = 9;
    public static final int SIZE_Bx = 18;
    public static final int SIZE_A = 8;
    public static final int SIZE_OP = 6;
    public static final int POS_OP = 0;
    public static final int POS_A = 6;
    public static final int POS_C = 14;
    public static final int POS_B = 23;
    public static final int POS_Bx = 14;
    public static final int MAX_OP = 63;
    public static final int MAXARG_A = 255;
    public static final int MAXARG_B = 511;
    public static final int MAXARG_C = 511;
    public static final int MAXARG_Bx = 262143;
    public static final int MAXARG_sBx = 131071;
    public static final int MASK_OP = 63;
    public static final int MASK_A = 16320;
    public static final int MASK_B = -8388608;
    public static final int MASK_C = 8372224;
    public static final int MASK_Bx = -16384;
    public static final int MASK_NOT_OP = -64;
    public static final int MASK_NOT_A = -16321;
    public static final int MASK_NOT_B = 0x7FFFFF;
    public static final int MASK_NOT_C = -8372225;
    public static final int MASK_NOT_Bx = 16383;
    public static final int BITRK = 256;
    public static final int MAXINDEXRK = 255;
    public static final int NO_REG = 255;
    public static final int OP_MOVE = 0;
    public static final int OP_LOADK = 1;
    public static final int OP_LOADBOOL = 2;
    public static final int OP_LOADNIL = 3;
    public static final int OP_GETUPVAL = 4;
    public static final int OP_GETGLOBAL = 5;
    public static final int OP_GETTABLE = 6;
    public static final int OP_SETGLOBAL = 7;
    public static final int OP_SETUPVAL = 8;
    public static final int OP_SETTABLE = 9;
    public static final int OP_NEWTABLE = 10;
    public static final int OP_SELF = 11;
    public static final int OP_ADD = 12;
    public static final int OP_SUB = 13;
    public static final int OP_MUL = 14;
    public static final int OP_DIV = 15;
    public static final int OP_MOD = 16;
    public static final int OP_POW = 17;
    public static final int OP_UNM = 18;
    public static final int OP_NOT = 19;
    public static final int OP_LEN = 20;
    public static final int OP_CONCAT = 21;
    public static final int OP_JMP = 22;
    public static final int OP_EQ = 23;
    public static final int OP_LT = 24;
    public static final int OP_LE = 25;
    public static final int OP_TEST = 26;
    public static final int OP_TESTSET = 27;
    public static final int OP_CALL = 28;
    public static final int OP_TAILCALL = 29;
    public static final int OP_RETURN = 30;
    public static final int OP_FORLOOP = 31;
    public static final int OP_FORPREP = 32;
    public static final int OP_TFORLOOP = 33;
    public static final int OP_SETLIST = 34;
    public static final int OP_CLOSE = 35;
    public static final int OP_CLOSURE = 36;
    public static final int OP_VARARG = 37;
    public static final int NUM_OPCODES = 38;
    public static final int[] luaP_opmodes;
    public static final int LFIELDS_PER_FLUSH = 50;

    FuncState(LexState lexState) {
        Prototype prototype = new Prototype();
        if (lexState.fs != null) {
            prototype.name = lexState.fs.f.name;
        }
        this.f = prototype;
        this.prev = lexState.fs;
        this.ls = lexState;
        lexState.fs = this;
        this.pc = 0;
        this.lasttarget = -1;
        this.jpc = -1;
        this.freereg = 0;
        this.nk = 0;
        this.np = 0;
        this.nlocvars = 0;
        this.nactvar = 0;
        this.bl = null;
        prototype.maxStacksize = 2;
        this.htable = new Hashtable();
    }

    FuncState(LexState lexState, String string) {
        Prototype prototype = new Prototype();
        prototype.name = string;
        this.f = prototype;
        this.prev = lexState.fs;
        this.ls = lexState;
        lexState.fs = this;
        this.pc = 0;
        this.lasttarget = -1;
        this.jpc = -1;
        this.freereg = 0;
        this.nk = 0;
        this.np = 0;
        this.nlocvars = 0;
        this.nactvar = 0;
        this.bl = null;
        prototype.maxStacksize = 2;
        this.htable = new Hashtable();
    }

    InstructionPtr getcodePtr(ExpDesc expDesc) {
        return new InstructionPtr(this.f.code, expDesc.info);
    }

    int getcode(ExpDesc expDesc) {
        return this.f.code[expDesc.info];
    }

    int codeAsBx(int n, int n2, int n3) {
        return this.codeABx(n, n2, n3 + 131071);
    }

    void setmultret(ExpDesc expDesc) {
        this.setreturns(expDesc, -1);
    }

    String getlocvar(int n) {
        return this.locvars[this.actvar[n]];
    }

    void checklimit(int n, int n2, String string) {
        if (n > n2) {
            this.errorlimit(n2, string);
        }
    }

    void errorlimit(int n, String string) {
        String string2 = this.linedefined == 0 ? "main function has more than " + n + " " + string : "function at line " + this.linedefined + " has more than " + n + " " + string;
        this.ls.lexerror(string2, 0);
    }

    int indexupvalue(String string, ExpDesc expDesc) {
        for (int i = 0; i < this.f.numUpvalues; ++i) {
            if (this.upvalues_k[i] != expDesc.k || this.upvalues_info[i] != expDesc.info) continue;
            FuncState._assert(this.upvalues[i].equals(string));
            return i;
        }
        this.checklimit(this.f.numUpvalues + 1, 60, "upvalues");
        if (this.upvalues == null || this.f.numUpvalues + 1 > this.upvalues.length) {
            this.upvalues = FuncState.realloc(this.upvalues, this.f.numUpvalues * 2 + 1);
        }
        FuncState._assert(expDesc.k == 6 || expDesc.k == 7);
        int n = this.f.numUpvalues++;
        this.upvalues[n] = string;
        this.upvalues_k[n] = expDesc.k;
        this.upvalues_info[n] = expDesc.info;
        return n;
    }

    int searchvar(String string) {
        for (int i = this.nactvar - 1; i >= 0; --i) {
            if (!string.equals(this.getlocvar(i))) continue;
            return i;
        }
        return -1;
    }

    void markupval(int n) {
        BlockCnt blockCnt = this.bl;
        while (blockCnt != null && blockCnt.nactvar > n) {
            blockCnt = blockCnt.previous;
        }
        if (blockCnt != null) {
            blockCnt.upval = true;
        }
    }

    int singlevaraux(String string, ExpDesc expDesc, int n) {
        int n2 = this.searchvar(string);
        if (n2 >= 0) {
            expDesc.init(6, n2);
            if (n == 0) {
                this.markupval(n2);
            }
            return 6;
        }
        if (this.prev == null) {
            expDesc.init(8, 255);
            return 8;
        }
        if (this.prev.singlevaraux(string, expDesc, 0) == 8) {
            return 8;
        }
        expDesc.info = this.indexupvalue(string, expDesc);
        expDesc.k = 7;
        return 7;
    }

    void enterblock(BlockCnt blockCnt, boolean bl) {
        blockCnt.breaklist = -1;
        blockCnt.isbreakable = bl;
        blockCnt.nactvar = this.nactvar;
        blockCnt.upval = false;
        blockCnt.previous = this.bl;
        this.bl = blockCnt;
        FuncState._assert(this.freereg == this.nactvar);
    }

    void leaveblock() {
        BlockCnt blockCnt = this.bl;
        this.bl = blockCnt.previous;
        this.ls.removevars(blockCnt.nactvar);
        if (blockCnt.upval) {
            this.codeABC(35, blockCnt.nactvar, 0, 0);
        }
        FuncState._assert(!blockCnt.isbreakable || !blockCnt.upval);
        FuncState._assert(blockCnt.nactvar == this.nactvar);
        this.freereg = this.nactvar;
        this.patchtohere(blockCnt.breaklist);
    }

    void closelistfield(ConsControl consControl) {
        if (consControl.v.k == 0) {
            return;
        }
        this.exp2nextreg(consControl.v);
        consControl.v.k = 0;
        if (consControl.tostore == 50) {
            this.setlist(consControl.t.info, consControl.na, consControl.tostore);
            consControl.tostore = 0;
        }
    }

    boolean hasmultret(int n) {
        return n == 13 || n == 14;
    }

    void lastlistfield(ConsControl consControl) {
        if (consControl.tostore == 0) {
            return;
        }
        if (this.hasmultret(consControl.v.k)) {
            this.setmultret(consControl.v);
            this.setlist(consControl.t.info, consControl.na, -1);
            --consControl.na;
        } else {
            if (consControl.v.k != 0) {
                this.exp2nextreg(consControl.v);
            }
            this.setlist(consControl.t.info, consControl.na, consControl.tostore);
        }
    }

    void nil(int n, int n2) {
        if (this.pc > this.lasttarget) {
            if (this.pc == 0) {
                if (n >= this.nactvar) {
                    return;
                }
            } else {
                InstructionPtr instructionPtr = new InstructionPtr(this.f.code, this.pc - 1);
                if (FuncState.GET_OPCODE(instructionPtr.get()) == 3) {
                    int n3 = FuncState.GETARG_A(instructionPtr.get());
                    int n4 = FuncState.GETARG_B(instructionPtr.get());
                    if (n3 <= n && n <= n4 + 1) {
                        if (n + n2 - 1 > n4) {
                            FuncState.SETARG_B(instructionPtr, n + n2 - 1);
                        }
                        return;
                    }
                }
            }
        }
        this.codeABC(3, n, n + n2 - 1, 0);
    }

    int jump() {
        int n = this.jpc;
        this.jpc = -1;
        int n2 = this.codeAsBx(22, 0, -1);
        n2 = this.concat(n2, n);
        return n2;
    }

    void ret(int n, int n2) {
        this.codeABC(30, n, n2 + 1, 0);
    }

    int condjump(int n, int n2, int n3, int n4) {
        this.codeABC(n, n2, n3, n4);
        return this.jump();
    }

    void fixjump(int n, int n2) {
        InstructionPtr instructionPtr = new InstructionPtr(this.f.code, n);
        int n3 = n2 - (n + 1);
        FuncState._assert(n2 != -1);
        if (Math.abs(n3) > 131071) {
            this.ls.syntaxerror("control structure too long");
        }
        FuncState.SETARG_sBx(instructionPtr, n3);
    }

    int getlabel() {
        this.lasttarget = this.pc;
        return this.pc;
    }

    int getjump(int n) {
        int n2 = FuncState.GETARG_sBx(this.f.code[n]);
        if (n2 == -1) {
            return -1;
        }
        return n + 1 + n2;
    }

    InstructionPtr getjumpcontrol(int n) {
        InstructionPtr instructionPtr = new InstructionPtr(this.f.code, n);
        if (n >= 1 && FuncState.testTMode(FuncState.GET_OPCODE(instructionPtr.code[instructionPtr.idx - 1]))) {
            return new InstructionPtr(instructionPtr.code, instructionPtr.idx - 1);
        }
        return instructionPtr;
    }

    boolean need_value(int n) {
        while (n != -1) {
            int n2 = this.getjumpcontrol(n).get();
            if (FuncState.GET_OPCODE(n2) != 27) {
                return true;
            }
            n = this.getjump(n);
        }
        return false;
    }

    boolean patchtestreg(int n, int n2) {
        InstructionPtr instructionPtr = this.getjumpcontrol(n);
        if (FuncState.GET_OPCODE(instructionPtr.get()) != 27) {
            return false;
        }
        if (n2 != 255 && n2 != FuncState.GETARG_B(instructionPtr.get())) {
            FuncState.SETARG_A(instructionPtr, n2);
        } else {
            instructionPtr.set(FuncState.CREATE_ABC(26, FuncState.GETARG_B(instructionPtr.get()), 0, FuncState.GETARG_C(instructionPtr.get())));
        }
        return true;
    }

    void removevalues(int n) {
        while (n != -1) {
            this.patchtestreg(n, 255);
            n = this.getjump(n);
        }
    }

    void patchlistaux(int n, int n2, int n3, int n4) {
        while (n != -1) {
            int n5 = this.getjump(n);
            if (this.patchtestreg(n, n3)) {
                this.fixjump(n, n2);
            } else {
                this.fixjump(n, n4);
            }
            n = n5;
        }
    }

    void dischargejpc() {
        this.patchlistaux(this.jpc, this.pc, 255, this.pc);
        this.jpc = -1;
    }

    void patchlist(int n, int n2) {
        if (n2 == this.pc) {
            this.patchtohere(n);
        } else {
            FuncState._assert(n2 < this.pc);
            this.patchlistaux(n, n2, 255, n2);
        }
    }

    void patchtohere(int n) {
        this.getlabel();
        this.jpc = this.concat(this.jpc, n);
    }

    int concat(int n, int n2) {
        if (n2 == -1) {
            return n;
        }
        if (n == -1) {
            n = n2;
        } else {
            int n3;
            int n4 = n;
            while ((n3 = this.getjump(n4)) != -1) {
                n4 = n3;
            }
            this.fixjump(n4, n2);
        }
        return n;
    }

    void checkstack(int n) {
        int n2 = this.freereg + n;
        if (n2 > this.f.maxStacksize) {
            if (n2 >= 250) {
                this.ls.syntaxerror("function or expression too complex");
            }
            this.f.maxStacksize = n2;
        }
    }

    void reserveregs(int n) {
        this.checkstack(n);
        this.freereg += n;
    }

    void freereg(int n) {
        if (!FuncState.ISK(n) && n >= this.nactvar) {
            --this.freereg;
            FuncState._assert(n == this.freereg);
        }
    }

    void freeexp(ExpDesc expDesc) {
        if (expDesc.k == 12) {
            this.freereg(expDesc.info);
        }
    }

    int addk(Object object) {
        int n;
        if (this.htable.containsKey(object)) {
            n = (Integer)this.htable.get(object);
        } else {
            n = this.nk;
            this.htable.put(object, new Integer(n));
            Prototype prototype = this.f;
            if (prototype.constants == null || this.nk + 1 >= prototype.constants.length) {
                prototype.constants = FuncState.realloc(prototype.constants, this.nk * 2 + 1);
            }
            if (object == NULL_OBJECT) {
                object = null;
            }
            prototype.constants[this.nk++] = object;
        }
        return n;
    }

    int stringK(String string) {
        return this.addk(string);
    }

    int numberK(double d) {
        return this.addk(new Double(d));
    }

    int boolK(boolean bl) {
        return this.addk(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    int nilK() {
        return this.addk(NULL_OBJECT);
    }

    void setreturns(ExpDesc expDesc, int n) {
        if (expDesc.k == 13) {
            FuncState.SETARG_C(this.getcodePtr(expDesc), n + 1);
        } else if (expDesc.k == 14) {
            FuncState.SETARG_B(this.getcodePtr(expDesc), n + 1);
            FuncState.SETARG_A(this.getcodePtr(expDesc), this.freereg);
            this.reserveregs(1);
        }
    }

    void setoneret(ExpDesc expDesc) {
        if (expDesc.k == 13) {
            expDesc.k = 12;
            expDesc.info = FuncState.GETARG_A(this.getcode(expDesc));
        } else if (expDesc.k == 14) {
            FuncState.SETARG_B(this.getcodePtr(expDesc), 2);
            expDesc.k = 11;
        }
    }

    void dischargevars(ExpDesc expDesc) {
        switch (expDesc.k) {
            case 6: {
                expDesc.k = 12;
                break;
            }
            case 7: {
                expDesc.info = this.codeABC(4, 0, expDesc.info, 0);
                expDesc.k = 11;
                break;
            }
            case 8: {
                expDesc.info = this.codeABx(5, 0, expDesc.info);
                expDesc.k = 11;
                break;
            }
            case 9: {
                this.freereg(expDesc.aux);
                this.freereg(expDesc.info);
                expDesc.info = this.codeABC(6, 0, expDesc.info, expDesc.aux);
                expDesc.k = 11;
                break;
            }
            case 13: 
            case 14: {
                this.setoneret(expDesc);
                break;
            }
        }
    }

    int code_label(int n, int n2, int n3) {
        this.getlabel();
        return this.codeABC(2, n, n2, n3);
    }

    void discharge2reg(ExpDesc expDesc, int n) {
        this.dischargevars(expDesc);
        switch (expDesc.k) {
            case 1: {
                this.nil(n, 1);
                break;
            }
            case 2: 
            case 3: {
                this.codeABC(2, n, expDesc.k == 2 ? 1 : 0, 0);
                break;
            }
            case 4: {
                this.codeABx(1, n, expDesc.info);
                break;
            }
            case 5: {
                this.codeABx(1, n, this.numberK(expDesc.nval()));
                break;
            }
            case 11: {
                InstructionPtr instructionPtr = this.getcodePtr(expDesc);
                FuncState.SETARG_A(instructionPtr, n);
                break;
            }
            case 12: {
                if (n == expDesc.info) break;
                this.codeABC(0, n, expDesc.info, 0);
                break;
            }
            default: {
                FuncState._assert(expDesc.k == 0 || expDesc.k == 10);
                return;
            }
        }
        expDesc.info = n;
        expDesc.k = 12;
    }

    void discharge2anyreg(ExpDesc expDesc) {
        if (expDesc.k != 12) {
            this.reserveregs(1);
            this.discharge2reg(expDesc, this.freereg - 1);
        }
    }

    void exp2reg(ExpDesc expDesc, int n) {
        this.discharge2reg(expDesc, n);
        if (expDesc.k == 10) {
            expDesc.t = this.concat(expDesc.t, expDesc.info);
        }
        if (expDesc.hasjumps()) {
            int n2 = -1;
            int n3 = -1;
            if (this.need_value(expDesc.t) || this.need_value(expDesc.f)) {
                int n4 = expDesc.k == 10 ? -1 : this.jump();
                n2 = this.code_label(n, 0, 1);
                n3 = this.code_label(n, 1, 0);
                this.patchtohere(n4);
            }
            int n5 = this.getlabel();
            this.patchlistaux(expDesc.f, n5, n, n2);
            this.patchlistaux(expDesc.t, n5, n, n3);
        }
        expDesc.t = -1;
        expDesc.f = -1;
        expDesc.info = n;
        expDesc.k = 12;
    }

    void exp2nextreg(ExpDesc expDesc) {
        this.dischargevars(expDesc);
        this.freeexp(expDesc);
        this.reserveregs(1);
        this.exp2reg(expDesc, this.freereg - 1);
    }

    int exp2anyreg(ExpDesc expDesc) {
        this.dischargevars(expDesc);
        if (expDesc.k == 12) {
            if (!expDesc.hasjumps()) {
                return expDesc.info;
            }
            if (expDesc.info >= this.nactvar) {
                this.exp2reg(expDesc, expDesc.info);
                return expDesc.info;
            }
        }
        this.exp2nextreg(expDesc);
        return expDesc.info;
    }

    void exp2val(ExpDesc expDesc) {
        if (expDesc.hasjumps()) {
            this.exp2anyreg(expDesc);
        } else {
            this.dischargevars(expDesc);
        }
    }

    int exp2RK(ExpDesc expDesc) {
        this.exp2val(expDesc);
        switch (expDesc.k) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.nk > 255) break;
                expDesc.info = expDesc.k == 1 ? this.nilK() : (expDesc.k == 5 ? this.numberK(expDesc.nval()) : this.boolK(expDesc.k == 2));
                expDesc.k = 4;
                return FuncState.RKASK(expDesc.info);
            }
            case 4: {
                if (expDesc.info > 255) break;
                return FuncState.RKASK(expDesc.info);
            }
        }
        return this.exp2anyreg(expDesc);
    }

    void storevar(ExpDesc expDesc, ExpDesc expDesc2) {
        switch (expDesc.k) {
            case 6: {
                this.freeexp(expDesc2);
                this.exp2reg(expDesc2, expDesc.info);
                return;
            }
            case 7: {
                int n = this.exp2anyreg(expDesc2);
                this.codeABC(8, n, expDesc.info, 0);
                break;
            }
            case 8: {
                int n = this.exp2anyreg(expDesc2);
                this.codeABx(7, n, expDesc.info);
                break;
            }
            case 9: {
                int n = this.exp2RK(expDesc2);
                this.codeABC(9, expDesc.info, expDesc.aux, n);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        this.freeexp(expDesc2);
    }

    void self(ExpDesc expDesc, ExpDesc expDesc2) {
        this.exp2anyreg(expDesc);
        this.freeexp(expDesc);
        int n = this.freereg;
        this.reserveregs(2);
        this.codeABC(11, n, expDesc.info, this.exp2RK(expDesc2));
        this.freeexp(expDesc2);
        expDesc.info = n;
        expDesc.k = 12;
    }

    void invertjump(ExpDesc expDesc) {
        InstructionPtr instructionPtr = this.getjumpcontrol(expDesc.info);
        FuncState._assert(FuncState.testTMode(FuncState.GET_OPCODE(instructionPtr.get())) && FuncState.GET_OPCODE(instructionPtr.get()) != 27 && FuncState.GET_OPCODE(instructionPtr.get()) != 26);
        int n = FuncState.GETARG_A(instructionPtr.get());
        int n2 = n != 0 ? 0 : 1;
        FuncState.SETARG_A(instructionPtr, n2);
    }

    int jumponcond(ExpDesc expDesc, int n) {
        int n2;
        if (expDesc.k == 11 && FuncState.GET_OPCODE(n2 = this.getcode(expDesc)) == 19) {
            --this.pc;
            return this.condjump(26, FuncState.GETARG_B(n2), 0, n != 0 ? 0 : 1);
        }
        this.discharge2anyreg(expDesc);
        this.freeexp(expDesc);
        return this.condjump(27, 255, expDesc.info, n);
    }

    void goiftrue(ExpDesc expDesc) {
        this.dischargevars(expDesc);
        expDesc.f = this.concat(expDesc.f, switch (expDesc.k) {
            case 2, 4, 5 -> -1;
            case 3 -> this.jump();
            case 10 -> {
                this.invertjump(expDesc);
                yield expDesc.info;
            }
            default -> this.jumponcond(expDesc, 0);
        });
        this.patchtohere(expDesc.t);
        expDesc.t = -1;
    }

    void goiffalse(ExpDesc expDesc) {
        this.dischargevars(expDesc);
        expDesc.t = this.concat(expDesc.t, switch (expDesc.k) {
            case 1, 3 -> -1;
            case 2 -> this.jump();
            case 10 -> expDesc.info;
            default -> this.jumponcond(expDesc, 1);
        });
        this.patchtohere(expDesc.f);
        expDesc.f = -1;
    }

    void codenot(ExpDesc expDesc) {
        this.dischargevars(expDesc);
        switch (expDesc.k) {
            case 1: 
            case 3: {
                expDesc.k = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                expDesc.k = 3;
                break;
            }
            case 10: {
                this.invertjump(expDesc);
                break;
            }
            case 11: 
            case 12: {
                this.discharge2anyreg(expDesc);
                this.freeexp(expDesc);
                expDesc.info = this.codeABC(19, 0, expDesc.info, 0);
                expDesc.k = 11;
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        int n = expDesc.f;
        expDesc.f = expDesc.t;
        expDesc.t = n;
        this.removevalues(expDesc.f);
        this.removevalues(expDesc.t);
    }

    void indexed(ExpDesc expDesc, ExpDesc expDesc2) {
        expDesc.aux = this.exp2RK(expDesc2);
        expDesc.k = 9;
    }

    boolean constfolding(int n, ExpDesc expDesc, ExpDesc expDesc2) {
        double d;
        if (!expDesc.isnumeral() || !expDesc2.isnumeral()) {
            return false;
        }
        double d2 = expDesc.nval();
        double d3 = expDesc2.nval();
        switch (n) {
            case 12: {
                d = d2 + d3;
                break;
            }
            case 13: {
                d = d2 - d3;
                break;
            }
            case 14: {
                d = d2 * d3;
                break;
            }
            case 15: {
                d = d2 / d3;
                break;
            }
            case 16: {
                d = d2 % d3;
                break;
            }
            case 17: {
                return false;
            }
            case 18: {
                d = -d2;
                break;
            }
            case 20: {
                return false;
            }
            default: {
                FuncState._assert(false);
                return false;
            }
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return false;
        }
        expDesc.setNval(d);
        return true;
    }

    void codearith(int n, ExpDesc expDesc, ExpDesc expDesc2) {
        if (this.constfolding(n, expDesc, expDesc2)) {
            return;
        }
        int n2 = n != 18 && n != 20 ? this.exp2RK(expDesc2) : 0;
        int n3 = this.exp2RK(expDesc);
        if (n3 > n2) {
            this.freeexp(expDesc);
            this.freeexp(expDesc2);
        } else {
            this.freeexp(expDesc2);
            this.freeexp(expDesc);
        }
        expDesc.info = this.codeABC(n, 0, n3, n2);
        expDesc.k = 11;
    }

    void codecomp(int n, int n2, ExpDesc expDesc, ExpDesc expDesc2) {
        int n3 = this.exp2RK(expDesc);
        int n4 = this.exp2RK(expDesc2);
        this.freeexp(expDesc2);
        this.freeexp(expDesc);
        if (n2 == 0 && n != 23) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
            n2 = 1;
        }
        expDesc.info = this.condjump(n, n2, n3, n4);
        expDesc.k = 10;
    }

    void prefix(int n, ExpDesc expDesc) {
        ExpDesc expDesc2 = new ExpDesc();
        expDesc2.init(5, 0);
        switch (n) {
            case 0: {
                if (expDesc.k == 4) {
                    this.exp2anyreg(expDesc);
                }
                this.codearith(18, expDesc, expDesc2);
                break;
            }
            case 1: {
                this.codenot(expDesc);
                break;
            }
            case 2: {
                this.exp2anyreg(expDesc);
                this.codearith(20, expDesc, expDesc2);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void infix(int n, ExpDesc expDesc) {
        switch (n) {
            case 13: {
                this.goiftrue(expDesc);
                break;
            }
            case 14: {
                this.goiffalse(expDesc);
                break;
            }
            case 6: {
                this.exp2nextreg(expDesc);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (expDesc.isnumeral()) break;
                this.exp2RK(expDesc);
                break;
            }
            default: {
                this.exp2RK(expDesc);
            }
        }
    }

    void posfix(int n, ExpDesc expDesc, ExpDesc expDesc2) {
        switch (n) {
            case 13: {
                FuncState._assert(expDesc.t == -1);
                this.dischargevars(expDesc2);
                expDesc2.f = this.concat(expDesc2.f, expDesc.f);
                expDesc.setvalue(expDesc2);
                break;
            }
            case 14: {
                FuncState._assert(expDesc.f == -1);
                this.dischargevars(expDesc2);
                expDesc2.t = this.concat(expDesc2.t, expDesc.t);
                expDesc.setvalue(expDesc2);
                break;
            }
            case 6: {
                this.exp2val(expDesc2);
                if (expDesc2.k == 11 && FuncState.GET_OPCODE(this.getcode(expDesc2)) == 21) {
                    FuncState._assert(expDesc.info == FuncState.GETARG_B(this.getcode(expDesc2)) - 1);
                    this.freeexp(expDesc);
                    FuncState.SETARG_B(this.getcodePtr(expDesc2), expDesc.info);
                    expDesc.k = 11;
                    expDesc.info = expDesc2.info;
                    break;
                }
                this.exp2nextreg(expDesc2);
                this.codearith(21, expDesc, expDesc2);
                break;
            }
            case 0: {
                this.codearith(12, expDesc, expDesc2);
                break;
            }
            case 1: {
                this.codearith(13, expDesc, expDesc2);
                break;
            }
            case 2: {
                this.codearith(14, expDesc, expDesc2);
                break;
            }
            case 3: {
                this.codearith(15, expDesc, expDesc2);
                break;
            }
            case 4: {
                this.codearith(16, expDesc, expDesc2);
                break;
            }
            case 5: {
                this.codearith(17, expDesc, expDesc2);
                break;
            }
            case 8: {
                this.codecomp(23, 1, expDesc, expDesc2);
                break;
            }
            case 7: {
                this.codecomp(23, 0, expDesc, expDesc2);
                break;
            }
            case 9: {
                this.codecomp(24, 1, expDesc, expDesc2);
                break;
            }
            case 10: {
                this.codecomp(25, 1, expDesc, expDesc2);
                break;
            }
            case 11: {
                this.codecomp(24, 0, expDesc, expDesc2);
                break;
            }
            case 12: {
                this.codecomp(25, 0, expDesc, expDesc2);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void fixline(int n) {
        this.f.lines[this.pc - 1] = n;
    }

    int code(int n, int n2) {
        Prototype prototype = this.f;
        this.dischargejpc();
        if (prototype.code == null || this.pc + 1 > prototype.code.length) {
            prototype.code = FuncState.realloc(prototype.code, this.pc * 2 + 1);
        }
        prototype.code[this.pc] = n;
        if (prototype.lines == null || this.pc + 1 > prototype.lines.length) {
            prototype.lines = FuncState.realloc(prototype.lines, this.pc * 2 + 1);
        }
        prototype.lines[this.pc] = n2;
        prototype.file = currentFile;
        prototype.filename = currentfullFile;
        return this.pc++;
    }

    int codeABC(int n, int n2, int n3, int n4) {
        FuncState._assert(FuncState.getOpMode(n) == 0);
        FuncState._assert(FuncState.getBMode(n) != 0 || n3 == 0);
        FuncState._assert(FuncState.getCMode(n) != 0 || n4 == 0);
        return this.code(FuncState.CREATE_ABC(n, n2, n3, n4), this.ls.lastline);
    }

    int codeABx(int n, int n2, int n3) {
        FuncState._assert(FuncState.getOpMode(n) == 1 || FuncState.getOpMode(n) == 2);
        FuncState._assert(FuncState.getCMode(n) == 0);
        return this.code(FuncState.CREATE_ABx(n, n2, n3), this.ls.lastline);
    }

    void setlist(int n, int n2, int n3) {
        int n4 = (n2 - 1) / 50 + 1;
        int n5 = n3 == -1 ? 0 : n3;
        FuncState._assert(n3 != 0);
        if (n4 <= 511) {
            this.codeABC(34, n, n5, n4);
        } else {
            this.codeABC(34, n, n5, 0);
            this.code(n4, this.ls.lastline);
        }
        this.freereg = n + 1;
    }

    protected static void _assert(boolean bl) {
        if (!bl) {
            throw new KahluaException((Object)"compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFFFC0 | n << 0 & 0x3F);
    }

    static void SETARG_A(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFC03F | n << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x7FFFFF | n << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFF803FFF | n << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x3FFF | n << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr instructionPtr, int n) {
        FuncState.SETARG_Bx(instructionPtr, n + 131071);
    }

    static int CREATE_ABC(int n, int n2, int n3, int n4) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 23 & 0xFF800000 | n4 << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int n, int n2, int n3) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 14 & 0xFFFFC000;
    }

    static Object[] realloc(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[n];
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n));
        }
        return objectArray2;
    }

    static String[] realloc(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(stringArray.length, n));
        }
        return stringArray2;
    }

    static Prototype[] realloc(Prototype[] prototypeArray, int n) {
        Prototype[] prototypeArray2 = new Prototype[n];
        if (prototypeArray != null) {
            System.arraycopy(prototypeArray, 0, prototypeArray2, 0, Math.min(prototypeArray.length, n));
        }
        return prototypeArray2;
    }

    static int[] realloc(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        }
        return nArray2;
    }

    static byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        }
        return byArray2;
    }

    public static int GET_OPCODE(int n) {
        return n >> 0 & 0x3F;
    }

    public static int GETARG_A(int n) {
        return n >> 6 & 0xFF;
    }

    public static int GETARG_B(int n) {
        return n >> 23 & 0x1FF;
    }

    public static int GETARG_C(int n) {
        return n >> 14 & 0x1FF;
    }

    public static int GETARG_Bx(int n) {
        return n >> 14 & 0x3FFFF;
    }

    public static int GETARG_sBx(int n) {
        return (n >> 14 & 0x3FFFF) - 131071;
    }

    public static boolean ISK(int n) {
        return 0 != (n & 0x100);
    }

    public static int INDEXK(int n) {
        return n & 0xFFFFFEFF;
    }

    public static int RKASK(int n) {
        return n | 0x100;
    }

    public static int getOpMode(int n) {
        return luaP_opmodes[n] & 3;
    }

    public static int getBMode(int n) {
        return luaP_opmodes[n] >> 4 & 3;
    }

    public static int getCMode(int n) {
        return luaP_opmodes[n] >> 2 & 3;
    }

    public static boolean testTMode(int n) {
        return 0 != (luaP_opmodes[n] & 0x80);
    }

    static {
        luaP_opmodes = new int[]{96, 113, 84, 96, 80, 113, 108, 49, 16, 60, 84, 108, 124, 124, 124, 124, 124, 124, 96, 96, 96, 104, 34, 188, 188, 188, 228, 228, 84, 84, 16, 98, 98, 132, 20, 0, 81, 80};
    }
}

