/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import org.joml.Random;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Callback3d;
import org.joml.sampling.Math;

public class UniformSampling {

    public static class Sphere {
        private final Random rnd;

        public Sphere(long l, int n, Callback3d callback3d) {
            this.rnd = new Random(l);
            this.generate(n, callback3d);
        }

        public void generate(int n, Callback3d callback3d) {
            int n2 = 0;
            while (n2 < n) {
                float f;
                float f2 = this.rnd.nextFloat() * 2.0f - 1.0f;
                if (f2 * f2 + (f = this.rnd.nextFloat() * 2.0f - 1.0f) * f >= 1.0f) continue;
                float f3 = (float)Math.sqrt(1.0 - (double)(f2 * f2) - (double)(f * f));
                float f4 = 2.0f * f2 * f3;
                float f5 = 2.0f * f * f3;
                float f6 = 1.0f - 2.0f * (f2 * f2 + f * f);
                callback3d.onNewSample(f4, f5, f6);
                ++n2;
            }
        }
    }

    public static class Disk {
        private final Random rnd;

        public Disk(long l, int n, Callback2d callback2d) {
            this.rnd = new Random(l);
            this.generate(n, callback2d);
        }

        private void generate(int n, Callback2d callback2d) {
            for (int i = 0; i < n; ++i) {
                float f = this.rnd.nextFloat();
                float f2 = this.rnd.nextFloat() * 2.0f * (float)java.lang.Math.PI;
                float f3 = Math.sqrt(f);
                float f4 = f3 * (float)Math.sin_roquen_9((double)f2 + 1.5707963267948966);
                float f5 = f3 * (float)Math.sin_roquen_9(f2);
                callback2d.onNewSample(f4, f5);
            }
        }
    }
}

