/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import org.joml.Random;
import org.joml.sampling.Callback2d;

public class StratifiedSampling {
    private final Random rnd;

    public StratifiedSampling(long l) {
        this.rnd = new Random(l);
    }

    public void generateRandom(int n, Callback2d callback2d) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                float f = (this.rnd.nextFloat() / (float)n + (float)j / (float)n) * 2.0f - 1.0f;
                float f2 = (this.rnd.nextFloat() / (float)n + (float)i / (float)n) * 2.0f - 1.0f;
                callback2d.onNewSample(f, f2);
            }
        }
    }

    public void generateCentered(int n, float f, Callback2d callback2d) {
        float f2 = f * 0.5f;
        float f3 = 1.0f - f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                float f4 = ((f2 + this.rnd.nextFloat() * f3) / (float)n + (float)j / (float)n) * 2.0f - 1.0f;
                float f5 = ((f2 + this.rnd.nextFloat() * f3) / (float)n + (float)i / (float)n) * 2.0f - 1.0f;
                callback2d.onNewSample(f4, f5);
            }
        }
    }
}

