/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.util.ArrayList;
import org.joml.Random;
import org.joml.Vector2f;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Math;

public class PoissonSampling {

    public static class Disk {
        private final Vector2f[] grid;
        private final float diskRadius;
        private final float diskRadiusSquared;
        private final float minDist;
        private final float minDistSquared;
        private final float cellSize;
        private final int numCells;
        private final Random rnd;
        private final ArrayList processList;

        public Disk(long l, float f, float f2, int n, Callback2d callback2d) {
            this.diskRadius = f;
            this.diskRadiusSquared = f * f;
            this.minDist = f2;
            this.minDistSquared = f2 * f2;
            this.rnd = new Random(l);
            this.cellSize = f2 / (float)Math.sqrt(2.0);
            this.numCells = (int)(f * 2.0f / this.cellSize) + 1;
            this.grid = new Vector2f[this.numCells * this.numCells];
            this.processList = new ArrayList();
            this.compute(n, callback2d);
        }

        private void compute(int n, Callback2d callback2d) {
            float f;
            float f2;
            while ((f2 = this.rnd.nextFloat() * 2.0f - 1.0f) * f2 + (f = this.rnd.nextFloat() * 2.0f - 1.0f) * f > 1.0f) {
            }
            Vector2f vector2f = new Vector2f(f2, f);
            this.processList.add(vector2f);
            callback2d.onNewSample(vector2f.x, vector2f.y);
            this.insert(vector2f);
            while (!this.processList.isEmpty()) {
                int n2 = this.rnd.nextInt(this.processList.size());
                Vector2f vector2f2 = (Vector2f)this.processList.get(n2);
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    float f3 = this.rnd.nextFloat() * ((float)java.lang.Math.PI * 2);
                    float f4 = this.minDist * (this.rnd.nextFloat() + 1.0f);
                    f2 = (float)((double)f4 * Math.sin_roquen_9((double)f3 + 1.5707963267948966));
                    f = (float)((double)f4 * Math.sin_roquen_9(f3));
                    if ((f2 += vector2f2.x) * f2 + (f += vector2f2.y) * f > this.diskRadiusSquared || this.searchNeighbors(f2, f)) continue;
                    bl = true;
                    callback2d.onNewSample(f2, f);
                    Vector2f vector2f3 = new Vector2f(f2, f);
                    this.processList.add(vector2f3);
                    this.insert(vector2f3);
                    break;
                }
                if (bl) continue;
                this.processList.remove(n2);
            }
        }

        private boolean searchNeighbors(float f, float f2) {
            int n = (int)((f2 + this.diskRadius) / this.cellSize);
            int n2 = (int)((f + this.diskRadius) / this.cellSize);
            if (this.grid[n * this.numCells + n2] != null) {
                return true;
            }
            int n3 = Math.max(0, n2 - 1);
            int n4 = Math.max(0, n - 1);
            int n5 = Math.min(n2 + 1, this.numCells - 1);
            int n6 = Math.min(n + 1, this.numCells - 1);
            for (int i = n4; i <= n6; ++i) {
                for (int j = n3; j <= n5; ++j) {
                    float f3;
                    float f4;
                    Vector2f vector2f = this.grid[i * this.numCells + j];
                    if (vector2f == null || !((f4 = vector2f.x - f) * f4 + (f3 = vector2f.y - f2) * f3 < this.minDistSquared)) continue;
                    return true;
                }
            }
            return false;
        }

        private void insert(Vector2f vector2f) {
            int n = (int)((vector2f.y + this.diskRadius) / this.cellSize);
            int n2 = (int)((vector2f.x + this.diskRadius) / this.cellSize);
            this.grid[n * this.numCells + n2] = vector2f;
        }
    }
}

