/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.nio.FloatBuffer;
import org.joml.Math;

public class Convolution {
    public static void gaussianKernel(int n, int n2, float f, FloatBuffer floatBuffer) {
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("rows must be an odd number");
        }
        if ((n2 & 1) == 0) {
            throw new IllegalArgumentException("cols must be an odd number");
        }
        if (floatBuffer == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        if (floatBuffer.remaining() < n * n2) {
            throw new IllegalArgumentException("dest must have at least " + n * n2 + " remaining values");
        }
        float f2 = 0.0f;
        int n3 = floatBuffer.position();
        int n4 = 0;
        for (int i = -(n - 1) / 2; i <= (n - 1) / 2; ++i) {
            int n5 = -(n2 - 1) / 2;
            while (n5 <= (n2 - 1) / 2) {
                float f3 = (float)Math.exp((double)(-(i * i + n5 * n5)) / (2.0 * (double)f * (double)f));
                floatBuffer.put(n3 + n4, f3);
                f2 += f3;
                ++n5;
                ++n4;
            }
        }
        for (n4 = 0; n4 < n * n2; ++n4) {
            floatBuffer.put(n3 + n4, floatBuffer.get(n3 + n4) / f2);
        }
    }

    public static void gaussianKernel(int n, int n2, float f, float[] fArray) {
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("rows must be an odd number");
        }
        if ((n2 & 1) == 0) {
            throw new IllegalArgumentException("cols must be an odd number");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        if (fArray.length < n * n2) {
            throw new IllegalArgumentException("dest must have a size of at least " + n * n2);
        }
        float f2 = 0.0f;
        int n3 = 0;
        for (int i = -(n - 1) / 2; i <= (n - 1) / 2; ++i) {
            int n4 = -(n2 - 1) / 2;
            while (n4 <= (n2 - 1) / 2) {
                float f3;
                fArray[n3] = f3 = (float)Math.exp((double)(-(i * i + n4 * n4)) / (2.0 * (double)f * (double)f));
                f2 += f3;
                ++n4;
                ++n3;
            }
        }
        for (n3 = 0; n3 < n * n2; ++n3) {
            fArray[n3] = fArray[n3] / f2;
        }
    }
}

