/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.joml.Random;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Callback3d;
import org.joml.sampling.Math;

public class BestCandidateSampling {

    public static class Cube {
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Cube seed(long l) {
            this.seed = l;
            return this;
        }

        public Cube numSamples(int n) {
            this.numSamples = n;
            return this;
        }

        public Cube numCandidates(int n) {
            this.numCandidates = n;
            return this;
        }

        public Cube generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback3d(){

                @Override
                public void onNewSample(float f, float f2, float f3) {
                    fArray[3 * intHolder.value + 0] = f;
                    fArray[3 * intHolder.value + 1] = f2;
                    fArray[3 * intHolder.value + 2] = f3;
                    ++intHolder.value;
                }
            });
        }

        public Cube generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n = floatBuffer.position();
            return this.generate(new Callback3d(){

                @Override
                public void onNewSample(float f, float f2, float f3) {
                    floatBuffer.put(n + 3 * intHolder.value + 0, f);
                    floatBuffer.put(n + 3 * intHolder.value + 1, f2);
                    floatBuffer.put(n + 3 * intHolder.value + 2, f3);
                    ++intHolder.value;
                }
            });
        }

        public Cube generate(Callback3d callback3d) {
            Octree octree = new Octree(-1.0f, -1.0f, -1.0f, 2.0f);
            Random random = new Random(this.seed);
            for (int i = 0; i < this.numSamples; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int j = 0; j < this.numCandidates; ++j) {
                    float f5;
                    float f6;
                    float f7 = random.nextFloat() * 2.0f - 1.0f;
                    float f8 = octree.nearest(f7, f6 = random.nextFloat() * 2.0f - 1.0f, f5 = random.nextFloat() * 2.0f - 1.0f, f4, Float.POSITIVE_INFINITY);
                    if (!(f8 > f4)) continue;
                    f4 = f8;
                    f = f7;
                    f2 = f6;
                    f3 = f5;
                }
                callback3d.onNewSample(f, f2, f3);
                octree.insert(new Vector3f(f, f2, f3));
            }
            return this;
        }
    }

    private static class Octree {
        private static final int MAX_OBJECTS_PER_NODE = 32;
        private static final int PXNYNZ = 0;
        private static final int NXNYNZ = 1;
        private static final int NXPYNZ = 2;
        private static final int PXPYNZ = 3;
        private static final int PXNYPZ = 4;
        private static final int NXNYPZ = 5;
        private static final int NXPYPZ = 6;
        private static final int PXPYPZ = 7;
        private float minX;
        private float minY;
        private float minZ;
        private float hs;
        private ArrayList objects;
        private Octree[] children;

        Octree(float f, float f2, float f3, float f4) {
            this.minX = f;
            this.minY = f2;
            this.minZ = f3;
            this.hs = f4 * 0.5f;
        }

        private void split() {
            this.children = new Octree[8];
            this.children[1] = new Octree(this.minX, this.minY, this.minZ, this.hs);
            this.children[0] = new Octree(this.minX + this.hs, this.minY, this.minZ, this.hs);
            this.children[2] = new Octree(this.minX, this.minY + this.hs, this.minZ, this.hs);
            this.children[3] = new Octree(this.minX + this.hs, this.minY + this.hs, this.minZ, this.hs);
            this.children[5] = new Octree(this.minX, this.minY, this.minZ + this.hs, this.hs);
            this.children[4] = new Octree(this.minX + this.hs, this.minY, this.minZ + this.hs, this.hs);
            this.children[6] = new Octree(this.minX, this.minY + this.hs, this.minZ + this.hs, this.hs);
            this.children[7] = new Octree(this.minX + this.hs, this.minY + this.hs, this.minZ + this.hs, this.hs);
        }

        private void insertIntoChild(Vector3f vector3f) {
            this.children[this.octant(vector3f.x, vector3f.y, vector3f.z)].insert(vector3f);
        }

        void insert(Vector3f vector3f) {
            if (this.children != null) {
                this.insertIntoChild(vector3f);
                return;
            }
            if (this.objects != null && this.objects.size() == 32) {
                this.split();
                for (int i = 0; i < this.objects.size(); ++i) {
                    this.insertIntoChild((Vector3f)this.objects.get(i));
                }
                this.objects = null;
                this.insertIntoChild(vector3f);
            } else {
                if (this.objects == null) {
                    this.objects = new ArrayList(32);
                }
                this.objects.add(vector3f);
            }
        }

        private int octant(float f, float f2, float f3) {
            if (f < this.minX + this.hs) {
                if (f2 < this.minY + this.hs) {
                    if (f3 < this.minZ + this.hs) {
                        return 1;
                    }
                    return 5;
                }
                if (f3 < this.minZ + this.hs) {
                    return 2;
                }
                return 6;
            }
            if (f2 < this.minY + this.hs) {
                if (f3 < this.minZ + this.hs) {
                    return 0;
                }
                return 4;
            }
            if (f3 < this.minZ + this.hs) {
                return 3;
            }
            return 7;
        }

        float nearest(float f, float f2, float f3, float f4, float f5) {
            float f6 = f5;
            if (f < this.minX - f5 || f > this.minX + this.hs * 2.0f + f5 || f2 < this.minY - f5 || f2 > this.minY + this.hs * 2.0f + f5 || f3 < this.minZ - f5 || f3 > this.minZ + this.hs * 2.0f + f5) {
                return f6;
            }
            if (this.children != null) {
                int n = this.octant(f, f2, f3);
                for (int i = 0; i < 8; ++i) {
                    float f7 = this.children[n].nearest(f, f2, f3, f4, f6);
                    if ((f6 = Math.min(f7, f6)) <= f4) {
                        return f4;
                    }
                    n = n + 1 & 7;
                }
                return f6;
            }
            float f8 = f6 * f6;
            float f9 = f4 * f4;
            for (int i = 0; this.objects != null && i < this.objects.size(); ++i) {
                Vector3f vector3f = (Vector3f)this.objects.get(i);
                float f10 = vector3f.distanceSquared(f, f2, f3);
                if (f10 <= f9) {
                    return f4;
                }
                if (!(f10 < f8)) continue;
                f8 = f10;
            }
            return Math.sqrt(f8);
        }
    }

    public static class Quad {
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Quad seed(long l) {
            this.seed = l;
            return this;
        }

        public Quad numSamples(int n) {
            this.numSamples = n;
            return this;
        }

        public Quad numCandidates(int n) {
            this.numCandidates = n;
            return this;
        }

        public Quad generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback2d(){

                @Override
                public void onNewSample(float f, float f2) {
                    fArray[2 * intHolder.value + 0] = f;
                    fArray[2 * intHolder.value + 1] = f2;
                    ++intHolder.value;
                }
            });
        }

        public Quad generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n = floatBuffer.position();
            return this.generate(new Callback2d(){

                @Override
                public void onNewSample(float f, float f2) {
                    floatBuffer.put(n + 3 * intHolder.value + 0, f);
                    floatBuffer.put(n + 3 * intHolder.value + 1, f2);
                    ++intHolder.value;
                }
            });
        }

        public Quad generate(Callback2d callback2d) {
            QuadTree quadTree = new QuadTree(-1.0f, -1.0f, 2.0f);
            Random random = new Random(this.seed);
            for (int i = 0; i < this.numSamples; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                for (int j = 0; j < this.numCandidates; ++j) {
                    float f4;
                    float f5 = random.nextFloat() * 2.0f - 1.0f;
                    float f6 = quadTree.nearest(f5, f4 = random.nextFloat() * 2.0f - 1.0f, f3, Float.POSITIVE_INFINITY);
                    if (!(f6 > f3)) continue;
                    f3 = f6;
                    f = f5;
                    f2 = f4;
                }
                callback2d.onNewSample(f, f2);
                quadTree.insert(new Vector2f(f, f2));
            }
            return this;
        }
    }

    public static class Disk {
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Disk seed(long l) {
            this.seed = l;
            return this;
        }

        public Disk numSamples(int n) {
            this.numSamples = n;
            return this;
        }

        public Disk numCandidates(int n) {
            this.numCandidates = n;
            return this;
        }

        public Disk generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback2d(){

                @Override
                public void onNewSample(float f, float f2) {
                    fArray[2 * intHolder.value + 0] = f;
                    fArray[2 * intHolder.value + 1] = f2;
                    ++intHolder.value;
                }
            });
        }

        public Disk generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n = floatBuffer.position();
            return this.generate(new Callback2d(){

                @Override
                public void onNewSample(float f, float f2) {
                    floatBuffer.put(n + 3 * intHolder.value + 0, f);
                    floatBuffer.put(n + 3 * intHolder.value + 1, f2);
                    ++intHolder.value;
                }
            });
        }

        public Disk generate(Callback2d callback2d) {
            QuadTree quadTree = new QuadTree(-1.0f, -1.0f, 2.0f);
            Random random = new Random(this.seed);
            for (int i = 0; i < this.numSamples; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                for (int j = 0; j < this.numCandidates; ++j) {
                    float f4;
                    float f5;
                    while ((f5 = random.nextFloat() * 2.0f - 1.0f) * f5 + (f4 = random.nextFloat() * 2.0f - 1.0f) * f4 > 1.0f) {
                    }
                    float f6 = quadTree.nearest(f5, f4, f3, Float.POSITIVE_INFINITY);
                    if (!(f6 > f3)) continue;
                    f3 = f6;
                    f = f5;
                    f2 = f4;
                }
                callback2d.onNewSample(f, f2);
                quadTree.insert(new Vector2f(f, f2));
            }
            return this;
        }
    }

    private static class QuadTree {
        private static final int MAX_OBJECTS_PER_NODE = 32;
        private static final int PXNY = 0;
        private static final int NXNY = 1;
        private static final int NXPY = 2;
        private static final int PXPY = 3;
        private float minX;
        private float minY;
        private float hs;
        private ArrayList objects;
        private QuadTree[] children;

        QuadTree(float f, float f2, float f3) {
            this.minX = f;
            this.minY = f2;
            this.hs = f3 * 0.5f;
        }

        private void split() {
            this.children = new QuadTree[4];
            this.children[1] = new QuadTree(this.minX, this.minY, this.hs);
            this.children[0] = new QuadTree(this.minX + this.hs, this.minY, this.hs);
            this.children[2] = new QuadTree(this.minX, this.minY + this.hs, this.hs);
            this.children[3] = new QuadTree(this.minX + this.hs, this.minY + this.hs, this.hs);
        }

        private void insertIntoChild(Vector2f vector2f) {
            this.children[this.quadrant(vector2f.x, vector2f.y)].insert(vector2f);
        }

        void insert(Vector2f vector2f) {
            if (this.children != null) {
                this.insertIntoChild(vector2f);
                return;
            }
            if (this.objects != null && this.objects.size() == 32) {
                this.split();
                for (int i = 0; i < this.objects.size(); ++i) {
                    this.insertIntoChild((Vector2f)this.objects.get(i));
                }
                this.objects = null;
                this.insertIntoChild(vector2f);
            } else {
                if (this.objects == null) {
                    this.objects = new ArrayList(32);
                }
                this.objects.add(vector2f);
            }
        }

        private int quadrant(float f, float f2) {
            if (f < this.minX + this.hs) {
                if (f2 < this.minY + this.hs) {
                    return 1;
                }
                return 2;
            }
            if (f2 < this.minY + this.hs) {
                return 0;
            }
            return 3;
        }

        float nearest(float f, float f2, float f3, float f4) {
            float f5 = f4;
            if (f < this.minX - f4 || f > this.minX + this.hs * 2.0f + f4 || f2 < this.minY - f4 || f2 > this.minY + this.hs * 2.0f + f4) {
                return f5;
            }
            if (this.children != null) {
                int n = this.quadrant(f, f2);
                for (int i = 0; i < 4; ++i) {
                    float f6 = this.children[n].nearest(f, f2, f3, f5);
                    if ((f5 = Math.min(f6, f5)) <= f3) {
                        return f3;
                    }
                    n = n + 1 & 3;
                }
                return f5;
            }
            float f7 = f5 * f5;
            float f8 = f3 * f3;
            for (int i = 0; this.objects != null && i < this.objects.size(); ++i) {
                Vector2f vector2f = (Vector2f)this.objects.get(i);
                float f9 = vector2f.distanceSquared(f, f2);
                if (f9 <= f8) {
                    return f3;
                }
                if (!(f9 < f7)) continue;
                f7 = f9;
            }
            return Math.sqrt(f7);
        }
    }

    public static class Sphere {
        private boolean onHemisphere;
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Sphere generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback3d(){

                @Override
                public void onNewSample(float f, float f2, float f3) {
                    fArray[3 * intHolder.value + 0] = f;
                    fArray[3 * intHolder.value + 1] = f2;
                    fArray[3 * intHolder.value + 2] = f3;
                    ++intHolder.value;
                }
            });
        }

        public Sphere generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n = floatBuffer.position();
            return this.generate(new Callback3d(){

                @Override
                public void onNewSample(float f, float f2, float f3) {
                    floatBuffer.put(n + 3 * intHolder.value + 0, f);
                    floatBuffer.put(n + 3 * intHolder.value + 1, f2);
                    floatBuffer.put(n + 3 * intHolder.value + 2, f3);
                    ++intHolder.value;
                }
            });
        }

        public Sphere seed(long l) {
            this.seed = l;
            return this;
        }

        public Sphere numSamples(int n) {
            this.numSamples = n;
            return this;
        }

        public Sphere numCandidates(int n) {
            this.numCandidates = n;
            return this;
        }

        public Sphere onHemisphere(boolean bl) {
            this.onHemisphere = bl;
            return this;
        }

        public Sphere generate(Callback3d callback3d) {
            Random random = new Random(this.seed);
            Node node = new Node();
            for (int i = 0; i < this.numSamples; ++i) {
                float f = Float.NaN;
                float f2 = Float.NaN;
                float f3 = Float.NaN;
                float f4 = 0.0f;
                for (int j = 0; j < this.numCandidates; ++j) {
                    float f5;
                    float f6;
                    float f7;
                    while ((f7 = random.nextFloat() * 2.0f - 1.0f) * f7 + (f6 = random.nextFloat() * 2.0f - 1.0f) * f6 > 1.0f) {
                    }
                    float f8 = (float)Math.sqrt(1.0 - (double)(f7 * f7) - (double)(f6 * f6));
                    float f9 = 2.0f * f7 * f8;
                    float f10 = 2.0f * f6 * f8;
                    float f11 = 1.0f - 2.0f * (f7 * f7 + f6 * f6);
                    if (this.onHemisphere) {
                        f11 = Math.abs(f11);
                    }
                    if (!((f5 = node.nearest(f9, f10, f11)) > f4)) continue;
                    f4 = f5;
                    f = f9;
                    f2 = f10;
                    f3 = f11;
                }
                callback3d.onNewSample(f, f2, f3);
                node.insert(new Vector3f(f, f2, f3));
            }
            return this;
        }

        private static final class Node {
            private static final int MAX_OBJECTS_PER_NODE = 32;
            private float v0x;
            private float v0y;
            private float v0z;
            private float v1x;
            private float v1y;
            private float v1z;
            private float v2x;
            private float v2y;
            private float v2z;
            private float cx;
            private float cy;
            private float cz;
            private float arc;
            private ArrayList objects;
            private Node[] children;

            Node() {
                this.children = new Node[8];
                float f = 1.0f;
                this.arc = (float)java.lang.Math.PI * 2;
                this.children[0] = new Node(-f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, f, 0.0f);
                this.children[1] = new Node(0.0f, 0.0f, f, f, 0.0f, 0.0f, 0.0f, f, 0.0f);
                this.children[2] = new Node(f, 0.0f, 0.0f, 0.0f, 0.0f, -f, 0.0f, f, 0.0f);
                this.children[3] = new Node(0.0f, 0.0f, -f, -f, 0.0f, 0.0f, 0.0f, f, 0.0f);
                this.children[4] = new Node(-f, 0.0f, 0.0f, 0.0f, -f, 0.0f, 0.0f, 0.0f, f);
                this.children[5] = new Node(0.0f, 0.0f, f, 0.0f, -f, 0.0f, f, 0.0f, 0.0f);
                this.children[6] = new Node(f, 0.0f, 0.0f, 0.0f, -f, 0.0f, 0.0f, 0.0f, -f);
                this.children[7] = new Node(0.0f, 0.0f, -f, 0.0f, -f, 0.0f, -f, 0.0f, 0.0f);
            }

            private Node(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
                this.v0x = f;
                this.v0y = f2;
                this.v0z = f3;
                this.v1x = f4;
                this.v1y = f5;
                this.v1z = f6;
                this.v2x = f7;
                this.v2y = f8;
                this.v2z = f9;
                this.cx = (this.v0x + this.v1x + this.v2x) / 3.0f;
                this.cy = (this.v0y + this.v1y + this.v2y) / 3.0f;
                this.cz = (this.v0z + this.v1z + this.v2z) / 3.0f;
                float f10 = Math.invsqrt(this.cx * this.cx + this.cy * this.cy + this.cz * this.cz);
                this.cx *= f10;
                this.cy *= f10;
                this.cz *= f10;
                float f11 = this.greatCircleDist(this.cx, this.cy, this.cz, this.v0x, this.v0y, this.v0z);
                float f12 = this.greatCircleDist(this.cx, this.cy, this.cz, this.v1x, this.v1y, this.v1z);
                float f13 = this.greatCircleDist(this.cx, this.cy, this.cz, this.v2x, this.v2y, this.v2z);
                float f14 = Math.max(Math.max(f11, f12), f13);
                this.arc = f14 *= 1.7f;
            }

            private void split() {
                float f = this.v1x + this.v2x;
                float f2 = this.v1y + this.v2y;
                float f3 = this.v1z + this.v2z;
                float f4 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
                f *= f4;
                f2 *= f4;
                f3 *= f4;
                float f5 = this.v0x + this.v2x;
                float f6 = this.v0y + this.v2y;
                float f7 = this.v0z + this.v2z;
                float f8 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
                f5 *= f8;
                f6 *= f8;
                f7 *= f8;
                float f9 = this.v0x + this.v1x;
                float f10 = this.v0y + this.v1y;
                float f11 = this.v0z + this.v1z;
                float f12 = Math.invsqrt(f9 * f9 + f10 * f10 + f11 * f11);
                this.children = new Node[4];
                this.children[0] = new Node(this.v0x, this.v0y, this.v0z, f9 *= f12, f10 *= f12, f11 *= f12, f5, f6, f7);
                this.children[1] = new Node(this.v1x, this.v1y, this.v1z, f, f2, f3, f9, f10, f11);
                this.children[2] = new Node(this.v2x, this.v2y, this.v2z, f5, f6, f7, f, f2, f3);
                this.children[3] = new Node(f, f2, f3, f5, f6, f7, f9, f10, f11);
            }

            private void insertIntoChild(Vector3f vector3f) {
                for (int i = 0; i < this.children.length; ++i) {
                    Node node = this.children[i];
                    if (!Node.isPointOnSphericalTriangle(vector3f.x, vector3f.y, vector3f.z, node.v0x, node.v0y, node.v0z, node.v1x, node.v1y, node.v1z, node.v2x, node.v2y, node.v2z, 1.0E-6f)) continue;
                    node.insert(vector3f);
                    return;
                }
            }

            void insert(Vector3f vector3f) {
                if (this.children != null) {
                    this.insertIntoChild(vector3f);
                    return;
                }
                if (this.objects != null && this.objects.size() == 32) {
                    this.split();
                    for (int i = 0; i < 32; ++i) {
                        this.insertIntoChild((Vector3f)this.objects.get(i));
                    }
                    this.objects = null;
                    this.insertIntoChild(vector3f);
                } else {
                    if (this.objects == null) {
                        this.objects = new ArrayList(32);
                    }
                    this.objects.add(vector3f);
                }
            }

            private static boolean isPointOnSphericalTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
                float f14 = f7 - f4;
                float f15 = f12 - f6;
                float f16 = f11 - f5;
                float f17 = f2 * f15 - f3 * f16;
                float f18 = f8 - f5;
                float f19 = f10 - f4;
                float f20 = f3 * f19 - f * f15;
                float f21 = f9 - f6;
                float f22 = f * f16 - f2 * f19;
                float f23 = f14 * f17 + f18 * f20 + f21 * f22;
                if (f23 > -f13 && f23 < f13) {
                    return false;
                }
                float f24 = -f4;
                float f25 = -f5;
                float f26 = -f6;
                float f27 = 1.0f / f23;
                float f28 = (f24 * f17 + f25 * f20 + f26 * f22) * f27;
                if (f28 < 0.0f || f28 > 1.0f) {
                    return false;
                }
                float f29 = f25 * f21 - f26 * f18;
                float f30 = f26 * f14 - f24 * f21;
                float f31 = f24 * f18 - f25 * f14;
                float f32 = (f * f29 + f2 * f30 + f3 * f31) * f27;
                if (f32 < 0.0f || f28 + f32 > 1.0f) {
                    return false;
                }
                float f33 = (f19 * f29 + f16 * f30 + f15 * f31) * f27;
                return f33 >= f13;
            }

            private int child(float f, float f2, float f3) {
                for (int i = 0; i < this.children.length; ++i) {
                    Node node = this.children[i];
                    if (!Node.isPointOnSphericalTriangle(f, f2, f3, node.v0x, node.v0y, node.v0z, node.v1x, node.v1y, node.v1z, node.v2x, node.v2y, node.v2z, 1.0E-5f)) continue;
                    return i;
                }
                return 0;
            }

            private float greatCircleDist(float f, float f2, float f3, float f4, float f5, float f6) {
                float f7 = f * f4 + f2 * f5 + f3 * f6;
                return (float)(-1.5707963267948966 * (double)f7 + 1.5707963267948966);
            }

            float nearest(float f, float f2, float f3) {
                return this.nearest(f, f2, f3, Float.POSITIVE_INFINITY);
            }

            float nearest(float f, float f2, float f3, float f4) {
                float f5 = this.greatCircleDist(f, f2, f3, this.cx, this.cy, this.cz);
                if (f5 - this.arc > f4) {
                    return f4;
                }
                float f6 = f4;
                if (this.children != null) {
                    int n = this.children.length;
                    int n2 = n - 1;
                    int n3 = this.child(f, f2, f3);
                    for (int i = 0; i < n; ++i) {
                        float f7 = this.children[n3].nearest(f, f2, f3, f6);
                        f6 = Math.min(f7, f6);
                        n3 = n3 + 1 & n2;
                    }
                    return f6;
                }
                for (int i = 0; this.objects != null && i < this.objects.size(); ++i) {
                    Vector3f vector3f = (Vector3f)this.objects.get(i);
                    float f8 = this.greatCircleDist(vector3f.x, vector3f.y, vector3f.z, f, f2, f3);
                    if (!(f8 < f6)) continue;
                    f6 = f8;
                }
                return f6;
            }
        }
    }

    private static final class IntHolder {
        int value;

        private IntHolder() {
        }
    }
}

