/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3x2dc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Vector2d
implements Externalizable,
Vector2dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Vector2d() {
    }

    public Vector2d(double d) {
        this.x = d;
        this.y = d;
    }

    public Vector2d(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2d(Vector2dc vector2dc) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
    }

    public Vector2d(Vector2fc vector2fc) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
    }

    public Vector2d(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
    }

    public Vector2d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public Vector2d(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
    }

    public Vector2d(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector2d(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector2d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Vector2d(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    public Vector2d set(double d) {
        this.x = d;
        this.y = d;
        return this;
    }

    public Vector2d set(double d, double d2) {
        this.x = d;
        this.y = d2;
        return this;
    }

    public Vector2d set(Vector2dc vector2dc) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        return this;
    }

    public Vector2d set(Vector2fc vector2fc) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        return this;
    }

    public Vector2d set(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        return this;
    }

    public Vector2d set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        return this;
    }

    public Vector2d set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        return this;
    }

    public Vector2d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector2d set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector2d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Vector2d set(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
        return this;
    }

    public Vector2d setFromAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l);
        return this;
    }

    @Override
    public double get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector2i get(int n, Vector2i vector2i) {
        vector2i.x = Math.roundUsing(this.x(), n);
        vector2i.y = Math.roundUsing(this.y(), n);
        return vector2i;
    }

    @Override
    public Vector2f get(Vector2f vector2f) {
        vector2f.x = (float)this.x();
        vector2f.y = (float)this.y();
        return vector2f;
    }

    @Override
    public Vector2d get(Vector2d vector2d) {
        vector2d.x = this.x();
        vector2d.y = this.y();
        return vector2d;
    }

    public Vector2d setComponent(int n, double d) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, doubleBuffer.position(), doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public DoubleBuffer get(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public Vector2dc getToAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l);
        return this;
    }

    public Vector2d perpendicular() {
        double d = this.y;
        this.y = this.x * -1.0;
        this.x = d;
        return this;
    }

    public Vector2d sub(Vector2dc vector2dc) {
        this.x -= vector2dc.x();
        this.y -= vector2dc.y();
        return this;
    }

    public Vector2d sub(double d, double d2) {
        this.x -= d;
        this.y -= d2;
        return this;
    }

    @Override
    public Vector2d sub(double d, double d2, Vector2d vector2d) {
        vector2d.x = this.x - d;
        vector2d.y = this.y - d2;
        return vector2d;
    }

    public Vector2d sub(Vector2fc vector2fc) {
        this.x -= (double)vector2fc.x();
        this.y -= (double)vector2fc.y();
        return this;
    }

    @Override
    public Vector2d sub(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x - vector2dc.x();
        vector2d.y = this.y - vector2dc.y();
        return vector2d;
    }

    @Override
    public Vector2d sub(Vector2fc vector2fc, Vector2d vector2d) {
        vector2d.x = this.x - (double)vector2fc.x();
        vector2d.y = this.y - (double)vector2fc.y();
        return vector2d;
    }

    public Vector2d mul(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    @Override
    public Vector2d mul(double d, Vector2d vector2d) {
        vector2d.x = this.x * d;
        vector2d.y = this.y * d;
        return vector2d;
    }

    public Vector2d mul(double d, double d2) {
        this.x *= d;
        this.y *= d2;
        return this;
    }

    @Override
    public Vector2d mul(double d, double d2, Vector2d vector2d) {
        vector2d.x = this.x * d;
        vector2d.y = this.y * d2;
        return vector2d;
    }

    public Vector2d mul(Vector2dc vector2dc) {
        this.x *= vector2dc.x();
        this.y *= vector2dc.y();
        return this;
    }

    @Override
    public Vector2d mul(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x * vector2dc.x();
        vector2d.y = this.y * vector2dc.y();
        return vector2d;
    }

    public Vector2d div(double d) {
        double d2 = 1.0 / d;
        this.x *= d2;
        this.y *= d2;
        return this;
    }

    @Override
    public Vector2d div(double d, Vector2d vector2d) {
        double d2 = 1.0 / d;
        vector2d.x = this.x * d2;
        vector2d.y = this.y * d2;
        return vector2d;
    }

    public Vector2d div(double d, double d2) {
        this.x /= d;
        this.y /= d2;
        return this;
    }

    @Override
    public Vector2d div(double d, double d2, Vector2d vector2d) {
        vector2d.x = this.x / d;
        vector2d.y = this.y / d2;
        return vector2d;
    }

    public Vector2d div(Vector2d vector2d) {
        this.x /= vector2d.x();
        this.y /= vector2d.y();
        return this;
    }

    public Vector2d div(Vector2fc vector2fc) {
        this.x /= (double)vector2fc.x();
        this.y /= (double)vector2fc.y();
        return this;
    }

    @Override
    public Vector2d div(Vector2fc vector2fc, Vector2d vector2d) {
        vector2d.x = this.x / (double)vector2fc.x();
        vector2d.y = this.y / (double)vector2fc.y();
        return vector2d;
    }

    @Override
    public Vector2d div(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x / vector2dc.x();
        vector2d.y = this.y / vector2dc.y();
        return vector2d;
    }

    public Vector2d mul(Matrix2fc matrix2fc) {
        double d = (double)matrix2fc.m00() * this.x + (double)matrix2fc.m10() * this.y;
        double d2 = (double)matrix2fc.m01() * this.x + (double)matrix2fc.m11() * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    public Vector2d mul(Matrix2dc matrix2dc) {
        double d = matrix2dc.m00() * this.x + matrix2dc.m10() * this.y;
        double d2 = matrix2dc.m01() * this.x + matrix2dc.m11() * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector2d mul(Matrix2dc matrix2dc, Vector2d vector2d) {
        double d = matrix2dc.m00() * this.x + matrix2dc.m10() * this.y;
        double d2 = matrix2dc.m01() * this.x + matrix2dc.m11() * this.y;
        vector2d.x = d;
        vector2d.y = d2;
        return vector2d;
    }

    @Override
    public Vector2d mul(Matrix2fc matrix2fc, Vector2d vector2d) {
        double d = (double)matrix2fc.m00() * this.x + (double)matrix2fc.m10() * this.y;
        double d2 = (double)matrix2fc.m01() * this.x + (double)matrix2fc.m11() * this.y;
        vector2d.x = d;
        vector2d.y = d2;
        return vector2d;
    }

    public Vector2d mulTranspose(Matrix2dc matrix2dc) {
        double d = matrix2dc.m00() * this.x + matrix2dc.m01() * this.y;
        double d2 = matrix2dc.m10() * this.x + matrix2dc.m11() * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector2d mulTranspose(Matrix2dc matrix2dc, Vector2d vector2d) {
        double d = matrix2dc.m00() * this.x + matrix2dc.m01() * this.y;
        double d2 = matrix2dc.m10() * this.x + matrix2dc.m11() * this.y;
        vector2d.x = d;
        vector2d.y = d2;
        return vector2d;
    }

    public Vector2d mulTranspose(Matrix2fc matrix2fc) {
        double d = (double)matrix2fc.m00() * this.x + (double)matrix2fc.m01() * this.y;
        double d2 = (double)matrix2fc.m10() * this.x + (double)matrix2fc.m11() * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector2d mulTranspose(Matrix2fc matrix2fc, Vector2d vector2d) {
        double d = (double)matrix2fc.m00() * this.x + (double)matrix2fc.m01() * this.y;
        double d2 = (double)matrix2fc.m10() * this.x + (double)matrix2fc.m11() * this.y;
        vector2d.x = d;
        vector2d.y = d2;
        return vector2d;
    }

    public Vector2d mulPosition(Matrix3x2dc matrix3x2dc) {
        double d = matrix3x2dc.m00() * this.x + matrix3x2dc.m10() * this.y + matrix3x2dc.m20();
        double d2 = matrix3x2dc.m01() * this.x + matrix3x2dc.m11() * this.y + matrix3x2dc.m21();
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector2d mulPosition(Matrix3x2dc matrix3x2dc, Vector2d vector2d) {
        double d = matrix3x2dc.m00() * this.x + matrix3x2dc.m10() * this.y + matrix3x2dc.m20();
        double d2 = matrix3x2dc.m01() * this.x + matrix3x2dc.m11() * this.y + matrix3x2dc.m21();
        vector2d.x = d;
        vector2d.y = d2;
        return vector2d;
    }

    public Vector2d mulDirection(Matrix3x2dc matrix3x2dc) {
        double d = matrix3x2dc.m00() * this.x + matrix3x2dc.m10() * this.y;
        double d2 = matrix3x2dc.m01() * this.x + matrix3x2dc.m11() * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector2d mulDirection(Matrix3x2dc matrix3x2dc, Vector2d vector2d) {
        double d = matrix3x2dc.m00() * this.x + matrix3x2dc.m10() * this.y;
        double d2 = matrix3x2dc.m01() * this.x + matrix3x2dc.m11() * this.y;
        vector2d.x = d;
        vector2d.y = d2;
        return vector2d;
    }

    @Override
    public double dot(Vector2dc vector2dc) {
        return this.x * vector2dc.x() + this.y * vector2dc.y();
    }

    @Override
    public double angle(Vector2dc vector2dc) {
        double d = this.x * vector2dc.x() + this.y * vector2dc.y();
        double d2 = this.x * vector2dc.y() - this.y * vector2dc.x();
        return Math.atan2(d2, d);
    }

    @Override
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public static double lengthSquared(double d, double d2) {
        return d * d + d2 * d2;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double length(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public double distance(Vector2dc vector2dc) {
        double d = this.x - vector2dc.x();
        double d2 = this.y - vector2dc.y();
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public double distanceSquared(Vector2dc vector2dc) {
        double d = this.x - vector2dc.x();
        double d2 = this.y - vector2dc.y();
        return d * d + d2 * d2;
    }

    @Override
    public double distance(Vector2fc vector2fc) {
        double d = this.x - (double)vector2fc.x();
        double d2 = this.y - (double)vector2fc.y();
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public double distanceSquared(Vector2fc vector2fc) {
        double d = this.x - (double)vector2fc.x();
        double d2 = this.y - (double)vector2fc.y();
        return d * d + d2 * d2;
    }

    @Override
    public double distance(double d, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    @Override
    public double distanceSquared(double d, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d2;
        return d3 * d3 + d4 * d4;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static double distanceSquared(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return d5 * d5 + d6 * d6;
    }

    public Vector2d normalize() {
        double d = Math.invsqrt(this.x * this.x + this.y * this.y);
        this.x *= d;
        this.y *= d;
        return this;
    }

    @Override
    public Vector2d normalize(Vector2d vector2d) {
        double d = Math.invsqrt(this.x * this.x + this.y * this.y);
        vector2d.x = this.x * d;
        vector2d.y = this.y * d;
        return vector2d;
    }

    public Vector2d normalize(double d) {
        double d2 = Math.invsqrt(this.x * this.x + this.y * this.y) * d;
        this.x *= d2;
        this.y *= d2;
        return this;
    }

    @Override
    public Vector2d normalize(double d, Vector2d vector2d) {
        double d2 = Math.invsqrt(this.x * this.x + this.y * this.y) * d;
        vector2d.x = this.x * d2;
        vector2d.y = this.y * d2;
        return vector2d;
    }

    public Vector2d add(Vector2dc vector2dc) {
        this.x += vector2dc.x();
        this.y += vector2dc.y();
        return this;
    }

    public Vector2d add(double d, double d2) {
        this.x += d;
        this.y += d2;
        return this;
    }

    @Override
    public Vector2d add(double d, double d2, Vector2d vector2d) {
        vector2d.x = this.x + d;
        vector2d.y = this.y + d2;
        return vector2d;
    }

    public Vector2d add(Vector2fc vector2fc) {
        this.x += (double)vector2fc.x();
        this.y += (double)vector2fc.y();
        return this;
    }

    @Override
    public Vector2d add(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x + vector2dc.x();
        vector2d.y = this.y + vector2dc.y();
        return vector2d;
    }

    @Override
    public Vector2d add(Vector2fc vector2fc, Vector2d vector2d) {
        vector2d.x = this.x + (double)vector2fc.x();
        vector2d.y = this.y + (double)vector2fc.y();
        return vector2d;
    }

    public Vector2d zero() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
    }

    public Vector2d negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    @Override
    public Vector2d negate(Vector2d vector2d) {
        vector2d.x = -this.x;
        vector2d.y = -this.y;
        return vector2d;
    }

    public Vector2d lerp(Vector2dc vector2dc, double d) {
        this.x += (vector2dc.x() - this.x) * d;
        this.y += (vector2dc.y() - this.y) * d;
        return this;
    }

    @Override
    public Vector2d lerp(Vector2dc vector2dc, double d, Vector2d vector2d) {
        vector2d.x = this.x + (vector2dc.x() - this.x) * d;
        vector2d.y = this.y + (vector2dc.y() - this.y) * d;
        return vector2d;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector2d vector2d = (Vector2d)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(vector2d.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(vector2d.y);
    }

    @Override
    public boolean equals(Vector2dc vector2dc, double d) {
        if (this == vector2dc) {
            return true;
        }
        if (vector2dc == null) {
            return false;
        }
        if (!(vector2dc instanceof Vector2dc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector2dc.x(), d)) {
            return false;
        }
        return Runtime.equals(this.y, vector2dc.y(), d);
    }

    @Override
    public boolean equals(double d, double d2) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(d2);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + ")";
    }

    public Vector2d fma(Vector2dc vector2dc, Vector2dc vector2dc2) {
        this.x += vector2dc.x() * vector2dc2.x();
        this.y += vector2dc.y() * vector2dc2.y();
        return this;
    }

    public Vector2d fma(double d, Vector2dc vector2dc) {
        this.x += d * vector2dc.x();
        this.y += d * vector2dc.y();
        return this;
    }

    @Override
    public Vector2d fma(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2d vector2d) {
        vector2d.x = this.x + vector2dc.x() * vector2dc2.x();
        vector2d.y = this.y + vector2dc.y() * vector2dc2.y();
        return vector2d;
    }

    @Override
    public Vector2d fma(double d, Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x + d * vector2dc.x();
        vector2d.y = this.y + d * vector2dc.y();
        return vector2d;
    }

    public Vector2d min(Vector2dc vector2dc) {
        this.x = this.x < vector2dc.x() ? this.x : vector2dc.x();
        this.y = this.y < vector2dc.y() ? this.y : vector2dc.y();
        return this;
    }

    @Override
    public Vector2d min(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x < vector2dc.x() ? this.x : vector2dc.x();
        vector2d.y = this.y < vector2dc.y() ? this.y : vector2dc.y();
        return vector2d;
    }

    public Vector2d max(Vector2dc vector2dc) {
        this.x = this.x > vector2dc.x() ? this.x : vector2dc.x();
        this.y = this.y > vector2dc.y() ? this.y : vector2dc.y();
        return this;
    }

    @Override
    public Vector2d max(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.x = this.x > vector2dc.x() ? this.x : vector2dc.x();
        vector2d.y = this.y > vector2dc.y() ? this.y : vector2dc.y();
        return vector2d;
    }

    @Override
    public int maxComponent() {
        double d;
        double d2 = Math.abs(this.x);
        if (d2 >= (d = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    @Override
    public int minComponent() {
        double d;
        double d2 = Math.abs(this.x);
        if (d2 < (d = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    public Vector2d floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        return this;
    }

    @Override
    public Vector2d floor(Vector2d vector2d) {
        vector2d.x = Math.floor(this.x);
        vector2d.y = Math.floor(this.y);
        return vector2d;
    }

    public Vector2d ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        return this;
    }

    @Override
    public Vector2d ceil(Vector2d vector2d) {
        vector2d.x = Math.ceil(this.x);
        vector2d.y = Math.ceil(this.y);
        return vector2d;
    }

    public Vector2d round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        return this;
    }

    @Override
    public Vector2d round(Vector2d vector2d) {
        vector2d.x = Math.round(this.x);
        vector2d.y = Math.round(this.y);
        return vector2d;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y);
    }

    public Vector2d absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    @Override
    public Vector2d absolute(Vector2d vector2d) {
        vector2d.x = Math.abs(this.x);
        vector2d.y = Math.abs(this.y);
        return vector2d;
    }
}

