/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Options;

public final class Runtime {
    public static final boolean HAS_floatToRawIntBits = Runtime.hasFloatToRawIntBits();
    public static final boolean HAS_doubleToRawLongBits = Runtime.hasDoubleToRawLongBits();
    public static final boolean HAS_Long_rotateLeft = Runtime.hasLongRotateLeft();
    public static final boolean HAS_Math_fma = Options.USE_MATH_FMA && Runtime.hasMathFma();

    private static boolean hasMathFma() {
        try {
            java.lang.Math.class.getDeclaredMethod("fma", Float.TYPE, Float.TYPE, Float.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private Runtime() {
    }

    private static boolean hasFloatToRawIntBits() {
        try {
            Float.class.getDeclaredMethod("floatToRawIntBits", Float.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean hasDoubleToRawLongBits() {
        try {
            Double.class.getDeclaredMethod("doubleToRawLongBits", Double.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean hasLongRotateLeft() {
        try {
            Long.class.getDeclaredMethod("rotateLeft", Long.TYPE, Integer.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static int floatToIntBits(float f) {
        if (HAS_floatToRawIntBits) {
            return Runtime.floatToIntBits1_3(f);
        }
        return Runtime.floatToIntBits1_2(f);
    }

    private static int floatToIntBits1_3(float f) {
        return Float.floatToRawIntBits(f);
    }

    private static int floatToIntBits1_2(float f) {
        return Float.floatToIntBits(f);
    }

    public static long doubleToLongBits(double d) {
        if (HAS_doubleToRawLongBits) {
            return Runtime.doubleToLongBits1_3(d);
        }
        return Runtime.doubleToLongBits1_2(d);
    }

    private static long doubleToLongBits1_3(double d) {
        return Double.doubleToRawLongBits(d);
    }

    private static long doubleToLongBits1_2(double d) {
        return Double.doubleToLongBits(d);
    }

    public static String formatNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String format(double d, NumberFormat numberFormat) {
        if (Double.isNaN(d)) {
            return Runtime.padLeft(numberFormat, " NaN");
        }
        if (Double.isInfinite(d)) {
            return Runtime.padLeft(numberFormat, d > 0.0 ? " +Inf" : " -Inf");
        }
        return numberFormat.format(d);
    }

    private static String padLeft(NumberFormat numberFormat, String string) {
        int n = numberFormat.format(0.0).length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - string.length() + 1; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.append(string).toString();
    }

    public static boolean equals(float f, float f2, float f3) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2) || Math.abs(f - f2) <= f3;
    }

    public static boolean equals(double d, double d2, double d3) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2) || Math.abs(d - d2) <= d3;
    }
}

