/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class QuaternionfInterpolator {
    private final SvdDecomposition3f svdDecomposition3f = new SvdDecomposition3f();
    private final float[] m = new float[9];
    private final Matrix3f u = new Matrix3f();
    private final Matrix3f v = new Matrix3f();

    public Quaternionf computeWeightedAverage(Quaternionfc[] quaternionfcArray, float[] fArray, int n, Quaternionf quaternionf) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        for (int i = 0; i < quaternionfcArray.length; ++i) {
            Quaternionfc quaternionfc = quaternionfcArray[i];
            float f10 = quaternionfc.x() + quaternionfc.x();
            float f11 = quaternionfc.y() + quaternionfc.y();
            float f12 = quaternionfc.z() + quaternionfc.z();
            float f13 = f10 * quaternionfc.x();
            float f14 = f11 * quaternionfc.y();
            float f15 = f12 * quaternionfc.z();
            float f16 = f10 * quaternionfc.y();
            float f17 = f10 * quaternionfc.z();
            float f18 = f10 * quaternionfc.w();
            float f19 = f11 * quaternionfc.z();
            float f20 = f11 * quaternionfc.w();
            float f21 = f12 * quaternionfc.w();
            f += fArray[i] * (1.0f - f14 - f15);
            f2 += fArray[i] * (f16 + f21);
            f3 += fArray[i] * (f17 - f20);
            f4 += fArray[i] * (f16 - f21);
            f5 += fArray[i] * (1.0f - f15 - f13);
            f6 += fArray[i] * (f19 + f18);
            f7 += fArray[i] * (f17 + f20);
            f8 += fArray[i] * (f19 - f18);
            f9 += fArray[i] * (1.0f - f14 - f13);
        }
        this.m[0] = f;
        this.m[1] = f2;
        this.m[2] = f3;
        this.m[3] = f4;
        this.m[4] = f5;
        this.m[5] = f6;
        this.m[6] = f7;
        this.m[7] = f8;
        this.m[8] = f9;
        this.svdDecomposition3f.svd(this.m, n, this.u, this.v);
        this.u.mul(this.v.transpose());
        return quaternionf.setFromNormalized(this.u).normalize();
    }

    private static class SvdDecomposition3f {
        private final float[] rv1 = new float[3];
        private final float[] w = new float[3];
        private final float[] v = new float[9];

        SvdDecomposition3f() {
        }

        private float SIGN(float f, float f2) {
            return (double)f2 >= 0.0 ? Math.abs(f) : -Math.abs(f);
        }

        void svd(float[] fArray, int n, Matrix3f matrix3f, Matrix3f matrix3f2) {
            int n2;
            float f;
            float f2;
            int n3;
            float f3;
            int n4;
            int n5 = 0;
            int n6 = 0;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            for (n4 = 0; n4 < 3; ++n4) {
                n5 = n4 + 1;
                this.rv1[n4] = f6 * f5;
                f6 = 0.0f;
                f3 = 0.0f;
                f5 = 0.0f;
                for (n3 = n4; n3 < 3; ++n3) {
                    f6 += Math.abs(fArray[n3 + 3 * n4]);
                }
                if (f6 != 0.0f) {
                    for (n3 = n4; n3 < 3; ++n3) {
                        fArray[n3 + 3 * n4] = fArray[n3 + 3 * n4] / f6;
                        f3 += fArray[n3 + 3 * n4] * fArray[n3 + 3 * n4];
                    }
                    f2 = fArray[n4 + 3 * n4];
                    f5 = -this.SIGN(Math.sqrt(f3), f2);
                    f = f2 * f5 - f3;
                    fArray[n4 + 3 * n4] = f2 - f5;
                    if (n4 != 2) {
                        for (n2 = n5; n2 < 3; ++n2) {
                            f3 = 0.0f;
                            for (n3 = n4; n3 < 3; ++n3) {
                                f3 += fArray[n3 + 3 * n4] * fArray[n3 + 3 * n2];
                            }
                            f2 = f3 / f;
                            for (n3 = n4; n3 < 3; ++n3) {
                                int n7 = n3 + 3 * n2;
                                fArray[n7] = fArray[n7] + f2 * fArray[n3 + 3 * n4];
                            }
                        }
                    }
                    for (n3 = n4; n3 < 3; ++n3) {
                        fArray[n3 + 3 * n4] = fArray[n3 + 3 * n4] * f6;
                    }
                }
                this.w[n4] = f6 * f5;
                f6 = 0.0f;
                f3 = 0.0f;
                f5 = 0.0f;
                if (n4 < 3 && n4 != 2) {
                    for (n3 = n5; n3 < 3; ++n3) {
                        f6 += Math.abs(fArray[n4 + 3 * n3]);
                    }
                    if (f6 != 0.0f) {
                        for (n3 = n5; n3 < 3; ++n3) {
                            fArray[n4 + 3 * n3] = fArray[n4 + 3 * n3] / f6;
                            f3 += fArray[n4 + 3 * n3] * fArray[n4 + 3 * n3];
                        }
                        f2 = fArray[n4 + 3 * n5];
                        f5 = -this.SIGN(Math.sqrt(f3), f2);
                        f = f2 * f5 - f3;
                        fArray[n4 + 3 * n5] = f2 - f5;
                        for (n3 = n5; n3 < 3; ++n3) {
                            this.rv1[n3] = fArray[n4 + 3 * n3] / f;
                        }
                        if (n4 != 2) {
                            for (n2 = n5; n2 < 3; ++n2) {
                                f3 = 0.0f;
                                for (n3 = n5; n3 < 3; ++n3) {
                                    f3 += fArray[n2 + 3 * n3] * fArray[n4 + 3 * n3];
                                }
                                for (n3 = n5; n3 < 3; ++n3) {
                                    int n8 = n2 + 3 * n3;
                                    fArray[n8] = fArray[n8] + f3 * this.rv1[n3];
                                }
                            }
                        }
                        for (n3 = n5; n3 < 3; ++n3) {
                            fArray[n4 + 3 * n3] = fArray[n4 + 3 * n3] * f6;
                        }
                    }
                }
                f4 = Math.max(f4, Math.abs(this.w[n4]) + Math.abs(this.rv1[n4]));
            }
            n4 = 2;
            while (n4 >= 0) {
                if (n4 < 2) {
                    if (f5 != 0.0f) {
                        for (n2 = n5; n2 < 3; ++n2) {
                            this.v[n2 + 3 * n4] = fArray[n4 + 3 * n2] / fArray[n4 + 3 * n5] / f5;
                        }
                        for (n2 = n5; n2 < 3; ++n2) {
                            f3 = 0.0f;
                            for (n3 = n5; n3 < 3; ++n3) {
                                f3 += fArray[n4 + 3 * n3] * this.v[n3 + 3 * n2];
                            }
                            for (n3 = n5; n3 < 3; ++n3) {
                                int n9 = n3 + 3 * n2;
                                this.v[n9] = this.v[n9] + f3 * this.v[n3 + 3 * n4];
                            }
                        }
                    }
                    for (n2 = n5; n2 < 3; ++n2) {
                        this.v[n2 + 3 * n4] = 0.0f;
                        this.v[n4 + 3 * n2] = 0.0f;
                    }
                }
                this.v[n4 + 3 * n4] = 1.0f;
                f5 = this.rv1[n4];
                n5 = n4--;
            }
            for (n4 = 2; n4 >= 0; --n4) {
                n5 = n4 + 1;
                f5 = this.w[n4];
                if (n4 < 2) {
                    for (n2 = n5; n2 < 3; ++n2) {
                        fArray[n4 + 3 * n2] = 0.0f;
                    }
                }
                if (f5 != 0.0f) {
                    f5 = 1.0f / f5;
                    if (n4 != 2) {
                        for (n2 = n5; n2 < 3; ++n2) {
                            f3 = 0.0f;
                            for (n3 = n5; n3 < 3; ++n3) {
                                f3 += fArray[n3 + 3 * n4] * fArray[n3 + 3 * n2];
                            }
                            f2 = f3 / fArray[n4 + 3 * n4] * f5;
                            for (n3 = n4; n3 < 3; ++n3) {
                                int n10 = n3 + 3 * n2;
                                fArray[n10] = fArray[n10] + f2 * fArray[n3 + 3 * n4];
                            }
                        }
                    }
                    for (n2 = n4; n2 < 3; ++n2) {
                        fArray[n2 + 3 * n4] = fArray[n2 + 3 * n4] * f5;
                    }
                } else {
                    for (n2 = n4; n2 < 3; ++n2) {
                        fArray[n2 + 3 * n4] = 0.0f;
                    }
                }
                int n11 = n4 + 3 * n4;
                fArray[n11] = fArray[n11] + 1.0f;
            }
            block27: for (n3 = 2; n3 >= 0; --n3) {
                for (int i = 0; i < n; ++i) {
                    float f7;
                    float f8;
                    float f9;
                    boolean bl = true;
                    for (n5 = n3; n5 >= 0; --n5) {
                        n6 = n5 - 1;
                        if (Math.abs(this.rv1[n5]) + f4 == f4) {
                            bl = false;
                            break;
                        }
                        if (Math.abs(this.w[n6]) + f4 == f4) break;
                    }
                    if (bl) {
                        f9 = 0.0f;
                        f3 = 1.0f;
                        for (n4 = n5; n4 <= n3; ++n4) {
                            f2 = f3 * this.rv1[n4];
                            if (Math.abs(f2) + f4 == f4) continue;
                            f5 = this.w[n4];
                            this.w[n4] = f = SvdDecomposition3f.PYTHAG(f2, f5);
                            f = 1.0f / f;
                            f9 = f5 * f;
                            f3 = -f2 * f;
                            for (n2 = 0; n2 < 3; ++n2) {
                                f8 = fArray[n2 + 3 * n6];
                                f7 = fArray[n2 + 3 * n4];
                                fArray[n2 + 3 * n6] = f8 * f9 + f7 * f3;
                                fArray[n2 + 3 * n4] = f7 * f9 - f8 * f3;
                            }
                        }
                    }
                    f7 = this.w[n3];
                    if (n5 == n3) {
                        if (!(f7 < 0.0f)) continue block27;
                        this.w[n3] = -f7;
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.v[n2 + 3 * n3] = -this.v[n2 + 3 * n3];
                        }
                        continue block27;
                    }
                    if (i == n - 1) {
                        throw new RuntimeException("No convergence after " + n + " iterations");
                    }
                    float f10 = this.w[n5];
                    n6 = n3 - 1;
                    f8 = this.w[n6];
                    f5 = this.rv1[n6];
                    f = this.rv1[n3];
                    f2 = ((f8 - f7) * (f8 + f7) + (f5 - f) * (f5 + f)) / (2.0f * f * f8);
                    f5 = SvdDecomposition3f.PYTHAG(f2, 1.0f);
                    f2 = ((f10 - f7) * (f10 + f7) + f * (f8 / (f2 + this.SIGN(f5, f2)) - f)) / f10;
                    f3 = 1.0f;
                    f9 = 1.0f;
                    for (n2 = n5; n2 <= n6; ++n2) {
                        int n12;
                        n4 = n2 + 1;
                        f5 = this.rv1[n4];
                        f8 = this.w[n4];
                        f = f3 * f5;
                        f5 = f9 * f5;
                        this.rv1[n2] = f7 = SvdDecomposition3f.PYTHAG(f2, f);
                        f9 = f2 / f7;
                        f3 = f / f7;
                        f2 = f10 * f9 + f5 * f3;
                        f5 = f5 * f9 - f10 * f3;
                        f = f8 * f3;
                        f8 *= f9;
                        for (n12 = 0; n12 < 3; ++n12) {
                            f10 = this.v[n12 + 3 * n2];
                            f7 = this.v[n12 + 3 * n4];
                            this.v[n12 + 3 * n2] = f10 * f9 + f7 * f3;
                            this.v[n12 + 3 * n4] = f7 * f9 - f10 * f3;
                        }
                        this.w[n2] = f7 = SvdDecomposition3f.PYTHAG(f2, f);
                        if (f7 != 0.0f) {
                            f7 = 1.0f / f7;
                            f9 = f2 * f7;
                            f3 = f * f7;
                        }
                        f2 = f9 * f5 + f3 * f8;
                        f10 = f9 * f8 - f3 * f5;
                        for (n12 = 0; n12 < 3; ++n12) {
                            f8 = fArray[n12 + 3 * n2];
                            f7 = fArray[n12 + 3 * n4];
                            fArray[n12 + 3 * n2] = f8 * f9 + f7 * f3;
                            fArray[n12 + 3 * n4] = f7 * f9 - f8 * f3;
                        }
                    }
                    this.rv1[n5] = 0.0f;
                    this.rv1[n3] = f2;
                    this.w[n3] = f10;
                }
            }
            matrix3f.set(fArray);
            matrix3f2.set(this.v);
        }

        private static float PYTHAG(float f, float f2) {
            float f3;
            float f4;
            float f5 = Math.abs(f);
            if (f5 > (f4 = Math.abs(f2))) {
                float f6 = f4 / f5;
                f3 = f5 * (float)Math.sqrt(1.0 + (double)(f6 * f6));
            } else if (f4 > 0.0f) {
                float f7 = f5 / f4;
                f3 = f4 * (float)Math.sqrt(1.0 + (double)(f7 * f7));
            } else {
                f3 = 0.0f;
            }
            return f3;
        }
    }
}

