/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Quaternionf
implements Externalizable,
Quaternionfc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternionf() {
        this.w = 1.0f;
    }

    public Quaternionf(double d, double d2, double d3, double d4) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
        this.w = (float)d4;
    }

    public Quaternionf(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Quaternionf(Quaternionfc quaternionfc) {
        this.set(quaternionfc);
    }

    public Quaternionf(Quaterniondc quaterniondc) {
        this.set(quaterniondc);
    }

    public Quaternionf(AxisAngle4f axisAngle4f) {
        float f = Math.sin(axisAngle4f.angle * 0.5f);
        float f2 = Math.cosFromSin(f, axisAngle4f.angle * 0.5f);
        this.x = axisAngle4f.x * f;
        this.y = axisAngle4f.y * f;
        this.z = axisAngle4f.z * f;
        this.w = f2;
    }

    public Quaternionf(AxisAngle4d axisAngle4d) {
        double d = Math.sin(axisAngle4d.angle * 0.5);
        double d2 = Math.cosFromSin(d, axisAngle4d.angle * 0.5);
        this.x = (float)(axisAngle4d.x * d);
        this.y = (float)(axisAngle4d.y * d);
        this.z = (float)(axisAngle4d.z * d);
        this.w = (float)d2;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public float w() {
        return this.w;
    }

    public Quaternionf normalize() {
        return this.normalize(this);
    }

    @Override
    public Quaternionf normalize(Quaternionf quaternionf) {
        float f = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
        quaternionf.x = this.x * f;
        quaternionf.y = this.y * f;
        quaternionf.z = this.z * f;
        quaternionf.w = this.w * f;
        return quaternionf;
    }

    public Quaternionf add(float f, float f2, float f3, float f4) {
        return this.add(f, f2, f3, f4, this);
    }

    @Override
    public Quaternionf add(float f, float f2, float f3, float f4, Quaternionf quaternionf) {
        quaternionf.x = this.x + f;
        quaternionf.y = this.y + f2;
        quaternionf.z = this.z + f3;
        quaternionf.w = this.w + f4;
        return quaternionf;
    }

    public Quaternionf add(Quaternionfc quaternionfc) {
        return this.add(quaternionfc, this);
    }

    @Override
    public Quaternionf add(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        quaternionf.x = this.x + quaternionfc.x();
        quaternionf.y = this.y + quaternionfc.y();
        quaternionf.z = this.z + quaternionfc.z();
        quaternionf.w = this.w + quaternionfc.w();
        return quaternionf;
    }

    public float dot(Quaternionf quaternionf) {
        return this.x * quaternionf.x + this.y * quaternionf.y + this.z * quaternionf.z + this.w * quaternionf.w;
    }

    @Override
    public float angle() {
        return (float)(2.0 * (double)Math.safeAcos(this.w));
    }

    @Override
    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    @Override
    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    @Override
    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    @Override
    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    @Override
    public Matrix4x3f get(Matrix4x3f matrix4x3f) {
        return matrix4x3f.set(this);
    }

    @Override
    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    @Override
    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        float f;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        if (f5 > 1.0f) {
            f = Math.invsqrt(Math.fma(f2, f2, Math.fma(f3, f3, Math.fma(f4, f4, f5 * f5))));
            f2 *= f;
            f3 *= f;
            f4 *= f;
            f5 *= f;
        }
        axisAngle4f.angle = 2.0f * Math.acos(f5);
        f = Math.sqrt(1.0f - f5 * f5);
        if (f < 0.001f) {
            axisAngle4f.x = f2;
            axisAngle4f.y = f3;
            axisAngle4f.z = f4;
        } else {
            f = 1.0f / f;
            axisAngle4f.x = f2 * f;
            axisAngle4f.y = f3 * f;
            axisAngle4f.z = f4 * f;
        }
        return axisAngle4f;
    }

    @Override
    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        float f;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        if (f5 > 1.0f) {
            f = Math.invsqrt(Math.fma(f2, f2, Math.fma(f3, f3, Math.fma(f4, f4, f5 * f5))));
            f2 *= f;
            f3 *= f;
            f4 *= f;
            f5 *= f;
        }
        axisAngle4d.angle = 2.0f * Math.acos(f5);
        f = Math.sqrt(1.0f - f5 * f5);
        if (f < 0.001f) {
            axisAngle4d.x = f2;
            axisAngle4d.y = f3;
            axisAngle4d.z = f4;
        } else {
            f = 1.0f / f;
            axisAngle4d.x = f2 * f;
            axisAngle4d.y = f3 * f;
            axisAngle4d.z = f4 * f;
        }
        return axisAngle4d;
    }

    @Override
    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    @Override
    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    @Override
    public ByteBuffer getAsMatrix3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix3f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getAsMatrix3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix3f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer getAsMatrix4f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix4f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getAsMatrix4f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix4f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer getAsMatrix4x3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix4x3f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getAsMatrix4x3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix4x3f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public Quaternionf set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Quaternionf set(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
        return this;
    }

    public Quaternionf set(Quaterniondc quaterniondc) {
        this.x = (float)quaterniondc.x();
        this.y = (float)quaterniondc.y();
        this.z = (float)quaterniondc.z();
        this.w = (float)quaterniondc.w();
        return this;
    }

    public Quaternionf set(AxisAngle4f axisAngle4f) {
        return this.setAngleAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaternionf set(AxisAngle4d axisAngle4d) {
        return this.setAngleAxis(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Quaternionf setAngleAxis(float f, float f2, float f3, float f4) {
        float f5 = Math.sin(f * 0.5f);
        this.x = f2 * f5;
        this.y = f3 * f5;
        this.z = f4 * f5;
        this.w = Math.cosFromSin(f5, f * 0.5f);
        return this;
    }

    public Quaternionf setAngleAxis(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d * 0.5);
        this.x = (float)(d2 * d5);
        this.y = (float)(d3 * d5);
        this.z = (float)(d4 * d5);
        this.w = (float)Math.cosFromSin(d5, d * 0.5);
        return this;
    }

    public Quaternionf rotationAxis(AxisAngle4f axisAngle4f) {
        return this.rotationAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaternionf rotationAxis(float f, float f2, float f3, float f4) {
        float f5 = f / 2.0f;
        float f6 = Math.sin(f5);
        float f7 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        return this.set(f2 * f7 * f6, f3 * f7 * f6, f4 * f7 * f6, Math.cosFromSin(f6, f5));
    }

    public Quaternionf rotationAxis(float f, Vector3fc vector3fc) {
        return this.rotationAxis(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Quaternionf rotationX(float f) {
        float f2 = Math.sin(f * 0.5f);
        float f3 = Math.cosFromSin(f2, f * 0.5f);
        return this.set(f2, 0.0f, 0.0f, f3);
    }

    public Quaternionf rotationY(float f) {
        float f2 = Math.sin(f * 0.5f);
        float f3 = Math.cosFromSin(f2, f * 0.5f);
        return this.set(0.0f, f2, 0.0f, f3);
    }

    public Quaternionf rotationZ(float f) {
        float f2 = Math.sin(f * 0.5f);
        float f3 = Math.cosFromSin(f2, f * 0.5f);
        return this.set(0.0f, 0.0f, f2, f3);
    }

    private void setFromUnnormalized(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f;
        float f11 = f2;
        float f12 = f3;
        float f13 = f4;
        float f14 = f5;
        float f15 = f6;
        float f16 = f7;
        float f17 = f8;
        float f18 = f9;
        float f19 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f20 = Math.invsqrt(f4 * f4 + f5 * f5 + f6 * f6);
        float f21 = Math.invsqrt(f7 * f7 + f8 * f8 + f9 * f9);
        this.setFromNormalized(f10 *= f19, f11 *= f19, f12 *= f19, f13 *= f20, f14 *= f20, f15 *= f20, f16 *= f21, f17 *= f21, f18 *= f21);
    }

    private void setFromNormalized(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f + f5 + f9;
        if (f10 >= 0.0f) {
            float f11 = Math.sqrt(f10 + 1.0f);
            this.w = f11 * 0.5f;
            f11 = 0.5f / f11;
            this.x = (f6 - f8) * f11;
            this.y = (f7 - f3) * f11;
            this.z = (f2 - f4) * f11;
        } else if (f >= f5 && f >= f9) {
            float f12 = Math.sqrt(f - (f5 + f9) + 1.0f);
            this.x = f12 * 0.5f;
            f12 = 0.5f / f12;
            this.y = (f4 + f2) * f12;
            this.z = (f3 + f7) * f12;
            this.w = (f6 - f8) * f12;
        } else if (f5 > f9) {
            float f13 = Math.sqrt(f5 - (f9 + f) + 1.0f);
            this.y = f13 * 0.5f;
            f13 = 0.5f / f13;
            this.z = (f8 + f6) * f13;
            this.x = (f4 + f2) * f13;
            this.w = (f7 - f3) * f13;
        } else {
            float f14 = Math.sqrt(f9 - (f + f5) + 1.0f);
            this.z = f14 * 0.5f;
            f14 = 0.5f / f14;
            this.x = (f3 + f7) * f14;
            this.y = (f8 + f6) * f14;
            this.w = (f2 - f4) * f14;
        }
    }

    private void setFromUnnormalized(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d;
        double d11 = d2;
        double d12 = d3;
        double d13 = d4;
        double d14 = d5;
        double d15 = d6;
        double d16 = d7;
        double d17 = d8;
        double d18 = d9;
        double d19 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d20 = Math.invsqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d21 = Math.invsqrt(d7 * d7 + d8 * d8 + d9 * d9);
        this.setFromNormalized(d10 *= d19, d11 *= d19, d12 *= d19, d13 *= d20, d14 *= d20, d15 *= d20, d16 *= d21, d17 *= d21, d18 *= d21);
    }

    private void setFromNormalized(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d + d5 + d9;
        if (d10 >= 0.0) {
            double d11 = Math.sqrt(d10 + 1.0);
            this.w = (float)(d11 * 0.5);
            d11 = 0.5 / d11;
            this.x = (float)((d6 - d8) * d11);
            this.y = (float)((d7 - d3) * d11);
            this.z = (float)((d2 - d4) * d11);
        } else if (d >= d5 && d >= d9) {
            double d12 = Math.sqrt(d - (d5 + d9) + 1.0);
            this.x = (float)(d12 * 0.5);
            d12 = 0.5 / d12;
            this.y = (float)((d4 + d2) * d12);
            this.z = (float)((d3 + d7) * d12);
            this.w = (float)((d6 - d8) * d12);
        } else if (d5 > d9) {
            double d13 = Math.sqrt(d5 - (d9 + d) + 1.0);
            this.y = (float)(d13 * 0.5);
            d13 = 0.5 / d13;
            this.z = (float)((d8 + d6) * d13);
            this.x = (float)((d4 + d2) * d13);
            this.w = (float)((d7 - d3) * d13);
        } else {
            double d14 = Math.sqrt(d9 - (d + d5) + 1.0);
            this.z = (float)(d14 * 0.5);
            d14 = 0.5 / d14;
            this.x = (float)((d3 + d7) * d14);
            this.y = (float)((d8 + d6) * d14);
            this.w = (float)((d2 - d4) * d14);
        }
    }

    public Quaternionf setFromUnnormalized(Matrix4fc matrix4fc) {
        this.setFromUnnormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromUnnormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromUnnormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4fc matrix4fc) {
        this.setFromNormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromNormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromNormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4dc matrix4dc) {
        this.setFromUnnormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4dc matrix4dc) {
        this.setFromNormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3fc matrix3fc) {
        this.setFromUnnormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3fc matrix3fc) {
        this.setFromNormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3dc matrix3dc) {
        this.setFromUnnormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3dc matrix3dc) {
        this.setFromNormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaternionf fromAxisAngleRad(Vector3fc vector3fc, float f) {
        return this.fromAxisAngleRad(vector3fc.x(), vector3fc.y(), vector3fc.z(), f);
    }

    public Quaternionf fromAxisAngleRad(float f, float f2, float f3, float f4) {
        float f5 = f4 / 2.0f;
        float f6 = Math.sin(f5);
        float f7 = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.x = f / f7 * f6;
        this.y = f2 / f7 * f6;
        this.z = f3 / f7 * f6;
        this.w = Math.cosFromSin(f6, f5);
        return this;
    }

    public Quaternionf fromAxisAngleDeg(Vector3fc vector3fc, float f) {
        return this.fromAxisAngleRad(vector3fc.x(), vector3fc.y(), vector3fc.z(), Math.toRadians(f));
    }

    public Quaternionf fromAxisAngleDeg(float f, float f2, float f3, float f4) {
        return this.fromAxisAngleRad(f, f2, f3, Math.toRadians(f4));
    }

    public Quaternionf mul(Quaternionfc quaternionfc) {
        return this.mul(quaternionfc, this);
    }

    @Override
    public Quaternionf mul(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(this.w, quaternionfc.x(), Math.fma(this.x, quaternionfc.w(), Math.fma(this.y, quaternionfc.z(), -this.z * quaternionfc.y()))), Math.fma(this.w, quaternionfc.y(), Math.fma(-this.x, quaternionfc.z(), Math.fma(this.y, quaternionfc.w(), this.z * quaternionfc.x()))), Math.fma(this.w, quaternionfc.z(), Math.fma(this.x, quaternionfc.y(), Math.fma(-this.y, quaternionfc.x(), this.z * quaternionfc.w()))), Math.fma(this.w, quaternionfc.w(), Math.fma(-this.x, quaternionfc.x(), Math.fma(-this.y, quaternionfc.y(), -this.z * quaternionfc.z()))));
    }

    public Quaternionf mul(float f, float f2, float f3, float f4) {
        return this.mul(f, f2, f3, f4, this);
    }

    @Override
    public Quaternionf mul(float f, float f2, float f3, float f4, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(this.w, f, Math.fma(this.x, f4, Math.fma(this.y, f3, -this.z * f2))), Math.fma(this.w, f2, Math.fma(-this.x, f3, Math.fma(this.y, f4, this.z * f))), Math.fma(this.w, f3, Math.fma(this.x, f2, Math.fma(-this.y, f, this.z * f4))), Math.fma(this.w, f4, Math.fma(-this.x, f, Math.fma(-this.y, f2, -this.z * f3))));
    }

    public Quaternionf premul(Quaternionfc quaternionfc) {
        return this.premul(quaternionfc, this);
    }

    @Override
    public Quaternionf premul(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(quaternionfc.w(), this.x, Math.fma(quaternionfc.x(), this.w, Math.fma(quaternionfc.y(), this.z, -quaternionfc.z() * this.y))), Math.fma(quaternionfc.w(), this.y, Math.fma(-quaternionfc.x(), this.z, Math.fma(quaternionfc.y(), this.w, quaternionfc.z() * this.x))), Math.fma(quaternionfc.w(), this.z, Math.fma(quaternionfc.x(), this.y, Math.fma(-quaternionfc.y(), this.x, quaternionfc.z() * this.w))), Math.fma(quaternionfc.w(), this.w, Math.fma(-quaternionfc.x(), this.x, Math.fma(-quaternionfc.y(), this.y, -quaternionfc.z() * this.z))));
    }

    public Quaternionf premul(float f, float f2, float f3, float f4) {
        return this.premul(f, f2, f3, f4, this);
    }

    @Override
    public Quaternionf premul(float f, float f2, float f3, float f4, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(f4, this.x, Math.fma(f, this.w, Math.fma(f2, this.z, -f3 * this.y))), Math.fma(f4, this.y, Math.fma(-f, this.z, Math.fma(f2, this.w, f3 * this.x))), Math.fma(f4, this.z, Math.fma(f, this.y, Math.fma(-f2, this.x, f3 * this.w))), Math.fma(f4, this.w, Math.fma(-f, this.x, Math.fma(-f2, this.y, -f3 * this.z))));
    }

    @Override
    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformInverse(Vector3f vector3f) {
        return this.transformInverse(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformPositiveX(Vector3f vector3f) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.w;
        vector3f.x = f + f2 - f4 - f3;
        vector3f.y = f6 + f5 + f5 + f6;
        vector3f.z = f7 - f8 + f7 - f8;
        return vector3f;
    }

    @Override
    public Vector4f transformPositiveX(Vector4f vector4f) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.w;
        vector4f.x = f + f2 - f4 - f3;
        vector4f.y = f6 + f5 + f5 + f6;
        vector4f.z = f7 - f8 + f7 - f8;
        return vector4f;
    }

    @Override
    public Vector3f transformUnitPositiveX(Vector3f vector3f) {
        float f = this.x * this.y;
        float f2 = this.x * this.z;
        float f3 = this.y * this.y;
        float f4 = this.y * this.w;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        vector3f.x = 1.0f - f3 - f5 - f3 - f5;
        vector3f.y = f + f6 + f + f6;
        vector3f.z = f2 - f4 + f2 - f4;
        return vector3f;
    }

    @Override
    public Vector4f transformUnitPositiveX(Vector4f vector4f) {
        float f = this.y * this.y;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.w;
        float f6 = this.z * this.w;
        vector4f.x = 1.0f - f - f - f2 - f2;
        vector4f.y = f3 + f6 + f3 + f6;
        vector4f.z = f4 - f5 + f4 - f5;
        return vector4f;
    }

    @Override
    public Vector3f transformPositiveY(Vector3f vector3f) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector3f.x = -f5 + f6 - f5 + f6;
        vector3f.y = f3 - f4 + f - f2;
        vector3f.z = f7 + f7 + f8 + f8;
        return vector3f;
    }

    @Override
    public Vector4f transformPositiveY(Vector4f vector4f) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector4f.x = -f5 + f6 - f5 + f6;
        vector4f.y = f3 - f4 + f - f2;
        vector4f.z = f7 + f7 + f8 + f8;
        return vector4f;
    }

    @Override
    public Vector4f transformUnitPositiveY(Vector4f vector4f) {
        float f = this.x * this.x;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.z * this.w;
        vector4f.x = f3 - f6 + f3 - f6;
        vector4f.y = 1.0f - f - f - f2 - f2;
        vector4f.z = f4 + f4 + f5 + f5;
        return vector4f;
    }

    @Override
    public Vector3f transformUnitPositiveY(Vector3f vector3f) {
        float f = this.x * this.x;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.z * this.w;
        vector3f.x = f3 - f6 + f3 - f6;
        vector3f.y = 1.0f - f - f - f2 - f2;
        vector3f.z = f4 + f4 + f5 + f5;
        return vector3f;
    }

    @Override
    public Vector3f transformPositiveZ(Vector3f vector3f) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector3f.x = f6 + f5 + f5 + f6;
        vector3f.y = f7 + f7 - f8 - f8;
        vector3f.z = f4 - f3 - f2 + f;
        return vector3f;
    }

    @Override
    public Vector4f transformPositiveZ(Vector4f vector4f) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector4f.x = f6 + f5 + f5 + f6;
        vector4f.y = f7 + f7 - f8 - f8;
        vector4f.z = f4 - f3 - f2 + f;
        return vector4f;
    }

    @Override
    public Vector4f transformUnitPositiveZ(Vector4f vector4f) {
        float f = this.x * this.x;
        float f2 = this.y * this.y;
        float f3 = this.x * this.z;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.w;
        vector4f.x = f3 + f6 + f3 + f6;
        vector4f.y = f4 + f4 - f5 - f5;
        vector4f.z = 1.0f - f - f - f2 - f2;
        return vector4f;
    }

    @Override
    public Vector3f transformUnitPositiveZ(Vector3f vector3f) {
        float f = this.x * this.x;
        float f2 = this.y * this.y;
        float f3 = this.x * this.z;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.w;
        vector3f.x = f3 + f6 + f3 + f6;
        vector3f.y = f4 + f4 - f5 - f5;
        vector3f.z = 1.0f - f - f - f2 - f2;
        return vector3f;
    }

    @Override
    public Vector4f transform(Vector4f vector4f) {
        return this.transform(vector4f, vector4f);
    }

    @Override
    public Vector4f transformInverse(Vector4f vector4f) {
        return this.transformInverse(vector4f, vector4f);
    }

    @Override
    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transform(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transformInverse(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverse(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transform(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = this.x * this.x;
        float f5 = this.y * this.y;
        float f6 = this.z * this.z;
        float f7 = this.w * this.w;
        float f8 = this.x * this.y;
        float f9 = this.x * this.z;
        float f10 = this.y * this.z;
        float f11 = this.x * this.w;
        float f12 = this.z * this.w;
        float f13 = this.y * this.w;
        float f14 = 1.0f / (f4 + f5 + f6 + f7);
        return vector3f.set(Math.fma((f4 - f5 - f6 + f7) * f14, f, Math.fma(2.0f * (f8 - f12) * f14, f2, 2.0f * (f9 + f13) * f14 * f3)), Math.fma(2.0f * (f8 + f12) * f14, f, Math.fma((f5 - f4 - f6 + f7) * f14, f2, 2.0f * (f10 - f11) * f14 * f3)), Math.fma(2.0f * (f9 - f13) * f14, f, Math.fma(2.0f * (f10 + f11) * f14, f2, (f6 - f4 - f5 + f7) * f14 * f3)));
    }

    @Override
    public Vector3f transformInverse(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f5 = this.x * f4;
        float f6 = this.y * f4;
        float f7 = this.z * f4;
        float f8 = this.w * f4;
        float f9 = f5 * f5;
        float f10 = f6 * f6;
        float f11 = f7 * f7;
        float f12 = f8 * f8;
        float f13 = f5 * f6;
        float f14 = f5 * f7;
        float f15 = f6 * f7;
        float f16 = f5 * f8;
        float f17 = f7 * f8;
        float f18 = f6 * f8;
        float f19 = 1.0f / (f9 + f10 + f11 + f12);
        return vector3f.set(Math.fma((f9 - f10 - f11 + f12) * f19, f, Math.fma(2.0f * (f13 + f17) * f19, f2, 2.0f * (f14 - f18) * f19 * f3)), Math.fma(2.0f * (f13 - f17) * f19, f, Math.fma((f10 - f9 - f11 + f12) * f19, f2, 2.0f * (f15 + f16) * f19 * f3)), Math.fma(2.0f * (f14 + f18) * f19, f, Math.fma(2.0f * (f15 - f16) * f19, f2, (f11 - f9 - f10 + f12) * f19 * f3)));
    }

    @Override
    public Vector3f transformUnit(Vector3f vector3f) {
        return this.transformUnit(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformInverseUnit(Vector3f vector3f) {
        return this.transformInverseUnit(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformUnit(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transformInverseUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverseUnit(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transformUnit(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = this.x * this.x;
        float f5 = this.x * this.y;
        float f6 = this.x * this.z;
        float f7 = this.x * this.w;
        float f8 = this.y * this.y;
        float f9 = this.y * this.z;
        float f10 = this.y * this.w;
        float f11 = this.z * this.z;
        float f12 = this.z * this.w;
        return vector3f.set(Math.fma(Math.fma(-2.0f, f8 + f11, 1.0f), f, Math.fma(2.0f * (f5 - f12), f2, 2.0f * (f6 + f10) * f3)), Math.fma(2.0f * (f5 + f12), f, Math.fma(Math.fma(-2.0f, f4 + f11, 1.0f), f2, 2.0f * (f9 - f7) * f3)), Math.fma(2.0f * (f6 - f10), f, Math.fma(2.0f * (f9 + f7), f2, Math.fma(-2.0f, f4 + f8, 1.0f) * f3)));
    }

    @Override
    public Vector3f transformInverseUnit(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = this.x * this.x;
        float f5 = this.x * this.y;
        float f6 = this.x * this.z;
        float f7 = this.x * this.w;
        float f8 = this.y * this.y;
        float f9 = this.y * this.z;
        float f10 = this.y * this.w;
        float f11 = this.z * this.z;
        float f12 = this.z * this.w;
        return vector3f.set(Math.fma(Math.fma(-2.0f, f8 + f11, 1.0f), f, Math.fma(2.0f * (f5 + f12), f2, 2.0f * (f6 - f10) * f3)), Math.fma(2.0f * (f5 - f12), f, Math.fma(Math.fma(-2.0f, f4 + f11, 1.0f), f2, 2.0f * (f9 + f7) * f3)), Math.fma(2.0f * (f6 + f10), f, Math.fma(2.0f * (f9 - f7), f2, Math.fma(-2.0f, f4 + f8, 1.0f) * f3)));
    }

    @Override
    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transform(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transformInverse(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverse(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transform(float f, float f2, float f3, Vector4f vector4f) {
        float f4 = this.x * this.x;
        float f5 = this.y * this.y;
        float f6 = this.z * this.z;
        float f7 = this.w * this.w;
        float f8 = this.x * this.y;
        float f9 = this.x * this.z;
        float f10 = this.y * this.z;
        float f11 = this.x * this.w;
        float f12 = this.z * this.w;
        float f13 = this.y * this.w;
        float f14 = 1.0f / (f4 + f5 + f6 + f7);
        return vector4f.set(Math.fma((f4 - f5 - f6 + f7) * f14, f, Math.fma(2.0f * (f8 - f12) * f14, f2, 2.0f * (f9 + f13) * f14 * f3)), Math.fma(2.0f * (f8 + f12) * f14, f, Math.fma((f5 - f4 - f6 + f7) * f14, f2, 2.0f * (f10 - f11) * f14 * f3)), Math.fma(2.0f * (f9 - f13) * f14, f, Math.fma(2.0f * (f10 + f11) * f14, f2, (f6 - f4 - f5 + f7) * f14 * f3)));
    }

    @Override
    public Vector4f transformInverse(float f, float f2, float f3, Vector4f vector4f) {
        float f4 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f5 = this.x * f4;
        float f6 = this.y * f4;
        float f7 = this.z * f4;
        float f8 = this.w * f4;
        float f9 = f5 * f5;
        float f10 = f6 * f6;
        float f11 = f7 * f7;
        float f12 = f8 * f8;
        float f13 = f5 * f6;
        float f14 = f5 * f7;
        float f15 = f6 * f7;
        float f16 = f5 * f8;
        float f17 = f7 * f8;
        float f18 = f6 * f8;
        float f19 = 1.0f / (f9 + f10 + f11 + f12);
        return vector4f.set(Math.fma((f9 - f10 - f11 + f12) * f19, f, Math.fma(2.0f * (f13 + f17) * f19, f2, 2.0f * (f14 - f18) * f19 * f3)), Math.fma(2.0f * (f13 - f17) * f19, f, Math.fma((f10 - f9 - f11 + f12) * f19, f2, 2.0f * (f15 + f16) * f19 * f3)), Math.fma(2.0f * (f14 + f18) * f19, f, Math.fma(2.0f * (f15 - f16) * f19, f2, (f11 - f9 - f10 + f12) * f19 * f3)));
    }

    @Override
    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    @Override
    public Vector3d transformInverse(Vector3d vector3d) {
        return this.transformInverse(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    @Override
    public Vector4f transformUnit(Vector4f vector4f) {
        return this.transformUnit(vector4f.x, vector4f.y, vector4f.z, vector4f);
    }

    @Override
    public Vector4f transformInverseUnit(Vector4f vector4f) {
        return this.transformInverseUnit(vector4f.x, vector4f.y, vector4f.z, vector4f);
    }

    @Override
    public Vector4f transformUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformUnit(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transformInverseUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverseUnit(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transformUnit(float f, float f2, float f3, Vector4f vector4f) {
        float f4 = this.x * this.x;
        float f5 = this.x * this.y;
        float f6 = this.x * this.z;
        float f7 = this.x * this.w;
        float f8 = this.y * this.y;
        float f9 = this.y * this.z;
        float f10 = this.y * this.w;
        float f11 = this.z * this.z;
        float f12 = this.z * this.w;
        return vector4f.set(Math.fma(Math.fma(-2.0f, f8 + f11, 1.0f), f, Math.fma(2.0f * (f5 - f12), f2, 2.0f * (f6 + f10) * f3)), Math.fma(2.0f * (f5 + f12), f, Math.fma(Math.fma(-2.0f, f4 + f11, 1.0f), f2, 2.0f * (f9 - f7) * f3)), Math.fma(2.0f * (f6 - f10), f, Math.fma(2.0f * (f9 + f7), f2, Math.fma(-2.0f, f4 + f8, 1.0f) * f3)));
    }

    @Override
    public Vector4f transformInverseUnit(float f, float f2, float f3, Vector4f vector4f) {
        float f4 = this.x * this.x;
        float f5 = this.x * this.y;
        float f6 = this.x * this.z;
        float f7 = this.x * this.w;
        float f8 = this.y * this.y;
        float f9 = this.y * this.z;
        float f10 = this.y * this.w;
        float f11 = this.z * this.z;
        float f12 = this.z * this.w;
        return vector4f.set(Math.fma(Math.fma(-2.0f, f8 + f11, 1.0f), f, Math.fma(2.0f * (f5 + f12), f2, 2.0f * (f6 - f10) * f3)), Math.fma(2.0f * (f5 - f12), f, Math.fma(Math.fma(-2.0f, f4 + f11, 1.0f), f2, 2.0f * (f9 + f7) * f3)), Math.fma(2.0f * (f6 + f10), f, Math.fma(2.0f * (f9 - f7), f2, Math.fma(-2.0f, f4 + f8, 1.0f) * f3)));
    }

    @Override
    public Vector3d transformPositiveX(Vector3d vector3d) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.w;
        vector3d.x = f + f2 - f4 - f3;
        vector3d.y = f6 + f5 + f5 + f6;
        vector3d.z = f7 - f8 + f7 - f8;
        return vector3d;
    }

    @Override
    public Vector4d transformPositiveX(Vector4d vector4d) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.w;
        vector4d.x = f + f2 - f4 - f3;
        vector4d.y = f6 + f5 + f5 + f6;
        vector4d.z = f7 - f8 + f7 - f8;
        return vector4d;
    }

    @Override
    public Vector3d transformUnitPositiveX(Vector3d vector3d) {
        float f = this.y * this.y;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.w;
        float f6 = this.z * this.w;
        vector3d.x = 1.0f - f - f - f2 - f2;
        vector3d.y = f3 + f6 + f3 + f6;
        vector3d.z = f4 - f5 + f4 - f5;
        return vector3d;
    }

    @Override
    public Vector4d transformUnitPositiveX(Vector4d vector4d) {
        float f = this.y * this.y;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.w;
        float f6 = this.z * this.w;
        vector4d.x = 1.0f - f - f - f2 - f2;
        vector4d.y = f3 + f6 + f3 + f6;
        vector4d.z = f4 - f5 + f4 - f5;
        return vector4d;
    }

    @Override
    public Vector3d transformPositiveY(Vector3d vector3d) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector3d.x = -f5 + f6 - f5 + f6;
        vector3d.y = f3 - f4 + f - f2;
        vector3d.z = f7 + f7 + f8 + f8;
        return vector3d;
    }

    @Override
    public Vector4d transformPositiveY(Vector4d vector4d) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.z * this.w;
        float f6 = this.x * this.y;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector4d.x = -f5 + f6 - f5 + f6;
        vector4d.y = f3 - f4 + f - f2;
        vector4d.z = f7 + f7 + f8 + f8;
        return vector4d;
    }

    @Override
    public Vector4d transformUnitPositiveY(Vector4d vector4d) {
        float f = this.x * this.x;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.z * this.w;
        vector4d.x = f3 - f6 + f3 - f6;
        vector4d.y = 1.0f - f - f - f2 - f2;
        vector4d.z = f4 + f4 + f5 + f5;
        return vector4d;
    }

    @Override
    public Vector3d transformUnitPositiveY(Vector3d vector3d) {
        float f = this.x * this.x;
        float f2 = this.z * this.z;
        float f3 = this.x * this.y;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.z * this.w;
        vector3d.x = f3 - f6 + f3 - f6;
        vector3d.y = 1.0f - f - f - f2 - f2;
        vector3d.z = f4 + f4 + f5 + f5;
        return vector3d;
    }

    @Override
    public Vector3d transformPositiveZ(Vector3d vector3d) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector3d.x = f6 + f5 + f5 + f6;
        vector3d.y = f7 + f7 - f8 - f8;
        vector3d.z = f4 - f3 - f2 + f;
        return vector3d;
    }

    @Override
    public Vector4d transformPositiveZ(Vector4d vector4d) {
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        vector4d.x = f6 + f5 + f5 + f6;
        vector4d.y = f7 + f7 - f8 - f8;
        vector4d.z = f4 - f3 - f2 + f;
        return vector4d;
    }

    @Override
    public Vector4d transformUnitPositiveZ(Vector4d vector4d) {
        float f = this.x * this.x;
        float f2 = this.y * this.y;
        float f3 = this.x * this.z;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.w;
        vector4d.x = f3 + f6 + f3 + f6;
        vector4d.y = f4 + f4 - f5 - f5;
        vector4d.z = 1.0f - f - f - f2 - f2;
        return vector4d;
    }

    @Override
    public Vector3d transformUnitPositiveZ(Vector3d vector3d) {
        float f = this.x * this.x;
        float f2 = this.y * this.y;
        float f3 = this.x * this.z;
        float f4 = this.y * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.w;
        vector3d.x = f3 + f6 + f3 + f6;
        vector3d.y = f4 + f4 - f5 - f5;
        vector3d.z = 1.0f - f - f - f2 - f2;
        return vector3d;
    }

    @Override
    public Vector4d transform(Vector4d vector4d) {
        return this.transform(vector4d, vector4d);
    }

    @Override
    public Vector4d transformInverse(Vector4d vector4d) {
        return this.transformInverse(vector4d, vector4d);
    }

    @Override
    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transform(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transformInverse(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverse(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transform(float f, float f2, float f3, Vector3d vector3d) {
        return this.transform((double)f, (double)f2, (double)f3, vector3d);
    }

    @Override
    public Vector3d transformInverse(float f, float f2, float f3, Vector3d vector3d) {
        return this.transformInverse((double)f, (double)f2, (double)f3, vector3d);
    }

    @Override
    public Vector3d transform(double d, double d2, double d3, Vector3d vector3d) {
        float f = this.x * this.x;
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.w * this.w;
        float f5 = this.x * this.y;
        float f6 = this.x * this.z;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        float f9 = this.z * this.w;
        float f10 = this.y * this.w;
        float f11 = 1.0f / (f + f2 + f3 + f4);
        return vector3d.set(Math.fma((double)((f - f2 - f3 + f4) * f11), d, Math.fma((double)(2.0f * (f5 - f9) * f11), d2, (double)(2.0f * (f6 + f10) * f11) * d3)), Math.fma((double)(2.0f * (f5 + f9) * f11), d, Math.fma((double)((f2 - f - f3 + f4) * f11), d2, (double)(2.0f * (f7 - f8) * f11) * d3)), Math.fma((double)(2.0f * (f6 - f10) * f11), d, Math.fma((double)(2.0f * (f7 + f8) * f11), d2, (double)((f3 - f - f2 + f4) * f11) * d3)));
    }

    @Override
    public Vector3d transformInverse(double d, double d2, double d3, Vector3d vector3d) {
        float f = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f2 = this.x * f;
        float f3 = this.y * f;
        float f4 = this.z * f;
        float f5 = this.w * f;
        float f6 = f2 * f2;
        float f7 = f3 * f3;
        float f8 = f4 * f4;
        float f9 = f5 * f5;
        float f10 = f2 * f3;
        float f11 = f2 * f4;
        float f12 = f3 * f4;
        float f13 = f2 * f5;
        float f14 = f4 * f5;
        float f15 = f3 * f5;
        float f16 = 1.0f / (f6 + f7 + f8 + f9);
        return vector3d.set(Math.fma((double)((f6 - f7 - f8 + f9) * f16), d, Math.fma((double)(2.0f * (f10 + f14) * f16), d2, (double)(2.0f * (f11 - f15) * f16) * d3)), Math.fma((double)(2.0f * (f10 - f14) * f16), d, Math.fma((double)((f7 - f6 - f8 + f9) * f16), d2, (double)(2.0f * (f12 + f13) * f16) * d3)), Math.fma((double)(2.0f * (f11 + f15) * f16), d, Math.fma((double)(2.0f * (f12 - f13) * f16), d2, (double)((f8 - f6 - f7 + f9) * f16) * d3)));
    }

    @Override
    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transform(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transformInverse(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverse(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transform(double d, double d2, double d3, Vector4d vector4d) {
        float f = this.x * this.x;
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.w * this.w;
        float f5 = this.x * this.y;
        float f6 = this.x * this.z;
        float f7 = this.y * this.z;
        float f8 = this.x * this.w;
        float f9 = this.z * this.w;
        float f10 = this.y * this.w;
        float f11 = 1.0f / (f + f2 + f3 + f4);
        return vector4d.set(Math.fma((double)((f - f2 - f3 + f4) * f11), d, Math.fma((double)(2.0f * (f5 - f9) * f11), d2, (double)(2.0f * (f6 + f10) * f11) * d3)), Math.fma((double)(2.0f * (f5 + f9) * f11), d, Math.fma((double)((f2 - f - f3 + f4) * f11), d2, (double)(2.0f * (f7 - f8) * f11) * d3)), Math.fma((double)(2.0f * (f6 - f10) * f11), d, Math.fma((double)(2.0f * (f7 + f8) * f11), d2, (double)((f3 - f - f2 + f4) * f11) * d3)));
    }

    @Override
    public Vector4d transformInverse(double d, double d2, double d3, Vector4d vector4d) {
        float f = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f2 = this.x * f;
        float f3 = this.y * f;
        float f4 = this.z * f;
        float f5 = this.w * f;
        float f6 = f2 * f2;
        float f7 = f3 * f3;
        float f8 = f4 * f4;
        float f9 = f5 * f5;
        float f10 = f2 * f3;
        float f11 = f2 * f4;
        float f12 = f3 * f4;
        float f13 = f2 * f5;
        float f14 = f4 * f5;
        float f15 = f3 * f5;
        float f16 = 1.0f / (f6 + f7 + f8 + f9);
        return vector4d.set(Math.fma((double)((f6 - f7 - f8 + f9) * f16), d, Math.fma((double)(2.0f * (f10 + f14) * f16), d2, (double)(2.0f * (f11 - f15) * f16) * d3)), Math.fma((double)(2.0f * (f10 - f14) * f16), d, Math.fma((double)((f7 - f6 - f8 + f9) * f16), d2, (double)(2.0f * (f12 + f13) * f16) * d3)), Math.fma((double)(2.0f * (f11 + f15) * f16), d, Math.fma((double)(2.0f * (f12 - f13) * f16), d2, (double)((f8 - f6 - f7 + f9) * f16) * d3)));
    }

    @Override
    public Vector4d transformUnit(Vector4d vector4d) {
        return this.transformUnit(vector4d, vector4d);
    }

    @Override
    public Vector4d transformInverseUnit(Vector4d vector4d) {
        return this.transformInverseUnit(vector4d, vector4d);
    }

    @Override
    public Vector3d transformUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transformInverseUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverseUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transformUnit(float f, float f2, float f3, Vector3d vector3d) {
        return this.transformUnit((double)f, (double)f2, (double)f3, vector3d);
    }

    @Override
    public Vector3d transformInverseUnit(float f, float f2, float f3, Vector3d vector3d) {
        return this.transformInverseUnit((double)f, (double)f2, (double)f3, vector3d);
    }

    @Override
    public Vector3d transformUnit(double d, double d2, double d3, Vector3d vector3d) {
        float f = this.x * this.x;
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.x * this.w;
        float f5 = this.y * this.y;
        float f6 = this.y * this.z;
        float f7 = this.y * this.w;
        float f8 = this.z * this.z;
        float f9 = this.z * this.w;
        return vector3d.set(Math.fma((double)Math.fma(-2.0f, f5 + f8, 1.0f), d, Math.fma((double)(2.0f * (f2 - f9)), d2, (double)(2.0f * (f3 + f7)) * d3)), Math.fma((double)(2.0f * (f2 + f9)), d, Math.fma((double)Math.fma(-2.0f, f + f8, 1.0f), d2, (double)(2.0f * (f6 - f4)) * d3)), Math.fma((double)(2.0f * (f3 - f7)), d, Math.fma((double)(2.0f * (f6 + f4)), d2, (double)Math.fma(-2.0f, f + f5, 1.0f) * d3)));
    }

    @Override
    public Vector3d transformInverseUnit(double d, double d2, double d3, Vector3d vector3d) {
        float f = this.x * this.x;
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.x * this.w;
        float f5 = this.y * this.y;
        float f6 = this.y * this.z;
        float f7 = this.y * this.w;
        float f8 = this.z * this.z;
        float f9 = this.z * this.w;
        return vector3d.set(Math.fma((double)Math.fma(-2.0f, f5 + f8, 1.0f), d, Math.fma((double)(2.0f * (f2 + f9)), d2, (double)(2.0f * (f3 - f7)) * d3)), Math.fma((double)(2.0f * (f2 - f9)), d, Math.fma((double)Math.fma(-2.0f, f + f8, 1.0f), d2, (double)(2.0f * (f6 + f4)) * d3)), Math.fma((double)(2.0f * (f3 + f7)), d, Math.fma((double)(2.0f * (f6 - f4)), d2, (double)Math.fma(-2.0f, f + f5, 1.0f) * d3)));
    }

    @Override
    public Vector4d transformUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transformInverseUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverseUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transformUnit(double d, double d2, double d3, Vector4d vector4d) {
        float f = this.x * this.x;
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.x * this.w;
        float f5 = this.y * this.y;
        float f6 = this.y * this.z;
        float f7 = this.y * this.w;
        float f8 = this.z * this.z;
        float f9 = this.z * this.w;
        return vector4d.set(Math.fma((double)Math.fma(-2.0f, f5 + f8, 1.0f), d, Math.fma((double)(2.0f * (f2 - f9)), d2, (double)(2.0f * (f3 + f7)) * d3)), Math.fma((double)(2.0f * (f2 + f9)), d, Math.fma((double)Math.fma(-2.0f, f + f8, 1.0f), d2, (double)(2.0f * (f6 - f4)) * d3)), Math.fma((double)(2.0f * (f3 - f7)), d, Math.fma((double)(2.0f * (f6 + f4)), d2, (double)Math.fma(-2.0f, f + f5, 1.0f) * d3)));
    }

    @Override
    public Vector4d transformInverseUnit(double d, double d2, double d3, Vector4d vector4d) {
        float f = this.x * this.x;
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.x * this.w;
        float f5 = this.y * this.y;
        float f6 = this.y * this.z;
        float f7 = this.y * this.w;
        float f8 = this.z * this.z;
        float f9 = this.z * this.w;
        return vector4d.set(Math.fma((double)Math.fma(-2.0f, f5 + f8, 1.0f), d, Math.fma((double)(2.0f * (f2 + f9)), d2, (double)(2.0f * (f3 - f7)) * d3)), Math.fma((double)(2.0f * (f2 - f9)), d, Math.fma((double)Math.fma(-2.0f, f + f8, 1.0f), d2, (double)(2.0f * (f6 + f4)) * d3)), Math.fma((double)(2.0f * (f3 + f7)), d, Math.fma((double)(2.0f * (f6 - f4)), d2, (double)Math.fma(-2.0f, f + f5, 1.0f) * d3)));
    }

    @Override
    public Quaternionf invert(Quaternionf quaternionf) {
        float f = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        quaternionf.x = -this.x * f;
        quaternionf.y = -this.y * f;
        quaternionf.z = -this.z * f;
        quaternionf.w = this.w * f;
        return quaternionf;
    }

    public Quaternionf invert() {
        return this.invert(this);
    }

    @Override
    public Quaternionf div(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f = 1.0f / Math.fma(quaternionfc.x(), quaternionfc.x(), Math.fma(quaternionfc.y(), quaternionfc.y(), Math.fma(quaternionfc.z(), quaternionfc.z(), quaternionfc.w() * quaternionfc.w())));
        float f2 = -quaternionfc.x() * f;
        float f3 = -quaternionfc.y() * f;
        float f4 = -quaternionfc.z() * f;
        float f5 = quaternionfc.w() * f;
        return quaternionf.set(Math.fma(this.w, f2, Math.fma(this.x, f5, Math.fma(this.y, f4, -this.z * f3))), Math.fma(this.w, f3, Math.fma(-this.x, f4, Math.fma(this.y, f5, this.z * f2))), Math.fma(this.w, f4, Math.fma(this.x, f3, Math.fma(-this.y, f2, this.z * f5))), Math.fma(this.w, f5, Math.fma(-this.x, f2, Math.fma(-this.y, f3, -this.z * f4))));
    }

    public Quaternionf div(Quaternionfc quaternionfc) {
        return this.div(quaternionfc, this);
    }

    public Quaternionf conjugate() {
        return this.conjugate(this);
    }

    @Override
    public Quaternionf conjugate(Quaternionf quaternionf) {
        quaternionf.x = -this.x;
        quaternionf.y = -this.y;
        quaternionf.z = -this.z;
        quaternionf.w = this.w;
        return quaternionf;
    }

    public Quaternionf identity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public Quaternionf rotateXYZ(float f, float f2, float f3) {
        return this.rotateXYZ(f, f2, f3, this);
    }

    @Override
    public Quaternionf rotateXYZ(float f, float f2, float f3, Quaternionf quaternionf) {
        float f4 = Math.sin(f * 0.5f);
        float f5 = Math.cosFromSin(f4, f * 0.5f);
        float f6 = Math.sin(f2 * 0.5f);
        float f7 = Math.cosFromSin(f6, f2 * 0.5f);
        float f8 = Math.sin(f3 * 0.5f);
        float f9 = Math.cosFromSin(f8, f3 * 0.5f);
        float f10 = f7 * f9;
        float f11 = f6 * f8;
        float f12 = f6 * f9;
        float f13 = f7 * f8;
        float f14 = f5 * f10 - f4 * f11;
        float f15 = f4 * f10 + f5 * f11;
        float f16 = f5 * f12 - f4 * f13;
        float f17 = f5 * f13 + f4 * f12;
        return quaternionf.set(Math.fma(this.w, f15, Math.fma(this.x, f14, Math.fma(this.y, f17, -this.z * f16))), Math.fma(this.w, f16, Math.fma(-this.x, f17, Math.fma(this.y, f14, this.z * f15))), Math.fma(this.w, f17, Math.fma(this.x, f16, Math.fma(-this.y, f15, this.z * f14))), Math.fma(this.w, f14, Math.fma(-this.x, f15, Math.fma(-this.y, f16, -this.z * f17))));
    }

    public Quaternionf rotateZYX(float f, float f2, float f3) {
        return this.rotateZYX(f, f2, f3, this);
    }

    @Override
    public Quaternionf rotateZYX(float f, float f2, float f3, Quaternionf quaternionf) {
        float f4 = Math.sin(f3 * 0.5f);
        float f5 = Math.cosFromSin(f4, f3 * 0.5f);
        float f6 = Math.sin(f2 * 0.5f);
        float f7 = Math.cosFromSin(f6, f2 * 0.5f);
        float f8 = Math.sin(f * 0.5f);
        float f9 = Math.cosFromSin(f8, f * 0.5f);
        float f10 = f7 * f9;
        float f11 = f6 * f8;
        float f12 = f6 * f9;
        float f13 = f7 * f8;
        float f14 = f5 * f10 + f4 * f11;
        float f15 = f4 * f10 - f5 * f11;
        float f16 = f5 * f12 + f4 * f13;
        float f17 = f5 * f13 - f4 * f12;
        return quaternionf.set(Math.fma(this.w, f15, Math.fma(this.x, f14, Math.fma(this.y, f17, -this.z * f16))), Math.fma(this.w, f16, Math.fma(-this.x, f17, Math.fma(this.y, f14, this.z * f15))), Math.fma(this.w, f17, Math.fma(this.x, f16, Math.fma(-this.y, f15, this.z * f14))), Math.fma(this.w, f14, Math.fma(-this.x, f15, Math.fma(-this.y, f16, -this.z * f17))));
    }

    public Quaternionf rotateYXZ(float f, float f2, float f3) {
        return this.rotateYXZ(f, f2, f3, this);
    }

    @Override
    public Quaternionf rotateYXZ(float f, float f2, float f3, Quaternionf quaternionf) {
        float f4 = Math.sin(f2 * 0.5f);
        float f5 = Math.cosFromSin(f4, f2 * 0.5f);
        float f6 = Math.sin(f * 0.5f);
        float f7 = Math.cosFromSin(f6, f * 0.5f);
        float f8 = Math.sin(f3 * 0.5f);
        float f9 = Math.cosFromSin(f8, f3 * 0.5f);
        float f10 = f7 * f4;
        float f11 = f6 * f5;
        float f12 = f6 * f4;
        float f13 = f7 * f5;
        float f14 = f10 * f9 + f11 * f8;
        float f15 = f11 * f9 - f10 * f8;
        float f16 = f13 * f8 - f12 * f9;
        float f17 = f13 * f9 + f12 * f8;
        return quaternionf.set(Math.fma(this.w, f14, Math.fma(this.x, f17, Math.fma(this.y, f16, -this.z * f15))), Math.fma(this.w, f15, Math.fma(-this.x, f16, Math.fma(this.y, f17, this.z * f14))), Math.fma(this.w, f16, Math.fma(this.x, f15, Math.fma(-this.y, f14, this.z * f17))), Math.fma(this.w, f17, Math.fma(-this.x, f14, Math.fma(-this.y, f15, -this.z * f16))));
    }

    @Override
    public Vector3f getEulerAnglesXYZ(Vector3f vector3f) {
        vector3f.x = Math.atan2(2.0f * (this.x * this.w - this.y * this.z), 1.0f - 2.0f * (this.x * this.x + this.y * this.y));
        vector3f.y = Math.safeAsin(2.0f * (this.x * this.z + this.y * this.w));
        vector3f.z = Math.atan2(2.0f * (this.z * this.w - this.x * this.y), 1.0f - 2.0f * (this.y * this.y + this.z * this.z));
        return vector3f;
    }

    @Override
    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public Quaternionf rotationXYZ(float f, float f2, float f3) {
        float f4 = Math.sin(f * 0.5f);
        float f5 = Math.cosFromSin(f4, f * 0.5f);
        float f6 = Math.sin(f2 * 0.5f);
        float f7 = Math.cosFromSin(f6, f2 * 0.5f);
        float f8 = Math.sin(f3 * 0.5f);
        float f9 = Math.cosFromSin(f8, f3 * 0.5f);
        float f10 = f7 * f9;
        float f11 = f6 * f8;
        float f12 = f6 * f9;
        float f13 = f7 * f8;
        this.w = f5 * f10 - f4 * f11;
        this.x = f4 * f10 + f5 * f11;
        this.y = f5 * f12 - f4 * f13;
        this.z = f5 * f13 + f4 * f12;
        return this;
    }

    public Quaternionf rotationZYX(float f, float f2, float f3) {
        float f4 = Math.sin(f3 * 0.5f);
        float f5 = Math.cosFromSin(f4, f3 * 0.5f);
        float f6 = Math.sin(f2 * 0.5f);
        float f7 = Math.cosFromSin(f6, f2 * 0.5f);
        float f8 = Math.sin(f * 0.5f);
        float f9 = Math.cosFromSin(f8, f * 0.5f);
        float f10 = f7 * f9;
        float f11 = f6 * f8;
        float f12 = f6 * f9;
        float f13 = f7 * f8;
        this.w = f5 * f10 + f4 * f11;
        this.x = f4 * f10 - f5 * f11;
        this.y = f5 * f12 + f4 * f13;
        this.z = f5 * f13 - f4 * f12;
        return this;
    }

    public Quaternionf rotationYXZ(float f, float f2, float f3) {
        float f4 = Math.sin(f2 * 0.5f);
        float f5 = Math.cosFromSin(f4, f2 * 0.5f);
        float f6 = Math.sin(f * 0.5f);
        float f7 = Math.cosFromSin(f6, f * 0.5f);
        float f8 = Math.sin(f3 * 0.5f);
        float f9 = Math.cosFromSin(f8, f3 * 0.5f);
        float f10 = f7 * f4;
        float f11 = f6 * f5;
        float f12 = f6 * f4;
        float f13 = f7 * f5;
        this.x = f10 * f9 + f11 * f8;
        this.y = f11 * f9 - f10 * f8;
        this.z = f13 * f8 - f12 * f9;
        this.w = f13 * f9 + f12 * f8;
        return this;
    }

    public Quaternionf slerp(Quaternionfc quaternionfc, float f) {
        return this.slerp(quaternionfc, f, this);
    }

    @Override
    public Quaternionf slerp(Quaternionfc quaternionfc, float f, Quaternionf quaternionf) {
        float f2;
        float f3;
        float f4 = Math.fma(this.x, quaternionfc.x(), Math.fma(this.y, quaternionfc.y(), Math.fma(this.z, quaternionfc.z(), this.w * quaternionfc.w())));
        float f5 = Math.abs(f4);
        if (1.0f - f5 > 1.0E-6f) {
            float f6 = 1.0f - f5 * f5;
            float f7 = Math.invsqrt(f6);
            float f8 = Math.atan2(f6 * f7, f5);
            f3 = (float)(Math.sin((1.0 - (double)f) * (double)f8) * (double)f7);
            f2 = Math.sin(f * f8) * f7;
        } else {
            f3 = 1.0f - f;
            f2 = f;
        }
        f2 = f4 >= 0.0f ? f2 : -f2;
        quaternionf.x = Math.fma(f3, this.x, f2 * quaternionfc.x());
        quaternionf.y = Math.fma(f3, this.y, f2 * quaternionfc.y());
        quaternionf.z = Math.fma(f3, this.z, f2 * quaternionfc.z());
        quaternionf.w = Math.fma(f3, this.w, f2 * quaternionfc.w());
        return quaternionf;
    }

    public static Quaternionfc slerp(Quaternionf[] quaternionfArray, float[] fArray, Quaternionf quaternionf) {
        quaternionf.set(quaternionfArray[0]);
        float f = fArray[0];
        for (int i = 1; i < quaternionfArray.length; ++i) {
            float f2 = f;
            float f3 = fArray[i];
            float f4 = f3 / (f2 + f3);
            f += f3;
            quaternionf.slerp(quaternionfArray[i], f4);
        }
        return quaternionf;
    }

    public Quaternionf scale(float f) {
        return this.scale(f, this);
    }

    @Override
    public Quaternionf scale(float f, Quaternionf quaternionf) {
        float f2 = Math.sqrt(f);
        quaternionf.x = f2 * this.x;
        quaternionf.y = f2 * this.y;
        quaternionf.z = f2 * this.z;
        quaternionf.w = f2 * this.w;
        return quaternionf;
    }

    public Quaternionf scaling(float f) {
        float f2 = Math.sqrt(f);
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = f2;
        return this;
    }

    public Quaternionf integrate(float f, float f2, float f3, float f4) {
        return this.integrate(f, f2, f3, f4, this);
    }

    @Override
    public Quaternionf integrate(float f, float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5;
        float f6;
        float f7 = f * f2 * 0.5f;
        float f8 = f * f3 * 0.5f;
        float f9 = f * f4 * 0.5f;
        float f10 = f7 * f7 + f8 * f8 + f9 * f9;
        if (f10 * f10 / 24.0f < 1.0E-8f) {
            f6 = 1.0f - f10 * 0.5f;
            f5 = 1.0f - f10 / 6.0f;
        } else {
            float f11 = Math.sqrt(f10);
            float f12 = Math.sin(f11);
            f5 = f12 / f11;
            f6 = Math.cosFromSin(f12, f11);
        }
        float f13 = f7 * f5;
        float f14 = f8 * f5;
        float f15 = f9 * f5;
        return quaternionf.set(Math.fma(f6, this.x, Math.fma(f13, this.w, Math.fma(f14, this.z, -f15 * this.y))), Math.fma(f6, this.y, Math.fma(-f13, this.z, Math.fma(f14, this.w, f15 * this.x))), Math.fma(f6, this.z, Math.fma(f13, this.y, Math.fma(-f14, this.x, f15 * this.w))), Math.fma(f6, this.w, Math.fma(-f13, this.x, Math.fma(-f14, this.y, -f15 * this.z))));
    }

    public Quaternionf nlerp(Quaternionfc quaternionfc, float f) {
        return this.nlerp(quaternionfc, f, this);
    }

    @Override
    public Quaternionf nlerp(Quaternionfc quaternionfc, float f, Quaternionf quaternionf) {
        float f2 = Math.fma(this.x, quaternionfc.x(), Math.fma(this.y, quaternionfc.y(), Math.fma(this.z, quaternionfc.z(), this.w * quaternionfc.w())));
        float f3 = 1.0f - f;
        float f4 = f2 >= 0.0f ? f : -f;
        quaternionf.x = Math.fma(f3, this.x, f4 * quaternionfc.x());
        quaternionf.y = Math.fma(f3, this.y, f4 * quaternionfc.y());
        quaternionf.z = Math.fma(f3, this.z, f4 * quaternionfc.z());
        quaternionf.w = Math.fma(f3, this.w, f4 * quaternionfc.w());
        float f5 = Math.invsqrt(Math.fma(quaternionf.x, quaternionf.x, Math.fma(quaternionf.y, quaternionf.y, Math.fma(quaternionf.z, quaternionf.z, quaternionf.w * quaternionf.w))));
        quaternionf.x *= f5;
        quaternionf.y *= f5;
        quaternionf.z *= f5;
        quaternionf.w *= f5;
        return quaternionf;
    }

    public static Quaternionfc nlerp(Quaternionfc[] quaternionfcArray, float[] fArray, Quaternionf quaternionf) {
        quaternionf.set(quaternionfcArray[0]);
        float f = fArray[0];
        for (int i = 1; i < quaternionfcArray.length; ++i) {
            float f2 = f;
            float f3 = fArray[i];
            float f4 = f3 / (f2 + f3);
            f += f3;
            quaternionf.nlerp(quaternionfcArray[i], f4);
        }
        return quaternionf;
    }

    @Override
    public Quaternionf nlerpIterative(Quaternionfc quaternionfc, float f, float f2, Quaternionf quaternionf) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9 = this.x;
        float f10 = this.y;
        float f11 = this.z;
        float f12 = this.w;
        float f13 = quaternionfc.x();
        float f14 = Math.fma(f9, f13, Math.fma(f10, f8 = quaternionfc.y(), Math.fma(f11, f7 = quaternionfc.z(), f12 * (f6 = quaternionfc.w()))));
        float f15 = Math.abs(f14);
        if (0.999999f < f15) {
            return quaternionf.set(this);
        }
        float f16 = f;
        while (f15 < f2) {
            f5 = 0.5f;
            float f17 = f4 = f14 >= 0.0f ? 0.5f : -0.5f;
            if (f16 < 0.5f) {
                f13 = Math.fma(f5, f13, f4 * f9);
                f8 = Math.fma(f5, f8, f4 * f10);
                f7 = Math.fma(f5, f7, f4 * f11);
                f6 = Math.fma(f5, f6, f4 * f12);
                f3 = Math.invsqrt(Math.fma(f13, f13, Math.fma(f8, f8, Math.fma(f7, f7, f6 * f6))));
                f13 *= f3;
                f8 *= f3;
                f7 *= f3;
                f6 *= f3;
                f16 += f16;
            } else {
                f9 = Math.fma(f5, f9, f4 * f13);
                f10 = Math.fma(f5, f10, f4 * f8);
                f11 = Math.fma(f5, f11, f4 * f7);
                f12 = Math.fma(f5, f12, f4 * f6);
                f3 = Math.invsqrt(Math.fma(f9, f9, Math.fma(f10, f10, Math.fma(f11, f11, f12 * f12))));
                f9 *= f3;
                f10 *= f3;
                f11 *= f3;
                f12 *= f3;
                f16 = f16 + f16 - 1.0f;
            }
            f14 = Math.fma(f9, f13, Math.fma(f10, f8, Math.fma(f11, f7, f12 * f6)));
            f15 = Math.abs(f14);
        }
        f5 = 1.0f - f16;
        f4 = f14 >= 0.0f ? f16 : -f16;
        f3 = Math.fma(f5, f9, f4 * f13);
        float f18 = Math.fma(f5, f10, f4 * f8);
        float f19 = Math.fma(f5, f11, f4 * f7);
        float f20 = Math.fma(f5, f12, f4 * f6);
        float f21 = Math.invsqrt(Math.fma(f3, f3, Math.fma(f18, f18, Math.fma(f19, f19, f20 * f20))));
        quaternionf.x = f3 * f21;
        quaternionf.y = f18 * f21;
        quaternionf.z = f19 * f21;
        quaternionf.w = f20 * f21;
        return quaternionf;
    }

    public Quaternionf nlerpIterative(Quaternionfc quaternionfc, float f, float f2) {
        return this.nlerpIterative(quaternionfc, f, f2, this);
    }

    public static Quaternionfc nlerpIterative(Quaternionf[] quaternionfArray, float[] fArray, float f, Quaternionf quaternionf) {
        quaternionf.set(quaternionfArray[0]);
        float f2 = fArray[0];
        for (int i = 1; i < quaternionfArray.length; ++i) {
            float f3 = f2;
            float f4 = fArray[i];
            float f5 = f4 / (f3 + f4);
            f2 += f4;
            quaternionf.nlerpIterative(quaternionfArray[i], f5, f);
        }
        return quaternionf;
    }

    public Quaternionf lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    @Override
    public Quaternionf lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Quaternionf quaternionf) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), quaternionf);
    }

    public Quaternionf lookAlong(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.lookAlong(f, f2, f3, f4, f5, f6, this);
    }

    @Override
    public Quaternionf lookAlong(float f, float f2, float f3, float f4, float f5, float f6, Quaternionf quaternionf) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f12 = -f * f11;
        float f13 = -f2 * f11;
        float f14 = -f3 * f11;
        float f15 = f5 * f14 - f6 * f13;
        float f16 = f6 * f12 - f4 * f14;
        float f17 = f4 * f13 - f5 * f12;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f13 * (f17 *= f18) - f14 * (f16 *= f18);
        float f20 = f14 * (f15 *= f18) - f12 * f17;
        float f21 = f12 * f16 - f13 * f15;
        double d = f15 + f20 + f14;
        if (d >= 0.0) {
            double d2 = Math.sqrt(d + 1.0);
            f10 = (float)(d2 * 0.5);
            d2 = 0.5 / d2;
            f9 = (float)((double)(f13 - f21) * d2);
            f8 = (float)((double)(f17 - f12) * d2);
            f7 = (float)((double)(f19 - f16) * d2);
        } else if (f15 > f20 && f15 > f14) {
            double d3 = Math.sqrt(1.0 + (double)f15 - (double)f20 - (double)f14);
            f9 = (float)(d3 * 0.5);
            d3 = 0.5 / d3;
            f8 = (float)((double)(f16 + f19) * d3);
            f7 = (float)((double)(f12 + f17) * d3);
            f10 = (float)((double)(f13 - f21) * d3);
        } else if (f20 > f14) {
            double d4 = Math.sqrt(1.0 + (double)f20 - (double)f15 - (double)f14);
            f8 = (float)(d4 * 0.5);
            d4 = 0.5 / d4;
            f9 = (float)((double)(f16 + f19) * d4);
            f7 = (float)((double)(f21 + f13) * d4);
            f10 = (float)((double)(f17 - f12) * d4);
        } else {
            double d5 = Math.sqrt(1.0 + (double)f14 - (double)f15 - (double)f20);
            f7 = (float)(d5 * 0.5);
            d5 = 0.5 / d5;
            f9 = (float)((double)(f12 + f17) * d5);
            f8 = (float)((double)(f21 + f13) * d5);
            f10 = (float)((double)(f19 - f16) * d5);
        }
        return quaternionf.set(Math.fma(this.w, f9, Math.fma(this.x, f10, Math.fma(this.y, f7, -this.z * f8))), Math.fma(this.w, f8, Math.fma(-this.x, f7, Math.fma(this.y, f10, this.z * f9))), Math.fma(this.w, f7, Math.fma(this.x, f8, Math.fma(-this.y, f9, this.z * f10))), Math.fma(this.w, f10, Math.fma(-this.x, f9, Math.fma(-this.y, f8, -this.z * f7))));
    }

    public Quaternionf rotationTo(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13 = Math.invsqrt(Math.fma(f, f, Math.fma(f2, f2, f3 * f3)));
        float f14 = f * f13;
        float f15 = f14 * (f12 = f4 * (f11 = Math.invsqrt(Math.fma(f4, f4, Math.fma(f5, f5, f6 * f6))))) + (f10 = f2 * f13) * (f9 = f5 * f11) + (f8 = f3 * f13) * (f7 = f6 * f11);
        if (f15 < -0.999999f) {
            float f16 = f10;
            float f17 = -f14;
            float f18 = 0.0f;
            float f19 = 0.0f;
            if (f16 * f16 + f17 * f17 == 0.0f) {
                f16 = 0.0f;
                f17 = f8;
                f18 = -f10;
                f19 = 0.0f;
            }
            this.x = f16;
            this.y = f17;
            this.z = f18;
            this.w = 0.0f;
        } else {
            float f20 = Math.sqrt((1.0f + f15) * 2.0f);
            float f21 = 1.0f / f20;
            float f22 = f10 * f7 - f8 * f9;
            float f23 = f8 * f12 - f14 * f7;
            float f24 = f14 * f9 - f10 * f12;
            float f25 = f22 * f21;
            float f26 = f23 * f21;
            float f27 = f24 * f21;
            float f28 = f20 * 0.5f;
            float f29 = Math.invsqrt(Math.fma(f25, f25, Math.fma(f26, f26, Math.fma(f27, f27, f28 * f28))));
            this.x = f25 * f29;
            this.y = f26 * f29;
            this.z = f27 * f29;
            this.w = f28 * f29;
        }
        return this;
    }

    public Quaternionf rotationTo(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    @Override
    public Quaternionf rotateTo(float f, float f2, float f3, float f4, float f5, float f6, Quaternionf quaternionf) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17 = Math.invsqrt(Math.fma(f, f, Math.fma(f2, f2, f3 * f3)));
        float f18 = f * f17;
        float f19 = f18 * (f16 = f4 * (f15 = Math.invsqrt(Math.fma(f4, f4, Math.fma(f5, f5, f6 * f6))))) + (f14 = f2 * f17) * (f13 = f5 * f15) + (f12 = f3 * f17) * (f11 = f6 * f15);
        if (f19 < -0.999999f) {
            f10 = f14;
            f9 = -f18;
            f8 = 0.0f;
            f7 = 0.0f;
            if (f10 * f10 + f9 * f9 == 0.0f) {
                f10 = 0.0f;
                f9 = f12;
                f8 = -f14;
                f7 = 0.0f;
            }
        } else {
            float f20 = Math.sqrt((1.0f + f19) * 2.0f);
            float f21 = 1.0f / f20;
            float f22 = f14 * f11 - f12 * f13;
            float f23 = f12 * f16 - f18 * f11;
            float f24 = f18 * f13 - f14 * f16;
            f10 = f22 * f21;
            f9 = f23 * f21;
            f8 = f24 * f21;
            f7 = f20 * 0.5f;
            float f25 = Math.invsqrt(Math.fma(f10, f10, Math.fma(f9, f9, Math.fma(f8, f8, f7 * f7))));
            f10 *= f25;
            f9 *= f25;
            f8 *= f25;
            f7 *= f25;
        }
        return quaternionf.set(Math.fma(this.w, f10, Math.fma(this.x, f7, Math.fma(this.y, f8, -this.z * f9))), Math.fma(this.w, f9, Math.fma(-this.x, f8, Math.fma(this.y, f7, this.z * f10))), Math.fma(this.w, f8, Math.fma(this.x, f9, Math.fma(-this.y, f10, this.z * f7))), Math.fma(this.w, f7, Math.fma(-this.x, f10, Math.fma(-this.y, f9, -this.z * f8))));
    }

    public Quaternionf rotateTo(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.rotateTo(f, f2, f3, f4, f5, f6, this);
    }

    @Override
    public Quaternionf rotateTo(Vector3fc vector3fc, Vector3fc vector3fc2, Quaternionf quaternionf) {
        return this.rotateTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), quaternionf);
    }

    public Quaternionf rotateTo(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Quaternionf rotateX(float f) {
        return this.rotateX(f, this);
    }

    @Override
    public Quaternionf rotateX(float f, Quaternionf quaternionf) {
        float f2 = Math.sin(f * 0.5f);
        float f3 = Math.cosFromSin(f2, f * 0.5f);
        return quaternionf.set(this.w * f2 + this.x * f3, this.y * f3 + this.z * f2, this.z * f3 - this.y * f2, this.w * f3 - this.x * f2);
    }

    public Quaternionf rotateY(float f) {
        return this.rotateY(f, this);
    }

    @Override
    public Quaternionf rotateY(float f, Quaternionf quaternionf) {
        float f2 = Math.sin(f * 0.5f);
        float f3 = Math.cosFromSin(f2, f * 0.5f);
        return quaternionf.set(this.x * f3 - this.z * f2, this.w * f2 + this.y * f3, this.x * f2 + this.z * f3, this.w * f3 - this.y * f2);
    }

    public Quaternionf rotateZ(float f) {
        return this.rotateZ(f, this);
    }

    @Override
    public Quaternionf rotateZ(float f, Quaternionf quaternionf) {
        float f2 = Math.sin(f * 0.5f);
        float f3 = Math.cosFromSin(f2, f * 0.5f);
        return quaternionf.set(this.x * f3 + this.y * f2, this.y * f3 - this.x * f2, this.w * f2 + this.z * f3, this.w * f3 - this.z * f2);
    }

    public Quaternionf rotateLocalX(float f) {
        return this.rotateLocalX(f, this);
    }

    @Override
    public Quaternionf rotateLocalX(float f, Quaternionf quaternionf) {
        float f2 = f * 0.5f;
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        quaternionf.set(f4 * this.x + f3 * this.w, f4 * this.y - f3 * this.z, f4 * this.z + f3 * this.y, f4 * this.w - f3 * this.x);
        return quaternionf;
    }

    public Quaternionf rotateLocalY(float f) {
        return this.rotateLocalY(f, this);
    }

    @Override
    public Quaternionf rotateLocalY(float f, Quaternionf quaternionf) {
        float f2 = f * 0.5f;
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        quaternionf.set(f4 * this.x + f3 * this.z, f4 * this.y + f3 * this.w, f4 * this.z - f3 * this.x, f4 * this.w - f3 * this.y);
        return quaternionf;
    }

    public Quaternionf rotateLocalZ(float f) {
        return this.rotateLocalZ(f, this);
    }

    @Override
    public Quaternionf rotateLocalZ(float f, Quaternionf quaternionf) {
        float f2 = f * 0.5f;
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        quaternionf.set(f4 * this.x - f3 * this.y, f4 * this.y + f3 * this.x, f4 * this.z + f3 * this.w, f4 * this.w - f3 * this.z);
        return quaternionf;
    }

    @Override
    public Quaternionf rotateAxis(float f, float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = f / 2.0f;
        float f6 = Math.sin(f5);
        float f7 = Math.invsqrt(Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
        float f8 = f2 * f7 * f6;
        float f9 = f3 * f7 * f6;
        float f10 = f4 * f7 * f6;
        float f11 = Math.cosFromSin(f6, f5);
        return quaternionf.set(Math.fma(this.w, f8, Math.fma(this.x, f11, Math.fma(this.y, f10, -this.z * f9))), Math.fma(this.w, f9, Math.fma(-this.x, f10, Math.fma(this.y, f11, this.z * f8))), Math.fma(this.w, f10, Math.fma(this.x, f9, Math.fma(-this.y, f8, this.z * f11))), Math.fma(this.w, f11, Math.fma(-this.x, f8, Math.fma(-this.y, f9, -this.z * f10))));
    }

    @Override
    public Quaternionf rotateAxis(float f, Vector3fc vector3fc, Quaternionf quaternionf) {
        return this.rotateAxis(f, vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionf);
    }

    public Quaternionf rotateAxis(float f, Vector3fc vector3fc) {
        return this.rotateAxis(f, vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    public Quaternionf rotateAxis(float f, float f2, float f3, float f4) {
        return this.rotateAxis(f, f2, f3, f4, this);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
        objectOutput.writeFloat(this.w);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
        this.w = objectInput.readFloat();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.w);
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Quaternionf quaternionf = (Quaternionf)object;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(quaternionf.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(quaternionf.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(quaternionf.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(quaternionf.z);
    }

    public Quaternionf difference(Quaternionf quaternionf) {
        return this.difference(quaternionf, this);
    }

    @Override
    public Quaternionf difference(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f = 1.0f / this.lengthSquared();
        float f2 = -this.x * f;
        float f3 = -this.y * f;
        float f4 = -this.z * f;
        float f5 = this.w * f;
        quaternionf.set(Math.fma(f5, quaternionfc.x(), Math.fma(f2, quaternionfc.w(), Math.fma(f3, quaternionfc.z(), -f4 * quaternionfc.y()))), Math.fma(f5, quaternionfc.y(), Math.fma(-f2, quaternionfc.z(), Math.fma(f3, quaternionfc.w(), f4 * quaternionfc.x()))), Math.fma(f5, quaternionfc.z(), Math.fma(f2, quaternionfc.y(), Math.fma(-f3, quaternionfc.x(), f4 * quaternionfc.w()))), Math.fma(f5, quaternionfc.w(), Math.fma(-f2, quaternionfc.x(), Math.fma(-f3, quaternionfc.y(), -f4 * quaternionfc.z()))));
        return quaternionf;
    }

    @Override
    public Vector3f positiveX(Vector3f vector3f) {
        float f = 1.0f / this.lengthSquared();
        float f2 = -this.x * f;
        float f3 = -this.y * f;
        float f4 = -this.z * f;
        float f5 = this.w * f;
        float f6 = f3 + f3;
        float f7 = f4 + f4;
        vector3f.x = -f3 * f6 - f4 * f7 + 1.0f;
        vector3f.y = f2 * f6 + f5 * f7;
        vector3f.z = f2 * f7 - f5 * f6;
        return vector3f;
    }

    @Override
    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        float f = this.y + this.y;
        float f2 = this.z + this.z;
        vector3f.x = -this.y * f - this.z * f2 + 1.0f;
        vector3f.y = this.x * f - this.w * f2;
        vector3f.z = this.x * f2 + this.w * f;
        return vector3f;
    }

    @Override
    public Vector3f positiveY(Vector3f vector3f) {
        float f = 1.0f / this.lengthSquared();
        float f2 = -this.x * f;
        float f3 = -this.y * f;
        float f4 = -this.z * f;
        float f5 = this.w * f;
        float f6 = f2 + f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        vector3f.x = f2 * f7 - f5 * f8;
        vector3f.y = -f2 * f6 - f4 * f8 + 1.0f;
        vector3f.z = f3 * f8 + f5 * f6;
        return vector3f;
    }

    @Override
    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        float f = this.x + this.x;
        float f2 = this.y + this.y;
        float f3 = this.z + this.z;
        vector3f.x = this.x * f2 + this.w * f3;
        vector3f.y = -this.x * f - this.z * f3 + 1.0f;
        vector3f.z = this.y * f3 - this.w * f;
        return vector3f;
    }

    @Override
    public Vector3f positiveZ(Vector3f vector3f) {
        float f = 1.0f / this.lengthSquared();
        float f2 = -this.x * f;
        float f3 = -this.y * f;
        float f4 = -this.z * f;
        float f5 = this.w * f;
        float f6 = f2 + f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        vector3f.x = f2 * f8 + f5 * f7;
        vector3f.y = f3 * f8 - f5 * f6;
        vector3f.z = -f2 * f6 - f3 * f7 + 1.0f;
        return vector3f;
    }

    @Override
    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        float f = this.x + this.x;
        float f2 = this.y + this.y;
        float f3 = this.z + this.z;
        vector3f.x = this.x * f3 - this.w * f2;
        vector3f.y = this.y * f3 + this.w * f;
        vector3f.z = -this.x * f - this.y * f2 + 1.0f;
        return vector3f;
    }

    public Quaternionf conjugateBy(Quaternionfc quaternionfc) {
        return this.conjugateBy(quaternionfc, this);
    }

    @Override
    public Quaternionf conjugateBy(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f = 1.0f / quaternionfc.lengthSquared();
        float f2 = -quaternionfc.x() * f;
        float f3 = -quaternionfc.y() * f;
        float f4 = -quaternionfc.z() * f;
        float f5 = quaternionfc.w() * f;
        float f6 = Math.fma(quaternionfc.w(), this.x, Math.fma(quaternionfc.x(), this.w, Math.fma(quaternionfc.y(), this.z, -quaternionfc.z() * this.y)));
        float f7 = Math.fma(quaternionfc.w(), this.y, Math.fma(-quaternionfc.x(), this.z, Math.fma(quaternionfc.y(), this.w, quaternionfc.z() * this.x)));
        float f8 = Math.fma(quaternionfc.w(), this.z, Math.fma(quaternionfc.x(), this.y, Math.fma(-quaternionfc.y(), this.x, quaternionfc.z() * this.w)));
        float f9 = Math.fma(quaternionfc.w(), this.w, Math.fma(-quaternionfc.x(), this.x, Math.fma(-quaternionfc.y(), this.y, -quaternionfc.z() * this.z)));
        return quaternionf.set(Math.fma(f9, f2, Math.fma(f6, f5, Math.fma(f7, f4, -f8 * f3))), Math.fma(f9, f3, Math.fma(-f6, f4, Math.fma(f7, f5, f8 * f2))), Math.fma(f9, f4, Math.fma(f6, f3, Math.fma(-f7, f2, f8 * f5))), Math.fma(f9, f5, Math.fma(-f6, f2, Math.fma(-f7, f3, -f8 * f4))));
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    @Override
    public boolean equals(Quaternionfc quaternionfc, float f) {
        if (this == quaternionfc) {
            return true;
        }
        if (quaternionfc == null) {
            return false;
        }
        if (!(quaternionfc instanceof Quaternionfc)) {
            return false;
        }
        if (!Runtime.equals(this.x, quaternionfc.x(), f)) {
            return false;
        }
        if (!Runtime.equals(this.y, quaternionfc.y(), f)) {
            return false;
        }
        if (!Runtime.equals(this.z, quaternionfc.z(), f)) {
            return false;
        }
        return Runtime.equals(this.w, quaternionfc.w(), f);
    }

    @Override
    public boolean equals(float f, float f2, float f3, float f4) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(f3)) {
            return false;
        }
        return Float.floatToIntBits(this.w) == Float.floatToIntBits(f4);
    }
}

