/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Quaterniond;

public class QuaterniondInterpolator {
    private final SvdDecomposition3d svdDecomposition3d = new SvdDecomposition3d();
    private final double[] m = new double[9];
    private final Matrix3d u = new Matrix3d();
    private final Matrix3d v = new Matrix3d();

    public Quaterniond computeWeightedAverage(Quaterniond[] quaterniondArray, double[] dArray, int n, Quaterniond quaterniond) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        for (int i = 0; i < quaterniondArray.length; ++i) {
            Quaterniond quaterniond2 = quaterniondArray[i];
            double d10 = quaterniond2.x + quaterniond2.x;
            double d11 = quaterniond2.y + quaterniond2.y;
            double d12 = quaterniond2.z + quaterniond2.z;
            double d13 = d10 * quaterniond2.x;
            double d14 = d11 * quaterniond2.y;
            double d15 = d12 * quaterniond2.z;
            double d16 = d10 * quaterniond2.y;
            double d17 = d10 * quaterniond2.z;
            double d18 = d10 * quaterniond2.w;
            double d19 = d11 * quaterniond2.z;
            double d20 = d11 * quaterniond2.w;
            double d21 = d12 * quaterniond2.w;
            d += dArray[i] * (1.0 - d14 - d15);
            d2 += dArray[i] * (d16 + d21);
            d3 += dArray[i] * (d17 - d20);
            d4 += dArray[i] * (d16 - d21);
            d5 += dArray[i] * (1.0 - d15 - d13);
            d6 += dArray[i] * (d19 + d18);
            d7 += dArray[i] * (d17 + d20);
            d8 += dArray[i] * (d19 - d18);
            d9 += dArray[i] * (1.0 - d14 - d13);
        }
        this.m[0] = d;
        this.m[1] = d2;
        this.m[2] = d3;
        this.m[3] = d4;
        this.m[4] = d5;
        this.m[5] = d6;
        this.m[6] = d7;
        this.m[7] = d8;
        this.m[8] = d9;
        this.svdDecomposition3d.svd(this.m, n, this.u, this.v);
        this.u.mul(this.v.transpose());
        return quaterniond.setFromNormalized(this.u).normalize();
    }

    private static class SvdDecomposition3d {
        private final double[] rv1 = new double[3];
        private final double[] w = new double[3];
        private final double[] v = new double[9];

        SvdDecomposition3d() {
        }

        private double SIGN(double d, double d2) {
            return d2 >= 0.0 ? Math.abs(d) : -Math.abs(d);
        }

        void svd(double[] dArray, int n, Matrix3d matrix3d, Matrix3d matrix3d2) {
            int n2;
            double d;
            double d2;
            int n3;
            double d3;
            int n4;
            int n5 = 0;
            int n6 = 0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (n4 = 0; n4 < 3; ++n4) {
                n5 = n4 + 1;
                this.rv1[n4] = d6 * d5;
                d6 = 0.0;
                d3 = 0.0;
                d5 = 0.0;
                for (n3 = n4; n3 < 3; ++n3) {
                    d6 += Math.abs(dArray[n3 + 3 * n4]);
                }
                if (d6 != 0.0) {
                    for (n3 = n4; n3 < 3; ++n3) {
                        dArray[n3 + 3 * n4] = dArray[n3 + 3 * n4] / d6;
                        d3 += dArray[n3 + 3 * n4] * dArray[n3 + 3 * n4];
                    }
                    d2 = dArray[n4 + 3 * n4];
                    d5 = -this.SIGN(Math.sqrt(d3), d2);
                    d = d2 * d5 - d3;
                    dArray[n4 + 3 * n4] = d2 - d5;
                    if (n4 != 2) {
                        for (n2 = n5; n2 < 3; ++n2) {
                            d3 = 0.0;
                            for (n3 = n4; n3 < 3; ++n3) {
                                d3 += dArray[n3 + 3 * n4] * dArray[n3 + 3 * n2];
                            }
                            d2 = d3 / d;
                            for (n3 = n4; n3 < 3; ++n3) {
                                int n7 = n3 + 3 * n2;
                                dArray[n7] = dArray[n7] + d2 * dArray[n3 + 3 * n4];
                            }
                        }
                    }
                    for (n3 = n4; n3 < 3; ++n3) {
                        dArray[n3 + 3 * n4] = dArray[n3 + 3 * n4] * d6;
                    }
                }
                this.w[n4] = d6 * d5;
                d6 = 0.0;
                d3 = 0.0;
                d5 = 0.0;
                if (n4 < 3 && n4 != 2) {
                    for (n3 = n5; n3 < 3; ++n3) {
                        d6 += Math.abs(dArray[n4 + 3 * n3]);
                    }
                    if (d6 != 0.0) {
                        for (n3 = n5; n3 < 3; ++n3) {
                            dArray[n4 + 3 * n3] = dArray[n4 + 3 * n3] / d6;
                            d3 += dArray[n4 + 3 * n3] * dArray[n4 + 3 * n3];
                        }
                        d2 = dArray[n4 + 3 * n5];
                        d5 = -this.SIGN(Math.sqrt(d3), d2);
                        d = d2 * d5 - d3;
                        dArray[n4 + 3 * n5] = d2 - d5;
                        for (n3 = n5; n3 < 3; ++n3) {
                            this.rv1[n3] = dArray[n4 + 3 * n3] / d;
                        }
                        if (n4 != 2) {
                            for (n2 = n5; n2 < 3; ++n2) {
                                d3 = 0.0;
                                for (n3 = n5; n3 < 3; ++n3) {
                                    d3 += dArray[n2 + 3 * n3] * dArray[n4 + 3 * n3];
                                }
                                for (n3 = n5; n3 < 3; ++n3) {
                                    int n8 = n2 + 3 * n3;
                                    dArray[n8] = dArray[n8] + d3 * this.rv1[n3];
                                }
                            }
                        }
                        for (n3 = n5; n3 < 3; ++n3) {
                            dArray[n4 + 3 * n3] = dArray[n4 + 3 * n3] * d6;
                        }
                    }
                }
                d4 = Math.max(d4, Math.abs(this.w[n4]) + Math.abs(this.rv1[n4]));
            }
            n4 = 2;
            while (n4 >= 0) {
                if (n4 < 2) {
                    if (d5 != 0.0) {
                        for (n2 = n5; n2 < 3; ++n2) {
                            this.v[n2 + 3 * n4] = dArray[n4 + 3 * n2] / dArray[n4 + 3 * n5] / d5;
                        }
                        for (n2 = n5; n2 < 3; ++n2) {
                            d3 = 0.0;
                            for (n3 = n5; n3 < 3; ++n3) {
                                d3 += dArray[n4 + 3 * n3] * this.v[n3 + 3 * n2];
                            }
                            for (n3 = n5; n3 < 3; ++n3) {
                                int n9 = n3 + 3 * n2;
                                this.v[n9] = this.v[n9] + d3 * this.v[n3 + 3 * n4];
                            }
                        }
                    }
                    for (n2 = n5; n2 < 3; ++n2) {
                        this.v[n2 + 3 * n4] = 0.0;
                        this.v[n4 + 3 * n2] = 0.0;
                    }
                }
                this.v[n4 + 3 * n4] = 1.0;
                d5 = this.rv1[n4];
                n5 = n4--;
            }
            for (n4 = 2; n4 >= 0; --n4) {
                n5 = n4 + 1;
                d5 = this.w[n4];
                if (n4 < 2) {
                    for (n2 = n5; n2 < 3; ++n2) {
                        dArray[n4 + 3 * n2] = 0.0;
                    }
                }
                if (d5 != 0.0) {
                    d5 = 1.0 / d5;
                    if (n4 != 2) {
                        for (n2 = n5; n2 < 3; ++n2) {
                            d3 = 0.0;
                            for (n3 = n5; n3 < 3; ++n3) {
                                d3 += dArray[n3 + 3 * n4] * dArray[n3 + 3 * n2];
                            }
                            d2 = d3 / dArray[n4 + 3 * n4] * d5;
                            for (n3 = n4; n3 < 3; ++n3) {
                                int n10 = n3 + 3 * n2;
                                dArray[n10] = dArray[n10] + d2 * dArray[n3 + 3 * n4];
                            }
                        }
                    }
                    for (n2 = n4; n2 < 3; ++n2) {
                        dArray[n2 + 3 * n4] = dArray[n2 + 3 * n4] * d5;
                    }
                } else {
                    for (n2 = n4; n2 < 3; ++n2) {
                        dArray[n2 + 3 * n4] = 0.0;
                    }
                }
                int n11 = n4 + 3 * n4;
                dArray[n11] = dArray[n11] + 1.0;
            }
            block27: for (n3 = 2; n3 >= 0; --n3) {
                for (int i = 0; i < n; ++i) {
                    double d7;
                    double d8;
                    double d9;
                    boolean bl = true;
                    for (n5 = n3; n5 >= 0; --n5) {
                        n6 = n5 - 1;
                        if (Math.abs(this.rv1[n5]) + d4 == d4) {
                            bl = false;
                            break;
                        }
                        if (Math.abs(this.w[n6]) + d4 == d4) break;
                    }
                    if (bl) {
                        d9 = 0.0;
                        d3 = 1.0;
                        for (n4 = n5; n4 <= n3; ++n4) {
                            d2 = d3 * this.rv1[n4];
                            if (Math.abs(d2) + d4 == d4) continue;
                            d5 = this.w[n4];
                            this.w[n4] = d = SvdDecomposition3d.PYTHAG(d2, d5);
                            d = 1.0 / d;
                            d9 = d5 * d;
                            d3 = -d2 * d;
                            for (n2 = 0; n2 < 3; ++n2) {
                                d8 = dArray[n2 + 3 * n6];
                                d7 = dArray[n2 + 3 * n4];
                                dArray[n2 + 3 * n6] = d8 * d9 + d7 * d3;
                                dArray[n2 + 3 * n4] = d7 * d9 - d8 * d3;
                            }
                        }
                    }
                    d7 = this.w[n3];
                    if (n5 == n3) {
                        if (!(d7 < 0.0)) continue block27;
                        this.w[n3] = -d7;
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.v[n2 + 3 * n3] = -this.v[n2 + 3 * n3];
                        }
                        continue block27;
                    }
                    if (i == n - 1) {
                        throw new RuntimeException("No convergence after " + n + " iterations");
                    }
                    double d10 = this.w[n5];
                    n6 = n3 - 1;
                    d8 = this.w[n6];
                    d5 = this.rv1[n6];
                    d = this.rv1[n3];
                    d2 = ((d8 - d7) * (d8 + d7) + (d5 - d) * (d5 + d)) / (2.0 * d * d8);
                    d5 = SvdDecomposition3d.PYTHAG(d2, 1.0);
                    d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + this.SIGN(d5, d2)) - d)) / d10;
                    d3 = 1.0;
                    d9 = 1.0;
                    for (n2 = n5; n2 <= n6; ++n2) {
                        int n12;
                        n4 = n2 + 1;
                        d5 = this.rv1[n4];
                        d8 = this.w[n4];
                        d = d3 * d5;
                        d5 = d9 * d5;
                        this.rv1[n2] = d7 = SvdDecomposition3d.PYTHAG(d2, d);
                        d9 = d2 / d7;
                        d3 = d / d7;
                        d2 = d10 * d9 + d5 * d3;
                        d5 = d5 * d9 - d10 * d3;
                        d = d8 * d3;
                        d8 *= d9;
                        for (n12 = 0; n12 < 3; ++n12) {
                            d10 = this.v[n12 + 3 * n2];
                            d7 = this.v[n12 + 3 * n4];
                            this.v[n12 + 3 * n2] = d10 * d9 + d7 * d3;
                            this.v[n12 + 3 * n4] = d7 * d9 - d10 * d3;
                        }
                        this.w[n2] = d7 = SvdDecomposition3d.PYTHAG(d2, d);
                        if (d7 != 0.0) {
                            d7 = 1.0 / d7;
                            d9 = d2 * d7;
                            d3 = d * d7;
                        }
                        d2 = d9 * d5 + d3 * d8;
                        d10 = d9 * d8 - d3 * d5;
                        for (n12 = 0; n12 < 3; ++n12) {
                            d8 = dArray[n12 + 3 * n2];
                            d7 = dArray[n12 + 3 * n4];
                            dArray[n12 + 3 * n2] = d8 * d9 + d7 * d3;
                            dArray[n12 + 3 * n4] = d7 * d9 - d8 * d3;
                        }
                    }
                    this.rv1[n5] = 0.0;
                    this.rv1[n3] = d2;
                    this.w[n3] = d10;
                }
            }
            matrix3d.set(dArray);
            matrix3d2.set(this.v);
        }

        private static double PYTHAG(double d, double d2) {
            double d3;
            double d4;
            double d5 = Math.abs(d);
            if (d5 > (d4 = Math.abs(d2))) {
                double d6 = d4 / d5;
                d3 = d5 * Math.sqrt(1.0 + d6 * d6);
            } else if (d4 > 0.0) {
                double d7 = d5 / d4;
                d3 = d4 * Math.sqrt(1.0 + d7 * d7);
            } else {
                d3 = 0.0;
            }
            return d3;
        }
    }
}

