/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PolygonsIntersection {
    private static final ByStartComparator byStartComparator = new ByStartComparator();
    private static final ByEndComparator byEndComparator = new ByEndComparator();
    protected final float[] verticesXY;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private float centerX;
    private float centerY;
    private float radiusSquared;
    private IntervalTreeNode tree;

    public PolygonsIntersection(float[] fArray, int[] nArray, int n) {
        this.verticesXY = fArray;
        this.preprocess(n, nArray);
    }

    private IntervalTreeNode buildNode(List list, float f) {
        ArrayList<Interval> arrayList = null;
        ArrayList<Interval> arrayList2 = null;
        ArrayList<Interval> arrayList3 = null;
        ArrayList<Interval> arrayList4 = null;
        float f2 = 1.0E38f;
        float f3 = -1.0E38f;
        float f4 = 1.0E38f;
        float f5 = -1.0E38f;
        float f6 = 1.0E38f;
        float f7 = -1.0E38f;
        for (int i = 0; i < list.size(); ++i) {
            Interval interval = (Interval)list.get(i);
            if (interval.start < f && interval.end < f) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Interval>();
                }
                arrayList.add(interval);
                f2 = f2 < interval.start ? f2 : interval.start;
                f3 = f3 > interval.end ? f3 : interval.end;
                continue;
            }
            if (interval.start > f && interval.end > f) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Interval>();
                }
                arrayList2.add(interval);
                f4 = f4 < interval.start ? f4 : interval.start;
                f5 = f5 > interval.end ? f5 : interval.end;
                continue;
            }
            if (arrayList3 == null || arrayList4 == null) {
                arrayList3 = new ArrayList<Interval>();
                arrayList4 = new ArrayList<Interval>();
            }
            f6 = interval.start < f6 ? interval.start : f6;
            f7 = interval.end > f7 ? interval.end : f7;
            arrayList3.add(interval);
            arrayList4.add(interval);
        }
        if (arrayList3 != null) {
            Collections.sort(arrayList3, byStartComparator);
            Collections.sort(arrayList4, byEndComparator);
        }
        IntervalTreeNode intervalTreeNode = new IntervalTreeNode();
        intervalTreeNode.byBeginning = arrayList3;
        intervalTreeNode.byEnding = arrayList4;
        intervalTreeNode.center = f;
        if (arrayList != null) {
            intervalTreeNode.left = this.buildNode(arrayList, (f2 + f3) / 2.0f);
            intervalTreeNode.left.childrenMinMax = f3;
        }
        if (arrayList2 != null) {
            intervalTreeNode.right = this.buildNode(arrayList2, (f4 + f5) / 2.0f);
            intervalTreeNode.right.childrenMinMax = f4;
        }
        return intervalTreeNode;
    }

    private void preprocess(int n, int[] nArray) {
        Interval interval;
        float f;
        float f2;
        float f3;
        int n2 = 0;
        this.minY = 1.0E38f;
        this.minX = 1.0E38f;
        this.maxY = -1.0E38f;
        this.maxX = -1.0E38f;
        ArrayList<Interval> arrayList = new ArrayList<Interval>(n);
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < n) {
            if (nArray != null && nArray.length > n4 && nArray[n4] == n5) {
                f3 = this.verticesXY[2 * (n5 - 1) + 1];
                f2 = this.verticesXY[2 * n3 + 1];
                Interval interval2 = new Interval();
                interval2.start = f3 < f2 ? f3 : f2;
                interval2.end = f2 > f3 ? f2 : f3;
                interval2.i = n5 - 1;
                interval2.j = n3;
                interval2.polyIndex = n4++;
                arrayList.add(interval2);
                n3 = n5++;
                n2 = n5 - 1;
            }
            f3 = this.verticesXY[2 * n5 + 1];
            f2 = this.verticesXY[2 * n5 + 0];
            f = this.verticesXY[2 * n2 + 1];
            this.minX = f2 < this.minX ? f2 : this.minX;
            this.minY = f3 < this.minY ? f3 : this.minY;
            this.maxX = f2 > this.maxX ? f2 : this.maxX;
            this.maxY = f3 > this.maxY ? f3 : this.maxY;
            interval = new Interval();
            interval.start = f3 < f ? f3 : f;
            interval.end = f > f3 ? f : f3;
            interval.i = n5;
            interval.j = n2;
            interval.polyIndex = n4;
            arrayList.add(interval);
            n2 = n5++;
        }
        f3 = this.verticesXY[2 * (n5 - 1) + 1];
        f2 = this.verticesXY[2 * (n5 - 1) + 0];
        f = this.verticesXY[2 * n3 + 1];
        this.minX = f2 < this.minX ? f2 : this.minX;
        this.minY = f3 < this.minY ? f3 : this.minY;
        this.maxX = f2 > this.maxX ? f2 : this.maxX;
        this.maxY = f3 > this.maxY ? f3 : this.maxY;
        interval = new Interval();
        interval.start = f3 < f ? f3 : f;
        interval.end = f > f3 ? f : f3;
        interval.i = n5 - 1;
        interval.j = n3;
        interval.polyIndex = n4;
        arrayList.add(interval);
        this.centerX = (this.maxX + this.minX) * 0.5f;
        this.centerY = (this.maxY + this.minY) * 0.5f;
        float f4 = this.maxX - this.centerX;
        float f5 = this.maxY - this.centerY;
        this.radiusSquared = f4 * f4 + f5 * f5;
        this.tree = this.buildNode(arrayList, this.centerY);
    }

    public boolean testPoint(float f, float f2) {
        return this.testPoint(f, f2, null);
    }

    public boolean testPoint(float f, float f2, BitSet bitSet) {
        float f3 = f - this.centerX;
        float f4 = f2 - this.centerY;
        if (bitSet != null) {
            bitSet.clear();
        }
        if (f3 * f3 + f4 * f4 > this.radiusSquared) {
            return false;
        }
        if (this.maxX < f || this.maxY < f2 || this.minX > f || this.minY > f2) {
            return false;
        }
        boolean bl = this.tree.traverse(this.verticesXY, f, f2, false, bitSet);
        return bl;
    }

    static class Interval {
        float start;
        float end;
        int i;
        int j;
        int polyIndex;

        Interval() {
        }
    }

    static class ByStartComparator
    implements Comparator {
        ByStartComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            return Float.compare(interval.start, interval2.start);
        }
    }

    static class ByEndComparator
    implements Comparator {
        ByEndComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            return Float.compare(interval2.end, interval.end);
        }
    }

    static class IntervalTreeNode {
        float center;
        float childrenMinMax;
        IntervalTreeNode left;
        IntervalTreeNode right;
        List byBeginning;
        List byEnding;

        IntervalTreeNode() {
        }

        static boolean computeEvenOdd(float[] fArray, Interval interval, float f, float f2, boolean bl, BitSet bitSet) {
            float f3;
            boolean bl2 = bl;
            int n = interval.i;
            int n2 = interval.j;
            float f4 = fArray[2 * n + 1];
            float f5 = fArray[2 * n2 + 1];
            float f6 = fArray[2 * n + 0];
            float f7 = fArray[2 * n2 + 0];
            if ((f4 < f2 && f5 >= f2 || f5 < f2 && f4 >= f2) && (f6 <= f || f7 <= f) && (bl2 ^= (f3 = f6 + (f2 - f4) / (f5 - f4) * (f7 - f6) - f) < 0.0f) != bl && bitSet != null) {
                bitSet.flip(interval.polyIndex);
            }
            return bl2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean traverse(float[] fArray, float f, float f2, boolean bl, BitSet bitSet) {
            boolean bl2 = bl;
            if (f2 == this.center && this.byBeginning != null) {
                int n = this.byBeginning.size();
                for (int i = 0; i < n; ++i) {
                    Interval interval = (Interval)this.byBeginning.get(i);
                    bl2 = IntervalTreeNode.computeEvenOdd(fArray, interval, f, f2, bl2, bitSet);
                }
                return bl2;
            } else if (f2 < this.center) {
                if (this.left != null && this.left.childrenMinMax >= f2) {
                    bl2 = this.left.traverse(fArray, f, f2, bl2, bitSet);
                }
                if (this.byBeginning == null) return bl2;
                int n = this.byBeginning.size();
                for (int i = 0; i < n; ++i) {
                    Interval interval = (Interval)this.byBeginning.get(i);
                    if (interval.start > f2) return bl2;
                    bl2 = IntervalTreeNode.computeEvenOdd(fArray, interval, f, f2, bl2, bitSet);
                }
                return bl2;
            } else {
                if (!(f2 > this.center)) return bl2;
                if (this.right != null && this.right.childrenMinMax <= f2) {
                    bl2 = this.right.traverse(fArray, f, f2, bl2, bitSet);
                }
                if (this.byEnding == null) return bl2;
                int n = this.byEnding.size();
                for (int i = 0; i < n; ++i) {
                    Interval interval = (Interval)this.byEnding.get(i);
                    if (interval.end < f2) return bl2;
                    bl2 = IntervalTreeNode.computeEvenOdd(fArray, interval, f, f2, bl2, bitSet);
                }
            }
            return bl2;
        }
    }
}

