/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.ConfigurationException;
import org.joml.Matrix2d;
import org.joml.Matrix2f;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix3x2d;
import org.joml.Matrix3x2f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3f;
import org.joml.Options;
import org.joml.Quaternionf;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import sun.misc.Unsafe;

abstract class MemUtil {
    public static final MemUtil INSTANCE = MemUtil.createInstance();

    MemUtil() {
    }

    private static MemUtil createInstance() {
        MemUtilNIO memUtilNIO;
        try {
            if (Options.NO_UNSAFE && Options.FORCE_UNSAFE) {
                throw new ConfigurationException("Cannot enable both -Djoml.nounsafe and -Djoml.forceUnsafe", null);
            }
            memUtilNIO = Options.NO_UNSAFE ? new MemUtilNIO() : new MemUtilUnsafe();
        }
        catch (Throwable throwable) {
            if (Options.FORCE_UNSAFE) {
                throw new ConfigurationException("Unsafe is not supported but its use was forced via -Djoml.forceUnsafe", throwable);
            }
            memUtilNIO = new MemUtilNIO();
        }
        return memUtilNIO;
    }

    public abstract void put(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put4x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void put4x4(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void put4x4(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void put4x4(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void put3x3(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void put3x3(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void put3x3(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void put3x3(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void put4x3(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put4x3(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put3x4(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put3x4(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put3x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put3x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put3x4(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void put3x4(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put4x3Transposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put4x3Transposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix2f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix2f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void put4x3Transposed(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void put4x3Transposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix2d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix2d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix2f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix2f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix2d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix2d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector4d var1, int var2, FloatBuffer var3);

    public abstract void put(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void putf(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector4f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4i var1, int var2, IntBuffer var3);

    public abstract void put(Vector4i var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector3f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector3d var1, int var2, FloatBuffer var3);

    public abstract void put(Vector3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Vector3d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3i var1, int var2, IntBuffer var3);

    public abstract void put(Vector3i var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector2f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector2d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2i var1, int var2, IntBuffer var3);

    public abstract void put(Vector2i var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void getTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void getTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix2f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix2f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix2d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix2d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector4f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4i var1, int var2, IntBuffer var3);

    public abstract void get(Vector4i var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector3f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector3d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3i var1, int var2, IntBuffer var3);

    public abstract void get(Vector3i var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector2f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector2d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2i var1, int var2, IntBuffer var3);

    public abstract void get(Vector2i var1, int var2, ByteBuffer var3);

    public abstract void putMatrix3f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix3f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void putMatrix4f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix4f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void putMatrix4x3f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix4x3f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract float get(Matrix4f var1, int var2, int var3);

    public abstract Matrix4f set(Matrix4f var1, int var2, int var3, float var4);

    public abstract double get(Matrix4d var1, int var2, int var3);

    public abstract Matrix4d set(Matrix4d var1, int var2, int var3, double var4);

    public abstract float get(Matrix3f var1, int var2, int var3);

    public abstract Matrix3f set(Matrix3f var1, int var2, int var3, float var4);

    public abstract double get(Matrix3d var1, int var2, int var3);

    public abstract Matrix3d set(Matrix3d var1, int var2, int var3, double var4);

    public abstract Vector4f getColumn(Matrix4f var1, int var2, Vector4f var3);

    public abstract Matrix4f setColumn(Vector4f var1, int var2, Matrix4f var3);

    public abstract Matrix4f setColumn(Vector4fc var1, int var2, Matrix4f var3);

    public abstract void copy(Matrix4f var1, Matrix4f var2);

    public abstract void copy(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void copy(Matrix4f var1, Matrix4x3f var2);

    public abstract void copy(Matrix4x3f var1, Matrix4f var2);

    public abstract void copy(Matrix3f var1, Matrix3f var2);

    public abstract void copy(Matrix3f var1, Matrix4f var2);

    public abstract void copy(Matrix4f var1, Matrix3f var2);

    public abstract void copy(Matrix3f var1, Matrix4x3f var2);

    public abstract void copy(Matrix3x2f var1, Matrix3x2f var2);

    public abstract void copy(Matrix3x2d var1, Matrix3x2d var2);

    public abstract void copy(Matrix2f var1, Matrix2f var2);

    public abstract void copy(Matrix2d var1, Matrix2d var2);

    public abstract void copy(Matrix2f var1, Matrix3f var2);

    public abstract void copy(Matrix3f var1, Matrix2f var2);

    public abstract void copy(Matrix2f var1, Matrix3x2f var2);

    public abstract void copy(Matrix3x2f var1, Matrix2f var2);

    public abstract void copy(Matrix2d var1, Matrix3d var2);

    public abstract void copy(Matrix3d var1, Matrix2d var2);

    public abstract void copy(Matrix2d var1, Matrix3x2d var2);

    public abstract void copy(Matrix3x2d var1, Matrix2d var2);

    public abstract void copy3x3(Matrix4f var1, Matrix4f var2);

    public abstract void copy3x3(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix3f var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix3f var1, Matrix4f var2);

    public abstract void copy4x3(Matrix4f var1, Matrix4f var2);

    public abstract void copy4x3(Matrix4x3f var1, Matrix4f var2);

    public abstract void copy(float[] var1, int var2, Matrix4f var3);

    public abstract void copyTransposed(float[] var1, int var2, Matrix4f var3);

    public abstract void copy(float[] var1, int var2, Matrix3f var3);

    public abstract void copy(float[] var1, int var2, Matrix4x3f var3);

    public abstract void copy(float[] var1, int var2, Matrix3x2f var3);

    public abstract void copy(double[] var1, int var2, Matrix3x2d var3);

    public abstract void copy(float[] var1, int var2, Matrix2f var3);

    public abstract void copy(double[] var1, int var2, Matrix2d var3);

    public abstract void copy(Matrix4f var1, float[] var2, int var3);

    public abstract void copy(Matrix3f var1, float[] var2, int var3);

    public abstract void copy(Matrix4x3f var1, float[] var2, int var3);

    public abstract void copy(Matrix3x2f var1, float[] var2, int var3);

    public abstract void copy(Matrix3x2d var1, double[] var2, int var3);

    public abstract void copy(Matrix2f var1, float[] var2, int var3);

    public abstract void copy(Matrix2d var1, double[] var2, int var3);

    public abstract void copy4x4(Matrix4x3f var1, float[] var2, int var3);

    public abstract void copy4x4(Matrix4x3d var1, float[] var2, int var3);

    public abstract void copy4x4(Matrix4x3d var1, double[] var2, int var3);

    public abstract void copy4x4(Matrix3x2f var1, float[] var2, int var3);

    public abstract void copy4x4(Matrix3x2d var1, double[] var2, int var3);

    public abstract void copy3x3(Matrix3x2f var1, float[] var2, int var3);

    public abstract void copy3x3(Matrix3x2d var1, double[] var2, int var3);

    public abstract void identity(Matrix4f var1);

    public abstract void identity(Matrix4x3f var1);

    public abstract void identity(Matrix3f var1);

    public abstract void identity(Matrix3x2f var1);

    public abstract void identity(Matrix3x2d var1);

    public abstract void identity(Matrix2f var1);

    public abstract void swap(Matrix4f var1, Matrix4f var2);

    public abstract void swap(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void swap(Matrix3f var1, Matrix3f var2);

    public abstract void swap(Matrix2f var1, Matrix2f var2);

    public abstract void swap(Matrix2d var1, Matrix2d var2);

    public abstract void zero(Matrix4f var1);

    public abstract void zero(Matrix4x3f var1);

    public abstract void zero(Matrix3f var1);

    public abstract void zero(Matrix3x2f var1);

    public abstract void zero(Matrix3x2d var1);

    public abstract void zero(Matrix2f var1);

    public abstract void zero(Matrix2d var1);

    public static class MemUtilNIO
    extends MemUtil {
        public void put0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m01()).put(2, matrix4f.m02()).put(3, matrix4f.m03()).put(4, matrix4f.m10()).put(5, matrix4f.m11()).put(6, matrix4f.m12()).put(7, matrix4f.m13()).put(8, matrix4f.m20()).put(9, matrix4f.m21()).put(10, matrix4f.m22()).put(11, matrix4f.m23()).put(12, matrix4f.m30()).put(13, matrix4f.m31()).put(14, matrix4f.m32()).put(15, matrix4f.m33());
        }

        public void putN(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4f.m00()).put(n + 1, matrix4f.m01()).put(n + 2, matrix4f.m02()).put(n + 3, matrix4f.m03()).put(n + 4, matrix4f.m10()).put(n + 5, matrix4f.m11()).put(n + 6, matrix4f.m12()).put(n + 7, matrix4f.m13()).put(n + 8, matrix4f.m20()).put(n + 9, matrix4f.m21()).put(n + 10, matrix4f.m22()).put(n + 11, matrix4f.m23()).put(n + 12, matrix4f.m30()).put(n + 13, matrix4f.m31()).put(n + 14, matrix4f.m32()).put(n + 15, matrix4f.m33());
        }

        @Override
        public void put(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put0(matrix4f, floatBuffer);
            } else {
                this.putN(matrix4f, n, floatBuffer);
            }
        }

        public void put0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m01()).putFloat(8, matrix4f.m02()).putFloat(12, matrix4f.m03()).putFloat(16, matrix4f.m10()).putFloat(20, matrix4f.m11()).putFloat(24, matrix4f.m12()).putFloat(28, matrix4f.m13()).putFloat(32, matrix4f.m20()).putFloat(36, matrix4f.m21()).putFloat(40, matrix4f.m22()).putFloat(44, matrix4f.m23()).putFloat(48, matrix4f.m30()).putFloat(52, matrix4f.m31()).putFloat(56, matrix4f.m32()).putFloat(60, matrix4f.m33());
        }

        private void putN(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4f.m00()).putFloat(n + 4, matrix4f.m01()).putFloat(n + 8, matrix4f.m02()).putFloat(n + 12, matrix4f.m03()).putFloat(n + 16, matrix4f.m10()).putFloat(n + 20, matrix4f.m11()).putFloat(n + 24, matrix4f.m12()).putFloat(n + 28, matrix4f.m13()).putFloat(n + 32, matrix4f.m20()).putFloat(n + 36, matrix4f.m21()).putFloat(n + 40, matrix4f.m22()).putFloat(n + 44, matrix4f.m23()).putFloat(n + 48, matrix4f.m30()).putFloat(n + 52, matrix4f.m31()).putFloat(n + 56, matrix4f.m32()).putFloat(n + 60, matrix4f.m33());
        }

        @Override
        public void put(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put0(matrix4f, byteBuffer);
            } else {
                this.putN(matrix4f, n, byteBuffer);
            }
        }

        public void put4x3_0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m01()).put(2, matrix4f.m02()).put(3, matrix4f.m10()).put(4, matrix4f.m11()).put(5, matrix4f.m12()).put(6, matrix4f.m20()).put(7, matrix4f.m21()).put(8, matrix4f.m22()).put(9, matrix4f.m30()).put(10, matrix4f.m31()).put(11, matrix4f.m32());
        }

        public void put4x3_N(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4f.m00()).put(n + 1, matrix4f.m01()).put(n + 2, matrix4f.m02()).put(n + 3, matrix4f.m10()).put(n + 4, matrix4f.m11()).put(n + 5, matrix4f.m12()).put(n + 6, matrix4f.m20()).put(n + 7, matrix4f.m21()).put(n + 8, matrix4f.m22()).put(n + 9, matrix4f.m30()).put(n + 10, matrix4f.m31()).put(n + 11, matrix4f.m32());
        }

        @Override
        public void put4x3(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put4x3_0(matrix4f, floatBuffer);
            } else {
                this.put4x3_N(matrix4f, n, floatBuffer);
            }
        }

        public void put4x3_0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m01()).putFloat(8, matrix4f.m02()).putFloat(12, matrix4f.m10()).putFloat(16, matrix4f.m11()).putFloat(20, matrix4f.m12()).putFloat(24, matrix4f.m20()).putFloat(28, matrix4f.m21()).putFloat(32, matrix4f.m22()).putFloat(36, matrix4f.m30()).putFloat(40, matrix4f.m31()).putFloat(44, matrix4f.m32());
        }

        private void put4x3_N(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4f.m00()).putFloat(n + 4, matrix4f.m01()).putFloat(n + 8, matrix4f.m02()).putFloat(n + 12, matrix4f.m10()).putFloat(n + 16, matrix4f.m11()).putFloat(n + 20, matrix4f.m12()).putFloat(n + 24, matrix4f.m20()).putFloat(n + 28, matrix4f.m21()).putFloat(n + 32, matrix4f.m22()).putFloat(n + 36, matrix4f.m30()).putFloat(n + 40, matrix4f.m31()).putFloat(n + 44, matrix4f.m32());
        }

        @Override
        public void put4x3(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put4x3_0(matrix4f, byteBuffer);
            } else {
                this.put4x3_N(matrix4f, n, byteBuffer);
            }
        }

        public void put3x4_0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m01()).putFloat(8, matrix4f.m02()).putFloat(12, matrix4f.m03()).putFloat(16, matrix4f.m10()).putFloat(20, matrix4f.m11()).putFloat(24, matrix4f.m12()).putFloat(28, matrix4f.m13()).putFloat(32, matrix4f.m20()).putFloat(36, matrix4f.m21()).putFloat(40, matrix4f.m22()).putFloat(44, matrix4f.m23());
        }

        private void put3x4_N(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4f.m00()).putFloat(n + 4, matrix4f.m01()).putFloat(n + 8, matrix4f.m02()).putFloat(n + 12, matrix4f.m03()).putFloat(n + 16, matrix4f.m10()).putFloat(n + 20, matrix4f.m11()).putFloat(n + 24, matrix4f.m12()).putFloat(n + 28, matrix4f.m13()).putFloat(n + 32, matrix4f.m20()).putFloat(n + 36, matrix4f.m21()).putFloat(n + 40, matrix4f.m22()).putFloat(n + 44, matrix4f.m23());
        }

        @Override
        public void put3x4(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put3x4_0(matrix4f, byteBuffer);
            } else {
                this.put3x4_N(matrix4f, n, byteBuffer);
            }
        }

        public void put3x4_0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m01()).put(2, matrix4f.m02()).put(3, matrix4f.m03()).put(4, matrix4f.m10()).put(5, matrix4f.m11()).put(6, matrix4f.m12()).put(7, matrix4f.m13()).put(8, matrix4f.m20()).put(9, matrix4f.m21()).put(10, matrix4f.m22()).put(11, matrix4f.m23());
        }

        public void put3x4_N(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4f.m00()).put(n + 1, matrix4f.m01()).put(n + 2, matrix4f.m02()).put(n + 3, matrix4f.m03()).put(n + 4, matrix4f.m10()).put(n + 5, matrix4f.m11()).put(n + 6, matrix4f.m12()).put(n + 7, matrix4f.m13()).put(n + 8, matrix4f.m20()).put(n + 9, matrix4f.m21()).put(n + 10, matrix4f.m22()).put(n + 11, matrix4f.m23());
        }

        @Override
        public void put3x4(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put3x4_0(matrix4f, floatBuffer);
            } else {
                this.put3x4_N(matrix4f, n, floatBuffer);
            }
        }

        public void put3x4_0(Matrix4x3f matrix4x3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4x3f.m00()).putFloat(4, matrix4x3f.m01()).putFloat(8, matrix4x3f.m02()).putFloat(12, 0.0f).putFloat(16, matrix4x3f.m10()).putFloat(20, matrix4x3f.m11()).putFloat(24, matrix4x3f.m12()).putFloat(28, 0.0f).putFloat(32, matrix4x3f.m20()).putFloat(36, matrix4x3f.m21()).putFloat(40, matrix4x3f.m22()).putFloat(44, 0.0f);
        }

        private void put3x4_N(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4x3f.m00()).putFloat(n + 4, matrix4x3f.m01()).putFloat(n + 8, matrix4x3f.m02()).putFloat(n + 12, 0.0f).putFloat(n + 16, matrix4x3f.m10()).putFloat(n + 20, matrix4x3f.m11()).putFloat(n + 24, matrix4x3f.m12()).putFloat(n + 28, 0.0f).putFloat(n + 32, matrix4x3f.m20()).putFloat(n + 36, matrix4x3f.m21()).putFloat(n + 40, matrix4x3f.m22()).putFloat(n + 44, 0.0f);
        }

        @Override
        public void put3x4(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put3x4_0(matrix4x3f, byteBuffer);
            } else {
                this.put3x4_N(matrix4x3f, n, byteBuffer);
            }
        }

        public void put3x4_0(Matrix4x3f matrix4x3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4x3f.m00()).put(1, matrix4x3f.m01()).put(2, matrix4x3f.m02()).put(3, 0.0f).put(4, matrix4x3f.m10()).put(5, matrix4x3f.m11()).put(6, matrix4x3f.m12()).put(7, 0.0f).put(8, matrix4x3f.m20()).put(9, matrix4x3f.m21()).put(10, matrix4x3f.m22()).put(11, 0.0f);
        }

        public void put3x4_N(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4x3f.m00()).put(n + 1, matrix4x3f.m01()).put(n + 2, matrix4x3f.m02()).put(n + 3, 0.0f).put(n + 4, matrix4x3f.m10()).put(n + 5, matrix4x3f.m11()).put(n + 6, matrix4x3f.m12()).put(n + 7, 0.0f).put(n + 8, matrix4x3f.m20()).put(n + 9, matrix4x3f.m21()).put(n + 10, matrix4x3f.m22()).put(n + 11, 0.0f);
        }

        @Override
        public void put3x4(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put3x4_0(matrix4x3f, floatBuffer);
            } else {
                this.put3x4_N(matrix4x3f, n, floatBuffer);
            }
        }

        public void put0(Matrix4x3f matrix4x3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4x3f.m00()).put(1, matrix4x3f.m01()).put(2, matrix4x3f.m02()).put(3, matrix4x3f.m10()).put(4, matrix4x3f.m11()).put(5, matrix4x3f.m12()).put(6, matrix4x3f.m20()).put(7, matrix4x3f.m21()).put(8, matrix4x3f.m22()).put(9, matrix4x3f.m30()).put(10, matrix4x3f.m31()).put(11, matrix4x3f.m32());
        }

        public void putN(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4x3f.m00()).put(n + 1, matrix4x3f.m01()).put(n + 2, matrix4x3f.m02()).put(n + 3, matrix4x3f.m10()).put(n + 4, matrix4x3f.m11()).put(n + 5, matrix4x3f.m12()).put(n + 6, matrix4x3f.m20()).put(n + 7, matrix4x3f.m21()).put(n + 8, matrix4x3f.m22()).put(n + 9, matrix4x3f.m30()).put(n + 10, matrix4x3f.m31()).put(n + 11, matrix4x3f.m32());
        }

        @Override
        public void put(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put0(matrix4x3f, floatBuffer);
            } else {
                this.putN(matrix4x3f, n, floatBuffer);
            }
        }

        public void put0(Matrix4x3f matrix4x3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4x3f.m00()).putFloat(4, matrix4x3f.m01()).putFloat(8, matrix4x3f.m02()).putFloat(12, matrix4x3f.m10()).putFloat(16, matrix4x3f.m11()).putFloat(20, matrix4x3f.m12()).putFloat(24, matrix4x3f.m20()).putFloat(28, matrix4x3f.m21()).putFloat(32, matrix4x3f.m22()).putFloat(36, matrix4x3f.m30()).putFloat(40, matrix4x3f.m31()).putFloat(44, matrix4x3f.m32());
        }

        public void putN(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4x3f.m00()).putFloat(n + 4, matrix4x3f.m01()).putFloat(n + 8, matrix4x3f.m02()).putFloat(n + 12, matrix4x3f.m10()).putFloat(n + 16, matrix4x3f.m11()).putFloat(n + 20, matrix4x3f.m12()).putFloat(n + 24, matrix4x3f.m20()).putFloat(n + 28, matrix4x3f.m21()).putFloat(n + 32, matrix4x3f.m22()).putFloat(n + 36, matrix4x3f.m30()).putFloat(n + 40, matrix4x3f.m31()).putFloat(n + 44, matrix4x3f.m32());
        }

        @Override
        public void put(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put0(matrix4x3f, byteBuffer);
            } else {
                this.putN(matrix4x3f, n, byteBuffer);
            }
        }

        @Override
        public void put4x4(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4x3f.m00()).put(n + 1, matrix4x3f.m01()).put(n + 2, matrix4x3f.m02()).put(n + 3, 0.0f).put(n + 4, matrix4x3f.m10()).put(n + 5, matrix4x3f.m11()).put(n + 6, matrix4x3f.m12()).put(n + 7, 0.0f).put(n + 8, matrix4x3f.m20()).put(n + 9, matrix4x3f.m21()).put(n + 10, matrix4x3f.m22()).put(n + 11, 0.0f).put(n + 12, matrix4x3f.m30()).put(n + 13, matrix4x3f.m31()).put(n + 14, matrix4x3f.m32()).put(n + 15, 1.0f);
        }

        @Override
        public void put4x4(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4x3f.m00()).putFloat(n + 4, matrix4x3f.m01()).putFloat(n + 8, matrix4x3f.m02()).putFloat(n + 12, 0.0f).putFloat(n + 16, matrix4x3f.m10()).putFloat(n + 20, matrix4x3f.m11()).putFloat(n + 24, matrix4x3f.m12()).putFloat(n + 28, 0.0f).putFloat(n + 32, matrix4x3f.m20()).putFloat(n + 36, matrix4x3f.m21()).putFloat(n + 40, matrix4x3f.m22()).putFloat(n + 44, 0.0f).putFloat(n + 48, matrix4x3f.m30()).putFloat(n + 52, matrix4x3f.m31()).putFloat(n + 56, matrix4x3f.m32()).putFloat(n + 60, 1.0f);
        }

        @Override
        public void put4x4(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix4x3d.m00()).put(n + 1, matrix4x3d.m01()).put(n + 2, matrix4x3d.m02()).put(n + 3, 0.0).put(n + 4, matrix4x3d.m10()).put(n + 5, matrix4x3d.m11()).put(n + 6, matrix4x3d.m12()).put(n + 7, 0.0).put(n + 8, matrix4x3d.m20()).put(n + 9, matrix4x3d.m21()).put(n + 10, matrix4x3d.m22()).put(n + 11, 0.0).put(n + 12, matrix4x3d.m30()).put(n + 13, matrix4x3d.m31()).put(n + 14, matrix4x3d.m32()).put(n + 15, 1.0);
        }

        @Override
        public void put4x4(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix4x3d.m00()).putDouble(n + 8, matrix4x3d.m01()).putDouble(n + 16, matrix4x3d.m02()).putDouble(n + 24, 0.0).putDouble(n + 32, matrix4x3d.m10()).putDouble(n + 40, matrix4x3d.m11()).putDouble(n + 48, matrix4x3d.m12()).putDouble(n + 56, 0.0).putDouble(n + 64, matrix4x3d.m20()).putDouble(n + 72, matrix4x3d.m21()).putDouble(n + 80, matrix4x3d.m22()).putDouble(n + 88, 0.0).putDouble(n + 96, matrix4x3d.m30()).putDouble(n + 104, matrix4x3d.m31()).putDouble(n + 112, matrix4x3d.m32()).putDouble(n + 120, 1.0);
        }

        @Override
        public void put4x4(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix3x2f.m00()).put(n + 1, matrix3x2f.m01()).put(n + 2, 0.0f).put(n + 3, 0.0f).put(n + 4, matrix3x2f.m10()).put(n + 5, matrix3x2f.m11()).put(n + 6, 0.0f).put(n + 7, 0.0f).put(n + 8, 0.0f).put(n + 9, 0.0f).put(n + 10, 1.0f).put(n + 11, 0.0f).put(n + 12, matrix3x2f.m20()).put(n + 13, matrix3x2f.m21()).put(n + 14, 0.0f).put(n + 15, 1.0f);
        }

        @Override
        public void put4x4(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix3x2f.m00()).putFloat(n + 4, matrix3x2f.m01()).putFloat(n + 8, 0.0f).putFloat(n + 12, 0.0f).putFloat(n + 16, matrix3x2f.m10()).putFloat(n + 20, matrix3x2f.m11()).putFloat(n + 24, 0.0f).putFloat(n + 28, 0.0f).putFloat(n + 32, 0.0f).putFloat(n + 36, 0.0f).putFloat(n + 40, 1.0f).putFloat(n + 44, 0.0f).putFloat(n + 48, matrix3x2f.m20()).putFloat(n + 52, matrix3x2f.m21()).putFloat(n + 56, 0.0f).putFloat(n + 60, 1.0f);
        }

        @Override
        public void put4x4(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix3x2d.m00()).put(n + 1, matrix3x2d.m01()).put(n + 2, 0.0).put(n + 3, 0.0).put(n + 4, matrix3x2d.m10()).put(n + 5, matrix3x2d.m11()).put(n + 6, 0.0).put(n + 7, 0.0).put(n + 8, 0.0).put(n + 9, 0.0).put(n + 10, 1.0).put(n + 11, 0.0).put(n + 12, matrix3x2d.m20()).put(n + 13, matrix3x2d.m21()).put(n + 14, 0.0).put(n + 15, 1.0);
        }

        @Override
        public void put4x4(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix3x2d.m00()).putDouble(n + 8, matrix3x2d.m01()).putDouble(n + 16, 0.0).putDouble(n + 24, 0.0).putDouble(n + 32, matrix3x2d.m10()).putDouble(n + 40, matrix3x2d.m11()).putDouble(n + 48, 0.0).putDouble(n + 56, 0.0).putDouble(n + 64, 0.0).putDouble(n + 72, 0.0).putDouble(n + 80, 1.0).putDouble(n + 88, 0.0).putDouble(n + 96, matrix3x2d.m20()).putDouble(n + 104, matrix3x2d.m21()).putDouble(n + 112, 0.0).putDouble(n + 120, 1.0);
        }

        @Override
        public void put3x3(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix3x2f.m00()).put(n + 1, matrix3x2f.m01()).put(n + 2, 0.0f).put(n + 3, matrix3x2f.m10()).put(n + 4, matrix3x2f.m11()).put(n + 5, 0.0f).put(n + 6, matrix3x2f.m20()).put(n + 7, matrix3x2f.m21()).put(n + 8, 1.0f);
        }

        @Override
        public void put3x3(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix3x2f.m00()).putFloat(n + 4, matrix3x2f.m01()).putFloat(n + 8, 0.0f).putFloat(n + 12, matrix3x2f.m10()).putFloat(n + 16, matrix3x2f.m11()).putFloat(n + 20, 0.0f).putFloat(n + 24, matrix3x2f.m20()).putFloat(n + 28, matrix3x2f.m21()).putFloat(n + 32, 1.0f);
        }

        @Override
        public void put3x3(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix3x2d.m00()).put(n + 1, matrix3x2d.m01()).put(n + 2, 0.0).put(n + 3, matrix3x2d.m10()).put(n + 4, matrix3x2d.m11()).put(n + 5, 0.0).put(n + 6, matrix3x2d.m20()).put(n + 7, matrix3x2d.m21()).put(n + 8, 1.0);
        }

        @Override
        public void put3x3(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix3x2d.m00()).putDouble(n + 8, matrix3x2d.m01()).putDouble(n + 16, 0.0).putDouble(n + 24, matrix3x2d.m10()).putDouble(n + 32, matrix3x2d.m11()).putDouble(n + 40, 0.0).putDouble(n + 48, matrix3x2d.m20()).putDouble(n + 56, matrix3x2d.m21()).putDouble(n + 64, 1.0);
        }

        private void putTransposedN(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4f.m00()).put(n + 1, matrix4f.m10()).put(n + 2, matrix4f.m20()).put(n + 3, matrix4f.m30()).put(n + 4, matrix4f.m01()).put(n + 5, matrix4f.m11()).put(n + 6, matrix4f.m21()).put(n + 7, matrix4f.m31()).put(n + 8, matrix4f.m02()).put(n + 9, matrix4f.m12()).put(n + 10, matrix4f.m22()).put(n + 11, matrix4f.m32()).put(n + 12, matrix4f.m03()).put(n + 13, matrix4f.m13()).put(n + 14, matrix4f.m23()).put(n + 15, matrix4f.m33());
        }

        private void putTransposed0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m10()).put(2, matrix4f.m20()).put(3, matrix4f.m30()).put(4, matrix4f.m01()).put(5, matrix4f.m11()).put(6, matrix4f.m21()).put(7, matrix4f.m31()).put(8, matrix4f.m02()).put(9, matrix4f.m12()).put(10, matrix4f.m22()).put(11, matrix4f.m32()).put(12, matrix4f.m03()).put(13, matrix4f.m13()).put(14, matrix4f.m23()).put(15, matrix4f.m33());
        }

        @Override
        public void putTransposed(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.putTransposed0(matrix4f, floatBuffer);
            } else {
                this.putTransposedN(matrix4f, n, floatBuffer);
            }
        }

        private void putTransposedN(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4f.m00()).putFloat(n + 4, matrix4f.m10()).putFloat(n + 8, matrix4f.m20()).putFloat(n + 12, matrix4f.m30()).putFloat(n + 16, matrix4f.m01()).putFloat(n + 20, matrix4f.m11()).putFloat(n + 24, matrix4f.m21()).putFloat(n + 28, matrix4f.m31()).putFloat(n + 32, matrix4f.m02()).putFloat(n + 36, matrix4f.m12()).putFloat(n + 40, matrix4f.m22()).putFloat(n + 44, matrix4f.m32()).putFloat(n + 48, matrix4f.m03()).putFloat(n + 52, matrix4f.m13()).putFloat(n + 56, matrix4f.m23()).putFloat(n + 60, matrix4f.m33());
        }

        private void putTransposed0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m10()).putFloat(8, matrix4f.m20()).putFloat(12, matrix4f.m30()).putFloat(16, matrix4f.m01()).putFloat(20, matrix4f.m11()).putFloat(24, matrix4f.m21()).putFloat(28, matrix4f.m31()).putFloat(32, matrix4f.m02()).putFloat(36, matrix4f.m12()).putFloat(40, matrix4f.m22()).putFloat(44, matrix4f.m32()).putFloat(48, matrix4f.m03()).putFloat(52, matrix4f.m13()).putFloat(56, matrix4f.m23()).putFloat(60, matrix4f.m33());
        }

        @Override
        public void putTransposed(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.putTransposed0(matrix4f, byteBuffer);
            } else {
                this.putTransposedN(matrix4f, n, byteBuffer);
            }
        }

        @Override
        public void put4x3Transposed(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4f.m00()).put(n + 1, matrix4f.m10()).put(n + 2, matrix4f.m20()).put(n + 3, matrix4f.m30()).put(n + 4, matrix4f.m01()).put(n + 5, matrix4f.m11()).put(n + 6, matrix4f.m21()).put(n + 7, matrix4f.m31()).put(n + 8, matrix4f.m02()).put(n + 9, matrix4f.m12()).put(n + 10, matrix4f.m22()).put(n + 11, matrix4f.m32());
        }

        @Override
        public void put4x3Transposed(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4f.m00()).putFloat(n + 4, matrix4f.m10()).putFloat(n + 8, matrix4f.m20()).putFloat(n + 12, matrix4f.m30()).putFloat(n + 16, matrix4f.m01()).putFloat(n + 20, matrix4f.m11()).putFloat(n + 24, matrix4f.m21()).putFloat(n + 28, matrix4f.m31()).putFloat(n + 32, matrix4f.m02()).putFloat(n + 36, matrix4f.m12()).putFloat(n + 40, matrix4f.m22()).putFloat(n + 44, matrix4f.m32());
        }

        @Override
        public void putTransposed(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix4x3f.m00()).put(n + 1, matrix4x3f.m10()).put(n + 2, matrix4x3f.m20()).put(n + 3, matrix4x3f.m30()).put(n + 4, matrix4x3f.m01()).put(n + 5, matrix4x3f.m11()).put(n + 6, matrix4x3f.m21()).put(n + 7, matrix4x3f.m31()).put(n + 8, matrix4x3f.m02()).put(n + 9, matrix4x3f.m12()).put(n + 10, matrix4x3f.m22()).put(n + 11, matrix4x3f.m32());
        }

        @Override
        public void putTransposed(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix4x3f.m00()).putFloat(n + 4, matrix4x3f.m10()).putFloat(n + 8, matrix4x3f.m20()).putFloat(n + 12, matrix4x3f.m30()).putFloat(n + 16, matrix4x3f.m01()).putFloat(n + 20, matrix4x3f.m11()).putFloat(n + 24, matrix4x3f.m21()).putFloat(n + 28, matrix4x3f.m31()).putFloat(n + 32, matrix4x3f.m02()).putFloat(n + 36, matrix4x3f.m12()).putFloat(n + 40, matrix4x3f.m22()).putFloat(n + 44, matrix4x3f.m32());
        }

        @Override
        public void putTransposed(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix3f.m00()).put(n + 1, matrix3f.m10()).put(n + 2, matrix3f.m20()).put(n + 3, matrix3f.m01()).put(n + 4, matrix3f.m11()).put(n + 5, matrix3f.m21()).put(n + 6, matrix3f.m02()).put(n + 7, matrix3f.m12()).put(n + 8, matrix3f.m22());
        }

        @Override
        public void putTransposed(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix3f.m00()).putFloat(n + 4, matrix3f.m10()).putFloat(n + 8, matrix3f.m20()).putFloat(n + 12, matrix3f.m01()).putFloat(n + 16, matrix3f.m11()).putFloat(n + 20, matrix3f.m21()).putFloat(n + 24, matrix3f.m02()).putFloat(n + 28, matrix3f.m12()).putFloat(n + 32, matrix3f.m22());
        }

        @Override
        public void putTransposed(Matrix2f matrix2f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix2f.m00()).put(n + 1, matrix2f.m10()).put(n + 2, matrix2f.m01()).put(n + 3, matrix2f.m11());
        }

        @Override
        public void putTransposed(Matrix2f matrix2f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix2f.m00()).putFloat(n + 4, matrix2f.m10()).putFloat(n + 8, matrix2f.m01()).putFloat(n + 12, matrix2f.m11());
        }

        @Override
        public void put(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix4d.m00()).put(n + 1, matrix4d.m01()).put(n + 2, matrix4d.m02()).put(n + 3, matrix4d.m03()).put(n + 4, matrix4d.m10()).put(n + 5, matrix4d.m11()).put(n + 6, matrix4d.m12()).put(n + 7, matrix4d.m13()).put(n + 8, matrix4d.m20()).put(n + 9, matrix4d.m21()).put(n + 10, matrix4d.m22()).put(n + 11, matrix4d.m23()).put(n + 12, matrix4d.m30()).put(n + 13, matrix4d.m31()).put(n + 14, matrix4d.m32()).put(n + 15, matrix4d.m33());
        }

        @Override
        public void put(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix4d.m00()).putDouble(n + 8, matrix4d.m01()).putDouble(n + 16, matrix4d.m02()).putDouble(n + 24, matrix4d.m03()).putDouble(n + 32, matrix4d.m10()).putDouble(n + 40, matrix4d.m11()).putDouble(n + 48, matrix4d.m12()).putDouble(n + 56, matrix4d.m13()).putDouble(n + 64, matrix4d.m20()).putDouble(n + 72, matrix4d.m21()).putDouble(n + 80, matrix4d.m22()).putDouble(n + 88, matrix4d.m23()).putDouble(n + 96, matrix4d.m30()).putDouble(n + 104, matrix4d.m31()).putDouble(n + 112, matrix4d.m32()).putDouble(n + 120, matrix4d.m33());
        }

        @Override
        public void put(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix4x3d.m00()).put(n + 1, matrix4x3d.m01()).put(n + 2, matrix4x3d.m02()).put(n + 3, matrix4x3d.m10()).put(n + 4, matrix4x3d.m11()).put(n + 5, matrix4x3d.m12()).put(n + 6, matrix4x3d.m20()).put(n + 7, matrix4x3d.m21()).put(n + 8, matrix4x3d.m22()).put(n + 9, matrix4x3d.m30()).put(n + 10, matrix4x3d.m31()).put(n + 11, matrix4x3d.m32());
        }

        @Override
        public void put(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix4x3d.m00()).putDouble(n + 8, matrix4x3d.m01()).putDouble(n + 16, matrix4x3d.m02()).putDouble(n + 24, matrix4x3d.m10()).putDouble(n + 32, matrix4x3d.m11()).putDouble(n + 40, matrix4x3d.m12()).putDouble(n + 48, matrix4x3d.m20()).putDouble(n + 56, matrix4x3d.m21()).putDouble(n + 64, matrix4x3d.m22()).putDouble(n + 72, matrix4x3d.m30()).putDouble(n + 80, matrix4x3d.m31()).putDouble(n + 88, matrix4x3d.m32());
        }

        @Override
        public void putf(Matrix4d matrix4d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix4d.m00()).put(n + 1, (float)matrix4d.m01()).put(n + 2, (float)matrix4d.m02()).put(n + 3, (float)matrix4d.m03()).put(n + 4, (float)matrix4d.m10()).put(n + 5, (float)matrix4d.m11()).put(n + 6, (float)matrix4d.m12()).put(n + 7, (float)matrix4d.m13()).put(n + 8, (float)matrix4d.m20()).put(n + 9, (float)matrix4d.m21()).put(n + 10, (float)matrix4d.m22()).put(n + 11, (float)matrix4d.m23()).put(n + 12, (float)matrix4d.m30()).put(n + 13, (float)matrix4d.m31()).put(n + 14, (float)matrix4d.m32()).put(n + 15, (float)matrix4d.m33());
        }

        @Override
        public void putf(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix4d.m00()).putFloat(n + 4, (float)matrix4d.m01()).putFloat(n + 8, (float)matrix4d.m02()).putFloat(n + 12, (float)matrix4d.m03()).putFloat(n + 16, (float)matrix4d.m10()).putFloat(n + 20, (float)matrix4d.m11()).putFloat(n + 24, (float)matrix4d.m12()).putFloat(n + 28, (float)matrix4d.m13()).putFloat(n + 32, (float)matrix4d.m20()).putFloat(n + 36, (float)matrix4d.m21()).putFloat(n + 40, (float)matrix4d.m22()).putFloat(n + 44, (float)matrix4d.m23()).putFloat(n + 48, (float)matrix4d.m30()).putFloat(n + 52, (float)matrix4d.m31()).putFloat(n + 56, (float)matrix4d.m32()).putFloat(n + 60, (float)matrix4d.m33());
        }

        @Override
        public void putf(Matrix4x3d matrix4x3d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix4x3d.m00()).put(n + 1, (float)matrix4x3d.m01()).put(n + 2, (float)matrix4x3d.m02()).put(n + 3, (float)matrix4x3d.m10()).put(n + 4, (float)matrix4x3d.m11()).put(n + 5, (float)matrix4x3d.m12()).put(n + 6, (float)matrix4x3d.m20()).put(n + 7, (float)matrix4x3d.m21()).put(n + 8, (float)matrix4x3d.m22()).put(n + 9, (float)matrix4x3d.m30()).put(n + 10, (float)matrix4x3d.m31()).put(n + 11, (float)matrix4x3d.m32());
        }

        @Override
        public void putf(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix4x3d.m00()).putFloat(n + 4, (float)matrix4x3d.m01()).putFloat(n + 8, (float)matrix4x3d.m02()).putFloat(n + 12, (float)matrix4x3d.m10()).putFloat(n + 16, (float)matrix4x3d.m11()).putFloat(n + 20, (float)matrix4x3d.m12()).putFloat(n + 24, (float)matrix4x3d.m20()).putFloat(n + 28, (float)matrix4x3d.m21()).putFloat(n + 32, (float)matrix4x3d.m22()).putFloat(n + 36, (float)matrix4x3d.m30()).putFloat(n + 40, (float)matrix4x3d.m31()).putFloat(n + 44, (float)matrix4x3d.m32());
        }

        @Override
        public void putTransposed(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix4d.m00()).put(n + 1, matrix4d.m10()).put(n + 2, matrix4d.m20()).put(n + 3, matrix4d.m30()).put(n + 4, matrix4d.m01()).put(n + 5, matrix4d.m11()).put(n + 6, matrix4d.m21()).put(n + 7, matrix4d.m31()).put(n + 8, matrix4d.m02()).put(n + 9, matrix4d.m12()).put(n + 10, matrix4d.m22()).put(n + 11, matrix4d.m32()).put(n + 12, matrix4d.m03()).put(n + 13, matrix4d.m13()).put(n + 14, matrix4d.m23()).put(n + 15, matrix4d.m33());
        }

        @Override
        public void putTransposed(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix4d.m00()).putDouble(n + 8, matrix4d.m10()).putDouble(n + 16, matrix4d.m20()).putDouble(n + 24, matrix4d.m30()).putDouble(n + 32, matrix4d.m01()).putDouble(n + 40, matrix4d.m11()).putDouble(n + 48, matrix4d.m21()).putDouble(n + 56, matrix4d.m31()).putDouble(n + 64, matrix4d.m02()).putDouble(n + 72, matrix4d.m12()).putDouble(n + 80, matrix4d.m22()).putDouble(n + 88, matrix4d.m32()).putDouble(n + 96, matrix4d.m03()).putDouble(n + 104, matrix4d.m13()).putDouble(n + 112, matrix4d.m23()).putDouble(n + 120, matrix4d.m33());
        }

        @Override
        public void put4x3Transposed(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix4d.m00()).put(n + 1, matrix4d.m10()).put(n + 2, matrix4d.m20()).put(n + 3, matrix4d.m30()).put(n + 4, matrix4d.m01()).put(n + 5, matrix4d.m11()).put(n + 6, matrix4d.m21()).put(n + 7, matrix4d.m31()).put(n + 8, matrix4d.m02()).put(n + 9, matrix4d.m12()).put(n + 10, matrix4d.m22()).put(n + 11, matrix4d.m32());
        }

        @Override
        public void put4x3Transposed(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix4d.m00()).putDouble(n + 8, matrix4d.m10()).putDouble(n + 16, matrix4d.m20()).putDouble(n + 24, matrix4d.m30()).putDouble(n + 32, matrix4d.m01()).putDouble(n + 40, matrix4d.m11()).putDouble(n + 48, matrix4d.m21()).putDouble(n + 56, matrix4d.m31()).putDouble(n + 64, matrix4d.m02()).putDouble(n + 72, matrix4d.m12()).putDouble(n + 80, matrix4d.m22()).putDouble(n + 88, matrix4d.m32());
        }

        @Override
        public void putTransposed(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix4x3d.m00()).put(n + 1, matrix4x3d.m10()).put(n + 2, matrix4x3d.m20()).put(n + 3, matrix4x3d.m30()).put(n + 4, matrix4x3d.m01()).put(n + 5, matrix4x3d.m11()).put(n + 6, matrix4x3d.m21()).put(n + 7, matrix4x3d.m31()).put(n + 8, matrix4x3d.m02()).put(n + 9, matrix4x3d.m12()).put(n + 10, matrix4x3d.m22()).put(n + 11, matrix4x3d.m32());
        }

        @Override
        public void putTransposed(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix4x3d.m00()).putDouble(n + 8, matrix4x3d.m10()).putDouble(n + 16, matrix4x3d.m20()).putDouble(n + 24, matrix4x3d.m30()).putDouble(n + 32, matrix4x3d.m01()).putDouble(n + 40, matrix4x3d.m11()).putDouble(n + 48, matrix4x3d.m21()).putDouble(n + 56, matrix4x3d.m31()).putDouble(n + 64, matrix4x3d.m02()).putDouble(n + 72, matrix4x3d.m12()).putDouble(n + 80, matrix4x3d.m22()).putDouble(n + 88, matrix4x3d.m32());
        }

        @Override
        public void putTransposed(Matrix2d matrix2d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix2d.m00()).put(n + 1, matrix2d.m10()).put(n + 2, matrix2d.m01()).put(n + 3, matrix2d.m11());
        }

        @Override
        public void putTransposed(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix2d.m00()).putDouble(n + 8, matrix2d.m10()).putDouble(n + 16, matrix2d.m01()).putDouble(n + 24, matrix2d.m11());
        }

        @Override
        public void putfTransposed(Matrix4x3d matrix4x3d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix4x3d.m00()).put(n + 1, (float)matrix4x3d.m10()).put(n + 2, (float)matrix4x3d.m20()).put(n + 3, (float)matrix4x3d.m30()).put(n + 4, (float)matrix4x3d.m01()).put(n + 5, (float)matrix4x3d.m11()).put(n + 6, (float)matrix4x3d.m21()).put(n + 7, (float)matrix4x3d.m31()).put(n + 8, (float)matrix4x3d.m02()).put(n + 9, (float)matrix4x3d.m12()).put(n + 10, (float)matrix4x3d.m22()).put(n + 11, (float)matrix4x3d.m32());
        }

        @Override
        public void putfTransposed(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix4x3d.m00()).putFloat(n + 4, (float)matrix4x3d.m10()).putFloat(n + 8, (float)matrix4x3d.m20()).putFloat(n + 12, (float)matrix4x3d.m30()).putFloat(n + 16, (float)matrix4x3d.m01()).putFloat(n + 20, (float)matrix4x3d.m11()).putFloat(n + 24, (float)matrix4x3d.m21()).putFloat(n + 28, (float)matrix4x3d.m31()).putFloat(n + 32, (float)matrix4x3d.m02()).putFloat(n + 36, (float)matrix4x3d.m12()).putFloat(n + 40, (float)matrix4x3d.m22()).putFloat(n + 44, (float)matrix4x3d.m32());
        }

        @Override
        public void putfTransposed(Matrix2d matrix2d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix2d.m00()).put(n + 1, (float)matrix2d.m10()).put(n + 2, (float)matrix2d.m01()).put(n + 3, (float)matrix2d.m11());
        }

        @Override
        public void putfTransposed(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix2d.m00()).putFloat(n + 4, (float)matrix2d.m10()).putFloat(n + 8, (float)matrix2d.m01()).putFloat(n + 12, (float)matrix2d.m11());
        }

        @Override
        public void putfTransposed(Matrix4d matrix4d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix4d.m00()).put(n + 1, (float)matrix4d.m10()).put(n + 2, (float)matrix4d.m20()).put(n + 3, (float)matrix4d.m30()).put(n + 4, (float)matrix4d.m01()).put(n + 5, (float)matrix4d.m11()).put(n + 6, (float)matrix4d.m21()).put(n + 7, (float)matrix4d.m31()).put(n + 8, (float)matrix4d.m02()).put(n + 9, (float)matrix4d.m12()).put(n + 10, (float)matrix4d.m22()).put(n + 11, (float)matrix4d.m32()).put(n + 12, (float)matrix4d.m03()).put(n + 13, (float)matrix4d.m13()).put(n + 14, (float)matrix4d.m23()).put(n + 15, (float)matrix4d.m33());
        }

        @Override
        public void putfTransposed(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix4d.m00()).putFloat(n + 4, (float)matrix4d.m10()).putFloat(n + 8, (float)matrix4d.m20()).putFloat(n + 12, (float)matrix4d.m30()).putFloat(n + 16, (float)matrix4d.m01()).putFloat(n + 20, (float)matrix4d.m11()).putFloat(n + 24, (float)matrix4d.m21()).putFloat(n + 28, (float)matrix4d.m31()).putFloat(n + 32, (float)matrix4d.m02()).putFloat(n + 36, (float)matrix4d.m12()).putFloat(n + 40, (float)matrix4d.m22()).putFloat(n + 44, (float)matrix4d.m32()).putFloat(n + 48, (float)matrix4d.m03()).putFloat(n + 52, (float)matrix4d.m13()).putFloat(n + 56, (float)matrix4d.m23()).putFloat(n + 60, (float)matrix4d.m33());
        }

        public void put0(Matrix3f matrix3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix3f.m00()).put(1, matrix3f.m01()).put(2, matrix3f.m02()).put(3, matrix3f.m10()).put(4, matrix3f.m11()).put(5, matrix3f.m12()).put(6, matrix3f.m20()).put(7, matrix3f.m21()).put(8, matrix3f.m22());
        }

        public void putN(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix3f.m00()).put(n + 1, matrix3f.m01()).put(n + 2, matrix3f.m02()).put(n + 3, matrix3f.m10()).put(n + 4, matrix3f.m11()).put(n + 5, matrix3f.m12()).put(n + 6, matrix3f.m20()).put(n + 7, matrix3f.m21()).put(n + 8, matrix3f.m22());
        }

        @Override
        public void put(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put0(matrix3f, floatBuffer);
            } else {
                this.putN(matrix3f, n, floatBuffer);
            }
        }

        public void put0(Matrix3f matrix3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix3f.m00()).putFloat(4, matrix3f.m01()).putFloat(8, matrix3f.m02()).putFloat(12, matrix3f.m10()).putFloat(16, matrix3f.m11()).putFloat(20, matrix3f.m12()).putFloat(24, matrix3f.m20()).putFloat(28, matrix3f.m21()).putFloat(32, matrix3f.m22());
        }

        public void putN(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix3f.m00()).putFloat(n + 4, matrix3f.m01()).putFloat(n + 8, matrix3f.m02()).putFloat(n + 12, matrix3f.m10()).putFloat(n + 16, matrix3f.m11()).putFloat(n + 20, matrix3f.m12()).putFloat(n + 24, matrix3f.m20()).putFloat(n + 28, matrix3f.m21()).putFloat(n + 32, matrix3f.m22());
        }

        @Override
        public void put(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put0(matrix3f, byteBuffer);
            } else {
                this.putN(matrix3f, n, byteBuffer);
            }
        }

        public void put3x4_0(Matrix3f matrix3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix3f.m00()).putFloat(4, matrix3f.m01()).putFloat(8, matrix3f.m02()).putFloat(12, 0.0f).putFloat(16, matrix3f.m10()).putFloat(20, matrix3f.m11()).putFloat(24, matrix3f.m12()).putFloat(28, 0.0f).putFloat(32, matrix3f.m20()).putFloat(36, matrix3f.m21()).putFloat(40, matrix3f.m22()).putFloat(44, 0.0f);
        }

        private void put3x4_N(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix3f.m00()).putFloat(n + 4, matrix3f.m01()).putFloat(n + 8, matrix3f.m02()).putFloat(n + 12, 0.0f).putFloat(n + 16, matrix3f.m10()).putFloat(n + 20, matrix3f.m11()).putFloat(n + 24, matrix3f.m12()).putFloat(n + 28, 0.0f).putFloat(n + 32, matrix3f.m20()).putFloat(n + 36, matrix3f.m21()).putFloat(n + 40, matrix3f.m22()).putFloat(n + 44, 0.0f);
        }

        @Override
        public void put3x4(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            if (n == 0) {
                this.put3x4_0(matrix3f, byteBuffer);
            } else {
                this.put3x4_N(matrix3f, n, byteBuffer);
            }
        }

        public void put3x4_0(Matrix3f matrix3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix3f.m00()).put(1, matrix3f.m01()).put(2, matrix3f.m02()).put(3, 0.0f).put(4, matrix3f.m10()).put(5, matrix3f.m11()).put(6, matrix3f.m12()).put(7, 0.0f).put(8, matrix3f.m20()).put(9, matrix3f.m21()).put(10, matrix3f.m22()).put(11, 0.0f);
        }

        public void put3x4_N(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix3f.m00()).put(n + 1, matrix3f.m01()).put(n + 2, matrix3f.m02()).put(n + 3, 0.0f).put(n + 4, matrix3f.m10()).put(n + 5, matrix3f.m11()).put(n + 6, matrix3f.m12()).put(n + 7, 0.0f).put(n + 8, matrix3f.m20()).put(n + 9, matrix3f.m21()).put(n + 10, matrix3f.m22()).put(n + 11, 0.0f);
        }

        @Override
        public void put3x4(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            if (n == 0) {
                this.put3x4_0(matrix3f, floatBuffer);
            } else {
                this.put3x4_N(matrix3f, n, floatBuffer);
            }
        }

        @Override
        public void put(Matrix3d matrix3d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix3d.m00()).put(n + 1, matrix3d.m01()).put(n + 2, matrix3d.m02()).put(n + 3, matrix3d.m10()).put(n + 4, matrix3d.m11()).put(n + 5, matrix3d.m12()).put(n + 6, matrix3d.m20()).put(n + 7, matrix3d.m21()).put(n + 8, matrix3d.m22());
        }

        @Override
        public void put(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix3d.m00()).putDouble(n + 8, matrix3d.m01()).putDouble(n + 16, matrix3d.m02()).putDouble(n + 24, matrix3d.m10()).putDouble(n + 32, matrix3d.m11()).putDouble(n + 40, matrix3d.m12()).putDouble(n + 48, matrix3d.m20()).putDouble(n + 56, matrix3d.m21()).putDouble(n + 64, matrix3d.m22());
        }

        @Override
        public void put(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix3x2f.m00()).put(n + 1, matrix3x2f.m01()).put(n + 2, matrix3x2f.m10()).put(n + 3, matrix3x2f.m11()).put(n + 4, matrix3x2f.m20()).put(n + 5, matrix3x2f.m21());
        }

        @Override
        public void put(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix3x2f.m00()).putFloat(n + 4, matrix3x2f.m01()).putFloat(n + 8, matrix3x2f.m10()).putFloat(n + 12, matrix3x2f.m11()).putFloat(n + 16, matrix3x2f.m20()).putFloat(n + 20, matrix3x2f.m21());
        }

        @Override
        public void put(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix3x2d.m00()).put(n + 1, matrix3x2d.m01()).put(n + 2, matrix3x2d.m10()).put(n + 3, matrix3x2d.m11()).put(n + 4, matrix3x2d.m20()).put(n + 5, matrix3x2d.m21());
        }

        @Override
        public void put(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix3x2d.m00()).putDouble(n + 8, matrix3x2d.m01()).putDouble(n + 16, matrix3x2d.m10()).putDouble(n + 24, matrix3x2d.m11()).putDouble(n + 32, matrix3x2d.m20()).putDouble(n + 40, matrix3x2d.m21());
        }

        @Override
        public void putf(Matrix3d matrix3d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix3d.m00()).put(n + 1, (float)matrix3d.m01()).put(n + 2, (float)matrix3d.m02()).put(n + 3, (float)matrix3d.m10()).put(n + 4, (float)matrix3d.m11()).put(n + 5, (float)matrix3d.m12()).put(n + 6, (float)matrix3d.m20()).put(n + 7, (float)matrix3d.m21()).put(n + 8, (float)matrix3d.m22());
        }

        @Override
        public void put(Matrix2f matrix2f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, matrix2f.m00()).put(n + 1, matrix2f.m01()).put(n + 2, matrix2f.m10()).put(n + 3, matrix2f.m11());
        }

        @Override
        public void put(Matrix2f matrix2f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, matrix2f.m00()).putFloat(n + 4, matrix2f.m01()).putFloat(n + 8, matrix2f.m10()).putFloat(n + 12, matrix2f.m11());
        }

        @Override
        public void put(Matrix2d matrix2d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, matrix2d.m00()).put(n + 1, matrix2d.m01()).put(n + 2, matrix2d.m10()).put(n + 3, matrix2d.m11());
        }

        @Override
        public void put(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, matrix2d.m00()).putDouble(n + 8, matrix2d.m01()).putDouble(n + 16, matrix2d.m10()).putDouble(n + 24, matrix2d.m11());
        }

        @Override
        public void putf(Matrix2d matrix2d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)matrix2d.m00()).put(n + 1, (float)matrix2d.m01()).put(n + 2, (float)matrix2d.m10()).put(n + 3, (float)matrix2d.m11());
        }

        @Override
        public void putf(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix2d.m00()).putFloat(n + 4, (float)matrix2d.m01()).putFloat(n + 8, (float)matrix2d.m10()).putFloat(n + 12, (float)matrix2d.m11());
        }

        @Override
        public void putf(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)matrix3d.m00()).putFloat(n + 4, (float)matrix3d.m01()).putFloat(n + 8, (float)matrix3d.m02()).putFloat(n + 12, (float)matrix3d.m10()).putFloat(n + 16, (float)matrix3d.m11()).putFloat(n + 20, (float)matrix3d.m12()).putFloat(n + 24, (float)matrix3d.m20()).putFloat(n + 28, (float)matrix3d.m21()).putFloat(n + 32, (float)matrix3d.m22());
        }

        @Override
        public void put(Vector4d vector4d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, vector4d.x).put(n + 1, vector4d.y).put(n + 2, vector4d.z).put(n + 3, vector4d.w);
        }

        @Override
        public void put(Vector4d vector4d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)vector4d.x).put(n + 1, (float)vector4d.y).put(n + 2, (float)vector4d.z).put(n + 3, (float)vector4d.w);
        }

        @Override
        public void put(Vector4d vector4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, vector4d.x).putDouble(n + 8, vector4d.y).putDouble(n + 16, vector4d.z).putDouble(n + 24, vector4d.w);
        }

        @Override
        public void putf(Vector4d vector4d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)vector4d.x).putFloat(n + 4, (float)vector4d.y).putFloat(n + 8, (float)vector4d.z).putFloat(n + 12, (float)vector4d.w);
        }

        @Override
        public void put(Vector4f vector4f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, vector4f.x).put(n + 1, vector4f.y).put(n + 2, vector4f.z).put(n + 3, vector4f.w);
        }

        @Override
        public void put(Vector4f vector4f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, vector4f.x).putFloat(n + 4, vector4f.y).putFloat(n + 8, vector4f.z).putFloat(n + 12, vector4f.w);
        }

        @Override
        public void put(Vector4i vector4i, int n, IntBuffer intBuffer) {
            intBuffer.put(n, vector4i.x).put(n + 1, vector4i.y).put(n + 2, vector4i.z).put(n + 3, vector4i.w);
        }

        @Override
        public void put(Vector4i vector4i, int n, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n, vector4i.x).putInt(n + 4, vector4i.y).putInt(n + 8, vector4i.z).putInt(n + 12, vector4i.w);
        }

        @Override
        public void put(Vector3f vector3f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, vector3f.x).put(n + 1, vector3f.y).put(n + 2, vector3f.z);
        }

        @Override
        public void put(Vector3f vector3f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, vector3f.x).putFloat(n + 4, vector3f.y).putFloat(n + 8, vector3f.z);
        }

        @Override
        public void put(Vector3d vector3d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, vector3d.x).put(n + 1, vector3d.y).put(n + 2, vector3d.z);
        }

        @Override
        public void put(Vector3d vector3d, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, (float)vector3d.x).put(n + 1, (float)vector3d.y).put(n + 2, (float)vector3d.z);
        }

        @Override
        public void put(Vector3d vector3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, vector3d.x).putDouble(n + 8, vector3d.y).putDouble(n + 16, vector3d.z);
        }

        @Override
        public void putf(Vector3d vector3d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, (float)vector3d.x).putFloat(n + 4, (float)vector3d.y).putFloat(n + 8, (float)vector3d.z);
        }

        @Override
        public void put(Vector3i vector3i, int n, IntBuffer intBuffer) {
            intBuffer.put(n, vector3i.x).put(n + 1, vector3i.y).put(n + 2, vector3i.z);
        }

        @Override
        public void put(Vector3i vector3i, int n, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n, vector3i.x).putInt(n + 4, vector3i.y).putInt(n + 8, vector3i.z);
        }

        @Override
        public void put(Vector2f vector2f, int n, FloatBuffer floatBuffer) {
            floatBuffer.put(n, vector2f.x).put(n + 1, vector2f.y);
        }

        @Override
        public void put(Vector2f vector2f, int n, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n, vector2f.x).putFloat(n + 4, vector2f.y);
        }

        @Override
        public void put(Vector2d vector2d, int n, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n, vector2d.x).put(n + 1, vector2d.y);
        }

        @Override
        public void put(Vector2d vector2d, int n, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n, vector2d.x).putDouble(n + 8, vector2d.y);
        }

        @Override
        public void put(Vector2i vector2i, int n, IntBuffer intBuffer) {
            intBuffer.put(n, vector2i.x).put(n + 1, vector2i.y);
        }

        @Override
        public void put(Vector2i vector2i, int n, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n, vector2i.x).putInt(n + 4, vector2i.y);
        }

        @Override
        public void get(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            matrix4f._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m02(floatBuffer.get(n + 2))._m03(floatBuffer.get(n + 3))._m10(floatBuffer.get(n + 4))._m11(floatBuffer.get(n + 5))._m12(floatBuffer.get(n + 6))._m13(floatBuffer.get(n + 7))._m20(floatBuffer.get(n + 8))._m21(floatBuffer.get(n + 9))._m22(floatBuffer.get(n + 10))._m23(floatBuffer.get(n + 11))._m30(floatBuffer.get(n + 12))._m31(floatBuffer.get(n + 13))._m32(floatBuffer.get(n + 14))._m33(floatBuffer.get(n + 15));
        }

        @Override
        public void get(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            matrix4f._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m02(byteBuffer.getFloat(n + 8))._m03(byteBuffer.getFloat(n + 12))._m10(byteBuffer.getFloat(n + 16))._m11(byteBuffer.getFloat(n + 20))._m12(byteBuffer.getFloat(n + 24))._m13(byteBuffer.getFloat(n + 28))._m20(byteBuffer.getFloat(n + 32))._m21(byteBuffer.getFloat(n + 36))._m22(byteBuffer.getFloat(n + 40))._m23(byteBuffer.getFloat(n + 44))._m30(byteBuffer.getFloat(n + 48))._m31(byteBuffer.getFloat(n + 52))._m32(byteBuffer.getFloat(n + 56))._m33(byteBuffer.getFloat(n + 60));
        }

        @Override
        public void getTransposed(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            matrix4f._m00(floatBuffer.get(n))._m10(floatBuffer.get(n + 1))._m20(floatBuffer.get(n + 2))._m30(floatBuffer.get(n + 3))._m01(floatBuffer.get(n + 4))._m11(floatBuffer.get(n + 5))._m21(floatBuffer.get(n + 6))._m31(floatBuffer.get(n + 7))._m02(floatBuffer.get(n + 8))._m12(floatBuffer.get(n + 9))._m22(floatBuffer.get(n + 10))._m32(floatBuffer.get(n + 11))._m03(floatBuffer.get(n + 12))._m13(floatBuffer.get(n + 13))._m23(floatBuffer.get(n + 14))._m33(floatBuffer.get(n + 15));
        }

        @Override
        public void getTransposed(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            matrix4f._m00(byteBuffer.getFloat(n))._m10(byteBuffer.getFloat(n + 4))._m20(byteBuffer.getFloat(n + 8))._m30(byteBuffer.getFloat(n + 12))._m01(byteBuffer.getFloat(n + 16))._m11(byteBuffer.getFloat(n + 20))._m21(byteBuffer.getFloat(n + 24))._m31(byteBuffer.getFloat(n + 28))._m02(byteBuffer.getFloat(n + 32))._m12(byteBuffer.getFloat(n + 36))._m22(byteBuffer.getFloat(n + 40))._m32(byteBuffer.getFloat(n + 44))._m03(byteBuffer.getFloat(n + 48))._m13(byteBuffer.getFloat(n + 52))._m23(byteBuffer.getFloat(n + 56))._m33(byteBuffer.getFloat(n + 60));
        }

        @Override
        public void get(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            matrix4x3f._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m02(floatBuffer.get(n + 2))._m10(floatBuffer.get(n + 3))._m11(floatBuffer.get(n + 4))._m12(floatBuffer.get(n + 5))._m20(floatBuffer.get(n + 6))._m21(floatBuffer.get(n + 7))._m22(floatBuffer.get(n + 8))._m30(floatBuffer.get(n + 9))._m31(floatBuffer.get(n + 10))._m32(floatBuffer.get(n + 11));
        }

        @Override
        public void get(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            matrix4x3f._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m02(byteBuffer.getFloat(n + 8))._m10(byteBuffer.getFloat(n + 12))._m11(byteBuffer.getFloat(n + 16))._m12(byteBuffer.getFloat(n + 20))._m20(byteBuffer.getFloat(n + 24))._m21(byteBuffer.getFloat(n + 28))._m22(byteBuffer.getFloat(n + 32))._m30(byteBuffer.getFloat(n + 36))._m31(byteBuffer.getFloat(n + 40))._m32(byteBuffer.getFloat(n + 44));
        }

        @Override
        public void get(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            matrix4d._m00(doubleBuffer.get(n))._m01(doubleBuffer.get(n + 1))._m02(doubleBuffer.get(n + 2))._m03(doubleBuffer.get(n + 3))._m10(doubleBuffer.get(n + 4))._m11(doubleBuffer.get(n + 5))._m12(doubleBuffer.get(n + 6))._m13(doubleBuffer.get(n + 7))._m20(doubleBuffer.get(n + 8))._m21(doubleBuffer.get(n + 9))._m22(doubleBuffer.get(n + 10))._m23(doubleBuffer.get(n + 11))._m30(doubleBuffer.get(n + 12))._m31(doubleBuffer.get(n + 13))._m32(doubleBuffer.get(n + 14))._m33(doubleBuffer.get(n + 15));
        }

        @Override
        public void get(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            matrix4d._m00(byteBuffer.getDouble(n))._m01(byteBuffer.getDouble(n + 8))._m02(byteBuffer.getDouble(n + 16))._m03(byteBuffer.getDouble(n + 24))._m10(byteBuffer.getDouble(n + 32))._m11(byteBuffer.getDouble(n + 40))._m12(byteBuffer.getDouble(n + 48))._m13(byteBuffer.getDouble(n + 56))._m20(byteBuffer.getDouble(n + 64))._m21(byteBuffer.getDouble(n + 72))._m22(byteBuffer.getDouble(n + 80))._m23(byteBuffer.getDouble(n + 88))._m30(byteBuffer.getDouble(n + 96))._m31(byteBuffer.getDouble(n + 104))._m32(byteBuffer.getDouble(n + 112))._m33(byteBuffer.getDouble(n + 120));
        }

        @Override
        public void get(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            matrix4x3d._m00(doubleBuffer.get(n))._m01(doubleBuffer.get(n + 1))._m02(doubleBuffer.get(n + 2))._m10(doubleBuffer.get(n + 3))._m11(doubleBuffer.get(n + 4))._m12(doubleBuffer.get(n + 5))._m20(doubleBuffer.get(n + 6))._m21(doubleBuffer.get(n + 7))._m22(doubleBuffer.get(n + 8))._m30(doubleBuffer.get(n + 9))._m31(doubleBuffer.get(n + 10))._m32(doubleBuffer.get(n + 11));
        }

        @Override
        public void get(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            matrix4x3d._m00(byteBuffer.getDouble(n))._m01(byteBuffer.getDouble(n + 8))._m02(byteBuffer.getDouble(n + 16))._m10(byteBuffer.getDouble(n + 24))._m11(byteBuffer.getDouble(n + 32))._m12(byteBuffer.getDouble(n + 40))._m20(byteBuffer.getDouble(n + 48))._m21(byteBuffer.getDouble(n + 56))._m22(byteBuffer.getDouble(n + 64))._m30(byteBuffer.getDouble(n + 72))._m31(byteBuffer.getDouble(n + 80))._m32(byteBuffer.getDouble(n + 88));
        }

        @Override
        public void getf(Matrix4d matrix4d, int n, FloatBuffer floatBuffer) {
            matrix4d._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m02(floatBuffer.get(n + 2))._m03(floatBuffer.get(n + 3))._m10(floatBuffer.get(n + 4))._m11(floatBuffer.get(n + 5))._m12(floatBuffer.get(n + 6))._m13(floatBuffer.get(n + 7))._m20(floatBuffer.get(n + 8))._m21(floatBuffer.get(n + 9))._m22(floatBuffer.get(n + 10))._m23(floatBuffer.get(n + 11))._m30(floatBuffer.get(n + 12))._m31(floatBuffer.get(n + 13))._m32(floatBuffer.get(n + 14))._m33(floatBuffer.get(n + 15));
        }

        @Override
        public void getf(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            matrix4d._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m02(byteBuffer.getFloat(n + 8))._m03(byteBuffer.getFloat(n + 12))._m10(byteBuffer.getFloat(n + 16))._m11(byteBuffer.getFloat(n + 20))._m12(byteBuffer.getFloat(n + 24))._m13(byteBuffer.getFloat(n + 28))._m20(byteBuffer.getFloat(n + 32))._m21(byteBuffer.getFloat(n + 36))._m22(byteBuffer.getFloat(n + 40))._m23(byteBuffer.getFloat(n + 44))._m30(byteBuffer.getFloat(n + 48))._m31(byteBuffer.getFloat(n + 52))._m32(byteBuffer.getFloat(n + 56))._m33(byteBuffer.getFloat(n + 60));
        }

        @Override
        public void getf(Matrix4x3d matrix4x3d, int n, FloatBuffer floatBuffer) {
            matrix4x3d._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m02(floatBuffer.get(n + 2))._m10(floatBuffer.get(n + 3))._m11(floatBuffer.get(n + 4))._m12(floatBuffer.get(n + 5))._m20(floatBuffer.get(n + 6))._m21(floatBuffer.get(n + 7))._m22(floatBuffer.get(n + 8))._m30(floatBuffer.get(n + 9))._m31(floatBuffer.get(n + 10))._m32(floatBuffer.get(n + 11));
        }

        @Override
        public void getf(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            matrix4x3d._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m02(byteBuffer.getFloat(n + 8))._m10(byteBuffer.getFloat(n + 12))._m11(byteBuffer.getFloat(n + 16))._m12(byteBuffer.getFloat(n + 20))._m20(byteBuffer.getFloat(n + 24))._m21(byteBuffer.getFloat(n + 28))._m22(byteBuffer.getFloat(n + 32))._m30(byteBuffer.getFloat(n + 36))._m31(byteBuffer.getFloat(n + 40))._m32(byteBuffer.getFloat(n + 44));
        }

        @Override
        public void get(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            matrix3f._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m02(floatBuffer.get(n + 2))._m10(floatBuffer.get(n + 3))._m11(floatBuffer.get(n + 4))._m12(floatBuffer.get(n + 5))._m20(floatBuffer.get(n + 6))._m21(floatBuffer.get(n + 7))._m22(floatBuffer.get(n + 8));
        }

        @Override
        public void get(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            matrix3f._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m02(byteBuffer.getFloat(n + 8))._m10(byteBuffer.getFloat(n + 12))._m11(byteBuffer.getFloat(n + 16))._m12(byteBuffer.getFloat(n + 20))._m20(byteBuffer.getFloat(n + 24))._m21(byteBuffer.getFloat(n + 28))._m22(byteBuffer.getFloat(n + 32));
        }

        @Override
        public void get(Matrix3d matrix3d, int n, DoubleBuffer doubleBuffer) {
            matrix3d._m00(doubleBuffer.get(n))._m01(doubleBuffer.get(n + 1))._m02(doubleBuffer.get(n + 2))._m10(doubleBuffer.get(n + 3))._m11(doubleBuffer.get(n + 4))._m12(doubleBuffer.get(n + 5))._m20(doubleBuffer.get(n + 6))._m21(doubleBuffer.get(n + 7))._m22(doubleBuffer.get(n + 8));
        }

        @Override
        public void get(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            matrix3d._m00(byteBuffer.getDouble(n))._m01(byteBuffer.getDouble(n + 8))._m02(byteBuffer.getDouble(n + 16))._m10(byteBuffer.getDouble(n + 24))._m11(byteBuffer.getDouble(n + 32))._m12(byteBuffer.getDouble(n + 40))._m20(byteBuffer.getDouble(n + 48))._m21(byteBuffer.getDouble(n + 56))._m22(byteBuffer.getDouble(n + 64));
        }

        @Override
        public void get(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            matrix3x2f._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m10(floatBuffer.get(n + 2))._m11(floatBuffer.get(n + 3))._m20(floatBuffer.get(n + 4))._m21(floatBuffer.get(n + 5));
        }

        @Override
        public void get(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            matrix3x2f._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m10(byteBuffer.getFloat(n + 8))._m11(byteBuffer.getFloat(n + 12))._m20(byteBuffer.getFloat(n + 16))._m21(byteBuffer.getFloat(n + 20));
        }

        @Override
        public void get(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            matrix3x2d._m00(doubleBuffer.get(n))._m01(doubleBuffer.get(n + 1))._m10(doubleBuffer.get(n + 2))._m11(doubleBuffer.get(n + 3))._m20(doubleBuffer.get(n + 4))._m21(doubleBuffer.get(n + 5));
        }

        @Override
        public void get(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            matrix3x2d._m00(byteBuffer.getDouble(n))._m01(byteBuffer.getDouble(n + 8))._m10(byteBuffer.getDouble(n + 16))._m11(byteBuffer.getDouble(n + 24))._m20(byteBuffer.getDouble(n + 32))._m21(byteBuffer.getDouble(n + 40));
        }

        @Override
        public void getf(Matrix3d matrix3d, int n, FloatBuffer floatBuffer) {
            matrix3d._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m02(floatBuffer.get(n + 2))._m10(floatBuffer.get(n + 3))._m11(floatBuffer.get(n + 4))._m12(floatBuffer.get(n + 5))._m20(floatBuffer.get(n + 6))._m21(floatBuffer.get(n + 7))._m22(floatBuffer.get(n + 8));
        }

        @Override
        public void getf(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            matrix3d._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m02(byteBuffer.getFloat(n + 8))._m10(byteBuffer.getFloat(n + 12))._m11(byteBuffer.getFloat(n + 16))._m12(byteBuffer.getFloat(n + 20))._m20(byteBuffer.getFloat(n + 24))._m21(byteBuffer.getFloat(n + 28))._m22(byteBuffer.getFloat(n + 32));
        }

        @Override
        public void get(Matrix2f matrix2f, int n, FloatBuffer floatBuffer) {
            matrix2f._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m10(floatBuffer.get(n + 2))._m11(floatBuffer.get(n + 3));
        }

        @Override
        public void get(Matrix2f matrix2f, int n, ByteBuffer byteBuffer) {
            matrix2f._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m10(byteBuffer.getFloat(n + 8))._m11(byteBuffer.getFloat(n + 12));
        }

        @Override
        public void get(Matrix2d matrix2d, int n, DoubleBuffer doubleBuffer) {
            matrix2d._m00(doubleBuffer.get(n))._m01(doubleBuffer.get(n + 1))._m10(doubleBuffer.get(n + 2))._m11(doubleBuffer.get(n + 3));
        }

        @Override
        public void get(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            matrix2d._m00(byteBuffer.getDouble(n))._m01(byteBuffer.getDouble(n + 8))._m10(byteBuffer.getDouble(n + 16))._m11(byteBuffer.getDouble(n + 24));
        }

        @Override
        public void getf(Matrix2d matrix2d, int n, FloatBuffer floatBuffer) {
            matrix2d._m00(floatBuffer.get(n))._m01(floatBuffer.get(n + 1))._m10(floatBuffer.get(n + 2))._m11(floatBuffer.get(n + 3));
        }

        @Override
        public void getf(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            matrix2d._m00(byteBuffer.getFloat(n))._m01(byteBuffer.getFloat(n + 4))._m10(byteBuffer.getFloat(n + 8))._m11(byteBuffer.getFloat(n + 12));
        }

        @Override
        public void get(Vector4d vector4d, int n, DoubleBuffer doubleBuffer) {
            vector4d.x = doubleBuffer.get(n);
            vector4d.y = doubleBuffer.get(n + 1);
            vector4d.z = doubleBuffer.get(n + 2);
            vector4d.w = doubleBuffer.get(n + 3);
        }

        @Override
        public void get(Vector4d vector4d, int n, ByteBuffer byteBuffer) {
            vector4d.x = byteBuffer.getDouble(n);
            vector4d.y = byteBuffer.getDouble(n + 8);
            vector4d.z = byteBuffer.getDouble(n + 16);
            vector4d.w = byteBuffer.getDouble(n + 24);
        }

        @Override
        public void get(Vector4f vector4f, int n, FloatBuffer floatBuffer) {
            vector4f.x = floatBuffer.get(n);
            vector4f.y = floatBuffer.get(n + 1);
            vector4f.z = floatBuffer.get(n + 2);
            vector4f.w = floatBuffer.get(n + 3);
        }

        @Override
        public void get(Vector4f vector4f, int n, ByteBuffer byteBuffer) {
            vector4f.x = byteBuffer.getFloat(n);
            vector4f.y = byteBuffer.getFloat(n + 4);
            vector4f.z = byteBuffer.getFloat(n + 8);
            vector4f.w = byteBuffer.getFloat(n + 12);
        }

        @Override
        public void get(Vector4i vector4i, int n, IntBuffer intBuffer) {
            vector4i.x = intBuffer.get(n);
            vector4i.y = intBuffer.get(n + 1);
            vector4i.z = intBuffer.get(n + 2);
            vector4i.w = intBuffer.get(n + 3);
        }

        @Override
        public void get(Vector4i vector4i, int n, ByteBuffer byteBuffer) {
            vector4i.x = byteBuffer.getInt(n);
            vector4i.y = byteBuffer.getInt(n + 4);
            vector4i.z = byteBuffer.getInt(n + 8);
            vector4i.w = byteBuffer.getInt(n + 12);
        }

        @Override
        public void get(Vector3f vector3f, int n, FloatBuffer floatBuffer) {
            vector3f.x = floatBuffer.get(n);
            vector3f.y = floatBuffer.get(n + 1);
            vector3f.z = floatBuffer.get(n + 2);
        }

        @Override
        public void get(Vector3f vector3f, int n, ByteBuffer byteBuffer) {
            vector3f.x = byteBuffer.getFloat(n);
            vector3f.y = byteBuffer.getFloat(n + 4);
            vector3f.z = byteBuffer.getFloat(n + 8);
        }

        @Override
        public void get(Vector3d vector3d, int n, DoubleBuffer doubleBuffer) {
            vector3d.x = doubleBuffer.get(n);
            vector3d.y = doubleBuffer.get(n + 1);
            vector3d.z = doubleBuffer.get(n + 2);
        }

        @Override
        public void get(Vector3d vector3d, int n, ByteBuffer byteBuffer) {
            vector3d.x = byteBuffer.getDouble(n);
            vector3d.y = byteBuffer.getDouble(n + 8);
            vector3d.z = byteBuffer.getDouble(n + 16);
        }

        @Override
        public void get(Vector3i vector3i, int n, IntBuffer intBuffer) {
            vector3i.x = intBuffer.get(n);
            vector3i.y = intBuffer.get(n + 1);
            vector3i.z = intBuffer.get(n + 2);
        }

        @Override
        public void get(Vector3i vector3i, int n, ByteBuffer byteBuffer) {
            vector3i.x = byteBuffer.getInt(n);
            vector3i.y = byteBuffer.getInt(n + 4);
            vector3i.z = byteBuffer.getInt(n + 8);
        }

        @Override
        public void get(Vector2f vector2f, int n, FloatBuffer floatBuffer) {
            vector2f.x = floatBuffer.get(n);
            vector2f.y = floatBuffer.get(n + 1);
        }

        @Override
        public void get(Vector2f vector2f, int n, ByteBuffer byteBuffer) {
            vector2f.x = byteBuffer.getFloat(n);
            vector2f.y = byteBuffer.getFloat(n + 4);
        }

        @Override
        public void get(Vector2d vector2d, int n, DoubleBuffer doubleBuffer) {
            vector2d.x = doubleBuffer.get(n);
            vector2d.y = doubleBuffer.get(n + 1);
        }

        @Override
        public void get(Vector2d vector2d, int n, ByteBuffer byteBuffer) {
            vector2d.x = byteBuffer.getDouble(n);
            vector2d.y = byteBuffer.getDouble(n + 8);
        }

        @Override
        public void get(Vector2i vector2i, int n, IntBuffer intBuffer) {
            vector2i.x = intBuffer.get(n);
            vector2i.y = intBuffer.get(n + 1);
        }

        @Override
        public void get(Vector2i vector2i, int n, ByteBuffer byteBuffer) {
            vector2i.x = byteBuffer.getInt(n);
            vector2i.y = byteBuffer.getInt(n + 4);
        }

        @Override
        public float get(Matrix4f matrix4f, int n, int n2) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m00;
                        }
                        case 1: {
                            return matrix4f.m01;
                        }
                        case 2: {
                            return matrix4f.m02;
                        }
                        case 3: {
                            return matrix4f.m03;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m10;
                        }
                        case 1: {
                            return matrix4f.m11;
                        }
                        case 2: {
                            return matrix4f.m12;
                        }
                        case 3: {
                            return matrix4f.m13;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m20;
                        }
                        case 1: {
                            return matrix4f.m21;
                        }
                        case 2: {
                            return matrix4f.m22;
                        }
                        case 3: {
                            return matrix4f.m23;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m30;
                        }
                        case 1: {
                            return matrix4f.m31;
                        }
                        case 2: {
                            return matrix4f.m32;
                        }
                        case 3: {
                            return matrix4f.m33;
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Matrix4f set(Matrix4f matrix4f, int n, int n2, float f) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m00(f);
                        }
                        case 1: {
                            return matrix4f.m01(f);
                        }
                        case 2: {
                            return matrix4f.m02(f);
                        }
                        case 3: {
                            return matrix4f.m03(f);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m10(f);
                        }
                        case 1: {
                            return matrix4f.m11(f);
                        }
                        case 2: {
                            return matrix4f.m12(f);
                        }
                        case 3: {
                            return matrix4f.m13(f);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m20(f);
                        }
                        case 1: {
                            return matrix4f.m21(f);
                        }
                        case 2: {
                            return matrix4f.m22(f);
                        }
                        case 3: {
                            return matrix4f.m23(f);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n2) {
                        case 0: {
                            return matrix4f.m30(f);
                        }
                        case 1: {
                            return matrix4f.m31(f);
                        }
                        case 2: {
                            return matrix4f.m32(f);
                        }
                        case 3: {
                            return matrix4f.m33(f);
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public double get(Matrix4d matrix4d, int n, int n2) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m00;
                        }
                        case 1: {
                            return matrix4d.m01;
                        }
                        case 2: {
                            return matrix4d.m02;
                        }
                        case 3: {
                            return matrix4d.m03;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m10;
                        }
                        case 1: {
                            return matrix4d.m11;
                        }
                        case 2: {
                            return matrix4d.m12;
                        }
                        case 3: {
                            return matrix4d.m13;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m20;
                        }
                        case 1: {
                            return matrix4d.m21;
                        }
                        case 2: {
                            return matrix4d.m22;
                        }
                        case 3: {
                            return matrix4d.m23;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m30;
                        }
                        case 1: {
                            return matrix4d.m31;
                        }
                        case 2: {
                            return matrix4d.m32;
                        }
                        case 3: {
                            return matrix4d.m33;
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Matrix4d set(Matrix4d matrix4d, int n, int n2, double d) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m00(d);
                        }
                        case 1: {
                            return matrix4d.m01(d);
                        }
                        case 2: {
                            return matrix4d.m02(d);
                        }
                        case 3: {
                            return matrix4d.m03(d);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m10(d);
                        }
                        case 1: {
                            return matrix4d.m11(d);
                        }
                        case 2: {
                            return matrix4d.m12(d);
                        }
                        case 3: {
                            return matrix4d.m13(d);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m20(d);
                        }
                        case 1: {
                            return matrix4d.m21(d);
                        }
                        case 2: {
                            return matrix4d.m22(d);
                        }
                        case 3: {
                            return matrix4d.m23(d);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n2) {
                        case 0: {
                            return matrix4d.m30(d);
                        }
                        case 1: {
                            return matrix4d.m31(d);
                        }
                        case 2: {
                            return matrix4d.m32(d);
                        }
                        case 3: {
                            return matrix4d.m33(d);
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public float get(Matrix3f matrix3f, int n, int n2) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix3f.m00;
                        }
                        case 1: {
                            return matrix3f.m01;
                        }
                        case 2: {
                            return matrix3f.m02;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix3f.m10;
                        }
                        case 1: {
                            return matrix3f.m11;
                        }
                        case 2: {
                            return matrix3f.m12;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix3f.m20;
                        }
                        case 1: {
                            return matrix3f.m21;
                        }
                        case 2: {
                            return matrix3f.m22;
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Matrix3f set(Matrix3f matrix3f, int n, int n2, float f) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix3f.m00(f);
                        }
                        case 1: {
                            return matrix3f.m01(f);
                        }
                        case 2: {
                            return matrix3f.m02(f);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix3f.m10(f);
                        }
                        case 1: {
                            return matrix3f.m11(f);
                        }
                        case 2: {
                            return matrix3f.m12(f);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix3f.m20(f);
                        }
                        case 1: {
                            return matrix3f.m21(f);
                        }
                        case 2: {
                            return matrix3f.m22(f);
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public double get(Matrix3d matrix3d, int n, int n2) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix3d.m00;
                        }
                        case 1: {
                            return matrix3d.m01;
                        }
                        case 2: {
                            return matrix3d.m02;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix3d.m10;
                        }
                        case 1: {
                            return matrix3d.m11;
                        }
                        case 2: {
                            return matrix3d.m12;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix3d.m20;
                        }
                        case 1: {
                            return matrix3d.m21;
                        }
                        case 2: {
                            return matrix3d.m22;
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Matrix3d set(Matrix3d matrix3d, int n, int n2, double d) {
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            return matrix3d.m00(d);
                        }
                        case 1: {
                            return matrix3d.m01(d);
                        }
                        case 2: {
                            return matrix3d.m02(d);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 0: {
                            return matrix3d.m10(d);
                        }
                        case 1: {
                            return matrix3d.m11(d);
                        }
                        case 2: {
                            return matrix3d.m12(d);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 0: {
                            return matrix3d.m20(d);
                        }
                        case 1: {
                            return matrix3d.m21(d);
                        }
                        case 2: {
                            return matrix3d.m22(d);
                        }
                    }
                    break;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Vector4f getColumn(Matrix4f matrix4f, int n, Vector4f vector4f) {
            switch (n) {
                case 0: {
                    return vector4f.set(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m03);
                }
                case 1: {
                    return vector4f.set(matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m13);
                }
                case 2: {
                    return vector4f.set(matrix4f.m20, matrix4f.m21, matrix4f.m22, matrix4f.m23);
                }
                case 3: {
                    return vector4f.set(matrix4f.m30, matrix4f.m31, matrix4f.m32, matrix4f.m33);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Matrix4f setColumn(Vector4f vector4f, int n, Matrix4f matrix4f) {
            switch (n) {
                case 0: {
                    return matrix4f._m00(vector4f.x)._m01(vector4f.y)._m02(vector4f.z)._m03(vector4f.w);
                }
                case 1: {
                    return matrix4f._m10(vector4f.x)._m11(vector4f.y)._m12(vector4f.z)._m13(vector4f.w);
                }
                case 2: {
                    return matrix4f._m20(vector4f.x)._m21(vector4f.y)._m22(vector4f.z)._m23(vector4f.w);
                }
                case 3: {
                    return matrix4f._m30(vector4f.x)._m31(vector4f.y)._m32(vector4f.z)._m33(vector4f.w);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Matrix4f setColumn(Vector4fc vector4fc, int n, Matrix4f matrix4f) {
            switch (n) {
                case 0: {
                    return matrix4f._m00(vector4fc.x())._m01(vector4fc.y())._m02(vector4fc.z())._m03(vector4fc.w());
                }
                case 1: {
                    return matrix4f._m10(vector4fc.x())._m11(vector4fc.y())._m12(vector4fc.z())._m13(vector4fc.w());
                }
                case 2: {
                    return matrix4f._m20(vector4fc.x())._m21(vector4fc.y())._m22(vector4fc.z())._m23(vector4fc.w());
                }
                case 3: {
                    return matrix4f._m30(vector4fc.x())._m31(vector4fc.y())._m32(vector4fc.z())._m33(vector4fc.w());
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void copy(Matrix4f matrix4f, Matrix4f matrix4f2) {
            matrix4f2._m00(matrix4f.m00())._m01(matrix4f.m01())._m02(matrix4f.m02())._m03(matrix4f.m03())._m10(matrix4f.m10())._m11(matrix4f.m11())._m12(matrix4f.m12())._m13(matrix4f.m13())._m20(matrix4f.m20())._m21(matrix4f.m21())._m22(matrix4f.m22())._m23(matrix4f.m23())._m30(matrix4f.m30())._m31(matrix4f.m31())._m32(matrix4f.m32())._m33(matrix4f.m33());
        }

        @Override
        public void copy(Matrix3f matrix3f, Matrix4f matrix4f) {
            matrix4f._m00(matrix3f.m00())._m01(matrix3f.m01())._m02(matrix3f.m02())._m03(0.0f)._m10(matrix3f.m10())._m11(matrix3f.m11())._m12(matrix3f.m12())._m13(0.0f)._m20(matrix3f.m20())._m21(matrix3f.m21())._m22(matrix3f.m22())._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(1.0f);
        }

        @Override
        public void copy(Matrix4f matrix4f, Matrix3f matrix3f) {
            matrix3f._m00(matrix4f.m00())._m01(matrix4f.m01())._m02(matrix4f.m02())._m10(matrix4f.m10())._m11(matrix4f.m11())._m12(matrix4f.m12())._m20(matrix4f.m20())._m21(matrix4f.m21())._m22(matrix4f.m22());
        }

        @Override
        public void copy(Matrix3f matrix3f, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix3f.m00())._m01(matrix3f.m01())._m02(matrix3f.m02())._m10(matrix3f.m10())._m11(matrix3f.m11())._m12(matrix3f.m12())._m20(matrix3f.m20())._m21(matrix3f.m21())._m22(matrix3f.m22())._m30(0.0f)._m31(0.0f)._m32(0.0f);
        }

        @Override
        public void copy(Matrix3x2f matrix3x2f, Matrix3x2f matrix3x2f2) {
            matrix3x2f2._m00(matrix3x2f.m00())._m01(matrix3x2f.m01())._m10(matrix3x2f.m10())._m11(matrix3x2f.m11())._m20(matrix3x2f.m20())._m21(matrix3x2f.m21());
        }

        @Override
        public void copy(Matrix3x2d matrix3x2d, Matrix3x2d matrix3x2d2) {
            matrix3x2d2._m00(matrix3x2d.m00())._m01(matrix3x2d.m01())._m10(matrix3x2d.m10())._m11(matrix3x2d.m11())._m20(matrix3x2d.m20())._m21(matrix3x2d.m21());
        }

        @Override
        public void copy(Matrix2f matrix2f, Matrix2f matrix2f2) {
            matrix2f2._m00(matrix2f.m00())._m01(matrix2f.m01())._m10(matrix2f.m10())._m11(matrix2f.m11());
        }

        @Override
        public void copy(Matrix2d matrix2d, Matrix2d matrix2d2) {
            matrix2d2._m00(matrix2d.m00())._m01(matrix2d.m01())._m10(matrix2d.m10())._m11(matrix2d.m11());
        }

        @Override
        public void copy(Matrix2f matrix2f, Matrix3f matrix3f) {
            matrix3f._m00(matrix2f.m00())._m01(matrix2f.m01())._m02(0.0f)._m10(matrix2f.m10())._m11(matrix2f.m11())._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f);
        }

        @Override
        public void copy(Matrix3f matrix3f, Matrix2f matrix2f) {
            matrix2f._m00(matrix3f.m00())._m01(matrix3f.m01())._m10(matrix3f.m10())._m11(matrix3f.m11());
        }

        @Override
        public void copy(Matrix2f matrix2f, Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(matrix2f.m00())._m01(matrix2f.m01())._m10(matrix2f.m10())._m11(matrix2f.m11())._m20(0.0f)._m21(0.0f);
        }

        @Override
        public void copy(Matrix3x2f matrix3x2f, Matrix2f matrix2f) {
            matrix2f._m00(matrix3x2f.m00())._m01(matrix3x2f.m01())._m10(matrix3x2f.m10())._m11(matrix3x2f.m11());
        }

        @Override
        public void copy(Matrix2d matrix2d, Matrix3d matrix3d) {
            matrix3d._m00(matrix2d.m00())._m01(matrix2d.m01())._m02(0.0)._m10(matrix2d.m10())._m11(matrix2d.m11())._m12(0.0)._m20(0.0)._m21(0.0)._m22(1.0);
        }

        @Override
        public void copy(Matrix3d matrix3d, Matrix2d matrix2d) {
            matrix2d._m00(matrix3d.m00())._m01(matrix3d.m01())._m10(matrix3d.m10())._m11(matrix3d.m11());
        }

        @Override
        public void copy(Matrix2d matrix2d, Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(matrix2d.m00())._m01(matrix2d.m01())._m10(matrix2d.m10())._m11(matrix2d.m11())._m20(0.0)._m21(0.0);
        }

        @Override
        public void copy(Matrix3x2d matrix3x2d, Matrix2d matrix2d) {
            matrix2d._m00(matrix3x2d.m00())._m01(matrix3x2d.m01())._m10(matrix3x2d.m10())._m11(matrix3x2d.m11());
        }

        @Override
        public void copy3x3(Matrix4f matrix4f, Matrix4f matrix4f2) {
            matrix4f2._m00(matrix4f.m00())._m01(matrix4f.m01())._m02(matrix4f.m02())._m10(matrix4f.m10())._m11(matrix4f.m11())._m12(matrix4f.m12())._m20(matrix4f.m20())._m21(matrix4f.m21())._m22(matrix4f.m22());
        }

        @Override
        public void copy3x3(Matrix4x3f matrix4x3f, Matrix4x3f matrix4x3f2) {
            matrix4x3f2._m00(matrix4x3f.m00())._m01(matrix4x3f.m01())._m02(matrix4x3f.m02())._m10(matrix4x3f.m10())._m11(matrix4x3f.m11())._m12(matrix4x3f.m12())._m20(matrix4x3f.m20())._m21(matrix4x3f.m21())._m22(matrix4x3f.m22());
        }

        @Override
        public void copy3x3(Matrix3f matrix3f, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix3f.m00())._m01(matrix3f.m01())._m02(matrix3f.m02())._m10(matrix3f.m10())._m11(matrix3f.m11())._m12(matrix3f.m12())._m20(matrix3f.m20())._m21(matrix3f.m21())._m22(matrix3f.m22());
        }

        @Override
        public void copy3x3(Matrix3f matrix3f, Matrix4f matrix4f) {
            matrix4f._m00(matrix3f.m00())._m01(matrix3f.m01())._m02(matrix3f.m02())._m10(matrix3f.m10())._m11(matrix3f.m11())._m12(matrix3f.m12())._m20(matrix3f.m20())._m21(matrix3f.m21())._m22(matrix3f.m22());
        }

        @Override
        public void copy4x3(Matrix4x3f matrix4x3f, Matrix4f matrix4f) {
            matrix4f._m00(matrix4x3f.m00())._m01(matrix4x3f.m01())._m02(matrix4x3f.m02())._m10(matrix4x3f.m10())._m11(matrix4x3f.m11())._m12(matrix4x3f.m12())._m20(matrix4x3f.m20())._m21(matrix4x3f.m21())._m22(matrix4x3f.m22())._m30(matrix4x3f.m30())._m31(matrix4x3f.m31())._m32(matrix4x3f.m32());
        }

        @Override
        public void copy4x3(Matrix4f matrix4f, Matrix4f matrix4f2) {
            matrix4f2._m00(matrix4f.m00())._m01(matrix4f.m01())._m02(matrix4f.m02())._m10(matrix4f.m10())._m11(matrix4f.m11())._m12(matrix4f.m12())._m20(matrix4f.m20())._m21(matrix4f.m21())._m22(matrix4f.m22())._m30(matrix4f.m30())._m31(matrix4f.m31())._m32(matrix4f.m32());
        }

        @Override
        public void copy(Matrix4f matrix4f, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix4f.m00())._m01(matrix4f.m01())._m02(matrix4f.m02())._m10(matrix4f.m10())._m11(matrix4f.m11())._m12(matrix4f.m12())._m20(matrix4f.m20())._m21(matrix4f.m21())._m22(matrix4f.m22())._m30(matrix4f.m30())._m31(matrix4f.m31())._m32(matrix4f.m32());
        }

        @Override
        public void copy(Matrix4x3f matrix4x3f, Matrix4f matrix4f) {
            matrix4f._m00(matrix4x3f.m00())._m01(matrix4x3f.m01())._m02(matrix4x3f.m02())._m03(0.0f)._m10(matrix4x3f.m10())._m11(matrix4x3f.m11())._m12(matrix4x3f.m12())._m13(0.0f)._m20(matrix4x3f.m20())._m21(matrix4x3f.m21())._m22(matrix4x3f.m22())._m23(0.0f)._m30(matrix4x3f.m30())._m31(matrix4x3f.m31())._m32(matrix4x3f.m32())._m33(1.0f);
        }

        @Override
        public void copy(Matrix4x3f matrix4x3f, Matrix4x3f matrix4x3f2) {
            matrix4x3f2._m00(matrix4x3f.m00())._m01(matrix4x3f.m01())._m02(matrix4x3f.m02())._m10(matrix4x3f.m10())._m11(matrix4x3f.m11())._m12(matrix4x3f.m12())._m20(matrix4x3f.m20())._m21(matrix4x3f.m21())._m22(matrix4x3f.m22())._m30(matrix4x3f.m30())._m31(matrix4x3f.m31())._m32(matrix4x3f.m32());
        }

        @Override
        public void copy(Matrix3f matrix3f, Matrix3f matrix3f2) {
            matrix3f2._m00(matrix3f.m00())._m01(matrix3f.m01())._m02(matrix3f.m02())._m10(matrix3f.m10())._m11(matrix3f.m11())._m12(matrix3f.m12())._m20(matrix3f.m20())._m21(matrix3f.m21())._m22(matrix3f.m22());
        }

        @Override
        public void copy(float[] fArray, int n, Matrix4f matrix4f) {
            matrix4f._m00(fArray[n + 0])._m01(fArray[n + 1])._m02(fArray[n + 2])._m03(fArray[n + 3])._m10(fArray[n + 4])._m11(fArray[n + 5])._m12(fArray[n + 6])._m13(fArray[n + 7])._m20(fArray[n + 8])._m21(fArray[n + 9])._m22(fArray[n + 10])._m23(fArray[n + 11])._m30(fArray[n + 12])._m31(fArray[n + 13])._m32(fArray[n + 14])._m33(fArray[n + 15]);
        }

        @Override
        public void copyTransposed(float[] fArray, int n, Matrix4f matrix4f) {
            matrix4f._m00(fArray[n + 0])._m10(fArray[n + 1])._m20(fArray[n + 2])._m30(fArray[n + 3])._m01(fArray[n + 4])._m11(fArray[n + 5])._m21(fArray[n + 6])._m31(fArray[n + 7])._m02(fArray[n + 8])._m12(fArray[n + 9])._m22(fArray[n + 10])._m32(fArray[n + 11])._m03(fArray[n + 12])._m13(fArray[n + 13])._m23(fArray[n + 14])._m33(fArray[n + 15]);
        }

        @Override
        public void copy(float[] fArray, int n, Matrix3f matrix3f) {
            matrix3f._m00(fArray[n + 0])._m01(fArray[n + 1])._m02(fArray[n + 2])._m10(fArray[n + 3])._m11(fArray[n + 4])._m12(fArray[n + 5])._m20(fArray[n + 6])._m21(fArray[n + 7])._m22(fArray[n + 8]);
        }

        @Override
        public void copy(float[] fArray, int n, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(fArray[n + 0])._m01(fArray[n + 1])._m02(fArray[n + 2])._m10(fArray[n + 3])._m11(fArray[n + 4])._m12(fArray[n + 5])._m20(fArray[n + 6])._m21(fArray[n + 7])._m22(fArray[n + 8])._m30(fArray[n + 9])._m31(fArray[n + 10])._m32(fArray[n + 11]);
        }

        @Override
        public void copy(float[] fArray, int n, Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(fArray[n + 0])._m01(fArray[n + 1])._m10(fArray[n + 2])._m11(fArray[n + 3])._m20(fArray[n + 4])._m21(fArray[n + 5]);
        }

        @Override
        public void copy(double[] dArray, int n, Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(dArray[n + 0])._m01(dArray[n + 1])._m10(dArray[n + 2])._m11(dArray[n + 3])._m20(dArray[n + 4])._m21(dArray[n + 5]);
        }

        @Override
        public void copy(float[] fArray, int n, Matrix2f matrix2f) {
            matrix2f._m00(fArray[n + 0])._m01(fArray[n + 1])._m10(fArray[n + 2])._m11(fArray[n + 3]);
        }

        @Override
        public void copy(double[] dArray, int n, Matrix2d matrix2d) {
            matrix2d._m00(dArray[n + 0])._m01(dArray[n + 1])._m10(dArray[n + 2])._m11(dArray[n + 3]);
        }

        @Override
        public void copy(Matrix4f matrix4f, float[] fArray, int n) {
            fArray[n + 0] = matrix4f.m00();
            fArray[n + 1] = matrix4f.m01();
            fArray[n + 2] = matrix4f.m02();
            fArray[n + 3] = matrix4f.m03();
            fArray[n + 4] = matrix4f.m10();
            fArray[n + 5] = matrix4f.m11();
            fArray[n + 6] = matrix4f.m12();
            fArray[n + 7] = matrix4f.m13();
            fArray[n + 8] = matrix4f.m20();
            fArray[n + 9] = matrix4f.m21();
            fArray[n + 10] = matrix4f.m22();
            fArray[n + 11] = matrix4f.m23();
            fArray[n + 12] = matrix4f.m30();
            fArray[n + 13] = matrix4f.m31();
            fArray[n + 14] = matrix4f.m32();
            fArray[n + 15] = matrix4f.m33();
        }

        @Override
        public void copy(Matrix3f matrix3f, float[] fArray, int n) {
            fArray[n + 0] = matrix3f.m00();
            fArray[n + 1] = matrix3f.m01();
            fArray[n + 2] = matrix3f.m02();
            fArray[n + 3] = matrix3f.m10();
            fArray[n + 4] = matrix3f.m11();
            fArray[n + 5] = matrix3f.m12();
            fArray[n + 6] = matrix3f.m20();
            fArray[n + 7] = matrix3f.m21();
            fArray[n + 8] = matrix3f.m22();
        }

        @Override
        public void copy(Matrix4x3f matrix4x3f, float[] fArray, int n) {
            fArray[n + 0] = matrix4x3f.m00();
            fArray[n + 1] = matrix4x3f.m01();
            fArray[n + 2] = matrix4x3f.m02();
            fArray[n + 3] = matrix4x3f.m10();
            fArray[n + 4] = matrix4x3f.m11();
            fArray[n + 5] = matrix4x3f.m12();
            fArray[n + 6] = matrix4x3f.m20();
            fArray[n + 7] = matrix4x3f.m21();
            fArray[n + 8] = matrix4x3f.m22();
            fArray[n + 9] = matrix4x3f.m30();
            fArray[n + 10] = matrix4x3f.m31();
            fArray[n + 11] = matrix4x3f.m32();
        }

        @Override
        public void copy(Matrix3x2f matrix3x2f, float[] fArray, int n) {
            fArray[n + 0] = matrix3x2f.m00();
            fArray[n + 1] = matrix3x2f.m01();
            fArray[n + 2] = matrix3x2f.m10();
            fArray[n + 3] = matrix3x2f.m11();
            fArray[n + 4] = matrix3x2f.m20();
            fArray[n + 5] = matrix3x2f.m21();
        }

        @Override
        public void copy(Matrix3x2d matrix3x2d, double[] dArray, int n) {
            dArray[n + 0] = matrix3x2d.m00();
            dArray[n + 1] = matrix3x2d.m01();
            dArray[n + 2] = matrix3x2d.m10();
            dArray[n + 3] = matrix3x2d.m11();
            dArray[n + 4] = matrix3x2d.m20();
            dArray[n + 5] = matrix3x2d.m21();
        }

        @Override
        public void copy(Matrix2f matrix2f, float[] fArray, int n) {
            fArray[n + 0] = matrix2f.m00();
            fArray[n + 1] = matrix2f.m01();
            fArray[n + 2] = matrix2f.m10();
            fArray[n + 3] = matrix2f.m11();
        }

        @Override
        public void copy(Matrix2d matrix2d, double[] dArray, int n) {
            dArray[n + 0] = matrix2d.m00();
            dArray[n + 1] = matrix2d.m01();
            dArray[n + 2] = matrix2d.m10();
            dArray[n + 3] = matrix2d.m11();
        }

        @Override
        public void copy4x4(Matrix4x3f matrix4x3f, float[] fArray, int n) {
            fArray[n + 0] = matrix4x3f.m00();
            fArray[n + 1] = matrix4x3f.m01();
            fArray[n + 2] = matrix4x3f.m02();
            fArray[n + 3] = 0.0f;
            fArray[n + 4] = matrix4x3f.m10();
            fArray[n + 5] = matrix4x3f.m11();
            fArray[n + 6] = matrix4x3f.m12();
            fArray[n + 7] = 0.0f;
            fArray[n + 8] = matrix4x3f.m20();
            fArray[n + 9] = matrix4x3f.m21();
            fArray[n + 10] = matrix4x3f.m22();
            fArray[n + 11] = 0.0f;
            fArray[n + 12] = matrix4x3f.m30();
            fArray[n + 13] = matrix4x3f.m31();
            fArray[n + 14] = matrix4x3f.m32();
            fArray[n + 15] = 1.0f;
        }

        @Override
        public void copy4x4(Matrix4x3d matrix4x3d, float[] fArray, int n) {
            fArray[n + 0] = (float)matrix4x3d.m00();
            fArray[n + 1] = (float)matrix4x3d.m01();
            fArray[n + 2] = (float)matrix4x3d.m02();
            fArray[n + 3] = 0.0f;
            fArray[n + 4] = (float)matrix4x3d.m10();
            fArray[n + 5] = (float)matrix4x3d.m11();
            fArray[n + 6] = (float)matrix4x3d.m12();
            fArray[n + 7] = 0.0f;
            fArray[n + 8] = (float)matrix4x3d.m20();
            fArray[n + 9] = (float)matrix4x3d.m21();
            fArray[n + 10] = (float)matrix4x3d.m22();
            fArray[n + 11] = 0.0f;
            fArray[n + 12] = (float)matrix4x3d.m30();
            fArray[n + 13] = (float)matrix4x3d.m31();
            fArray[n + 14] = (float)matrix4x3d.m32();
            fArray[n + 15] = 1.0f;
        }

        @Override
        public void copy4x4(Matrix4x3d matrix4x3d, double[] dArray, int n) {
            dArray[n + 0] = matrix4x3d.m00();
            dArray[n + 1] = matrix4x3d.m01();
            dArray[n + 2] = matrix4x3d.m02();
            dArray[n + 3] = 0.0;
            dArray[n + 4] = matrix4x3d.m10();
            dArray[n + 5] = matrix4x3d.m11();
            dArray[n + 6] = matrix4x3d.m12();
            dArray[n + 7] = 0.0;
            dArray[n + 8] = matrix4x3d.m20();
            dArray[n + 9] = matrix4x3d.m21();
            dArray[n + 10] = matrix4x3d.m22();
            dArray[n + 11] = 0.0;
            dArray[n + 12] = matrix4x3d.m30();
            dArray[n + 13] = matrix4x3d.m31();
            dArray[n + 14] = matrix4x3d.m32();
            dArray[n + 15] = 1.0;
        }

        @Override
        public void copy3x3(Matrix3x2f matrix3x2f, float[] fArray, int n) {
            fArray[n + 0] = matrix3x2f.m00();
            fArray[n + 1] = matrix3x2f.m01();
            fArray[n + 2] = 0.0f;
            fArray[n + 3] = matrix3x2f.m10();
            fArray[n + 4] = matrix3x2f.m11();
            fArray[n + 5] = 0.0f;
            fArray[n + 6] = matrix3x2f.m20();
            fArray[n + 7] = matrix3x2f.m21();
            fArray[n + 8] = 1.0f;
        }

        @Override
        public void copy3x3(Matrix3x2d matrix3x2d, double[] dArray, int n) {
            dArray[n + 0] = matrix3x2d.m00();
            dArray[n + 1] = matrix3x2d.m01();
            dArray[n + 2] = 0.0;
            dArray[n + 3] = matrix3x2d.m10();
            dArray[n + 4] = matrix3x2d.m11();
            dArray[n + 5] = 0.0;
            dArray[n + 6] = matrix3x2d.m20();
            dArray[n + 7] = matrix3x2d.m21();
            dArray[n + 8] = 1.0;
        }

        @Override
        public void copy4x4(Matrix3x2f matrix3x2f, float[] fArray, int n) {
            fArray[n + 0] = matrix3x2f.m00();
            fArray[n + 1] = matrix3x2f.m01();
            fArray[n + 2] = 0.0f;
            fArray[n + 3] = 0.0f;
            fArray[n + 4] = matrix3x2f.m10();
            fArray[n + 5] = matrix3x2f.m11();
            fArray[n + 6] = 0.0f;
            fArray[n + 7] = 0.0f;
            fArray[n + 8] = 0.0f;
            fArray[n + 9] = 0.0f;
            fArray[n + 10] = 1.0f;
            fArray[n + 11] = 0.0f;
            fArray[n + 12] = matrix3x2f.m20();
            fArray[n + 13] = matrix3x2f.m21();
            fArray[n + 14] = 0.0f;
            fArray[n + 15] = 1.0f;
        }

        @Override
        public void copy4x4(Matrix3x2d matrix3x2d, double[] dArray, int n) {
            dArray[n + 0] = matrix3x2d.m00();
            dArray[n + 1] = matrix3x2d.m01();
            dArray[n + 2] = 0.0;
            dArray[n + 3] = 0.0;
            dArray[n + 4] = matrix3x2d.m10();
            dArray[n + 5] = matrix3x2d.m11();
            dArray[n + 6] = 0.0;
            dArray[n + 7] = 0.0;
            dArray[n + 8] = 0.0;
            dArray[n + 9] = 0.0;
            dArray[n + 10] = 1.0;
            dArray[n + 11] = 0.0;
            dArray[n + 12] = matrix3x2d.m20();
            dArray[n + 13] = matrix3x2d.m21();
            dArray[n + 14] = 0.0;
            dArray[n + 15] = 1.0;
        }

        @Override
        public void identity(Matrix4f matrix4f) {
            matrix4f._m00(1.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(1.0f);
        }

        @Override
        public void identity(Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(1.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f);
        }

        @Override
        public void identity(Matrix3f matrix3f) {
            matrix3f._m00(1.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f);
        }

        @Override
        public void identity(Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(1.0f)._m01(0.0f)._m10(0.0f)._m11(1.0f)._m20(0.0f)._m21(0.0f);
        }

        @Override
        public void identity(Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(1.0)._m01(0.0)._m10(0.0)._m11(1.0)._m20(0.0)._m21(0.0);
        }

        @Override
        public void identity(Matrix2f matrix2f) {
            matrix2f._m00(1.0f)._m01(0.0f)._m10(0.0f)._m11(1.0f);
        }

        @Override
        public void swap(Matrix4f matrix4f, Matrix4f matrix4f2) {
            float f = matrix4f.m00();
            matrix4f._m00(matrix4f2.m00());
            matrix4f2._m00(f);
            f = matrix4f.m01();
            matrix4f._m01(matrix4f2.m01());
            matrix4f2._m01(f);
            f = matrix4f.m02();
            matrix4f._m02(matrix4f2.m02());
            matrix4f2._m02(f);
            f = matrix4f.m03();
            matrix4f._m03(matrix4f2.m03());
            matrix4f2._m03(f);
            f = matrix4f.m10();
            matrix4f._m10(matrix4f2.m10());
            matrix4f2._m10(f);
            f = matrix4f.m11();
            matrix4f._m11(matrix4f2.m11());
            matrix4f2._m11(f);
            f = matrix4f.m12();
            matrix4f._m12(matrix4f2.m12());
            matrix4f2._m12(f);
            f = matrix4f.m13();
            matrix4f._m13(matrix4f2.m13());
            matrix4f2._m13(f);
            f = matrix4f.m20();
            matrix4f._m20(matrix4f2.m20());
            matrix4f2._m20(f);
            f = matrix4f.m21();
            matrix4f._m21(matrix4f2.m21());
            matrix4f2._m21(f);
            f = matrix4f.m22();
            matrix4f._m22(matrix4f2.m22());
            matrix4f2._m22(f);
            f = matrix4f.m23();
            matrix4f._m23(matrix4f2.m23());
            matrix4f2._m23(f);
            f = matrix4f.m30();
            matrix4f._m30(matrix4f2.m30());
            matrix4f2._m30(f);
            f = matrix4f.m31();
            matrix4f._m31(matrix4f2.m31());
            matrix4f2._m31(f);
            f = matrix4f.m32();
            matrix4f._m32(matrix4f2.m32());
            matrix4f2._m32(f);
            f = matrix4f.m33();
            matrix4f._m33(matrix4f2.m33());
            matrix4f2._m33(f);
        }

        @Override
        public void swap(Matrix4x3f matrix4x3f, Matrix4x3f matrix4x3f2) {
            float f = matrix4x3f.m00();
            matrix4x3f._m00(matrix4x3f2.m00());
            matrix4x3f2._m00(f);
            f = matrix4x3f.m01();
            matrix4x3f._m01(matrix4x3f2.m01());
            matrix4x3f2._m01(f);
            f = matrix4x3f.m02();
            matrix4x3f._m02(matrix4x3f2.m02());
            matrix4x3f2._m02(f);
            f = matrix4x3f.m10();
            matrix4x3f._m10(matrix4x3f2.m10());
            matrix4x3f2._m10(f);
            f = matrix4x3f.m11();
            matrix4x3f._m11(matrix4x3f2.m11());
            matrix4x3f2._m11(f);
            f = matrix4x3f.m12();
            matrix4x3f._m12(matrix4x3f2.m12());
            matrix4x3f2._m12(f);
            f = matrix4x3f.m20();
            matrix4x3f._m20(matrix4x3f2.m20());
            matrix4x3f2._m20(f);
            f = matrix4x3f.m21();
            matrix4x3f._m21(matrix4x3f2.m21());
            matrix4x3f2._m21(f);
            f = matrix4x3f.m22();
            matrix4x3f._m22(matrix4x3f2.m22());
            matrix4x3f2._m22(f);
            f = matrix4x3f.m30();
            matrix4x3f._m30(matrix4x3f2.m30());
            matrix4x3f2._m30(f);
            f = matrix4x3f.m31();
            matrix4x3f._m31(matrix4x3f2.m31());
            matrix4x3f2._m31(f);
            f = matrix4x3f.m32();
            matrix4x3f._m32(matrix4x3f2.m32());
            matrix4x3f2._m32(f);
        }

        @Override
        public void swap(Matrix3f matrix3f, Matrix3f matrix3f2) {
            float f = matrix3f.m00();
            matrix3f._m00(matrix3f2.m00());
            matrix3f2._m00(f);
            f = matrix3f.m01();
            matrix3f._m01(matrix3f2.m01());
            matrix3f2._m01(f);
            f = matrix3f.m02();
            matrix3f._m02(matrix3f2.m02());
            matrix3f2._m02(f);
            f = matrix3f.m10();
            matrix3f._m10(matrix3f2.m10());
            matrix3f2._m10(f);
            f = matrix3f.m11();
            matrix3f._m11(matrix3f2.m11());
            matrix3f2._m11(f);
            f = matrix3f.m12();
            matrix3f._m12(matrix3f2.m12());
            matrix3f2._m12(f);
            f = matrix3f.m20();
            matrix3f._m20(matrix3f2.m20());
            matrix3f2._m20(f);
            f = matrix3f.m21();
            matrix3f._m21(matrix3f2.m21());
            matrix3f2._m21(f);
            f = matrix3f.m22();
            matrix3f._m22(matrix3f2.m22());
            matrix3f2._m22(f);
        }

        @Override
        public void swap(Matrix2f matrix2f, Matrix2f matrix2f2) {
            float f = matrix2f.m00();
            matrix2f._m00(matrix2f2.m00());
            matrix2f2._m00(f);
            f = matrix2f.m01();
            matrix2f._m00(matrix2f2.m01());
            matrix2f2._m01(f);
            f = matrix2f.m10();
            matrix2f._m00(matrix2f2.m10());
            matrix2f2._m10(f);
            f = matrix2f.m11();
            matrix2f._m00(matrix2f2.m11());
            matrix2f2._m11(f);
        }

        @Override
        public void swap(Matrix2d matrix2d, Matrix2d matrix2d2) {
            double d = matrix2d.m00();
            matrix2d._m00(matrix2d2.m00());
            matrix2d2._m00(d);
            d = matrix2d.m01();
            matrix2d._m00(matrix2d2.m01());
            matrix2d2._m01(d);
            d = matrix2d.m10();
            matrix2d._m00(matrix2d2.m10());
            matrix2d2._m10(d);
            d = matrix2d.m11();
            matrix2d._m00(matrix2d2.m11());
            matrix2d2._m11(d);
        }

        @Override
        public void zero(Matrix4f matrix4f) {
            matrix4f._m00(0.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(0.0f);
        }

        @Override
        public void zero(Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(0.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f);
        }

        @Override
        public void zero(Matrix3f matrix3f) {
            matrix3f._m00(0.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f);
        }

        @Override
        public void zero(Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(0.0f)._m01(0.0f)._m10(0.0f)._m11(0.0f)._m20(0.0f)._m21(0.0f);
        }

        @Override
        public void zero(Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(0.0)._m01(0.0)._m10(0.0)._m11(0.0)._m20(0.0)._m21(0.0);
        }

        @Override
        public void zero(Matrix2f matrix2f) {
            matrix2f._m00(0.0f)._m01(0.0f)._m10(0.0f)._m11(0.0f);
        }

        @Override
        public void zero(Matrix2d matrix2d) {
            matrix2d._m00(0.0)._m01(0.0)._m10(0.0)._m11(0.0);
        }

        @Override
        public void putMatrix3f(Quaternionf quaternionf, int n, ByteBuffer byteBuffer) {
            float f = quaternionf.w * quaternionf.w;
            float f2 = quaternionf.x * quaternionf.x;
            float f3 = quaternionf.y * quaternionf.y;
            float f4 = quaternionf.z * quaternionf.z;
            float f5 = quaternionf.z * quaternionf.w;
            float f6 = quaternionf.x * quaternionf.y;
            float f7 = quaternionf.x * quaternionf.z;
            float f8 = quaternionf.y * quaternionf.w;
            float f9 = quaternionf.y * quaternionf.z;
            float f10 = quaternionf.x * quaternionf.w;
            byteBuffer.putFloat(n, f + f2 - f4 - f3).putFloat(n + 4, f6 + f5 + f5 + f6).putFloat(n + 8, f7 - f8 + f7 - f8).putFloat(n + 12, -f5 + f6 - f5 + f6).putFloat(n + 16, f3 - f4 + f - f2).putFloat(n + 20, f9 + f9 + f10 + f10).putFloat(n + 24, f8 + f7 + f7 + f8).putFloat(n + 28, f9 + f9 - f10 - f10).putFloat(n + 32, f4 - f3 - f2 + f);
        }

        @Override
        public void putMatrix3f(Quaternionf quaternionf, int n, FloatBuffer floatBuffer) {
            float f = quaternionf.w * quaternionf.w;
            float f2 = quaternionf.x * quaternionf.x;
            float f3 = quaternionf.y * quaternionf.y;
            float f4 = quaternionf.z * quaternionf.z;
            float f5 = quaternionf.z * quaternionf.w;
            float f6 = quaternionf.x * quaternionf.y;
            float f7 = quaternionf.x * quaternionf.z;
            float f8 = quaternionf.y * quaternionf.w;
            float f9 = quaternionf.y * quaternionf.z;
            float f10 = quaternionf.x * quaternionf.w;
            floatBuffer.put(n, f + f2 - f4 - f3).put(n + 1, f6 + f5 + f5 + f6).put(n + 2, f7 - f8 + f7 - f8).put(n + 3, -f5 + f6 - f5 + f6).put(n + 4, f3 - f4 + f - f2).put(n + 5, f9 + f9 + f10 + f10).put(n + 6, f8 + f7 + f7 + f8).put(n + 7, f9 + f9 - f10 - f10).put(n + 8, f4 - f3 - f2 + f);
        }

        @Override
        public void putMatrix4f(Quaternionf quaternionf, int n, ByteBuffer byteBuffer) {
            float f = quaternionf.w * quaternionf.w;
            float f2 = quaternionf.x * quaternionf.x;
            float f3 = quaternionf.y * quaternionf.y;
            float f4 = quaternionf.z * quaternionf.z;
            float f5 = quaternionf.z * quaternionf.w;
            float f6 = quaternionf.x * quaternionf.y;
            float f7 = quaternionf.x * quaternionf.z;
            float f8 = quaternionf.y * quaternionf.w;
            float f9 = quaternionf.y * quaternionf.z;
            float f10 = quaternionf.x * quaternionf.w;
            byteBuffer.putFloat(n, f + f2 - f4 - f3).putFloat(n + 4, f6 + f5 + f5 + f6).putFloat(n + 8, f7 - f8 + f7 - f8).putFloat(n + 12, 0.0f).putFloat(n + 16, -f5 + f6 - f5 + f6).putFloat(n + 20, f3 - f4 + f - f2).putFloat(n + 24, f9 + f9 + f10 + f10).putFloat(n + 28, 0.0f).putFloat(n + 32, f8 + f7 + f7 + f8).putFloat(n + 36, f9 + f9 - f10 - f10).putFloat(n + 40, f4 - f3 - f2 + f).putFloat(n + 44, 0.0f).putLong(n + 48, 0L).putLong(n + 56, 4575657221408423936L);
        }

        @Override
        public void putMatrix4f(Quaternionf quaternionf, int n, FloatBuffer floatBuffer) {
            float f = quaternionf.w * quaternionf.w;
            float f2 = quaternionf.x * quaternionf.x;
            float f3 = quaternionf.y * quaternionf.y;
            float f4 = quaternionf.z * quaternionf.z;
            float f5 = quaternionf.z * quaternionf.w;
            float f6 = quaternionf.x * quaternionf.y;
            float f7 = quaternionf.x * quaternionf.z;
            float f8 = quaternionf.y * quaternionf.w;
            float f9 = quaternionf.y * quaternionf.z;
            float f10 = quaternionf.x * quaternionf.w;
            floatBuffer.put(n, f + f2 - f4 - f3).put(n + 1, f6 + f5 + f5 + f6).put(n + 2, f7 - f8 + f7 - f8).put(n + 3, 0.0f).put(n + 4, -f5 + f6 - f5 + f6).put(n + 5, f3 - f4 + f - f2).put(n + 6, f9 + f9 + f10 + f10).put(n + 7, 0.0f).put(n + 8, f8 + f7 + f7 + f8).put(n + 9, f9 + f9 - f10 - f10).put(n + 10, f4 - f3 - f2 + f).put(n + 11, 0.0f).put(n + 12, 0.0f).put(n + 13, 0.0f).put(n + 14, 0.0f).put(n + 15, 1.0f);
        }

        @Override
        public void putMatrix4x3f(Quaternionf quaternionf, int n, ByteBuffer byteBuffer) {
            float f = quaternionf.w * quaternionf.w;
            float f2 = quaternionf.x * quaternionf.x;
            float f3 = quaternionf.y * quaternionf.y;
            float f4 = quaternionf.z * quaternionf.z;
            float f5 = quaternionf.z * quaternionf.w;
            float f6 = quaternionf.x * quaternionf.y;
            float f7 = quaternionf.x * quaternionf.z;
            float f8 = quaternionf.y * quaternionf.w;
            float f9 = quaternionf.y * quaternionf.z;
            float f10 = quaternionf.x * quaternionf.w;
            byteBuffer.putFloat(n, f + f2 - f4 - f3).putFloat(n + 4, f6 + f5 + f5 + f6).putFloat(n + 8, f7 - f8 + f7 - f8).putFloat(n + 12, -f5 + f6 - f5 + f6).putFloat(n + 16, f3 - f4 + f - f2).putFloat(n + 20, f9 + f9 + f10 + f10).putFloat(n + 24, f8 + f7 + f7 + f8).putFloat(n + 28, f9 + f9 - f10 - f10).putFloat(n + 32, f4 - f3 - f2 + f).putLong(n + 36, 0L).putFloat(n + 44, 0.0f);
        }

        @Override
        public void putMatrix4x3f(Quaternionf quaternionf, int n, FloatBuffer floatBuffer) {
            float f = quaternionf.w * quaternionf.w;
            float f2 = quaternionf.x * quaternionf.x;
            float f3 = quaternionf.y * quaternionf.y;
            float f4 = quaternionf.z * quaternionf.z;
            float f5 = quaternionf.z * quaternionf.w;
            float f6 = quaternionf.x * quaternionf.y;
            float f7 = quaternionf.x * quaternionf.z;
            float f8 = quaternionf.y * quaternionf.w;
            float f9 = quaternionf.y * quaternionf.z;
            float f10 = quaternionf.x * quaternionf.w;
            floatBuffer.put(n, f + f2 - f4 - f3).put(n + 1, f6 + f5 + f5 + f6).put(n + 2, f7 - f8 + f7 - f8).put(n + 3, -f5 + f6 - f5 + f6).put(n + 4, f3 - f4 + f - f2).put(n + 5, f9 + f9 + f10 + f10).put(n + 6, f8 + f7 + f7 + f8).put(n + 7, f9 + f9 - f10 - f10).put(n + 8, f4 - f3 - f2 + f).put(n + 9, 0.0f).put(n + 10, 0.0f).put(n + 11, 0.0f);
        }
    }

    public static class MemUtilUnsafe
    extends MemUtilNIO {
        public static final Unsafe UNSAFE = MemUtilUnsafe.getUnsafeInstance();
        public static final long ADDRESS;
        public static final long Matrix2f_m00;
        public static final long Matrix3f_m00;
        public static final long Matrix3d_m00;
        public static final long Matrix4f_m00;
        public static final long Matrix4d_m00;
        public static final long Matrix4x3f_m00;
        public static final long Matrix3x2f_m00;
        public static final long Vector4f_x;
        public static final long Vector4i_x;
        public static final long Vector3f_x;
        public static final long Vector3i_x;
        public static final long Vector2f_x;
        public static final long Vector2i_x;
        public static final long Quaternionf_x;
        public static final long floatArrayOffset;

        private static long findBufferAddress() {
            try {
                return UNSAFE.objectFieldOffset(MemUtilUnsafe.getDeclaredField(Buffer.class, "address"));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(exception);
            }
        }

        private static long checkMatrix4f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix4f.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 16; ++i) {
                int n = i >>> 2;
                int n2 = i & 3;
                field = Matrix4f.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix4f element offset");
            }
            return l;
        }

        private static long checkMatrix4d() throws NoSuchFieldException, SecurityException {
            Field field = Matrix4d.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 16; ++i) {
                int n = i >>> 2;
                int n2 = i & 3;
                field = Matrix4d.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 3)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix4d element offset");
            }
            return l;
        }

        private static long checkMatrix4x3f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix4x3f.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 12; ++i) {
                int n = i / 3;
                int n2 = i % 3;
                field = Matrix4x3f.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix4x3f element offset");
            }
            return l;
        }

        private static long checkMatrix3f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix3f.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 9; ++i) {
                int n = i / 3;
                int n2 = i % 3;
                field = Matrix3f.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix3f element offset");
            }
            return l;
        }

        private static long checkMatrix3d() throws NoSuchFieldException, SecurityException {
            Field field = Matrix3d.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 9; ++i) {
                int n = i / 3;
                int n2 = i % 3;
                field = Matrix3d.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 3)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix3d element offset");
            }
            return l;
        }

        private static long checkMatrix3x2f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix3x2f.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 6; ++i) {
                int n = i / 2;
                int n2 = i % 2;
                field = Matrix3x2f.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix3x2f element offset");
            }
            return l;
        }

        private static long checkMatrix2f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix2f.class.getDeclaredField("m00");
            long l = UNSAFE.objectFieldOffset(field);
            for (int i = 1; i < 4; ++i) {
                int n = i / 2;
                int n2 = i % 2;
                field = Matrix2f.class.getDeclaredField("m" + n + n2);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix2f element offset");
            }
            return l;
        }

        private static long checkVector4f() throws NoSuchFieldException, SecurityException {
            Field field = Vector4f.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                field = Vector4f.class.getDeclaredField(stringArray[i - 1]);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector4f element offset");
            }
            return l;
        }

        private static long checkVector4i() throws NoSuchFieldException, SecurityException {
            Field field = Vector4i.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                field = Vector4i.class.getDeclaredField(stringArray[i - 1]);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector4i element offset");
            }
            return l;
        }

        private static long checkVector3f() throws NoSuchFieldException, SecurityException {
            Field field = Vector3f.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z"};
            for (int i = 1; i < 3; ++i) {
                field = Vector3f.class.getDeclaredField(stringArray[i - 1]);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector3f element offset");
            }
            return l;
        }

        private static long checkVector3i() throws NoSuchFieldException, SecurityException {
            Field field = Vector3i.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z"};
            for (int i = 1; i < 3; ++i) {
                field = Vector3i.class.getDeclaredField(stringArray[i - 1]);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector3i element offset");
            }
            return l;
        }

        private static long checkVector2f() throws NoSuchFieldException, SecurityException {
            Field field = Vector2f.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            field = Vector2f.class.getDeclaredField("y");
            long l2 = UNSAFE.objectFieldOffset(field);
            if (l2 != l + 4L) {
                throw new UnsupportedOperationException("Unexpected Vector2f element offset");
            }
            return l;
        }

        private static long checkVector2i() throws NoSuchFieldException, SecurityException {
            Field field = Vector2i.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            field = Vector2i.class.getDeclaredField("y");
            long l2 = UNSAFE.objectFieldOffset(field);
            if (l2 != l + 4L) {
                throw new UnsupportedOperationException("Unexpected Vector2i element offset");
            }
            return l;
        }

        private static long checkQuaternionf() throws NoSuchFieldException, SecurityException {
            Field field = Quaternionf.class.getDeclaredField("x");
            long l = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                field = Quaternionf.class.getDeclaredField(stringArray[i - 1]);
                long l2 = UNSAFE.objectFieldOffset(field);
                if (l2 == l + (long)(i << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Quaternionf element offset");
            }
            return l;
        }

        private static Field getDeclaredField(Class clazz, String string) throws NoSuchFieldException {
            Class clazz2 = clazz;
            do {
                try {
                    Field field = clazz2.getDeclaredField(string);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    clazz2 = clazz2.getSuperclass();
                }
                catch (SecurityException securityException) {
                    clazz2 = clazz2.getSuperclass();
                }
            } while (clazz2 != null);
            throw new NoSuchFieldException(string + " does not exist in " + clazz.getName() + " or any of its superclasses.");
        }

        public static Unsafe getUnsafeInstance() throws SecurityException {
            Field[] fieldArray = Unsafe.class.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                int n;
                Field field = fieldArray[i];
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(n = field.getModifiers()) || !Modifier.isFinal(n)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static void put(Matrix4f matrix4f, long l) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 3), UNSAFE.getLong(matrix4f, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        public static void put4x3(Matrix4f matrix4f, long l) {
            Unsafe unsafe = UNSAFE;
            for (int i = 0; i < 4; ++i) {
                unsafe.putLong(null, l + (long)(12 * i), unsafe.getLong(matrix4f, Matrix4f_m00 + (long)(i << 4)));
            }
            unsafe.putFloat(null, l + 8L, matrix4f.m02());
            unsafe.putFloat(null, l + 20L, matrix4f.m12());
            unsafe.putFloat(null, l + 32L, matrix4f.m22());
            unsafe.putFloat(null, l + 44L, matrix4f.m32());
        }

        public static void put3x4(Matrix4f matrix4f, long l) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 3), UNSAFE.getLong(matrix4f, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        public static void put(Matrix4x3f matrix4x3f, long l) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 3), UNSAFE.getLong(matrix4x3f, Matrix4x3f_m00 + (long)(i << 3)));
            }
        }

        public static void put4x4(Matrix4x3f matrix4x3f, long l) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 4), UNSAFE.getLong(matrix4x3f, Matrix4x3f_m00 + (long)(12 * i)));
                long l2 = (long)UNSAFE.getInt(matrix4x3f, Matrix4x3f_m00 + 8L + (long)(12 * i)) & 0xFFFFFFFFL;
                UNSAFE.putLong(null, l + 8L + (long)(i << 4), l2);
            }
            UNSAFE.putFloat(null, l + 60L, 1.0f);
        }

        public static void put3x4(Matrix4x3f matrix4x3f, long l) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 4), UNSAFE.getLong(matrix4x3f, Matrix4x3f_m00 + (long)(12 * i)));
                UNSAFE.putFloat(null, l + (long)(i << 4) + 8L, UNSAFE.getFloat(matrix4x3f, Matrix4x3f_m00 + 8L + (long)(12 * i)));
                UNSAFE.putFloat(null, l + (long)(i << 4) + 12L, 0.0f);
            }
        }

        public static void put4x4(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix4x3d.m00());
            unsafe.putDouble(null, l + 8L, matrix4x3d.m01());
            unsafe.putDouble(null, l + 16L, matrix4x3d.m02());
            unsafe.putDouble(null, l + 24L, 0.0);
            unsafe.putDouble(null, l + 32L, matrix4x3d.m10());
            unsafe.putDouble(null, l + 40L, matrix4x3d.m11());
            unsafe.putDouble(null, l + 48L, matrix4x3d.m12());
            unsafe.putDouble(null, l + 56L, 0.0);
            unsafe.putDouble(null, l + 64L, matrix4x3d.m20());
            unsafe.putDouble(null, l + 72L, matrix4x3d.m21());
            unsafe.putDouble(null, l + 80L, matrix4x3d.m22());
            unsafe.putDouble(null, l + 88L, 0.0);
            unsafe.putDouble(null, l + 96L, matrix4x3d.m30());
            unsafe.putDouble(null, l + 104L, matrix4x3d.m31());
            unsafe.putDouble(null, l + 112L, matrix4x3d.m32());
            unsafe.putDouble(null, l + 120L, 1.0);
        }

        public static void put4x4(Matrix3x2f matrix3x2f, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putLong(null, l, unsafe.getLong(matrix3x2f, Matrix3x2f_m00));
            unsafe.putLong(null, l + 8L, 0L);
            unsafe.putLong(null, l + 16L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 8L));
            unsafe.putLong(null, l + 24L, 0L);
            unsafe.putLong(null, l + 32L, 0L);
            unsafe.putLong(null, l + 40L, 1065353216L);
            unsafe.putLong(null, l + 48L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 16L));
            unsafe.putLong(null, l + 56L, 4575657221408423936L);
        }

        public static void put4x4(Matrix3x2d matrix3x2d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix3x2d.m00());
            unsafe.putDouble(null, l + 8L, matrix3x2d.m01());
            unsafe.putDouble(null, l + 16L, 0.0);
            unsafe.putDouble(null, l + 24L, 0.0);
            unsafe.putDouble(null, l + 32L, matrix3x2d.m10());
            unsafe.putDouble(null, l + 40L, matrix3x2d.m11());
            unsafe.putDouble(null, l + 48L, 0.0);
            unsafe.putDouble(null, l + 56L, 0.0);
            unsafe.putDouble(null, l + 64L, 0.0);
            unsafe.putDouble(null, l + 72L, 0.0);
            unsafe.putDouble(null, l + 80L, 1.0);
            unsafe.putDouble(null, l + 88L, 0.0);
            unsafe.putDouble(null, l + 96L, matrix3x2d.m20());
            unsafe.putDouble(null, l + 104L, matrix3x2d.m21());
            unsafe.putDouble(null, l + 112L, 0.0);
            unsafe.putDouble(null, l + 120L, 1.0);
        }

        public static void put3x3(Matrix3x2f matrix3x2f, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putLong(null, l, unsafe.getLong(matrix3x2f, Matrix3x2f_m00));
            unsafe.putInt(null, l + 8L, 0);
            unsafe.putLong(null, l + 12L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 8L));
            unsafe.putInt(null, l + 20L, 0);
            unsafe.putLong(null, l + 24L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 16L));
            unsafe.putFloat(null, l + 32L, 0.0f);
        }

        public static void put3x3(Matrix3x2d matrix3x2d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix3x2d.m00());
            unsafe.putDouble(null, l + 8L, matrix3x2d.m01());
            unsafe.putDouble(null, l + 16L, 0.0);
            unsafe.putDouble(null, l + 24L, matrix3x2d.m10());
            unsafe.putDouble(null, l + 32L, matrix3x2d.m11());
            unsafe.putDouble(null, l + 40L, 0.0);
            unsafe.putDouble(null, l + 48L, matrix3x2d.m20());
            unsafe.putDouble(null, l + 56L, matrix3x2d.m21());
            unsafe.putDouble(null, l + 64L, 1.0);
        }

        public static void putTransposed(Matrix4f matrix4f, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, matrix4f.m00());
            unsafe.putFloat(null, l + 4L, matrix4f.m10());
            unsafe.putFloat(null, l + 8L, matrix4f.m20());
            unsafe.putFloat(null, l + 12L, matrix4f.m30());
            unsafe.putFloat(null, l + 16L, matrix4f.m01());
            unsafe.putFloat(null, l + 20L, matrix4f.m11());
            unsafe.putFloat(null, l + 24L, matrix4f.m21());
            unsafe.putFloat(null, l + 28L, matrix4f.m31());
            unsafe.putFloat(null, l + 32L, matrix4f.m02());
            unsafe.putFloat(null, l + 36L, matrix4f.m12());
            unsafe.putFloat(null, l + 40L, matrix4f.m22());
            unsafe.putFloat(null, l + 44L, matrix4f.m32());
            unsafe.putFloat(null, l + 48L, matrix4f.m03());
            unsafe.putFloat(null, l + 52L, matrix4f.m13());
            unsafe.putFloat(null, l + 56L, matrix4f.m23());
            unsafe.putFloat(null, l + 60L, matrix4f.m33());
        }

        public static void put4x3Transposed(Matrix4f matrix4f, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, matrix4f.m00());
            unsafe.putFloat(null, l + 4L, matrix4f.m10());
            unsafe.putFloat(null, l + 8L, matrix4f.m20());
            unsafe.putFloat(null, l + 12L, matrix4f.m30());
            unsafe.putFloat(null, l + 16L, matrix4f.m01());
            unsafe.putFloat(null, l + 20L, matrix4f.m11());
            unsafe.putFloat(null, l + 24L, matrix4f.m21());
            unsafe.putFloat(null, l + 28L, matrix4f.m31());
            unsafe.putFloat(null, l + 32L, matrix4f.m02());
            unsafe.putFloat(null, l + 36L, matrix4f.m12());
            unsafe.putFloat(null, l + 40L, matrix4f.m22());
            unsafe.putFloat(null, l + 44L, matrix4f.m32());
        }

        public static void putTransposed(Matrix4x3f matrix4x3f, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, matrix4x3f.m00());
            unsafe.putFloat(null, l + 4L, matrix4x3f.m10());
            unsafe.putFloat(null, l + 8L, matrix4x3f.m20());
            unsafe.putFloat(null, l + 12L, matrix4x3f.m30());
            unsafe.putFloat(null, l + 16L, matrix4x3f.m01());
            unsafe.putFloat(null, l + 20L, matrix4x3f.m11());
            unsafe.putFloat(null, l + 24L, matrix4x3f.m21());
            unsafe.putFloat(null, l + 28L, matrix4x3f.m31());
            unsafe.putFloat(null, l + 32L, matrix4x3f.m02());
            unsafe.putFloat(null, l + 36L, matrix4x3f.m12());
            unsafe.putFloat(null, l + 40L, matrix4x3f.m22());
            unsafe.putFloat(null, l + 44L, matrix4x3f.m32());
        }

        public static void putTransposed(Matrix3f matrix3f, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, matrix3f.m00());
            unsafe.putFloat(null, l + 4L, matrix3f.m10());
            unsafe.putFloat(null, l + 8L, matrix3f.m20());
            unsafe.putFloat(null, l + 12L, matrix3f.m01());
            unsafe.putFloat(null, l + 16L, matrix3f.m11());
            unsafe.putFloat(null, l + 20L, matrix3f.m21());
            unsafe.putFloat(null, l + 24L, matrix3f.m02());
            unsafe.putFloat(null, l + 28L, matrix3f.m12());
            unsafe.putFloat(null, l + 32L, matrix3f.m22());
        }

        public static void putTransposed(Matrix2f matrix2f, long l) {
            UNSAFE.putFloat(null, l, matrix2f.m00());
            UNSAFE.putFloat(null, l + 4L, matrix2f.m10());
            UNSAFE.putFloat(null, l + 8L, matrix2f.m01());
            UNSAFE.putFloat(null, l + 12L, matrix2f.m11());
        }

        public static void put(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix4d.m00());
            unsafe.putDouble(null, l + 8L, matrix4d.m01());
            unsafe.putDouble(null, l + 16L, matrix4d.m02());
            unsafe.putDouble(null, l + 24L, matrix4d.m03());
            unsafe.putDouble(null, l + 32L, matrix4d.m10());
            unsafe.putDouble(null, l + 40L, matrix4d.m11());
            unsafe.putDouble(null, l + 48L, matrix4d.m12());
            unsafe.putDouble(null, l + 56L, matrix4d.m13());
            unsafe.putDouble(null, l + 64L, matrix4d.m20());
            unsafe.putDouble(null, l + 72L, matrix4d.m21());
            unsafe.putDouble(null, l + 80L, matrix4d.m22());
            unsafe.putDouble(null, l + 88L, matrix4d.m23());
            unsafe.putDouble(null, l + 96L, matrix4d.m30());
            unsafe.putDouble(null, l + 104L, matrix4d.m31());
            unsafe.putDouble(null, l + 112L, matrix4d.m32());
            unsafe.putDouble(null, l + 120L, matrix4d.m33());
        }

        public static void put(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix4x3d.m00());
            unsafe.putDouble(null, l + 8L, matrix4x3d.m01());
            unsafe.putDouble(null, l + 16L, matrix4x3d.m02());
            unsafe.putDouble(null, l + 24L, matrix4x3d.m10());
            unsafe.putDouble(null, l + 32L, matrix4x3d.m11());
            unsafe.putDouble(null, l + 40L, matrix4x3d.m12());
            unsafe.putDouble(null, l + 48L, matrix4x3d.m20());
            unsafe.putDouble(null, l + 56L, matrix4x3d.m21());
            unsafe.putDouble(null, l + 64L, matrix4x3d.m22());
            unsafe.putDouble(null, l + 72L, matrix4x3d.m30());
            unsafe.putDouble(null, l + 80L, matrix4x3d.m31());
            unsafe.putDouble(null, l + 88L, matrix4x3d.m32());
        }

        public static void putTransposed(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix4d.m00());
            unsafe.putDouble(null, l + 8L, matrix4d.m10());
            unsafe.putDouble(null, l + 16L, matrix4d.m20());
            unsafe.putDouble(null, l + 24L, matrix4d.m30());
            unsafe.putDouble(null, l + 32L, matrix4d.m01());
            unsafe.putDouble(null, l + 40L, matrix4d.m11());
            unsafe.putDouble(null, l + 48L, matrix4d.m21());
            unsafe.putDouble(null, l + 56L, matrix4d.m31());
            unsafe.putDouble(null, l + 64L, matrix4d.m02());
            unsafe.putDouble(null, l + 72L, matrix4d.m12());
            unsafe.putDouble(null, l + 80L, matrix4d.m22());
            unsafe.putDouble(null, l + 88L, matrix4d.m32());
            unsafe.putDouble(null, l + 96L, matrix4d.m03());
            unsafe.putDouble(null, l + 104L, matrix4d.m13());
            unsafe.putDouble(null, l + 112L, matrix4d.m23());
            unsafe.putDouble(null, l + 120L, matrix4d.m33());
        }

        public static void putfTransposed(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, (float)matrix4d.m00());
            unsafe.putFloat(null, l + 4L, (float)matrix4d.m10());
            unsafe.putFloat(null, l + 8L, (float)matrix4d.m20());
            unsafe.putFloat(null, l + 12L, (float)matrix4d.m30());
            unsafe.putFloat(null, l + 16L, (float)matrix4d.m01());
            unsafe.putFloat(null, l + 20L, (float)matrix4d.m11());
            unsafe.putFloat(null, l + 24L, (float)matrix4d.m21());
            unsafe.putFloat(null, l + 28L, (float)matrix4d.m31());
            unsafe.putFloat(null, l + 32L, (float)matrix4d.m02());
            unsafe.putFloat(null, l + 36L, (float)matrix4d.m12());
            unsafe.putFloat(null, l + 40L, (float)matrix4d.m22());
            unsafe.putFloat(null, l + 44L, (float)matrix4d.m32());
            unsafe.putFloat(null, l + 48L, (float)matrix4d.m03());
            unsafe.putFloat(null, l + 52L, (float)matrix4d.m13());
            unsafe.putFloat(null, l + 56L, (float)matrix4d.m23());
            unsafe.putFloat(null, l + 60L, (float)matrix4d.m33());
        }

        public static void put4x3Transposed(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix4d.m00());
            unsafe.putDouble(null, l + 8L, matrix4d.m10());
            unsafe.putDouble(null, l + 16L, matrix4d.m20());
            unsafe.putDouble(null, l + 24L, matrix4d.m30());
            unsafe.putDouble(null, l + 32L, matrix4d.m01());
            unsafe.putDouble(null, l + 40L, matrix4d.m11());
            unsafe.putDouble(null, l + 48L, matrix4d.m21());
            unsafe.putDouble(null, l + 56L, matrix4d.m31());
            unsafe.putDouble(null, l + 64L, matrix4d.m02());
            unsafe.putDouble(null, l + 72L, matrix4d.m12());
            unsafe.putDouble(null, l + 80L, matrix4d.m22());
            unsafe.putDouble(null, l + 88L, matrix4d.m32());
        }

        public static void putTransposed(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix4x3d.m00());
            unsafe.putDouble(null, l + 8L, matrix4x3d.m10());
            unsafe.putDouble(null, l + 16L, matrix4x3d.m20());
            unsafe.putDouble(null, l + 24L, matrix4x3d.m30());
            unsafe.putDouble(null, l + 32L, matrix4x3d.m01());
            unsafe.putDouble(null, l + 40L, matrix4x3d.m11());
            unsafe.putDouble(null, l + 48L, matrix4x3d.m21());
            unsafe.putDouble(null, l + 56L, matrix4x3d.m31());
            unsafe.putDouble(null, l + 64L, matrix4x3d.m02());
            unsafe.putDouble(null, l + 72L, matrix4x3d.m12());
            unsafe.putDouble(null, l + 80L, matrix4x3d.m22());
            unsafe.putDouble(null, l + 88L, matrix4x3d.m32());
        }

        public static void putTransposed(Matrix2d matrix2d, long l) {
            UNSAFE.putDouble(null, l, matrix2d.m00());
            UNSAFE.putDouble(null, l + 8L, matrix2d.m10());
            UNSAFE.putDouble(null, l + 16L, matrix2d.m10());
            UNSAFE.putDouble(null, l + 24L, matrix2d.m10());
        }

        public static void putfTransposed(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, (float)matrix4x3d.m00());
            unsafe.putFloat(null, l + 4L, (float)matrix4x3d.m10());
            unsafe.putFloat(null, l + 8L, (float)matrix4x3d.m20());
            unsafe.putFloat(null, l + 12L, (float)matrix4x3d.m30());
            unsafe.putFloat(null, l + 16L, (float)matrix4x3d.m01());
            unsafe.putFloat(null, l + 20L, (float)matrix4x3d.m11());
            unsafe.putFloat(null, l + 24L, (float)matrix4x3d.m21());
            unsafe.putFloat(null, l + 28L, (float)matrix4x3d.m31());
            unsafe.putFloat(null, l + 32L, (float)matrix4x3d.m02());
            unsafe.putFloat(null, l + 36L, (float)matrix4x3d.m12());
            unsafe.putFloat(null, l + 40L, (float)matrix4x3d.m22());
            unsafe.putFloat(null, l + 44L, (float)matrix4x3d.m32());
        }

        public static void putfTransposed(Matrix2d matrix2d, long l) {
            UNSAFE.putFloat(null, l, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l + 4L, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l + 8L, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l + 12L, (float)matrix2d.m00());
        }

        public static void putf(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, (float)matrix4d.m00());
            unsafe.putFloat(null, l + 4L, (float)matrix4d.m01());
            unsafe.putFloat(null, l + 8L, (float)matrix4d.m02());
            unsafe.putFloat(null, l + 12L, (float)matrix4d.m03());
            unsafe.putFloat(null, l + 16L, (float)matrix4d.m10());
            unsafe.putFloat(null, l + 20L, (float)matrix4d.m11());
            unsafe.putFloat(null, l + 24L, (float)matrix4d.m12());
            unsafe.putFloat(null, l + 28L, (float)matrix4d.m13());
            unsafe.putFloat(null, l + 32L, (float)matrix4d.m20());
            unsafe.putFloat(null, l + 36L, (float)matrix4d.m21());
            unsafe.putFloat(null, l + 40L, (float)matrix4d.m22());
            unsafe.putFloat(null, l + 44L, (float)matrix4d.m23());
            unsafe.putFloat(null, l + 48L, (float)matrix4d.m30());
            unsafe.putFloat(null, l + 52L, (float)matrix4d.m31());
            unsafe.putFloat(null, l + 56L, (float)matrix4d.m32());
            unsafe.putFloat(null, l + 60L, (float)matrix4d.m33());
        }

        public static void putf(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, (float)matrix4x3d.m00());
            unsafe.putFloat(null, l + 4L, (float)matrix4x3d.m01());
            unsafe.putFloat(null, l + 8L, (float)matrix4x3d.m02());
            unsafe.putFloat(null, l + 12L, (float)matrix4x3d.m10());
            unsafe.putFloat(null, l + 16L, (float)matrix4x3d.m11());
            unsafe.putFloat(null, l + 20L, (float)matrix4x3d.m12());
            unsafe.putFloat(null, l + 24L, (float)matrix4x3d.m20());
            unsafe.putFloat(null, l + 28L, (float)matrix4x3d.m21());
            unsafe.putFloat(null, l + 32L, (float)matrix4x3d.m22());
            unsafe.putFloat(null, l + 36L, (float)matrix4x3d.m30());
            unsafe.putFloat(null, l + 40L, (float)matrix4x3d.m31());
            unsafe.putFloat(null, l + 44L, (float)matrix4x3d.m32());
        }

        public static void put(Matrix3f matrix3f, long l) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 3), UNSAFE.getLong(matrix3f, Matrix3f_m00 + (long)(i << 3)));
            }
            UNSAFE.putFloat(null, l + 32L, matrix3f.m22());
        }

        public static void put3x4(Matrix3f matrix3f, long l) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 4), UNSAFE.getLong(matrix3f, Matrix3f_m00 + (long)(12 * i)));
                UNSAFE.putFloat(null, l + (long)(i << 4) + 8L, UNSAFE.getFloat(matrix3f, Matrix3f_m00 + 8L + (long)(12 * i)));
                UNSAFE.putFloat(null, l + (long)(12 * i), 0.0f);
            }
        }

        public static void put(Matrix3d matrix3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix3d.m00());
            unsafe.putDouble(null, l + 8L, matrix3d.m01());
            unsafe.putDouble(null, l + 16L, matrix3d.m02());
            unsafe.putDouble(null, l + 24L, matrix3d.m10());
            unsafe.putDouble(null, l + 32L, matrix3d.m11());
            unsafe.putDouble(null, l + 40L, matrix3d.m12());
            unsafe.putDouble(null, l + 48L, matrix3d.m20());
            unsafe.putDouble(null, l + 56L, matrix3d.m21());
            unsafe.putDouble(null, l + 64L, matrix3d.m22());
        }

        public static void put(Matrix3x2f matrix3x2f, long l) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putLong(null, l + (long)(i << 3), UNSAFE.getLong(matrix3x2f, Matrix3x2f_m00 + (long)(i << 3)));
            }
        }

        public static void put(Matrix3x2d matrix3x2d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l, matrix3x2d.m00());
            unsafe.putDouble(null, l + 8L, matrix3x2d.m01());
            unsafe.putDouble(null, l + 16L, matrix3x2d.m10());
            unsafe.putDouble(null, l + 24L, matrix3x2d.m11());
            unsafe.putDouble(null, l + 32L, matrix3x2d.m20());
            unsafe.putDouble(null, l + 40L, matrix3x2d.m21());
        }

        public static void putf(Matrix3d matrix3d, long l) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, (float)matrix3d.m00());
            unsafe.putFloat(null, l + 4L, (float)matrix3d.m01());
            unsafe.putFloat(null, l + 8L, (float)matrix3d.m02());
            unsafe.putFloat(null, l + 12L, (float)matrix3d.m10());
            unsafe.putFloat(null, l + 16L, (float)matrix3d.m11());
            unsafe.putFloat(null, l + 20L, (float)matrix3d.m12());
            unsafe.putFloat(null, l + 24L, (float)matrix3d.m20());
            unsafe.putFloat(null, l + 28L, (float)matrix3d.m21());
            unsafe.putFloat(null, l + 32L, (float)matrix3d.m22());
        }

        public static void put(Matrix2f matrix2f, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(matrix2f, Matrix2f_m00));
            UNSAFE.putLong(null, l + 8L, UNSAFE.getLong(matrix2f, Matrix2f_m00 + 8L));
        }

        public static void put(Matrix2d matrix2d, long l) {
            UNSAFE.putDouble(null, l, matrix2d.m00());
            UNSAFE.putDouble(null, l + 8L, matrix2d.m01());
            UNSAFE.putDouble(null, l + 16L, matrix2d.m10());
            UNSAFE.putDouble(null, l + 24L, matrix2d.m11());
        }

        public static void putf(Matrix2d matrix2d, long l) {
            UNSAFE.putFloat(null, l, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l + 4L, (float)matrix2d.m01());
            UNSAFE.putFloat(null, l + 8L, (float)matrix2d.m10());
            UNSAFE.putFloat(null, l + 12L, (float)matrix2d.m11());
        }

        public static void put(Vector4d vector4d, long l) {
            UNSAFE.putDouble(null, l, vector4d.x);
            UNSAFE.putDouble(null, l + 8L, vector4d.y);
            UNSAFE.putDouble(null, l + 16L, vector4d.z);
            UNSAFE.putDouble(null, l + 24L, vector4d.w);
        }

        public static void putf(Vector4d vector4d, long l) {
            UNSAFE.putFloat(null, l, (float)vector4d.x);
            UNSAFE.putFloat(null, l + 4L, (float)vector4d.y);
            UNSAFE.putFloat(null, l + 8L, (float)vector4d.z);
            UNSAFE.putFloat(null, l + 12L, (float)vector4d.w);
        }

        public static void put(Vector4f vector4f, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(vector4f, Vector4f_x));
            UNSAFE.putLong(null, l + 8L, UNSAFE.getLong(vector4f, Vector4f_x + 8L));
        }

        public static void put(Vector4i vector4i, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(vector4i, Vector4i_x));
            UNSAFE.putLong(null, l + 8L, UNSAFE.getLong(vector4i, Vector4i_x + 8L));
        }

        public static void put(Vector3f vector3f, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(vector3f, Vector3f_x));
            UNSAFE.putFloat(null, l + 8L, vector3f.z);
        }

        public static void put(Vector3d vector3d, long l) {
            UNSAFE.putDouble(null, l, vector3d.x);
            UNSAFE.putDouble(null, l + 8L, vector3d.y);
            UNSAFE.putDouble(null, l + 16L, vector3d.z);
        }

        public static void putf(Vector3d vector3d, long l) {
            UNSAFE.putFloat(null, l, (float)vector3d.x);
            UNSAFE.putFloat(null, l + 4L, (float)vector3d.y);
            UNSAFE.putFloat(null, l + 8L, (float)vector3d.z);
        }

        public static void put(Vector3i vector3i, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(vector3i, Vector3i_x));
            UNSAFE.putInt(null, l + 8L, vector3i.z);
        }

        public static void put(Vector2f vector2f, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(vector2f, Vector2f_x));
        }

        public static void put(Vector2d vector2d, long l) {
            UNSAFE.putDouble(null, l, vector2d.x);
            UNSAFE.putDouble(null, l + 8L, vector2d.y);
        }

        public static void put(Vector2i vector2i, long l) {
            UNSAFE.putLong(null, l, UNSAFE.getLong(vector2i, Vector2i_x));
        }

        public static void get(Matrix4f matrix4f, long l) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putLong(matrix4f, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(l + (long)(i << 3)));
            }
        }

        public static void getTransposed(Matrix4f matrix4f, long l) {
            matrix4f._m00(UNSAFE.getFloat(l))._m10(UNSAFE.getFloat(l + 4L))._m20(UNSAFE.getFloat(l + 8L))._m30(UNSAFE.getFloat(l + 12L))._m01(UNSAFE.getFloat(l + 16L))._m11(UNSAFE.getFloat(l + 20L))._m21(UNSAFE.getFloat(l + 24L))._m31(UNSAFE.getFloat(l + 28L))._m02(UNSAFE.getFloat(l + 32L))._m12(UNSAFE.getFloat(l + 36L))._m22(UNSAFE.getFloat(l + 40L))._m32(UNSAFE.getFloat(l + 44L))._m03(UNSAFE.getFloat(l + 48L))._m13(UNSAFE.getFloat(l + 52L))._m23(UNSAFE.getFloat(l + 56L))._m33(UNSAFE.getFloat(l + 60L));
        }

        public static void get(Matrix4x3f matrix4x3f, long l) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putLong(matrix4x3f, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(l + (long)(i << 3)));
            }
        }

        public static void get(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix4d._m00(unsafe.getDouble(null, l))._m01(unsafe.getDouble(null, l + 8L))._m02(unsafe.getDouble(null, l + 16L))._m03(unsafe.getDouble(null, l + 24L))._m10(unsafe.getDouble(null, l + 32L))._m11(unsafe.getDouble(null, l + 40L))._m12(unsafe.getDouble(null, l + 48L))._m13(unsafe.getDouble(null, l + 56L))._m20(unsafe.getDouble(null, l + 64L))._m21(unsafe.getDouble(null, l + 72L))._m22(unsafe.getDouble(null, l + 80L))._m23(unsafe.getDouble(null, l + 88L))._m30(unsafe.getDouble(null, l + 96L))._m31(unsafe.getDouble(null, l + 104L))._m32(unsafe.getDouble(null, l + 112L))._m33(unsafe.getDouble(null, l + 120L));
        }

        public static void get(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix4x3d._m00(unsafe.getDouble(null, l))._m01(unsafe.getDouble(null, l + 8L))._m02(unsafe.getDouble(null, l + 16L))._m10(unsafe.getDouble(null, l + 24L))._m11(unsafe.getDouble(null, l + 32L))._m12(unsafe.getDouble(null, l + 40L))._m20(unsafe.getDouble(null, l + 48L))._m21(unsafe.getDouble(null, l + 56L))._m22(unsafe.getDouble(null, l + 64L))._m30(unsafe.getDouble(null, l + 72L))._m31(unsafe.getDouble(null, l + 80L))._m32(unsafe.getDouble(null, l + 88L));
        }

        public static void getf(Matrix4d matrix4d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix4d._m00(unsafe.getFloat(null, l))._m01(unsafe.getFloat(null, l + 4L))._m02(unsafe.getFloat(null, l + 8L))._m03(unsafe.getFloat(null, l + 12L))._m10(unsafe.getFloat(null, l + 16L))._m11(unsafe.getFloat(null, l + 20L))._m12(unsafe.getFloat(null, l + 24L))._m13(unsafe.getFloat(null, l + 28L))._m20(unsafe.getFloat(null, l + 32L))._m21(unsafe.getFloat(null, l + 36L))._m22(unsafe.getFloat(null, l + 40L))._m23(unsafe.getFloat(null, l + 44L))._m30(unsafe.getFloat(null, l + 48L))._m31(unsafe.getFloat(null, l + 52L))._m32(unsafe.getFloat(null, l + 56L))._m33(unsafe.getFloat(null, l + 60L));
        }

        public static void getf(Matrix4x3d matrix4x3d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix4x3d._m00(unsafe.getFloat(null, l))._m01(unsafe.getFloat(null, l + 4L))._m02(unsafe.getFloat(null, l + 8L))._m10(unsafe.getFloat(null, l + 12L))._m11(unsafe.getFloat(null, l + 16L))._m12(unsafe.getFloat(null, l + 20L))._m20(unsafe.getFloat(null, l + 24L))._m21(unsafe.getFloat(null, l + 28L))._m22(unsafe.getFloat(null, l + 32L))._m30(unsafe.getFloat(null, l + 36L))._m31(unsafe.getFloat(null, l + 40L))._m32(unsafe.getFloat(null, l + 44L));
        }

        public static void get(Matrix3f matrix3f, long l) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putLong(matrix3f, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(null, l + (long)(i << 3)));
            }
            matrix3f._m22(UNSAFE.getFloat(null, l + 32L));
        }

        public static void get(Matrix3d matrix3d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix3d._m00(unsafe.getDouble(null, l))._m01(unsafe.getDouble(null, l + 8L))._m02(unsafe.getDouble(null, l + 16L))._m10(unsafe.getDouble(null, l + 24L))._m11(unsafe.getDouble(null, l + 32L))._m12(unsafe.getDouble(null, l + 40L))._m20(unsafe.getDouble(null, l + 48L))._m21(unsafe.getDouble(null, l + 56L))._m22(unsafe.getDouble(null, l + 64L));
        }

        public static void get(Matrix3x2f matrix3x2f, long l) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putLong(matrix3x2f, Matrix3x2f_m00 + (long)(i << 3), UNSAFE.getLong(null, l + (long)(i << 3)));
            }
        }

        public static void get(Matrix3x2d matrix3x2d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix3x2d._m00(unsafe.getDouble(null, l))._m01(unsafe.getDouble(null, l + 8L))._m10(unsafe.getDouble(null, l + 16L))._m11(unsafe.getDouble(null, l + 24L))._m20(unsafe.getDouble(null, l + 32L))._m21(unsafe.getDouble(null, l + 40L));
        }

        public static void getf(Matrix3d matrix3d, long l) {
            Unsafe unsafe = UNSAFE;
            matrix3d._m00(unsafe.getFloat(null, l))._m01(unsafe.getFloat(null, l + 4L))._m02(unsafe.getFloat(null, l + 8L))._m10(unsafe.getFloat(null, l + 12L))._m11(unsafe.getFloat(null, l + 16L))._m12(unsafe.getFloat(null, l + 20L))._m20(unsafe.getFloat(null, l + 24L))._m21(unsafe.getFloat(null, l + 28L))._m22(unsafe.getFloat(null, l + 32L));
        }

        public static void get(Matrix2f matrix2f, long l) {
            UNSAFE.putLong(matrix2f, Matrix2f_m00, UNSAFE.getLong(null, l));
            UNSAFE.putLong(matrix2f, Matrix2f_m00 + 8L, UNSAFE.getLong(null, l + 8L));
        }

        public static void get(Matrix2d matrix2d, long l) {
            matrix2d._m00(UNSAFE.getDouble(null, l))._m01(UNSAFE.getDouble(null, l + 8L))._m10(UNSAFE.getDouble(null, l + 16L))._m11(UNSAFE.getDouble(null, l + 24L));
        }

        public static void getf(Matrix2d matrix2d, long l) {
            matrix2d._m00(UNSAFE.getFloat(null, l))._m01(UNSAFE.getFloat(null, l + 4L))._m10(UNSAFE.getFloat(null, l + 8L))._m11(UNSAFE.getFloat(null, l + 12L));
        }

        public static void get(Vector4d vector4d, long l) {
            vector4d.x = UNSAFE.getDouble(null, l);
            vector4d.y = UNSAFE.getDouble(null, l + 8L);
            vector4d.z = UNSAFE.getDouble(null, l + 16L);
            vector4d.w = UNSAFE.getDouble(null, l + 24L);
        }

        public static void get(Vector4f vector4f, long l) {
            vector4f.x = UNSAFE.getFloat(null, l);
            vector4f.y = UNSAFE.getFloat(null, l + 4L);
            vector4f.z = UNSAFE.getFloat(null, l + 8L);
            vector4f.w = UNSAFE.getFloat(null, l + 12L);
        }

        public static void get(Vector4i vector4i, long l) {
            vector4i.x = UNSAFE.getInt(null, l);
            vector4i.y = UNSAFE.getInt(null, l + 4L);
            vector4i.z = UNSAFE.getInt(null, l + 8L);
            vector4i.w = UNSAFE.getInt(null, l + 12L);
        }

        public static void get(Vector3f vector3f, long l) {
            vector3f.x = UNSAFE.getFloat(null, l);
            vector3f.y = UNSAFE.getFloat(null, l + 4L);
            vector3f.z = UNSAFE.getFloat(null, l + 8L);
        }

        public static void get(Vector3d vector3d, long l) {
            vector3d.x = UNSAFE.getDouble(null, l);
            vector3d.y = UNSAFE.getDouble(null, l + 8L);
            vector3d.z = UNSAFE.getDouble(null, l + 16L);
        }

        public static void get(Vector3i vector3i, long l) {
            vector3i.x = UNSAFE.getInt(null, l);
            vector3i.y = UNSAFE.getInt(null, l + 4L);
            vector3i.z = UNSAFE.getInt(null, l + 8L);
        }

        public static void get(Vector2f vector2f, long l) {
            vector2f.x = UNSAFE.getFloat(null, l);
            vector2f.y = UNSAFE.getFloat(null, l + 4L);
        }

        public static void get(Vector2d vector2d, long l) {
            vector2d.x = UNSAFE.getDouble(null, l);
            vector2d.y = UNSAFE.getDouble(null, l + 8L);
        }

        public static void get(Vector2i vector2i, long l) {
            vector2i.x = UNSAFE.getInt(null, l);
            vector2i.y = UNSAFE.getInt(null, l + 4L);
        }

        public static void putMatrix3f(Quaternionf quaternionf, long l) {
            float f = quaternionf.x + quaternionf.x;
            float f2 = quaternionf.y + quaternionf.y;
            float f3 = quaternionf.z + quaternionf.z;
            float f4 = f * quaternionf.x;
            float f5 = f2 * quaternionf.y;
            float f6 = f3 * quaternionf.z;
            float f7 = f * quaternionf.y;
            float f8 = f * quaternionf.z;
            float f9 = f * quaternionf.w;
            float f10 = f2 * quaternionf.z;
            float f11 = f2 * quaternionf.w;
            float f12 = f3 * quaternionf.w;
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, 1.0f - f5 - f6);
            unsafe.putFloat(null, l + 4L, f7 + f12);
            unsafe.putFloat(null, l + 8L, f8 - f11);
            unsafe.putFloat(null, l + 12L, f7 - f12);
            unsafe.putFloat(null, l + 16L, 1.0f - f6 - f4);
            unsafe.putFloat(null, l + 20L, f10 + f9);
            unsafe.putFloat(null, l + 24L, f8 + f11);
            unsafe.putFloat(null, l + 28L, f10 - f9);
            unsafe.putFloat(null, l + 32L, 1.0f - f5 - f4);
        }

        public static void putMatrix4f(Quaternionf quaternionf, long l) {
            float f = quaternionf.x + quaternionf.x;
            float f2 = quaternionf.y + quaternionf.y;
            float f3 = quaternionf.z + quaternionf.z;
            float f4 = f * quaternionf.x;
            float f5 = f2 * quaternionf.y;
            float f6 = f3 * quaternionf.z;
            float f7 = f * quaternionf.y;
            float f8 = f * quaternionf.z;
            float f9 = f * quaternionf.w;
            float f10 = f2 * quaternionf.z;
            float f11 = f2 * quaternionf.w;
            float f12 = f3 * quaternionf.w;
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, 1.0f - f5 - f6);
            unsafe.putFloat(null, l + 4L, f7 + f12);
            unsafe.putLong(null, l + 8L, (long)Float.floatToRawIntBits(f8 - f11) & 0xFFFFFFFFL);
            unsafe.putFloat(null, l + 16L, f7 - f12);
            unsafe.putFloat(null, l + 20L, 1.0f - f6 - f4);
            unsafe.putLong(null, l + 24L, (long)Float.floatToRawIntBits(f10 + f9) & 0xFFFFFFFFL);
            unsafe.putFloat(null, l + 32L, f8 + f11);
            unsafe.putFloat(null, l + 36L, f10 - f9);
            unsafe.putLong(null, l + 40L, (long)Float.floatToRawIntBits(1.0f - f5 - f4) & 0xFFFFFFFFL);
            unsafe.putLong(null, l + 48L, 0L);
            unsafe.putLong(null, l + 56L, 4575657221408423936L);
        }

        public static void putMatrix4x3f(Quaternionf quaternionf, long l) {
            float f = quaternionf.x + quaternionf.x;
            float f2 = quaternionf.y + quaternionf.y;
            float f3 = quaternionf.z + quaternionf.z;
            float f4 = f * quaternionf.x;
            float f5 = f2 * quaternionf.y;
            float f6 = f3 * quaternionf.z;
            float f7 = f * quaternionf.y;
            float f8 = f * quaternionf.z;
            float f9 = f * quaternionf.w;
            float f10 = f2 * quaternionf.z;
            float f11 = f2 * quaternionf.w;
            float f12 = f3 * quaternionf.w;
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l, 1.0f - f5 - f6);
            unsafe.putFloat(null, l + 4L, f7 + f12);
            unsafe.putFloat(null, l + 8L, f8 - f11);
            unsafe.putFloat(null, l + 12L, f7 - f12);
            unsafe.putFloat(null, l + 16L, 1.0f - f6 - f4);
            unsafe.putFloat(null, l + 20L, f10 + f9);
            unsafe.putFloat(null, l + 24L, f8 + f11);
            unsafe.putFloat(null, l + 28L, f10 - f9);
            unsafe.putFloat(null, l + 32L, 1.0f - f5 - f4);
            unsafe.putLong(null, l + 36L, 0L);
            unsafe.putFloat(null, l + 44L, 0.0f);
        }

        private static void throwNoDirectBufferException() {
            throw new IllegalArgumentException("Must use a direct buffer");
        }

        @Override
        public void putMatrix3f(Quaternionf quaternionf, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.putMatrix3f(quaternionf, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putMatrix3f(Quaternionf quaternionf, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.putMatrix3f(quaternionf, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        private static void checkPut(int n, boolean bl, int n2, int n3) {
            if (!bl) {
                MemUtilUnsafe.throwNoDirectBufferException();
            }
            if (n2 - n < n3) {
                throw new BufferOverflowException();
            }
        }

        @Override
        public void putMatrix4f(Quaternionf quaternionf, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.putMatrix4f(quaternionf, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putMatrix4f(Quaternionf quaternionf, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putMatrix4f(quaternionf, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putMatrix4x3f(Quaternionf quaternionf, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.putMatrix4x3f(quaternionf, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putMatrix4x3f(Quaternionf quaternionf, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.putMatrix4x3f(quaternionf, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.put(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x3(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put4x3(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put4x3(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put4x3(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put3x4(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put3x4(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put3x4(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put3x4(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x4(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put4x4(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put4x4(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.put4x4(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put3x4(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put3x4(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put3x4(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put3x4(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x4(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put4x4(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put4x4(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            MemUtilUnsafe.put4x4(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x4(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put4x4(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put4x4(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.put4x4(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x4(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put4x4(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put4x4(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            MemUtilUnsafe.put4x4(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put3x3(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.put3x3(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put3x3(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.put3x3(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put3x3(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            MemUtilUnsafe.put3x3(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put3x3(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            MemUtilUnsafe.put3x3(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putTransposed(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putTransposed(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.putTransposed(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x3Transposed(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put4x3Transposed(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put4x3Transposed(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put4x3Transposed(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.putTransposed(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putTransposed(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.putTransposed(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.putTransposed(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putTransposed(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.putTransposed(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix2f matrix2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.putTransposed(matrix2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putTransposed(Matrix2f matrix2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putTransposed(matrix2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            MemUtilUnsafe.put(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            MemUtilUnsafe.put(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putf(Matrix4d matrix4d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putf(matrix4d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putf(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.putf(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putf(Matrix4x3d matrix4x3d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.putf(matrix4x3d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putf(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.putf(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putTransposed(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void putTransposed(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            MemUtilUnsafe.putTransposed(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put4x3Transposed(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put4x3Transposed(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put4x3Transposed(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            MemUtilUnsafe.put4x3Transposed(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            MemUtilUnsafe.putTransposed(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void putTransposed(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            MemUtilUnsafe.putTransposed(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putTransposed(Matrix2d matrix2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            MemUtilUnsafe.putTransposed(matrix2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void putTransposed(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            MemUtilUnsafe.putTransposed(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putfTransposed(Matrix4d matrix4d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putfTransposed(matrix4d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putfTransposed(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.putfTransposed(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putfTransposed(Matrix4x3d matrix4x3d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.putfTransposed(matrix4x3d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putfTransposed(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.putfTransposed(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putfTransposed(Matrix2d matrix2d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.putfTransposed(matrix2d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putfTransposed(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putfTransposed(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.put(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.put(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put3x4(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put3x4(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put3x4(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put3x4(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix3d matrix3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            MemUtilUnsafe.put(matrix3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            MemUtilUnsafe.put(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 6);
            }
            MemUtilUnsafe.put(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            MemUtilUnsafe.put(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 6);
            }
            MemUtilUnsafe.put(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.put(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putf(Matrix3d matrix3d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.putf(matrix3d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putf(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.putf(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix2f matrix2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.put(matrix2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Matrix2f matrix2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(matrix2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Matrix2d matrix2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            MemUtilUnsafe.put(matrix2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putf(Matrix2d matrix2d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.putf(matrix2d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void putf(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putf(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector4d vector4d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            MemUtilUnsafe.put(vector4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Vector4d vector4d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.putf(vector4d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector4d vector4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            MemUtilUnsafe.put(vector4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putf(Vector4d vector4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.putf(vector4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector4f vector4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.put(vector4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector4f vector4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(vector4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector4i vector4i, int n, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, intBuffer.isDirect(), intBuffer.capacity(), 4);
            }
            MemUtilUnsafe.put(vector4i, UNSAFE.getLong(intBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector4i vector4i, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(vector4i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector3f vector3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 3);
            }
            MemUtilUnsafe.put(vector3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector3f vector3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put(vector3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector3d vector3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 3);
            }
            MemUtilUnsafe.put(vector3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Vector3d vector3d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 3);
            }
            MemUtilUnsafe.putf(vector3d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector3d vector3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            MemUtilUnsafe.put(vector3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void putf(Vector3d vector3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            MemUtilUnsafe.putf(vector3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector3i vector3i, int n, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, intBuffer.isDirect(), intBuffer.capacity(), 3);
            }
            MemUtilUnsafe.put(vector3i, UNSAFE.getLong(intBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector3i vector3i, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            MemUtilUnsafe.put(vector3i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector2f vector2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, floatBuffer.isDirect(), floatBuffer.capacity(), 2);
            }
            MemUtilUnsafe.put(vector2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector2f vector2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            MemUtilUnsafe.put(vector2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector2d vector2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 2);
            }
            MemUtilUnsafe.put(vector2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void put(Vector2d vector2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.put(vector2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void put(Vector2i vector2i, int n, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, intBuffer.isDirect(), intBuffer.capacity(), 2);
            }
            MemUtilUnsafe.put(vector2i, UNSAFE.getLong(intBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void put(Vector2i vector2i, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            MemUtilUnsafe.put(vector2i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix4f matrix4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.get(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Matrix4f matrix4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.get(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public float get(Matrix4f matrix4f, int n, int n2) {
            return UNSAFE.getFloat(matrix4f, Matrix4f_m00 + (long)(n << 4) + (long)(n2 << 2));
        }

        @Override
        public Matrix4f set(Matrix4f matrix4f, int n, int n2, float f) {
            UNSAFE.putFloat(matrix4f, Matrix4f_m00 + (long)(n << 4) + (long)(n2 << 2), f);
            return matrix4f;
        }

        @Override
        public double get(Matrix4d matrix4d, int n, int n2) {
            return UNSAFE.getDouble(matrix4d, Matrix4d_m00 + (long)(n << 5) + (long)(n2 << 3));
        }

        @Override
        public Matrix4d set(Matrix4d matrix4d, int n, int n2, double d) {
            UNSAFE.putDouble(matrix4d, Matrix4d_m00 + (long)(n << 5) + (long)(n2 << 3), d);
            return matrix4d;
        }

        @Override
        public float get(Matrix3f matrix3f, int n, int n2) {
            return UNSAFE.getFloat(matrix3f, Matrix3f_m00 + (long)(n * 12) + (long)(n2 << 2));
        }

        @Override
        public Matrix3f set(Matrix3f matrix3f, int n, int n2, float f) {
            UNSAFE.putFloat(matrix3f, Matrix3f_m00 + (long)(n * 12) + (long)(n2 << 2), f);
            return matrix3f;
        }

        @Override
        public double get(Matrix3d matrix3d, int n, int n2) {
            return UNSAFE.getDouble(matrix3d, Matrix3d_m00 + (long)(n * 24) + (long)(n2 << 3));
        }

        @Override
        public Matrix3d set(Matrix3d matrix3d, int n, int n2, double d) {
            UNSAFE.putDouble(matrix3d, Matrix3d_m00 + (long)(n * 24) + (long)(n2 << 3), d);
            return matrix3d;
        }

        @Override
        public void get(Matrix4x3f matrix4x3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.get(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Matrix4x3f matrix4x3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.get(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix4d matrix4d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            MemUtilUnsafe.get(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            MemUtilUnsafe.get(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix4x3d matrix4x3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            MemUtilUnsafe.get(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            MemUtilUnsafe.get(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void getf(Matrix4d matrix4d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            MemUtilUnsafe.getf(matrix4d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void getf(Matrix4d matrix4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            MemUtilUnsafe.getf(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void getf(Matrix4x3d matrix4x3d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            MemUtilUnsafe.getf(matrix4x3d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        private static void checkGet(int n, boolean bl, int n2, int n3) {
            if (!bl) {
                MemUtilUnsafe.throwNoDirectBufferException();
            }
            if (n2 - n < n3) {
                throw new BufferUnderflowException();
            }
        }

        @Override
        public void getf(Matrix4x3d matrix4x3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.getf(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix3f matrix3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.get(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Matrix3f matrix3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.get(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix3d matrix3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            MemUtilUnsafe.get(matrix3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            MemUtilUnsafe.get(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix3x2f matrix3x2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 6);
            }
            MemUtilUnsafe.get(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Matrix3x2f matrix3x2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            MemUtilUnsafe.get(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix3x2d matrix3x2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 6);
            }
            MemUtilUnsafe.get(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Matrix3x2d matrix3x2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            MemUtilUnsafe.get(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void getf(Matrix3d matrix3d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            MemUtilUnsafe.getf(matrix3d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void getf(Matrix3d matrix3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            MemUtilUnsafe.getf(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix2f matrix2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.get(matrix2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Matrix2f matrix2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.get(matrix2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Matrix2d matrix2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            MemUtilUnsafe.get(matrix2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            MemUtilUnsafe.get(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void getf(Matrix2d matrix2d, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.getf(matrix2d, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void getf(Matrix2d matrix2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.getf(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector4d vector4d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            MemUtilUnsafe.get(vector4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Vector4d vector4d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            MemUtilUnsafe.get(vector4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector4f vector4f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            MemUtilUnsafe.get(vector4f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Vector4f vector4f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.get(vector4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector4i vector4i, int n, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, intBuffer.isDirect(), intBuffer.capacity(), 4);
            }
            MemUtilUnsafe.get(vector4i, UNSAFE.getLong(intBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Vector4i vector4i, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.get(vector4i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector3f vector3f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 3);
            }
            MemUtilUnsafe.get(vector3f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Vector3f vector3f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            MemUtilUnsafe.get(vector3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector3d vector3d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 3);
            }
            MemUtilUnsafe.get(vector3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Vector3d vector3d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            MemUtilUnsafe.get(vector3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector3i vector3i, int n, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, intBuffer.isDirect(), intBuffer.capacity(), 3);
            }
            MemUtilUnsafe.get(vector3i, UNSAFE.getLong(intBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Vector3i vector3i, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            MemUtilUnsafe.get(vector3i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector2f vector2f, int n, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, floatBuffer.isDirect(), floatBuffer.capacity(), 2);
            }
            MemUtilUnsafe.get(vector2f, UNSAFE.getLong(floatBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Vector2f vector2f, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            MemUtilUnsafe.get(vector2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector2d vector2d, int n, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, doubleBuffer.isDirect(), doubleBuffer.capacity(), 2);
            }
            MemUtilUnsafe.get(vector2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + (long)(n << 3));
        }

        @Override
        public void get(Vector2d vector2d, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            MemUtilUnsafe.get(vector2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        @Override
        public void get(Vector2i vector2i, int n, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, intBuffer.isDirect(), intBuffer.capacity(), 2);
            }
            MemUtilUnsafe.get(vector2i, UNSAFE.getLong(intBuffer, ADDRESS) + (long)(n << 2));
        }

        @Override
        public void get(Vector2i vector2i, int n, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            MemUtilUnsafe.get(vector2i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n);
        }

        static {
            try {
                ADDRESS = MemUtilUnsafe.findBufferAddress();
                Matrix4f_m00 = MemUtilUnsafe.checkMatrix4f();
                Matrix4d_m00 = MemUtilUnsafe.checkMatrix4d();
                Matrix4x3f_m00 = MemUtilUnsafe.checkMatrix4x3f();
                Matrix3f_m00 = MemUtilUnsafe.checkMatrix3f();
                Matrix3d_m00 = MemUtilUnsafe.checkMatrix3d();
                Matrix3x2f_m00 = MemUtilUnsafe.checkMatrix3x2f();
                Matrix2f_m00 = MemUtilUnsafe.checkMatrix2f();
                Vector4f_x = MemUtilUnsafe.checkVector4f();
                Vector4i_x = MemUtilUnsafe.checkVector4i();
                Vector3f_x = MemUtilUnsafe.checkVector3f();
                Vector3i_x = MemUtilUnsafe.checkVector3i();
                Vector2f_x = MemUtilUnsafe.checkVector2f();
                Vector2i_x = MemUtilUnsafe.checkVector2i();
                Quaternionf_x = MemUtilUnsafe.checkQuaternionf();
                floatArrayOffset = UNSAFE.arrayBaseOffset(float[].class);
                Unsafe.class.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                Unsafe.class.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new UnsupportedOperationException(noSuchFieldException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException(noSuchMethodException);
            }
        }
    }
}

