/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix4x3f;

public class Matrix4x3fStack
extends Matrix4x3f {
    private static final long serialVersionUID = 1L;
    private Matrix4x3f[] mats;
    private int curr;

    public Matrix4x3fStack(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix4x3f[n - 1];
        for (int i = 0; i < this.mats.length; ++i) {
            this.mats[i] = new Matrix4x3f();
        }
    }

    public Matrix4x3fStack() {
    }

    public Matrix4x3fStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix4x3fStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix4x3fStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the buttom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.curr;
        for (int i = 0; i < this.curr; ++i) {
            n = 31 * n + this.mats[i].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix4x3fStack) {
            Matrix4x3fStack matrix4x3fStack = (Matrix4x3fStack)object;
            if (this.curr != matrix4x3fStack.curr) {
                return false;
            }
            for (int i = 0; i < this.curr; ++i) {
                if (this.mats[i].equals(matrix4x3fStack.mats[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i = 0; i < this.curr; ++i) {
            objectOutput.writeObject(this.mats[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix4x3fStack[this.curr];
        for (int i = 0; i < this.curr; ++i) {
            Matrix4x3f matrix4x3f = new Matrix4x3f();
            matrix4x3f.readExternal(objectInput);
            this.mats[i] = matrix4x3f;
        }
    }
}

