/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Options;
import org.joml.Runtime;

public class Math {
    public static final double PI = java.lang.Math.PI;
    static final double PI2 = java.lang.Math.PI * 2;
    static final float PI_f = (float)java.lang.Math.PI;
    static final float PI2_f = (float)java.lang.Math.PI * 2;
    static final double PIHalf = 1.5707963267948966;
    static final float PIHalf_f = 1.5707964f;
    static final double PI_4 = 0.7853981633974483;
    static final double PI_INV = 0.3183098861837907;
    private static final int lookupBits = Options.SIN_LOOKUP_BITS;
    private static final int lookupTableSize = 1 << lookupBits;
    private static final int lookupTableSizeMinus1 = lookupTableSize - 1;
    private static final int lookupTableSizeWithMargin = lookupTableSize + 1;
    private static final float pi2OverLookupSize = (float)java.lang.Math.PI * 2 / (float)lookupTableSize;
    private static final float lookupSizeOverPi2 = (float)lookupTableSize / ((float)java.lang.Math.PI * 2);
    private static final float[] sinTable;
    private static final double c1;
    private static final double c2;
    private static final double c3;
    private static final double c4;
    private static final double c5;
    private static final double c6;
    private static final double c7;
    private static final double s5;
    private static final double s4;
    private static final double s3;
    private static final double s2;
    private static final double s1;
    private static final double k1;
    private static final double k2;
    private static final double k3;
    private static final double k4;
    private static final double k5;
    private static final double k6;
    private static final double k7;

    static double sin_theagentd_arith(double d) {
        double d2 = Math.floor((d + 0.7853981633974483) * 0.3183098861837907);
        double d3 = d - d2 * java.lang.Math.PI;
        double d4 = ((int)d2 & 1) * -2 + 1;
        double d5 = d3 * d3;
        double d6 = d3;
        double d7 = d3 * d5;
        d6 += d7 * c1;
        d6 += (d7 *= d5) * c2;
        d6 += (d7 *= d5) * c3;
        d6 += (d7 *= d5) * c4;
        d6 += (d7 *= d5) * c5;
        d6 += (d7 *= d5) * c6;
        return d4 * (d6 += (d7 *= d5) * c7);
    }

    static double sin_roquen_arith(double d) {
        double d2 = Math.floor((d + 0.7853981633974483) * 0.3183098861837907);
        double d3 = d - d2 * java.lang.Math.PI;
        double d4 = ((int)d2 & 1) * -2 + 1;
        double d5 = d3 * d3;
        d3 = d4 * d3;
        double d6 = c7;
        d6 = d6 * d5 + c6;
        d6 = d6 * d5 + c5;
        d6 = d6 * d5 + c4;
        d6 = d6 * d5 + c3;
        d6 = d6 * d5 + c2;
        d6 = d6 * d5 + c1;
        return d3 + d3 * d5 * d6;
    }

    static double sin_roquen_9(double d) {
        double d2 = java.lang.Math.rint(d * 0.3183098861837907);
        double d3 = d - d2 * java.lang.Math.PI;
        double d4 = 1 - 2 * ((int)d2 & 1);
        double d5 = d3 * d3;
        d3 = d4 * d3;
        double d6 = s5;
        d6 = d6 * d5 + s4;
        d6 = d6 * d5 + s3;
        d6 = d6 * d5 + s2;
        d6 = d6 * d5 + s1;
        return d3 * d6;
    }

    static double sin_roquen_newk(double d) {
        double d2 = java.lang.Math.rint(d * 0.3183098861837907);
        double d3 = d - d2 * java.lang.Math.PI;
        double d4 = 1 - 2 * ((int)d2 & 1);
        double d5 = d3 * d3;
        d3 = d4 * d3;
        double d6 = k7;
        d6 = d6 * d5 + k6;
        d6 = d6 * d5 + k5;
        d6 = d6 * d5 + k4;
        d6 = d6 * d5 + k3;
        d6 = d6 * d5 + k2;
        d6 = d6 * d5 + k1;
        return d3 + d3 * d5 * d6;
    }

    static float sin_theagentd_lookup(float f) {
        float f2 = f * lookupSizeOverPi2;
        int n = (int)java.lang.Math.floor(f2);
        float f3 = f2 - (float)n;
        int n2 = n & lookupTableSizeMinus1;
        float f4 = sinTable[n2];
        float f5 = sinTable[n2 + 1];
        return f4 + (f5 - f4) * f3;
    }

    public static float sin(float f) {
        return (float)java.lang.Math.sin(f);
    }

    public static double sin(double d) {
        if (Options.FASTMATH) {
            if (Options.SIN_LOOKUP) {
                return Math.sin_theagentd_lookup((float)d);
            }
            return Math.sin_roquen_newk(d);
        }
        return java.lang.Math.sin(d);
    }

    public static float cos(float f) {
        if (Options.FASTMATH) {
            return Math.sin(f + 1.5707964f);
        }
        return (float)java.lang.Math.cos(f);
    }

    public static double cos(double d) {
        if (Options.FASTMATH) {
            return Math.sin(d + 1.5707963267948966);
        }
        return java.lang.Math.cos(d);
    }

    public static float cosFromSin(float f, float f2) {
        if (Options.FASTMATH) {
            return Math.sin(f2 + 1.5707964f);
        }
        return Math.cosFromSinInternal(f, f2);
    }

    private static float cosFromSinInternal(float f, float f2) {
        float f3 = Math.sqrt(1.0f - f * f);
        float f4 = f2 + 1.5707964f;
        float f5 = f4 - (float)((int)(f4 / ((float)java.lang.Math.PI * 2))) * ((float)java.lang.Math.PI * 2);
        if ((double)f5 < 0.0) {
            f5 = (float)java.lang.Math.PI * 2 + f5;
        }
        if (f5 >= (float)java.lang.Math.PI) {
            return -f3;
        }
        return f3;
    }

    public static double cosFromSin(double d, double d2) {
        if (Options.FASTMATH) {
            return Math.sin(d2 + 1.5707963267948966);
        }
        double d3 = Math.sqrt(1.0 - d * d);
        double d4 = d2 + 1.5707963267948966;
        double d5 = d4 - (double)((int)(d4 / (java.lang.Math.PI * 2))) * (java.lang.Math.PI * 2);
        if (d5 < 0.0) {
            d5 = java.lang.Math.PI * 2 + d5;
        }
        if (d5 >= java.lang.Math.PI) {
            return -d3;
        }
        return d3;
    }

    public static float sqrt(float f) {
        return (float)java.lang.Math.sqrt(f);
    }

    public static double sqrt(double d) {
        return java.lang.Math.sqrt(d);
    }

    public static float invsqrt(float f) {
        return 1.0f / (float)java.lang.Math.sqrt(f);
    }

    public static double invsqrt(double d) {
        return 1.0 / java.lang.Math.sqrt(d);
    }

    public static float tan(float f) {
        return (float)java.lang.Math.tan(f);
    }

    public static double tan(double d) {
        return java.lang.Math.tan(d);
    }

    public static float acos(float f) {
        return (float)java.lang.Math.acos(f);
    }

    public static double acos(double d) {
        return java.lang.Math.acos(d);
    }

    public static float safeAcos(float f) {
        if (f < -1.0f) {
            return (float)java.lang.Math.PI;
        }
        if (f > 1.0f) {
            return 0.0f;
        }
        return Math.acos(f);
    }

    public static double safeAcos(double d) {
        if (d < -1.0) {
            return java.lang.Math.PI;
        }
        if (d > 1.0) {
            return 0.0;
        }
        return Math.acos(d);
    }

    private static double fastAtan2(double d, double d2) {
        double d3 = d2 >= 0.0 ? d2 : -d2;
        double d4 = d >= 0.0 ? d : -d;
        double d5 = Math.min(d3, d4) / Math.max(d3, d4);
        double d6 = d5 * d5;
        double d7 = ((-0.0464964749 * d6 + 0.15931422) * d6 - 0.327622764) * d6 * d5 + d5;
        if (d4 > d3) {
            d7 = 1.57079637 - d7;
        }
        if (d2 < 0.0) {
            d7 = 3.14159274 - d7;
        }
        return d >= 0.0 ? d7 : -d7;
    }

    public static float atan2(float f, float f2) {
        return (float)java.lang.Math.atan2(f, f2);
    }

    public static double atan2(double d, double d2) {
        if (Options.FASTMATH) {
            return Math.fastAtan2(d, d2);
        }
        return java.lang.Math.atan2(d, d2);
    }

    public static float asin(float f) {
        return (float)java.lang.Math.asin(f);
    }

    public static double asin(double d) {
        return java.lang.Math.asin(d);
    }

    public static float safeAsin(float f) {
        return f <= -1.0f ? -1.5707964f : (f >= 1.0f ? 1.5707964f : Math.asin(f));
    }

    public static double safeAsin(double d) {
        return d <= -1.0 ? -1.5707963267948966 : (d >= 1.0 ? 1.5707963267948966 : Math.asin(d));
    }

    public static float abs(float f) {
        return java.lang.Math.abs(f);
    }

    public static double abs(double d) {
        return java.lang.Math.abs(d);
    }

    static boolean absEqualsOne(float f) {
        return (Float.floatToRawIntBits(f) & Integer.MAX_VALUE) == 1065353216;
    }

    static boolean absEqualsOne(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MAX_VALUE) == 0x3FF0000000000000L;
    }

    public static int abs(int n) {
        return java.lang.Math.abs(n);
    }

    public static int max(int n, int n2) {
        return java.lang.Math.max(n, n2);
    }

    public static int min(int n, int n2) {
        return java.lang.Math.min(n, n2);
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static float clamp(float f, float f2, float f3) {
        return Math.max(f, Math.min(f2, f3));
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.max(d, Math.min(d2, d3));
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.max(n, Math.min(n2, n3));
    }

    public static float toRadians(float f) {
        return (float)java.lang.Math.toRadians(f);
    }

    public static double toRadians(double d) {
        return java.lang.Math.toRadians(d);
    }

    public static double toDegrees(double d) {
        return java.lang.Math.toDegrees(d);
    }

    public static double floor(double d) {
        return java.lang.Math.floor(d);
    }

    public static float floor(float f) {
        return (float)java.lang.Math.floor(f);
    }

    public static double ceil(double d) {
        return java.lang.Math.ceil(d);
    }

    public static float ceil(float f) {
        return (float)java.lang.Math.ceil(f);
    }

    public static long round(double d) {
        return java.lang.Math.round(d);
    }

    public static int round(float f) {
        return java.lang.Math.round(f);
    }

    public static double exp(double d) {
        return java.lang.Math.exp(d);
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    public static float fma(float f, float f2, float f3) {
        if (Runtime.HAS_Math_fma) {
            return java.lang.Math.fma(f, f2, f3);
        }
        return f * f2 + f3;
    }

    public static double fma(double d, double d2, double d3) {
        if (Runtime.HAS_Math_fma) {
            return java.lang.Math.fma(d, d2, d3);
        }
        return d * d2 + d3;
    }

    public static int roundUsing(float f, int n) {
        switch (n) {
            case 0: {
                return (int)f;
            }
            case 1: {
                return (int)java.lang.Math.ceil(f);
            }
            case 2: {
                return (int)java.lang.Math.floor(f);
            }
            case 4: {
                return Math.roundHalfDown(f);
            }
            case 5: {
                return Math.roundHalfUp(f);
            }
            case 3: {
                return Math.roundHalfEven(f);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int roundUsing(double d, int n) {
        switch (n) {
            case 0: {
                return (int)d;
            }
            case 1: {
                return (int)java.lang.Math.ceil(d);
            }
            case 2: {
                return (int)java.lang.Math.floor(d);
            }
            case 4: {
                return Math.roundHalfDown(d);
            }
            case 5: {
                return Math.roundHalfUp(d);
            }
            case 3: {
                return Math.roundHalfEven(d);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static float lerp(float f, float f2, float f3) {
        return Math.fma(f2 - f, f3, f);
    }

    public static double lerp(double d, double d2, double d3) {
        return Math.fma(d2 - d, d3, d);
    }

    public static float biLerp(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.lerp(f, f2, f5);
        float f8 = Math.lerp(f3, f4, f5);
        return Math.lerp(f7, f8, f6);
    }

    public static double biLerp(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.lerp(d, d2, d5);
        double d8 = Math.lerp(d3, d4, d5);
        return Math.lerp(d7, d8, d6);
    }

    public static float triLerp(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12 = Math.lerp(f, f2, f9);
        float f13 = Math.lerp(f3, f4, f9);
        float f14 = Math.lerp(f5, f6, f9);
        float f15 = Math.lerp(f7, f8, f9);
        float f16 = Math.lerp(f12, f13, f10);
        float f17 = Math.lerp(f14, f15, f10);
        return Math.lerp(f16, f17, f11);
    }

    public static double triLerp(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12 = Math.lerp(d, d2, d9);
        double d13 = Math.lerp(d3, d4, d9);
        double d14 = Math.lerp(d5, d6, d9);
        double d15 = Math.lerp(d7, d8, d9);
        double d16 = Math.lerp(d12, d13, d10);
        double d17 = Math.lerp(d14, d15, d10);
        return Math.lerp(d16, d17, d11);
    }

    public static int roundHalfEven(float f) {
        return (int)java.lang.Math.rint(f);
    }

    public static int roundHalfDown(float f) {
        return f > 0.0f ? (int)java.lang.Math.ceil((double)f - 0.5) : (int)java.lang.Math.floor((double)f + 0.5);
    }

    public static int roundHalfUp(float f) {
        return f > 0.0f ? (int)java.lang.Math.floor((double)f + 0.5) : (int)java.lang.Math.ceil((double)f - 0.5);
    }

    public static int roundHalfEven(double d) {
        return (int)java.lang.Math.rint(d);
    }

    public static int roundHalfDown(double d) {
        return d > 0.0 ? (int)java.lang.Math.ceil(d - 0.5) : (int)java.lang.Math.floor(d + 0.5);
    }

    public static int roundHalfUp(double d) {
        return d > 0.0 ? (int)java.lang.Math.floor(d + 0.5) : (int)java.lang.Math.ceil(d - 0.5);
    }

    public static double random() {
        return java.lang.Math.random();
    }

    public static double signum(double d) {
        return java.lang.Math.signum(d);
    }

    public static float signum(float f) {
        return java.lang.Math.signum(f);
    }

    public static int signum(int n) {
        int n2 = Integer.signum(n);
        return n2;
    }

    public static int signum(long l) {
        int n = Long.signum(l);
        return n;
    }

    static {
        if (Options.FASTMATH && Options.SIN_LOOKUP) {
            sinTable = new float[lookupTableSizeWithMargin];
            for (int i = 0; i < lookupTableSizeWithMargin; ++i) {
                double d = (float)i * pi2OverLookupSize;
                Math.sinTable[i] = (float)java.lang.Math.sin(d);
            }
        } else {
            sinTable = null;
        }
        c1 = Double.longBitsToDouble(-4628199217061079772L);
        c2 = Double.longBitsToDouble(4575957461383582011L);
        c3 = Double.longBitsToDouble(-4671919876300759001L);
        c4 = Double.longBitsToDouble(4523617214285661942L);
        c5 = Double.longBitsToDouble(-4730215272828025532L);
        c6 = Double.longBitsToDouble(4460272573143870633L);
        c7 = Double.longBitsToDouble(-4797767418267846529L);
        s5 = Double.longBitsToDouble(4523227044276562163L);
        s4 = Double.longBitsToDouble(-4671934770969572232L);
        s3 = Double.longBitsToDouble(4575957211482072852L);
        s2 = Double.longBitsToDouble(-4628199223918090387L);
        s1 = Double.longBitsToDouble(4607182418589157889L);
        k1 = Double.longBitsToDouble(-4628199217061079959L);
        k2 = Double.longBitsToDouble(4575957461383549981L);
        k3 = Double.longBitsToDouble(-4671919876307284301L);
        k4 = Double.longBitsToDouble(4523617213632129738L);
        k5 = Double.longBitsToDouble(-4730215344060517252L);
        k6 = Double.longBitsToDouble(4460268259291226124L);
        k7 = Double.longBitsToDouble(-4798040743777455072L);
    }
}

