/*
 * Decompiled with CFR 0.152.
 */
package fmod.fmod;

import fmod.FMOD_STUDIO_EVENT_PROPERTY;
import fmod.fmod.EmitterType;
import fmod.fmod.FMODManager;
import fmod.fmod.FMOD_STUDIO_EVENT_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PLAYBACK_STATE;
import fmod.fmod.IFMODParameterUpdater;
import fmod.javafmod;
import fmod.javafmodJNI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import zombie.GameSounds;
import zombie.SoundManager;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.FMODParameter;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.audio.parameters.ParameterOcclusion;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.SoundTimelineScript;

public final class FMODSoundEmitter
extends BaseSoundEmitter {
    private final ArrayList<Sound> ToStart = new ArrayList();
    private final ArrayList<Sound> Instances = new ArrayList();
    public float x;
    public float y;
    public float z;
    public EmitterType emitterType;
    public IsoObject parent;
    private final ParameterOcclusion occlusion = new ParameterOcclusion(this);
    private final ArrayList<FMODParameter> parameters = new ArrayList();
    public IFMODParameterUpdater parameterUpdater;
    private final ArrayList<ParameterValue> parameterValues = new ArrayList();
    private static final ObjectPool<ParameterValue> parameterValuePool = new ObjectPool(ParameterValue::new);
    private static BitSet parameterSet;
    private final ArrayDeque<EventSound> eventSoundPool = new ArrayDeque();
    private final ArrayDeque<FileSound> fileSoundPool = new ArrayDeque();
    private static long CurrentTimeMS;

    public FMODSoundEmitter() {
        SoundManager.instance.registerEmitter((BaseSoundEmitter)this);
        if (parameterSet == null) {
            parameterSet = new BitSet(FMODManager.instance.getParameterCount());
        }
    }

    public void randomStart() {
    }

    public void setPos(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public int stopSound(long l) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (sound.getRef() != l) continue;
            this.sendStopSound(sound.name, false);
            sound.release();
            this.ToStart.remove(n--);
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (sound.getRef() != l) continue;
            sound.stop();
            this.sendStopSound(sound.name, false);
            sound.release();
            this.Instances.remove(n--);
        }
        return 0;
    }

    public void stopSoundLocal(long l) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (sound.getRef() != l) continue;
            sound.release();
            this.ToStart.remove(n--);
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (sound.getRef() != l) continue;
            sound.stop();
            sound.release();
            this.Instances.remove(n--);
        }
    }

    public int stopSoundByName(String string) {
        Sound sound;
        int n;
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return 0;
        }
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (!gameSound.clips.contains(sound.clip)) continue;
            sound.release();
            this.ToStart.remove(n--);
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (!gameSound.clips.contains(sound.clip)) continue;
            sound.stop();
            sound.release();
            this.Instances.remove(n--);
        }
        return 0;
    }

    public void stopOrTriggerSound(long l) {
        int n = this.findToStart(l);
        if (n != -1) {
            Sound sound = this.ToStart.remove(n);
            this.sendStopSound(sound.name, true);
            sound.release();
            return;
        }
        n = this.findInstance(l);
        if (n != -1) {
            Sound sound = this.Instances.get(n);
            this.sendStopSound(sound.name, true);
            if (sound.clip.hasSustainPoints()) {
                sound.triggerCue();
            } else {
                this.Instances.remove(n);
                sound.stop();
                sound.release();
            }
        }
    }

    public void stopOrTriggerSoundByName(String string) {
        Sound sound;
        int n;
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return;
        }
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (!gameSound.clips.contains(sound.clip)) continue;
            this.ToStart.remove(n--);
            sound.release();
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (!gameSound.clips.contains(sound.clip)) continue;
            if (sound.clip.hasSustainPoints()) {
                sound.triggerCue();
                continue;
            }
            sound.stop();
            sound.release();
            this.Instances.remove(n--);
        }
    }

    private void limitSound(GameSound gameSound, int n) {
        Sound sound;
        int n2;
        int n3 = this.countToStart(gameSound) + this.countInstances(gameSound);
        if (n3 <= n) {
            return;
        }
        for (n2 = 0; n2 < this.ToStart.size(); ++n2) {
            sound = this.ToStart.get(n2);
            if (!gameSound.clips.contains(sound.clip)) continue;
            this.ToStart.remove(n2--);
            sound.release();
            if (--n3 > n) continue;
            return;
        }
        for (n2 = 0; n2 < this.Instances.size(); ++n2) {
            sound = this.Instances.get(n2);
            if (!gameSound.clips.contains(sound.clip)) continue;
            if (sound.clip.hasSustainPoints()) {
                if (sound.isTriggeredCue()) continue;
                sound.triggerCue();
                continue;
            }
            sound.stop();
            sound.release();
            this.Instances.remove(n2--);
            if (--n3 > n) continue;
            return;
        }
    }

    public void setVolume(long l, float f) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (sound.getRef() != l) continue;
            sound.volume = f;
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (sound.getRef() != l) continue;
            sound.volume = f;
        }
    }

    public void setPitch(long l, float f) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (sound.getRef() != l) continue;
            sound.pitch = f;
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (sound.getRef() != l) continue;
            sound.pitch = f;
        }
    }

    public boolean hasSustainPoints(long l) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (sound.getRef() != l) continue;
            if (sound.clip.eventDescription == null) {
                return false;
            }
            return sound.clip.eventDescription.bHasSustainPoints;
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (sound.getRef() != l) continue;
            if (sound.clip.eventDescription == null) {
                return false;
            }
            return sound.clip.eventDescription.bHasSustainPoints;
        }
        return false;
    }

    public void triggerCue(long l) {
        for (int i = 0; i < this.Instances.size(); ++i) {
            Sound sound = this.Instances.get(i);
            if (sound.getRef() != l) continue;
            sound.triggerCue();
        }
    }

    public void setVolumeAll(float f) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            sound.volume = f;
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            sound.volume = f;
        }
    }

    public void stopAll() {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            sound.release();
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            sound.stop();
            sound.release();
        }
        this.ToStart.clear();
        this.Instances.clear();
    }

    public long playSound(String string) {
        if (GameClient.bClient) {
            if (this.parent instanceof IsoMovingObject) {
                if (!(this.parent instanceof IsoPlayer) || !((IsoPlayer)this.parent).isInvisible()) {
                    GameClient.instance.PlaySound(string, false, (IsoMovingObject)this.parent);
                }
            } else {
                GameClient.instance.PlayWorldSound(string, (int)this.x, (int)this.y, (byte)this.z);
            }
        }
        if (GameServer.bServer) {
            return 0L;
        }
        return this.playSoundImpl(string, (IsoObject)null);
    }

    public long playSound(String string, IsoGameCharacter isoGameCharacter) {
        if (GameClient.bClient) {
            if (!isoGameCharacter.isInvisible()) {
                GameClient.instance.PlaySound(string, false, (IsoMovingObject)isoGameCharacter);
            }
            return !isoGameCharacter.isInvisible() || DebugOptions.instance.Character.Debug.PlaySoundWhenInvisible.getValue() ? this.playSoundImpl(string, (IsoObject)null) : 0L;
        }
        if (GameServer.bServer) {
            return 0L;
        }
        return this.playSoundImpl(string, (IsoObject)null);
    }

    public long playSound(String string, int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        return this.playSound(string);
    }

    public long playSound(String string, IsoGridSquare isoGridSquare) {
        this.x = (float)isoGridSquare.x + 0.5f;
        this.y = (float)isoGridSquare.y + 0.5f;
        this.z = isoGridSquare.z;
        return this.playSound(string);
    }

    public long playSoundImpl(String string, IsoGridSquare isoGridSquare) {
        this.x = (float)isoGridSquare.x + 0.5f;
        this.y = (float)isoGridSquare.y + 0.5f;
        this.z = (float)isoGridSquare.z + 0.5f;
        return this.playSoundImpl(string, (IsoObject)null);
    }

    public long playSound(String string, boolean bl) {
        return this.playSound(string);
    }

    public long playSoundImpl(String string, boolean bl, IsoObject isoObject) {
        return this.playSoundImpl(string, isoObject);
    }

    public long playSoundLooped(String string) {
        if (GameClient.bClient) {
            if (this.parent instanceof IsoMovingObject) {
                GameClient.instance.PlaySound(string, true, (IsoMovingObject)this.parent);
            } else {
                GameClient.instance.PlayWorldSound(string, (int)this.x, (int)this.y, (byte)this.z);
            }
        }
        return this.playSoundLoopedImpl(string);
    }

    public long playSoundLoopedImpl(String string) {
        return this.playSoundImpl(string, false, null);
    }

    public long playSound(String string, IsoObject isoObject) {
        if (GameClient.bClient) {
            if (isoObject instanceof IsoMovingObject) {
                GameClient.instance.PlaySound(string, false, (IsoMovingObject)this.parent);
            } else {
                GameClient.instance.PlayWorldSound(string, (int)this.x, (int)this.y, (byte)this.z);
            }
        }
        if (GameServer.bServer) {
            return 0L;
        }
        return this.playSoundImpl(string, isoObject);
    }

    public long playSoundImpl(String string, IsoObject isoObject) {
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return 0L;
        }
        GameSoundClip gameSoundClip = gameSound.getRandomClip();
        return this.playClip(gameSoundClip, isoObject);
    }

    public long playClip(GameSoundClip gameSoundClip, IsoObject isoObject) {
        Sound sound = this.addSound(gameSoundClip, 1.0f, isoObject);
        return sound == null ? 0L : sound.getRef();
    }

    public long playAmbientSound(String string) {
        if (GameServer.bServer) {
            return 0L;
        }
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return 0L;
        }
        GameSoundClip gameSoundClip = gameSound.getRandomClip();
        Sound sound = this.addSound(gameSoundClip, 1.0f, null);
        if (sound instanceof FileSound) {
            ((FileSound)sound).ambient = true;
        }
        return sound == null ? 0L : sound.getRef();
    }

    public long playAmbientLoopedImpl(String string) {
        if (GameServer.bServer) {
            return 0L;
        }
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return 0L;
        }
        GameSoundClip gameSoundClip = gameSound.getRandomClip();
        Sound sound = this.addSound(gameSoundClip, 1.0f, null);
        return sound == null ? 0L : sound.getRef();
    }

    public void set3D(long l, boolean bl) {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            if (sound.getRef() != l) continue;
            sound.set3D(bl);
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (sound.getRef() != l) continue;
            sound.set3D(bl);
        }
    }

    public void tick() {
        Sound sound;
        int n;
        if (!this.isEmpty()) {
            this.occlusion.update();
            for (n = 0; n < this.parameters.size(); ++n) {
                sound = this.parameters.get(n);
                sound.update();
            }
        }
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            this.Instances.add(sound);
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            boolean bl;
            sound = this.Instances.get(n);
            if (!sound.tick(bl = this.ToStart.contains(sound))) continue;
            this.Instances.remove(n--);
            sound.release();
        }
        this.ToStart.clear();
    }

    public boolean hasSoundsToStart() {
        return !this.ToStart.isEmpty();
    }

    public boolean isEmpty() {
        return this.ToStart.isEmpty() && this.Instances.isEmpty();
    }

    public boolean isPlaying(long l) {
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            if (this.ToStart.get(n).getRef() != l) continue;
            return true;
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            if (this.Instances.get(n).getRef() != l) continue;
            return true;
        }
        return false;
    }

    public boolean isPlaying(String string) {
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            if (!string.equals(this.ToStart.get((int)n).name)) continue;
            return true;
        }
        for (n = 0; n < this.Instances.size(); ++n) {
            if (!string.equals(this.Instances.get((int)n).name)) continue;
            return true;
        }
        return false;
    }

    public boolean restart(long l) {
        int n = this.findToStart(l);
        if (n != -1) {
            return true;
        }
        n = this.findInstance(l);
        return n != -1 && this.Instances.get(n).restart();
    }

    private int findInstance(long l) {
        for (int i = 0; i < this.Instances.size(); ++i) {
            Sound sound = this.Instances.get(i);
            if (sound.getRef() != l) continue;
            return i;
        }
        return -1;
    }

    private int findInstance(String string) {
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return -1;
        }
        for (int i = 0; i < this.Instances.size(); ++i) {
            Sound sound = this.Instances.get(i);
            if (!gameSound.clips.contains(sound.clip)) continue;
            return i;
        }
        return -1;
    }

    private int findToStart(long l) {
        for (int i = 0; i < this.ToStart.size(); ++i) {
            Sound sound = this.ToStart.get(i);
            if (sound.getRef() != l) continue;
            return i;
        }
        return -1;
    }

    private int findToStart(String string) {
        GameSound gameSound = GameSounds.getSound((String)string);
        if (gameSound == null) {
            return -1;
        }
        for (int i = 0; i < this.ToStart.size(); ++i) {
            Sound sound = this.ToStart.get(i);
            if (!gameSound.clips.contains(sound.clip)) continue;
            return i;
        }
        return -1;
    }

    private int countToStart(GameSound gameSound) {
        int n = 0;
        for (int i = 0; i < this.ToStart.size(); ++i) {
            Sound sound = this.ToStart.get(i);
            if (!gameSound.clips.contains(sound.clip)) continue;
            ++n;
        }
        return n;
    }

    private int countInstances(GameSound gameSound) {
        int n = 0;
        for (int i = 0; i < this.Instances.size(); ++i) {
            Sound sound = this.Instances.get(i);
            if (!gameSound.clips.contains(sound.clip)) continue;
            ++n;
        }
        return n;
    }

    public void addParameter(FMODParameter fMODParameter) {
        this.parameters.add(fMODParameter);
    }

    public void setParameterValue(long l, FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION, float f) {
        if (l == 0L || fMOD_STUDIO_PARAMETER_DESCRIPTION == null) {
            return;
        }
        int n = this.findInstance(l);
        if (n != -1) {
            Sound sound = this.Instances.get(n);
            sound.setParameterValue(fMOD_STUDIO_PARAMETER_DESCRIPTION, f);
            return;
        }
        n = this.findParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION);
        if (n != -1) {
            this.parameterValues.get((int)n).value = f;
            return;
        }
        ParameterValue parameterValue = (ParameterValue)parameterValuePool.alloc();
        parameterValue.eventInstance = l;
        parameterValue.parameterDescription = fMOD_STUDIO_PARAMETER_DESCRIPTION;
        parameterValue.value = f;
        this.parameterValues.add(parameterValue);
    }

    public void setTimelinePosition(long l, String string) {
        if (l == 0L) {
            return;
        }
        int n = this.findToStart(l);
        if (n != -1) {
            Sound sound = this.ToStart.get(n);
            sound.setTimelinePosition(string);
        }
    }

    private int findParameterValue(long l, FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION) {
        for (int i = 0; i < this.parameterValues.size(); ++i) {
            ParameterValue parameterValue = this.parameterValues.get(i);
            if (parameterValue.eventInstance != l || parameterValue.parameterDescription != fMOD_STUDIO_PARAMETER_DESCRIPTION) continue;
            return i;
        }
        return -1;
    }

    public void clearParameters() {
        this.occlusion.resetToDefault();
        this.parameters.clear();
        parameterValuePool.releaseAll(this.parameterValues);
        this.parameterValues.clear();
    }

    private void startEvent(long l, GameSoundClip gameSoundClip) {
        parameterSet.clear();
        ArrayList<FMODParameter> arrayList = this.parameters;
        ArrayList<FMOD_STUDIO_PARAMETER_DESCRIPTION> arrayList2 = gameSoundClip.eventDescription.parameters;
        block0: for (int i = 0; i < arrayList2.size(); ++i) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = arrayList2.get(i);
            int n = this.findParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION);
            if (n != -1) {
                ParameterValue parameterValue = this.parameterValues.get(n);
                javafmod.FMOD_Studio_EventInstance_SetParameterByID(l, fMOD_STUDIO_PARAMETER_DESCRIPTION.id, parameterValue.value, false);
                parameterSet.set(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex, true);
                continue;
            }
            if (fMOD_STUDIO_PARAMETER_DESCRIPTION == this.occlusion.getParameterDescription()) {
                this.occlusion.startEventInstance(l);
                parameterSet.set(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex, true);
                continue;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                FMODParameter fMODParameter = arrayList.get(j);
                if (fMODParameter.getParameterDescription() != fMOD_STUDIO_PARAMETER_DESCRIPTION) continue;
                fMODParameter.startEventInstance(l);
                parameterSet.set(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex, true);
                continue block0;
            }
        }
        if (this.parameterUpdater != null) {
            this.parameterUpdater.startEvent(l, gameSoundClip, parameterSet);
        }
    }

    private void updateEvent(long l, GameSoundClip gameSoundClip) {
        if (this.parameterUpdater != null) {
            this.parameterUpdater.updateEvent(l, gameSoundClip);
        }
    }

    private void stopEvent(long l, GameSoundClip gameSoundClip) {
        parameterSet.clear();
        ArrayList<FMODParameter> arrayList = this.parameters;
        ArrayList<FMOD_STUDIO_PARAMETER_DESCRIPTION> arrayList2 = gameSoundClip.eventDescription.parameters;
        block0: for (int i = 0; i < arrayList2.size(); ++i) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = arrayList2.get(i);
            int n = this.findParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION);
            if (n != -1) {
                ParameterValue parameterValue = this.parameterValues.remove(n);
                parameterValuePool.release((Object)parameterValue);
                parameterSet.set(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex, true);
                continue;
            }
            if (fMOD_STUDIO_PARAMETER_DESCRIPTION == this.occlusion.getParameterDescription()) {
                this.occlusion.stopEventInstance(l);
                parameterSet.set(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex, true);
                continue;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                FMODParameter fMODParameter = arrayList.get(j);
                if (fMODParameter.getParameterDescription() != fMOD_STUDIO_PARAMETER_DESCRIPTION) continue;
                fMODParameter.stopEventInstance(l);
                parameterSet.set(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex, true);
                continue block0;
            }
        }
        if (this.parameterUpdater != null) {
            this.parameterUpdater.stopEvent(l, gameSoundClip, parameterSet);
        }
    }

    private EventSound allocEventSound() {
        return this.eventSoundPool.isEmpty() ? new EventSound(this) : this.eventSoundPool.pop();
    }

    private void releaseEventSound(EventSound eventSound) {
        assert (!this.eventSoundPool.contains(eventSound));
        this.eventSoundPool.push(eventSound);
    }

    private FileSound allocFileSound() {
        return this.fileSoundPool.isEmpty() ? new FileSound(this) : this.fileSoundPool.pop();
    }

    private void releaseFileSound(FileSound fileSound) {
        assert (!this.fileSoundPool.contains(fileSound));
        this.fileSoundPool.push(fileSound);
    }

    private Sound addSound(GameSoundClip gameSoundClip, float f, IsoObject isoObject) {
        if (gameSoundClip == null) {
            DebugLog.log((String)"null sound passed to SoundEmitter.playSoundImpl");
            return null;
        }
        if (gameSoundClip.gameSound.maxInstancesPerEmitter > 0) {
            this.limitSound(gameSoundClip.gameSound, gameSoundClip.gameSound.maxInstancesPerEmitter - 1);
        }
        if (gameSoundClip.event != null && !gameSoundClip.event.isEmpty()) {
            long l;
            if (gameSoundClip.eventDescription == null) {
                return null;
            }
            FMOD_STUDIO_EVENT_DESCRIPTION fMOD_STUDIO_EVENT_DESCRIPTION = gameSoundClip.eventDescription;
            if (gameSoundClip.eventDescriptionMP != null && this.parent instanceof IsoPlayer && !((IsoPlayer)this.parent).isLocalPlayer()) {
                fMOD_STUDIO_EVENT_DESCRIPTION = gameSoundClip.eventDescriptionMP;
            }
            if ((l = javafmod.FMOD_Studio_System_CreateEventInstance(fMOD_STUDIO_EVENT_DESCRIPTION.address)) < 0L) {
                return null;
            }
            if (gameSoundClip.hasMinDistance()) {
                javafmodJNI.FMOD_Studio_EventInstance_SetProperty(l, FMOD_STUDIO_EVENT_PROPERTY.FMOD_STUDIO_EVENT_PROPERTY_MINIMUM_DISTANCE.ordinal(), gameSoundClip.getMinDistance());
            }
            if (gameSoundClip.hasMaxDistance()) {
                javafmodJNI.FMOD_Studio_EventInstance_SetProperty(l, FMOD_STUDIO_EVENT_PROPERTY.FMOD_STUDIO_EVENT_PROPERTY_MAXIMUM_DISTANCE.ordinal(), gameSoundClip.getMaxDistance());
            }
            EventSound eventSound = this.allocEventSound();
            eventSound.clip = gameSoundClip;
            eventSound.name = gameSoundClip.gameSound.getName();
            eventSound.eventInstance = l;
            eventSound.volume = f;
            eventSound.parent = isoObject;
            eventSound.setVolume = 1.0f;
            eventSound.setZ = 0.0f;
            eventSound.setY = 0.0f;
            eventSound.setX = 0.0f;
            this.ToStart.add(eventSound);
            return eventSound;
        }
        if (gameSoundClip.file != null && !gameSoundClip.file.isEmpty()) {
            long l = FMODManager.instance.loadSound(gameSoundClip.file);
            if (l == 0L) {
                return null;
            }
            long l2 = javafmod.FMOD_System_PlaySound(l, true);
            javafmod.FMOD_Channel_SetVolume(l2, 0.0f);
            javafmod.FMOD_Channel_SetPriority(l2, 9 - gameSoundClip.priority);
            javafmod.FMOD_Channel_SetChannelGroup(l2, FMODManager.instance.channelGroupInGameNonBankSounds);
            if (gameSoundClip.distanceMax == 0.0f || this.x == 0.0f && this.y == 0.0f) {
                javafmod.FMOD_Channel_SetMode(l2, FMODManager.FMOD_2D);
            }
            FileSound fileSound = this.allocFileSound();
            fileSound.clip = gameSoundClip;
            fileSound.name = gameSoundClip.gameSound.getName();
            fileSound.sound = l;
            fileSound.pitch = gameSoundClip.pitch;
            fileSound.channel = l2;
            fileSound.parent = isoObject;
            fileSound.volume = f;
            fileSound.setVolume = 1.0f;
            fileSound.setZ = 0.0f;
            fileSound.setY = 0.0f;
            fileSound.setX = 0.0f;
            fileSound.is3D = (byte)-1;
            fileSound.ambient = false;
            this.ToStart.add(fileSound);
            return fileSound;
        }
        return null;
    }

    private void sendStopSound(String string, boolean bl) {
        if (GameClient.bClient && this.parent instanceof IsoMovingObject) {
            GameClient.instance.StopSound((IsoMovingObject)this.parent, string, bl);
        }
    }

    public static void update() {
        CurrentTimeMS = System.currentTimeMillis();
    }

    static {
        CurrentTimeMS = 0L;
    }

    private static abstract class Sound {
        FMODSoundEmitter emitter;
        public GameSoundClip clip;
        public String name;
        public float volume = 1.0f;
        public float pitch = 1.0f;
        public IsoObject parent;
        public float setVolume = 1.0f;
        float setX = 0.0f;
        float setY = 0.0f;
        float setZ = 0.0f;

        Sound(FMODSoundEmitter fMODSoundEmitter) {
            this.emitter = fMODSoundEmitter;
        }

        abstract long getRef();

        abstract void stop();

        abstract void set3D(boolean var1);

        abstract void release();

        abstract boolean tick(boolean var1);

        float getVolume() {
            this.clip = this.clip.checkReloaded();
            return this.volume * this.clip.getEffectiveVolume();
        }

        abstract void setParameterValue(FMOD_STUDIO_PARAMETER_DESCRIPTION var1, float var2);

        abstract void setTimelinePosition(String var1);

        abstract void triggerCue();

        abstract boolean isTriggeredCue();

        abstract boolean restart();
    }

    private static final class FileSound
    extends Sound {
        long sound;
        long channel;
        byte is3D = (byte)-1;
        boolean ambient;
        float lx;
        float ly;
        float lz;

        FileSound(FMODSoundEmitter fMODSoundEmitter) {
            super(fMODSoundEmitter);
        }

        @Override
        long getRef() {
            return this.channel;
        }

        @Override
        void stop() {
            if (this.channel == 0L) {
                return;
            }
            javafmod.FMOD_Channel_Stop(this.channel);
            this.sound = 0L;
            this.channel = 0L;
        }

        @Override
        void set3D(boolean bl) {
            if (this.is3D != (byte)(bl ? 1 : '\u0000')) {
                javafmod.FMOD_Channel_SetMode(this.channel, bl ? (long)FMODManager.FMOD_3D : (long)FMODManager.FMOD_2D);
                if (bl) {
                    javafmod.FMOD_Channel_Set3DAttributes(this.channel, this.emitter.x, this.emitter.y, this.emitter.z * 3.0f, 0.0f, 0.0f, 0.0f);
                }
                this.is3D = (byte)(bl ? 1 : '\u0000');
            }
        }

        @Override
        void release() {
            this.stop();
            this.emitter.releaseFileSound(this);
        }

        @Override
        boolean tick(boolean bl) {
            int n;
            int n2;
            int n3;
            float f;
            if (bl && this.clip.gameSound.isLooped()) {
                javafmod.FMOD_Channel_SetMode(this.channel, FMODManager.FMOD_LOOP_NORMAL);
            }
            float f2 = this.clip.distanceMin;
            if (!bl && !javafmod.FMOD_Channel_IsPlaying(this.channel)) {
                return true;
            }
            float f3 = this.emitter.x;
            float f4 = this.emitter.y;
            float f5 = this.emitter.z;
            if (!this.clip.gameSound.is3D || f3 == 0.0f && f4 == 0.0f) {
                if (!(f3 == 0.0f && f4 == 0.0f || !bl && f3 == this.lx && f4 == this.ly || this.is3D != 1)) {
                    javafmod.FMOD_Channel_Set3DAttributes(this.channel, f3, f4, f5 * 3.0f, 0.0f, 0.0f, 0.0f);
                }
                javafmod.FMOD_Channel_SetVolume(this.channel, this.getVolume());
                javafmod.FMOD_Channel_SetPitch(this.channel, this.pitch);
                if (bl) {
                    javafmod.FMOD_Channel_SetPaused(this.channel, false);
                }
                return false;
            }
            this.lx = f3;
            this.ly = f4;
            this.lz = f5;
            javafmod.FMOD_Channel_Set3DAttributes(this.channel, f3, f4, f5 * 3.0f, f3 - this.lx, f4 - this.ly, f5 * 3.0f - this.lz * 3.0f);
            float f6 = Float.MAX_VALUE;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.isDeaf()) continue;
                f = IsoUtils.DistanceTo((float)f3, (float)f4, (float)(f5 * 3.0f), (float)isoPlayer.x, (float)isoPlayer.y, (float)(isoPlayer.z * 3.0f));
                f6 = PZMath.min((float)f6, (float)f);
            }
            float f7 = 2.0f;
            float f8 = f6 >= f7 ? 1.0f : 1.0f - (f7 - f6) / f7;
            javafmodJNI.FMOD_Channel_Set3DLevel(this.channel, f8);
            if (IsoPlayer.numPlayers > 1) {
                if (bl) {
                    javafmod.FMOD_System_SetReverbDefault(0, FMODManager.FMOD_PRESET_OFF);
                    javafmod.FMOD_Channel_Set3DMinMaxDistance(this.channel, this.clip.distanceMin, this.clip.distanceMax);
                    javafmod.FMOD_Channel_Set3DOcclusion(this.channel, 0.0f, 0.0f);
                }
                javafmod.FMOD_Channel_SetVolume(this.channel, this.getVolume());
                if (bl) {
                    javafmod.FMOD_Channel_SetPaused(this.channel, false);
                }
                javafmod.FMOD_Channel_SetReverbProperties(this.channel, 0, 0.0f);
                javafmod.FMOD_Channel_SetReverbProperties(this.channel, 1, 0.0f);
                javafmod.FMOD_System_SetReverbDefault(1, FMODManager.FMOD_PRESET_OFF);
                javafmod.FMOD_Channel_Set3DOcclusion(this.channel, 0.0f, 0.0f);
                return false;
            }
            f6 = this.clip.reverbMaxRange;
            f7 = IsoUtils.DistanceManhatten((float)f3, (float)f4, (float)IsoPlayer.getInstance().x, (float)IsoPlayer.getInstance().y, (float)f5, (float)IsoPlayer.getInstance().z) / f6;
            IsoGridSquare isoGridSquare = IsoPlayer.getInstance().getCurrentSquare();
            if (isoGridSquare == null) {
                javafmod.FMOD_Channel_Set3DMinMaxDistance(this.channel, f2, this.clip.distanceMax);
                javafmod.FMOD_Channel_SetVolume(this.channel, this.getVolume());
                if (bl) {
                    javafmod.FMOD_Channel_SetPaused(this.channel, false);
                }
                return false;
            }
            if (isoGridSquare.getRoom() == null) {
                if (!this.ambient) {
                    f7 += IsoPlayer.getInstance().numNearbyBuildingsRooms / 32.0f;
                }
                if (!this.ambient) {
                    f7 += 0.08f;
                }
            } else {
                f = isoGridSquare.getRoom().Squares.size();
                if (!this.ambient) {
                    f7 += f / 500.0f;
                }
            }
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            f7 *= f7;
            f7 *= f7;
            f7 *= this.clip.reverbFactor;
            f7 *= 10.0f;
            if (IsoPlayer.getInstance().getCurrentSquare().getRoom() == null && f7 < 0.1f) {
                f7 = 0.1f;
            }
            if (!this.ambient) {
                if (isoGridSquare.getRoom() != null) {
                    n3 = 0;
                    n2 = 1;
                    n = 2;
                } else {
                    n3 = 2;
                    n2 = 0;
                    n = 1;
                }
            } else {
                n3 = 2;
                n2 = 0;
                n = 1;
            }
            IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare((double)f3, (double)f4, (double)f5);
            if (isoGridSquare2 != null && isoGridSquare2.getZone() != null && (isoGridSquare2.getZone().getType().equals("Forest") || isoGridSquare2.getZone().getType().equals("DeepForest"))) {
                n3 = 1;
                n2 = 0;
                n = 2;
            }
            javafmod.FMOD_Channel_SetReverbProperties(this.channel, n3, 0.0f);
            javafmod.FMOD_Channel_SetReverbProperties(this.channel, n2, 0.0f);
            javafmod.FMOD_Channel_SetReverbProperties(this.channel, n, 0.0f);
            javafmod.FMOD_Channel_Set3DMinMaxDistance(this.channel, f2, this.clip.distanceMax);
            IsoGridSquare isoGridSquare3 = IsoWorld.instance.CurrentCell.getGridSquare((double)f3, (double)f4, (double)f5);
            float f9 = 0.0f;
            float f10 = 0.0f;
            if (isoGridSquare3 != null) {
                if (this.emitter.parent instanceof IsoWindow || this.emitter.parent instanceof IsoDoor) {
                    isoGridSquare2 = IsoPlayer.getInstance().getCurrentSquare().getRoom();
                    if (isoGridSquare2 != this.emitter.parent.square.getRoom()) {
                        if (isoGridSquare2 != null && isoGridSquare2.getBuilding() == this.emitter.parent.square.getBuilding()) {
                            f9 = 0.33f;
                            f10 = 0.33f;
                        } else {
                            IsoGridSquare isoGridSquare4 = null;
                            if (this.emitter.parent instanceof IsoDoor) {
                                IsoDoor isoDoor = (IsoDoor)this.emitter.parent;
                                isoGridSquare4 = isoDoor.north ? IsoWorld.instance.CurrentCell.getGridSquare((double)isoDoor.getX(), (double)(isoDoor.getY() - 1.0f), (double)isoDoor.getZ()) : IsoWorld.instance.CurrentCell.getGridSquare((double)(isoDoor.getX() - 1.0f), (double)isoDoor.getY(), (double)isoDoor.getZ());
                            } else {
                                IsoWindow isoWindow = (IsoWindow)this.emitter.parent;
                                isoGridSquare4 = isoWindow.north ? IsoWorld.instance.CurrentCell.getGridSquare((double)isoWindow.getX(), (double)(isoWindow.getY() - 1.0f), (double)isoWindow.getZ()) : IsoWorld.instance.CurrentCell.getGridSquare((double)(isoWindow.getX() - 1.0f), (double)isoWindow.getY(), (double)isoWindow.getZ());
                            }
                            if (isoGridSquare4 != null && ((isoGridSquare2 = IsoPlayer.getInstance().getCurrentSquare().getRoom()) != null || isoGridSquare4.getRoom() == null)) {
                                if (isoGridSquare2 != null && isoGridSquare4.getRoom() != null && isoGridSquare2.building == isoGridSquare4.getBuilding()) {
                                    if (isoGridSquare2 != isoGridSquare4.getRoom()) {
                                        if (isoGridSquare2.def.level == isoGridSquare4.getZ()) {
                                            f9 = 0.33f;
                                            f10 = 0.33f;
                                        } else {
                                            f9 = 0.6f;
                                            f10 = 0.6f;
                                        }
                                    }
                                } else {
                                    f9 = 0.33f;
                                    f10 = 0.33f;
                                }
                            }
                        }
                    }
                } else if (isoGridSquare3.getRoom() != null) {
                    isoGridSquare2 = IsoPlayer.getInstance().getCurrentSquare().getRoom();
                    if (isoGridSquare2 == null) {
                        f9 = 0.33f;
                        f10 = 0.23f;
                    } else if (isoGridSquare2 != isoGridSquare3.getRoom()) {
                        f9 = 0.24f;
                        f10 = 0.24f;
                    }
                    if (isoGridSquare2 != null && isoGridSquare3.getRoom().getBuilding() != isoGridSquare2.getBuilding()) {
                        f9 = 1.0f;
                        f10 = 0.8f;
                    }
                    if (isoGridSquare2 != null && isoGridSquare3.getRoom().def.level != (int)IsoPlayer.getInstance().z) {
                        f9 = 0.6f;
                        f10 = 0.6f;
                    }
                } else {
                    isoGridSquare2 = IsoPlayer.getInstance().getCurrentSquare().getRoom();
                    if (isoGridSquare2 != null) {
                        f9 = 0.79f;
                        f10 = 0.59f;
                    }
                }
                if (!isoGridSquare3.isCouldSee(IsoPlayer.getPlayerIndex()) && isoGridSquare3 != IsoPlayer.getInstance().getCurrentSquare()) {
                    f9 += 0.4f;
                }
            } else {
                if (IsoWorld.instance.MetaGrid.getRoomAt((int)f3, (int)f4, (int)f5) != null) {
                    f9 = 1.0f;
                    f10 = 1.0f;
                }
                f9 = (isoGridSquare2 = IsoPlayer.getInstance().getCurrentSquare().getRoom()) != null ? (f9 += 0.94f) : (f9 += 0.6f);
            }
            if (isoGridSquare3 != null && (int)IsoPlayer.getInstance().z != isoGridSquare3.getZ()) {
                f9 *= 1.3f;
            }
            if (f9 > 0.9f) {
                f9 = 0.9f;
            }
            if (f10 > 0.9f) {
                f10 = 0.9f;
            }
            if (this.emitter.emitterType == EmitterType.Footstep && f5 > IsoPlayer.getInstance().z && isoGridSquare3.getBuilding() == IsoPlayer.getInstance().getBuilding()) {
                f9 = 0.0f;
                f10 = 0.0f;
            }
            if ("HouseAlarm".equals(this.name)) {
                f9 = 0.0f;
                f10 = 0.0f;
            }
            javafmod.FMOD_Channel_Set3DOcclusion(this.channel, f9, f10);
            javafmod.FMOD_Channel_SetVolume(this.channel, this.getVolume());
            javafmod.FMOD_Channel_SetPitch(this.channel, this.pitch);
            if (bl) {
                javafmod.FMOD_Channel_SetPaused(this.channel, false);
            }
            this.lx = f3;
            this.ly = f4;
            this.lz = f5;
            return false;
        }

        @Override
        void setParameterValue(FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION, float f) {
        }

        @Override
        void setTimelinePosition(String string) {
        }

        @Override
        void triggerCue() {
        }

        @Override
        boolean isTriggeredCue() {
            return false;
        }

        @Override
        boolean restart() {
            return false;
        }
    }

    private static final class ParameterValue {
        long eventInstance;
        FMOD_STUDIO_PARAMETER_DESCRIPTION parameterDescription;
        float value;

        private ParameterValue() {
        }
    }

    private static final class EventSound
    extends Sound {
        long eventInstance;
        boolean bTriggeredCue = false;
        long checkTimeMS = 0L;

        EventSound(FMODSoundEmitter fMODSoundEmitter) {
            super(fMODSoundEmitter);
        }

        @Override
        long getRef() {
            return this.eventInstance;
        }

        @Override
        void stop() {
            if (this.eventInstance == 0L) {
                return;
            }
            this.emitter.stopEvent(this.eventInstance, this.clip);
            javafmod.FMOD_Studio_EventInstance_Stop(this.eventInstance, false);
            javafmod.FMOD_Studio_ReleaseEventInstance(this.eventInstance);
            this.eventInstance = 0L;
        }

        @Override
        void set3D(boolean bl) {
        }

        @Override
        void release() {
            this.stop();
            this.checkTimeMS = 0L;
            this.bTriggeredCue = false;
            this.emitter.releaseEventSound(this);
        }

        @Override
        boolean tick(boolean bl) {
            float f;
            int n;
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            if (IsoPlayer.numPlayers > 1) {
                isoPlayer = null;
            }
            if (!bl) {
                n = javafmod.FMOD_Studio_GetPlaybackState(this.eventInstance);
                if (n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPING.index) {
                    return false;
                }
                if (n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPED.index) {
                    javafmod.FMOD_Studio_ReleaseEventInstance(this.eventInstance);
                    this.emitter.stopEvent(this.eventInstance, this.clip);
                    this.eventInstance = 0L;
                    return true;
                }
                if (this.bTriggeredCue && CurrentTimeMS - this.checkTimeMS > 250L && n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_SUSTAINING.index) {
                    javafmodJNI.FMOD_Studio_EventInstance_KeyOff(this.eventInstance);
                }
                if (this.bTriggeredCue && this.clip.eventDescription.length > 0L && CurrentTimeMS - this.checkTimeMS > 1500L) {
                    long l = javafmodJNI.FMOD_Studio_GetTimelinePosition(this.eventInstance);
                    if (l > this.clip.eventDescription.length + 1000L) {
                        javafmod.FMOD_Studio_EventInstance_Stop(this.eventInstance, false);
                    }
                    this.checkTimeMS = CurrentTimeMS;
                }
            }
            int n2 = n = Float.compare(this.emitter.x, this.setX) != 0 || Float.compare(this.emitter.y, this.setY) != 0 || Float.compare(this.emitter.z, this.setZ) != 0 ? 1 : 0;
            if (n != 0) {
                this.setX = this.emitter.x;
                this.setY = this.emitter.y;
                this.setZ = this.emitter.z;
                javafmod.FMOD_Studio_EventInstance3D(this.eventInstance, this.emitter.x, this.emitter.y, this.emitter.z * 3.0f);
            }
            if (Float.compare(f = this.getVolume(), this.setVolume) != 0) {
                this.setVolume = f;
                javafmod.FMOD_Studio_EventInstance_SetVolume(this.eventInstance, f);
            }
            if (bl) {
                this.emitter.startEvent(this.eventInstance, this.clip);
                javafmod.FMOD_Studio_StartEvent(this.eventInstance);
            } else {
                this.emitter.updateEvent(this.eventInstance, this.clip);
            }
            return false;
        }

        @Override
        void setParameterValue(FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION, float f) {
            if (this.eventInstance == 0L) {
                return;
            }
            javafmod.FMOD_Studio_EventInstance_SetParameterByID(this.eventInstance, fMOD_STUDIO_PARAMETER_DESCRIPTION.id, f, false);
        }

        @Override
        void setTimelinePosition(String string) {
            if (this.eventInstance == 0L || this.clip == null || this.clip.event == null) {
                return;
            }
            SoundTimelineScript soundTimelineScript = ScriptManager.instance.getSoundTimeline(this.clip.event);
            if (soundTimelineScript == null) {
                return;
            }
            int n = soundTimelineScript.getPosition(string);
            if (n == -1) {
                return;
            }
            javafmodJNI.FMOD_Studio_EventInstance_SetTimelinePosition(this.eventInstance, n);
        }

        @Override
        void triggerCue() {
            if (this.eventInstance == 0L) {
                return;
            }
            if (!this.clip.hasSustainPoints()) {
                return;
            }
            javafmodJNI.FMOD_Studio_EventInstance_KeyOff(this.eventInstance);
            this.bTriggeredCue = true;
            this.checkTimeMS = CurrentTimeMS;
        }

        @Override
        boolean isTriggeredCue() {
            return this.bTriggeredCue;
        }

        @Override
        boolean restart() {
            if (this.eventInstance == 0L) {
                return false;
            }
            javafmodJNI.FMOD_Studio_StartEvent(this.eventInstance);
            return true;
        }
    }
}

