/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

class MdctFloat {
    private static final float cPI3_8 = 0.38268343f;
    private static final float cPI2_8 = 0.70710677f;
    private static final float cPI1_8 = 0.9238795f;
    private int n;
    private int log2n;
    private float[] trig;
    private int[] bitrev;
    private float[] equalizer;
    private float scale;
    private int itmp1;
    private int itmp2;
    private int itmp3;
    private int itmp4;
    private int itmp5;
    private int itmp6;
    private int itmp7;
    private int itmp8;
    private int itmp9;
    private float dtmp1;
    private float dtmp2;
    private float dtmp3;
    private float dtmp4;
    private float dtmp5;
    private float dtmp6;
    private float dtmp7;
    private float dtmp8;
    private float dtmp9;
    private float[] _x = new float[1024];
    private float[] _w = new float[1024];

    protected MdctFloat(int n) {
        int n2;
        this.bitrev = new int[n / 4];
        this.trig = new float[n + n / 4];
        int n3 = n >>> 1;
        this.log2n = (int)Math.rint(Math.log(n) / Math.log(2.0));
        this.n = n;
        int n4 = 0;
        int n5 = 1;
        int n6 = n4 + n / 2;
        int n7 = n6 + 1;
        int n8 = n6 + n / 2;
        int n9 = n8 + 1;
        for (n2 = 0; n2 < n / 4; ++n2) {
            this.trig[n4 + n2 * 2] = (float)Math.cos(Math.PI / (double)n * (double)(4 * n2));
            this.trig[n5 + n2 * 2] = (float)(-Math.sin(Math.PI / (double)n * (double)(4 * n2)));
            this.trig[n6 + n2 * 2] = (float)Math.cos(Math.PI / (double)(2 * n) * (double)(2 * n2 + 1));
            this.trig[n7 + n2 * 2] = (float)Math.sin(Math.PI / (double)(2 * n) * (double)(2 * n2 + 1));
        }
        for (n2 = 0; n2 < n / 8; ++n2) {
            this.trig[n8 + n2 * 2] = (float)Math.cos(Math.PI / (double)n * (double)(4 * n2 + 2));
            this.trig[n9 + n2 * 2] = (float)(-Math.sin(Math.PI / (double)n * (double)(4 * n2 + 2)));
        }
        n2 = (1 << this.log2n - 1) - 1;
        int n10 = 1 << this.log2n - 2;
        for (int i = 0; i < n / 8; ++i) {
            int n11 = 0;
            int n12 = 0;
            while (n10 >>> n12 != 0) {
                if ((n10 >>> n12 & i) != 0) {
                    n11 |= 1 << n12;
                }
                ++n12;
            }
            this.bitrev[i * 2] = ~n11 & n2;
            this.bitrev[i * 2 + 1] = n11;
        }
        this.scale = 4.0f / (float)n;
    }

    protected void setEqualizer(float[] fArray) {
        this.equalizer = fArray;
    }

    protected float[] getEqualizer() {
        return this.equalizer;
    }

    protected synchronized void imdct(float[] fArray, float[] fArray2, int[] nArray) {
        int n;
        int n2;
        float[] fArray3 = fArray;
        if (this._x.length < this.n / 2) {
            this._x = new float[this.n / 2];
        }
        if (this._w.length < this.n / 2) {
            this._w = new float[this.n / 2];
        }
        float[] fArray4 = this._x;
        float[] fArray5 = this._w;
        int n3 = this.n >> 1;
        int n4 = this.n >> 2;
        int n5 = this.n >> 3;
        if (this.equalizer != null) {
            for (n2 = 0; n2 < this.n; ++n2) {
                int n6 = n2;
                fArray[n6] = fArray[n6] * this.equalizer[n2];
            }
        }
        n2 = -1;
        int n7 = 0;
        int n8 = n3;
        for (n = 0; n < n5; ++n) {
            this.dtmp1 = fArray3[n2 += 2];
            this.dtmp2 = fArray3[n2 += 2];
            this.dtmp3 = this.trig[--n8];
            this.dtmp4 = this.trig[--n8];
            fArray4[n7++] = -this.dtmp2 * this.dtmp3 - this.dtmp1 * this.dtmp4;
            fArray4[n7++] = this.dtmp1 * this.dtmp3 - this.dtmp2 * this.dtmp4;
        }
        n2 = n3;
        for (n = 0; n < n5; ++n) {
            this.dtmp1 = fArray3[n2 -= 2];
            this.dtmp2 = fArray3[n2 -= 2];
            this.dtmp3 = this.trig[--n8];
            this.dtmp4 = this.trig[--n8];
            fArray4[n7++] = this.dtmp2 * this.dtmp3 + this.dtmp1 * this.dtmp4;
            fArray4[n7++] = this.dtmp2 * this.dtmp4 - this.dtmp1 * this.dtmp3;
        }
        float[] fArray6 = this.kernel(fArray4, fArray5, this.n, n3, n4, n5);
        n7 = 0;
        n8 = n3;
        n = n4;
        int n9 = n - 1;
        int n10 = n4 + n3;
        int n11 = n10 - 1;
        for (int i = 0; i < n4; ++i) {
            this.dtmp1 = fArray6[n7++];
            this.dtmp2 = fArray6[n7++];
            this.dtmp3 = this.trig[n8++];
            this.dtmp4 = this.trig[n8++];
            float f = this.dtmp1 * this.dtmp4 - this.dtmp2 * this.dtmp3;
            float f2 = -(this.dtmp1 * this.dtmp3 + this.dtmp2 * this.dtmp4);
            nArray[n] = (int)(-f * fArray2[n]);
            nArray[n9] = (int)(f * fArray2[n9]);
            nArray[n10] = (int)(f2 * fArray2[n10]);
            nArray[n11] = (int)(f2 * fArray2[n11]);
            ++n;
            --n9;
            ++n10;
            --n11;
        }
    }

    private float[] kernel(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        float f;
        float f2;
        float f3;
        float f4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n3;
        int n10 = 0;
        int n11 = n3;
        int n12 = n2;
        for (n8 = 0; n8 < n3; ++n8) {
            float f5 = fArray[n9] - fArray[n10];
            fArray2[n11 + n8] = fArray[n9++] + fArray[n10++];
            float f6 = fArray[n9] - fArray[n10];
            fArray2[n8++] = f5 * this.trig[n12 -= 4] + f6 * this.trig[n12 + 1];
            fArray2[n8] = f6 * this.trig[n12] - f5 * this.trig[n12 + 1];
            fArray2[n11 + n8] = fArray[n9++] + fArray[n10++];
        }
        for (n8 = 0; n8 < this.log2n - 3; ++n8) {
            int n13 = n >>> n8 + 2;
            int n14 = 1 << n8 + 3;
            n7 = n2 - 2;
            n12 = 0;
            for (n6 = 0; n6 < n13 >>> 2; ++n6) {
                n5 = n7;
                n11 = n5 - (n13 >> 1);
                f4 = this.trig[n12];
                f3 = this.trig[n12 + 1];
                n7 -= 2;
                ++n13;
                for (int i = 0; i < 2 << n8; ++i) {
                    this.dtmp1 = fArray2[n5];
                    this.dtmp2 = fArray2[n11];
                    f2 = this.dtmp1 - this.dtmp2;
                    fArray[n5] = this.dtmp1 + this.dtmp2;
                    this.dtmp1 = fArray2[++n5];
                    this.dtmp2 = fArray2[++n11];
                    f = this.dtmp1 - this.dtmp2;
                    fArray[n5] = this.dtmp1 + this.dtmp2;
                    fArray[n11] = f * f4 - f2 * f3;
                    fArray[n11 - 1] = f2 * f4 + f * f3;
                    n5 -= n13;
                    n11 -= n13;
                }
                --n13;
                n12 += n14;
            }
            float[] fArray3 = fArray2;
            fArray2 = fArray;
            fArray = fArray3;
        }
        n8 = n;
        int n15 = 0;
        int n16 = 0;
        n7 = n2 - 1;
        for (int i = 0; i < n4; ++i) {
            n6 = this.bitrev[n15++];
            n5 = this.bitrev[n15++];
            f4 = fArray2[n6] - fArray2[n5 + 1];
            f = fArray2[n6 - 1] + fArray2[n5];
            f3 = fArray2[n6] + fArray2[n5 + 1];
            f2 = fArray2[n6 - 1] - fArray2[n5];
            float f7 = f4 * this.trig[n8];
            float f8 = f * this.trig[n8++];
            float f9 = f4 * this.trig[n8];
            float f10 = f * this.trig[n8++];
            fArray[n16++] = (f3 + f9 + f8) * 16383.0f;
            fArray[n7--] = (-f2 + f10 - f7) * 16383.0f;
            fArray[n16++] = (f2 + f10 - f7) * 16383.0f;
            fArray[n7--] = (f3 - f9 - f8) * 16383.0f;
        }
        return fArray;
    }
}

