/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.HuffmanNode;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.Arrays;

class CodeBook {
    private HuffmanNode huffmanRoot;
    private int dimensions;
    private int entries;
    private int[] entryLengths;
    private float[][] valueVector;
    private static long totalTime = 0L;

    protected CodeBook(BitInputStream bitInputStream) throws VorbisFormatException, IOException {
        int n;
        if (bitInputStream.getInt(24) != 5653314) {
            throw new VorbisFormatException("The code book sync pattern is not correct.");
        }
        this.dimensions = bitInputStream.getInt(16);
        this.entries = bitInputStream.getInt(24);
        this.entryLengths = new int[this.entries];
        boolean bl = bitInputStream.getBit();
        if (bl) {
            int n2;
            n = bitInputStream.getInt(5) + 1;
            for (var4_4 = 0; var4_4 < this.entryLengths.length; var4_4 += n2) {
                n2 = bitInputStream.getInt(Util.ilog(this.entryLengths.length - var4_4));
                if (var4_4 + n2 > this.entryLengths.length) {
                    throw new VorbisFormatException("The codebook entry length list is longer than the actual number of entry lengths.");
                }
                Arrays.fill(this.entryLengths, var4_4, var4_4 + n2, n);
                ++n;
            }
        } else {
            n = bitInputStream.getBit();
            if (n != 0) {
                for (var4_4 = 0; var4_4 < this.entryLengths.length; ++var4_4) {
                    this.entryLengths[var4_4] = bitInputStream.getBit() ? bitInputStream.getInt(5) + 1 : -1;
                }
            } else {
                for (var4_4 = 0; var4_4 < this.entryLengths.length; ++var4_4) {
                    this.entryLengths[var4_4] = bitInputStream.getInt(5) + 1;
                }
            }
        }
        if (!this.createHuffmanTree(this.entryLengths)) {
            throw new VorbisFormatException("An exception was thrown when building the codebook Huffman tree.");
        }
        n = bitInputStream.getInt(4);
        switch (n) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int n3;
                float f = Util.float32unpack(bitInputStream.getInt(32));
                float f2 = Util.float32unpack(bitInputStream.getInt(32));
                int n4 = bitInputStream.getInt(4) + 1;
                boolean bl2 = bitInputStream.getBit();
                int n5 = 0;
                n5 = n == 1 ? Util.lookup1Values(this.entries, this.dimensions) : this.entries * this.dimensions;
                int[] nArray = new int[n5];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = bitInputStream.getInt(n4);
                }
                this.valueVector = new float[this.entries][this.dimensions];
                if (n == 1) {
                    for (n3 = 0; n3 < this.entries; ++n3) {
                        float f3 = 0.0f;
                        int n6 = 1;
                        for (int i = 0; i < this.dimensions; ++i) {
                            int n7 = n3 / n6 % n5;
                            this.valueVector[n3][i] = (float)nArray[n7] * f2 + f + f3;
                            if (bl2) {
                                f3 = this.valueVector[n3][i];
                            }
                            n6 *= n5;
                        }
                    }
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new VorbisFormatException("Unsupported codebook lookup type: " + n);
            }
        }
    }

    private boolean createHuffmanTree(int[] nArray) {
        this.huffmanRoot = new HuffmanNode();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= 0 || this.huffmanRoot.setNewValue(n, i)) continue;
            return false;
        }
        return true;
    }

    protected int getDimensions() {
        return this.dimensions;
    }

    protected int getEntries() {
        return this.entries;
    }

    protected HuffmanNode getHuffmanRoot() {
        return this.huffmanRoot;
    }

    protected int readInt(BitInputStream bitInputStream) throws IOException {
        return bitInputStream.getInt(this.huffmanRoot);
    }

    protected void readVvAdd(float[][] fArray, BitInputStream bitInputStream, int n, int n2) throws VorbisFormatException, IOException {
        int n3 = 0;
        int n4 = fArray.length;
        if (n4 == 0) {
            return;
        }
        int n5 = (n + n2) / n4;
        int n6 = n / n4;
        while (n6 < n5) {
            float[] fArray2 = this.valueVector[bitInputStream.getInt(this.huffmanRoot)];
            for (int i = 0; i < this.dimensions; ++i) {
                float[] fArray3 = fArray[n3++];
                int n7 = n6++;
                fArray3[n7] = fArray3[n7] + fArray2[i];
                if (n3 != n4) continue;
                n3 = 0;
            }
        }
    }
}

