/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.Mapping;
import de.jarnbjo.vorbis.MdctFloat;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class AudioPacket {
    private int modeNumber;
    private Mode mode;
    private Mapping mapping;
    private int n;
    private boolean blockFlag;
    private boolean previousWindowFlag;
    private boolean nextWindowFlag;
    private int windowCenter;
    private int leftWindowStart;
    private int leftWindowEnd;
    private int leftN;
    private int rightWindowStart;
    private int rightWindowEnd;
    private int rightN;
    private float[] window;
    private float[][] pcm;
    private int[][] pcmInt;
    private Floor[] channelFloors;
    private boolean[] noResidues;
    private static final float[][] windows = new float[8][];

    protected AudioPacket(VorbisStream vorbisStream, BitInputStream bitInputStream) throws VorbisFormatException, IOException {
        Object object;
        int n;
        int n2;
        int n3;
        SetupHeader setupHeader = vorbisStream.getSetupHeader();
        IdentificationHeader identificationHeader = vorbisStream.getIdentificationHeader();
        Mode[] modeArray = setupHeader.getModes();
        Mapping[] mappingArray = setupHeader.getMappings();
        Residue[] residueArray = setupHeader.getResidues();
        int n4 = identificationHeader.getChannels();
        if (bitInputStream.getInt(1) != 0) {
            throw new VorbisFormatException("Packet type mismatch when trying to create an audio packet.");
        }
        this.modeNumber = bitInputStream.getInt(Util.ilog(modeArray.length - 1));
        try {
            this.mode = modeArray[this.modeNumber];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new VorbisFormatException("Reference to invalid mode in audio packet.");
        }
        this.mapping = mappingArray[this.mode.getMapping()];
        int[] nArray = this.mapping.getMagnitudes();
        int[] nArray2 = this.mapping.getAngles();
        this.blockFlag = this.mode.getBlockFlag();
        int n5 = identificationHeader.getBlockSize0();
        int n6 = identificationHeader.getBlockSize1();
        int n7 = this.n = this.blockFlag ? n6 : n5;
        if (this.blockFlag) {
            this.previousWindowFlag = bitInputStream.getBit();
            this.nextWindowFlag = bitInputStream.getBit();
        }
        this.windowCenter = this.n / 2;
        if (this.blockFlag && !this.previousWindowFlag) {
            this.leftWindowStart = this.n / 4 - n5 / 4;
            this.leftWindowEnd = this.n / 4 + n5 / 4;
            this.leftN = n5 / 2;
        } else {
            this.leftWindowStart = 0;
            this.leftWindowEnd = this.n / 2;
            this.leftN = this.windowCenter;
        }
        if (this.blockFlag && !this.nextWindowFlag) {
            this.rightWindowStart = this.n * 3 / 4 - n5 / 4;
            this.rightWindowEnd = this.n * 3 / 4 + n5 / 4;
            this.rightN = n5 / 2;
        } else {
            this.rightWindowStart = this.windowCenter;
            this.rightWindowEnd = this.n;
            this.rightN = this.n / 2;
        }
        this.window = this.getComputedWindow();
        this.channelFloors = new Floor[n4];
        this.noResidues = new boolean[n4];
        this.pcm = new float[n4][this.n];
        this.pcmInt = new int[n4][this.n];
        boolean bl = true;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.mapping.getMux()[n3];
            n = this.mapping.getSubmapFloors()[n2];
            object = setupHeader.getFloors()[n].decodeFloor(vorbisStream, bitInputStream);
            this.channelFloors[n3] = object;
            boolean bl2 = this.noResidues[n3] = object == null;
            if (object == null) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (this.noResidues[nArray[n3]] && this.noResidues[nArray2[n3]]) continue;
            this.noResidues[nArray[n3]] = false;
            this.noResidues[nArray2[n3]] = false;
        }
        Residue[] residueArray2 = new Residue[this.mapping.getSubmaps()];
        for (n2 = 0; n2 < this.mapping.getSubmaps(); ++n2) {
            int n8;
            n = 0;
            object = new boolean[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                if (this.mapping.getMux()[n8] != n2) continue;
                object[n++] = this.noResidues[n8];
            }
            n8 = this.mapping.getSubmapResidues()[n2];
            Residue residue = residueArray[n8];
            residue.decodeResidue(vorbisStream, bitInputStream, this.mode, n, (boolean[])object, this.pcm);
        }
        for (n2 = this.mapping.getCouplingSteps() - 1; n2 >= 0; --n2) {
            double d = 0.0;
            double d2 = 0.0;
            float[] fArray = this.pcm[nArray[n2]];
            float[] fArray2 = this.pcm[nArray2[n2]];
            for (int i = 0; i < fArray.length; ++i) {
                float f = fArray2[i];
                float f2 = fArray[i];
                if (f > 0.0f) {
                    fArray2[i] = f2 > 0.0f ? f2 - f : f2 + f;
                    continue;
                }
                fArray[i] = f2 > 0.0f ? f2 + f : f2 - f;
                fArray2[i] = f2;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.channelFloors[n2] == null) continue;
            this.channelFloors[n2].computeFloor(this.pcm[n2]);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            MdctFloat mdctFloat = this.blockFlag ? identificationHeader.getMdct1() : identificationHeader.getMdct0();
            mdctFloat.imdct(this.pcm[n2], this.window, this.pcmInt[n2]);
        }
    }

    private float[] getComputedWindow() {
        int n = (this.blockFlag ? 4 : 0) + (this.previousWindowFlag ? 2 : 0) + (this.nextWindowFlag ? 1 : 0);
        float[] fArray = windows[n];
        if (fArray == null) {
            float f;
            int n2;
            fArray = new float[this.n];
            for (n2 = 0; n2 < this.leftN; ++n2) {
                f = (float)(((double)n2 + 0.5) / (double)this.leftN * Math.PI / 2.0);
                f = (float)Math.sin(f);
                f *= f;
                f = (float)((double)f * 1.5707963705062866);
                fArray[n2 + this.leftWindowStart] = f = (float)Math.sin(f);
            }
            n2 = this.leftWindowEnd;
            while (n2 < this.rightWindowStart) {
                fArray[n2++] = 1.0f;
            }
            for (n2 = 0; n2 < this.rightN; ++n2) {
                f = (float)(((double)(this.rightN - n2) - 0.5) / (double)this.rightN * Math.PI / 2.0);
                f = (float)Math.sin(f);
                f *= f;
                f = (float)((double)f * 1.5707963705062866);
                fArray[n2 + this.rightWindowStart] = f = (float)Math.sin(f);
            }
            AudioPacket.windows[n] = fArray;
        }
        return fArray;
    }

    protected int getNumberOfSamples() {
        return this.rightWindowStart - this.leftWindowStart;
    }

    protected int getPcm(AudioPacket audioPacket, int[][] nArray) {
        int n;
        int n2 = this.pcm.length;
        for (n = 0; n < n2; ++n) {
            int n3 = 0;
            int n4 = audioPacket.rightWindowStart;
            int[] nArray2 = audioPacket.pcmInt[n];
            int[] nArray3 = this.pcmInt[n];
            int[] nArray4 = nArray[n];
            for (int i = this.leftWindowStart; i < this.leftWindowEnd; ++i) {
                int n5;
                if ((n5 = nArray2[n4++] + nArray3[i]) > Short.MAX_VALUE) {
                    n5 = Short.MAX_VALUE;
                }
                if (n5 < Short.MIN_VALUE) {
                    n5 = Short.MIN_VALUE;
                }
                nArray4[n3++] = n5;
            }
        }
        if (this.leftWindowEnd + 1 < this.rightWindowStart) {
            for (n = 0; n < n2; ++n) {
                System.arraycopy(this.pcmInt[n], this.leftWindowEnd, nArray[n], this.leftWindowEnd - this.leftWindowStart, this.rightWindowStart - this.leftWindowEnd);
            }
        }
        return this.rightWindowStart - this.leftWindowStart;
    }

    protected void getPcm(AudioPacket audioPacket, byte[] byArray) {
        int n = this.pcm.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = audioPacket.rightWindowStart;
            int[] nArray = audioPacket.pcmInt[i];
            int[] nArray2 = this.pcmInt[i];
            for (n3 = this.leftWindowStart; n3 < this.leftWindowEnd; ++n3) {
                if ((n2 = nArray[n5++] + nArray2[n3]) > Short.MAX_VALUE) {
                    n2 = Short.MAX_VALUE;
                }
                if (n2 < Short.MIN_VALUE) {
                    n2 = Short.MIN_VALUE;
                }
                byArray[n4 + i * 2 + 1] = (byte)(n2 & 0xFF);
                byArray[n4 + i * 2] = (byte)(n2 >> 8 & 0xFF);
                n4 += n * 2;
            }
            n4 = (this.leftWindowEnd - this.leftWindowStart) * n * 2;
            for (n3 = this.leftWindowEnd; n3 < this.rightWindowStart; ++n3) {
                n2 = nArray2[n3];
                if (n2 > Short.MAX_VALUE) {
                    n2 = Short.MAX_VALUE;
                }
                if (n2 < Short.MIN_VALUE) {
                    n2 = Short.MIN_VALUE;
                }
                byArray[n4 + i * 2 + 1] = (byte)(n2 & 0xFF);
                byArray[n4 + i * 2] = (byte)(n2 >> 8 & 0xFF);
                n4 += n * 2;
            }
        }
    }

    protected float[] getWindow() {
        return this.window;
    }

    protected int getLeftWindowStart() {
        return this.leftWindowStart;
    }

    protected int getLeftWindowEnd() {
        return this.leftWindowEnd;
    }

    protected int getRightWindowStart() {
        return this.rightWindowStart;
    }

    protected int getRightWindowEnd() {
        return this.rightWindowEnd;
    }

    public int[][] getPcm() {
        return this.pcmInt;
    }

    public float[][] getFreqencyDomain() {
        return this.pcm;
    }
}

