/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class FileStream
implements PhysicalOggStream {
    private boolean closed = false;
    private RandomAccessFile source;
    private long[] pageOffsets;
    private long numberOfSamples = -1L;
    private HashMap logicalStreams = new HashMap();

    public FileStream(RandomAccessFile randomAccessFile) throws OggFormatException, IOException {
        Object object;
        this.source = randomAccessFile;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        try {
            while (true) {
                arrayList.add(new Long(this.source.getFilePointer()));
                OggPage oggPage = this.getNextPage(n > 0);
                if (oggPage != null) {
                    object = (LogicalOggStreamImpl)this.getLogicalStream(oggPage.getStreamSerialNumber());
                    if (object == null) {
                        object = new LogicalOggStreamImpl(this, oggPage.getStreamSerialNumber());
                        this.logicalStreams.put(new Integer(oggPage.getStreamSerialNumber()), object);
                    }
                    if (n == 0) {
                        ((LogicalOggStreamImpl)object).checkFormat(oggPage);
                    }
                    ((LogicalOggStreamImpl)object).addPageNumberMapping(n);
                    ((LogicalOggStreamImpl)object).addGranulePosition(oggPage.getAbsoluteGranulePosition());
                    if (n > 0) {
                        this.source.seek(this.source.getFilePointer() + (long)oggPage.getTotalLength());
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (EndOfOggStreamException endOfOggStreamException) {
        }
        catch (IOException iOException) {
            throw iOException;
        }
        this.source.seek(0L);
        this.pageOffsets = new long[arrayList.size()];
        int n2 = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.pageOffsets[n2++] = (Long)object.next();
        }
    }

    @Override
    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.source.close();
    }

    private OggPage getNextPage() throws EndOfOggStreamException, IOException, OggFormatException {
        return this.getNextPage(false);
    }

    private OggPage getNextPage(boolean bl) throws EndOfOggStreamException, IOException, OggFormatException {
        return OggPage.create(this.source, bl);
    }

    @Override
    public OggPage getOggPage(int n) throws IOException {
        this.source.seek(this.pageOffsets[n]);
        return OggPage.create(this.source);
    }

    private LogicalOggStream getLogicalStream(int n) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(n));
    }

    @Override
    public void setTime(long l) throws IOException {
        for (LogicalOggStream logicalOggStream : this.logicalStreams.values()) {
            logicalOggStream.setTime(l);
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }
}

