/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.BasicPixelProcessor;
import com.sixlegs.png.Destination;

final class TransGammaPixelProcessor
extends BasicPixelProcessor {
    private final short[] gammaTable;
    private final int[] trans;
    private final int shift;
    private final int max;
    private final int samplesNoAlpha;
    private final int[] temp;

    public TransGammaPixelProcessor(Destination destination, short[] sArray, int[] nArray, int n) {
        super(destination, destination.getRaster().getNumBands());
        this.gammaTable = sArray;
        this.trans = nArray;
        this.shift = n;
        this.max = sArray.length - 1;
        this.samplesNoAlpha = this.samples - 1;
        this.temp = new int[this.samples * destination.getSourceWidth()];
    }

    @Override
    public boolean process(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 * this.samplesNoAlpha;
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            boolean bl = false;
            for (int i = 0; i < this.samplesNoAlpha; ++i) {
                int n9 = nArray[n7 + i];
                bl = bl || n9 != this.trans[i];
                this.temp[n8 + i] = 0xFFFF & this.gammaTable[n9 >> this.shift];
            }
            this.temp[n8 + this.samplesNoAlpha] = bl ? this.max : 0;
            n7 += this.samplesNoAlpha;
            n8 += this.samples;
        }
        return super.process(this.temp, n, n2, n3, n4, n5);
    }
}

