/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.SuggestedPalette;

class SuggestedPaletteImpl
implements SuggestedPalette {
    private final String name;
    private final int sampleDepth;
    private final byte[] bytes;
    private final int entrySize;
    private final int sampleCount;

    public SuggestedPaletteImpl(String string, int n, byte[] byArray) {
        this.name = string;
        this.sampleDepth = n;
        this.bytes = byArray;
        this.entrySize = n == 8 ? 6 : 10;
        this.sampleCount = byArray.length / this.entrySize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public int getSampleDepth() {
        return this.sampleDepth;
    }

    @Override
    public void getSample(int n, short[] sArray) {
        int n2 = n * this.entrySize;
        if (this.sampleDepth == 8) {
            for (int i = 0; i < 4; ++i) {
                int n3 = 0xFF & this.bytes[n2++];
                sArray[i] = (short)n3;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                int n4 = 0xFF & this.bytes[n2++];
                int n5 = 0xFF & this.bytes[n2++];
                sArray[i] = (short)(n4 << 8 | n5);
            }
        }
    }

    @Override
    public int getFrequency(int n) {
        int n2 = (n + 1) * this.entrySize - 2;
        int n3 = 0xFF & this.bytes[n2];
        int n4 = 0xFF & this.bytes[n2 + 1];
        return n3 << 8 | n4;
    }
}

