/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.RasterDestination;
import java.awt.image.WritableRaster;

final class SubsamplingDestination
extends RasterDestination {
    private final int xsub;
    private final int ysub;
    private final int xoff;
    private final int yoff;
    private final int[] singlePixel;

    public SubsamplingDestination(WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5) {
        super(writableRaster, n);
        this.xsub = n2;
        this.ysub = n3;
        this.xoff = n4;
        this.yoff = n5;
        this.singlePixel = new int[writableRaster.getNumBands()];
    }

    @Override
    public void setPixels(int n, int n2, int n3, int[] nArray) {
        if ((n2 - this.yoff) % this.ysub == 0) {
            int n4 = (n - this.xoff) / this.xsub;
            int n5 = (n2 - this.yoff) / this.ysub;
            int n6 = n4 * this.xsub + this.xoff;
            if (n6 < n) {
                ++n4;
                n6 += this.xsub;
            }
            int n7 = this.raster.getNumBands();
            int n8 = n + n3;
            for (int i = n6 - n; i < n8; i += this.xsub) {
                System.arraycopy(nArray, i * n7, this.singlePixel, 0, n7);
                super.setPixel(n4++, n5, this.singlePixel);
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray) {
        if ((n -= this.xoff) % this.xsub == 0 && (n2 -= this.yoff) % this.ysub == 0) {
            super.setPixel(n / this.xsub, n2 / this.ysub, nArray);
        }
    }

    @Override
    public void getPixel(int n, int n2, int[] nArray) {
        throw new UnsupportedOperationException();
    }
}

