/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import com.sixlegs.png.PngImage;

class StateMachine {
    public static final int STATE_START = 0;
    public static final int STATE_SAW_IHDR = 1;
    public static final int STATE_SAW_IHDR_NO_PLTE = 2;
    public static final int STATE_SAW_PLTE = 3;
    public static final int STATE_IN_IDAT = 4;
    public static final int STATE_AFTER_IDAT = 5;
    public static final int STATE_END = 6;
    private PngImage png;
    private int state = 0;
    private int type;

    public StateMachine(PngImage pngImage) {
        this.png = pngImage;
    }

    public int getState() {
        return this.state;
    }

    public int getType() {
        return this.type;
    }

    public void nextState(int n) throws PngException {
        this.type = n;
        this.state = StateMachine.nextState(this.png, this.state, this.type);
    }

    private static int nextState(PngImage pngImage, int n, int n2) throws PngException {
        for (int i = 0; i < 4; ++i) {
            int n3 = 0xFF & n2 >>> 8 * i;
            if (n3 >= 65 && (n3 <= 90 || n3 >= 97) && n3 <= 122) continue;
            throw new PngException("Corrupted chunk type: 0x" + Integer.toHexString(n2), true);
        }
        if (PngConstants.isPrivate(n2) && !PngConstants.isAncillary(n2)) {
            throw new PngException("Private critical chunk encountered: " + PngConstants.getChunkName(n2), true);
        }
        switch (n) {
            case 0: {
                if (n2 == 1229472850) {
                    return 1;
                }
                throw new PngException("IHDR chunk must be first chunk", true);
            }
            case 1: 
            case 2: {
                switch (n2) {
                    case 1347179589: {
                        return 3;
                    }
                    case 1229209940: {
                        StateMachine.errorIfPaletted(pngImage);
                        return 4;
                    }
                    case 1649100612: {
                        return 2;
                    }
                    case 1951551059: {
                        StateMachine.errorIfPaletted(pngImage);
                        return 2;
                    }
                    case 1749635924: {
                        throw new PngException("PLTE must precede hIST", true);
                    }
                }
                return n;
            }
            case 3: {
                switch (n2) {
                    case 1665684045: 
                    case 1732332865: 
                    case 1766015824: 
                    case 1933723988: 
                    case 1934772034: {
                        throw new PngException(PngConstants.getChunkName(n2) + " cannot appear after PLTE", true);
                    }
                    case 1229209940: {
                        return 4;
                    }
                    case 1229278788: {
                        throw new PngException("Required data chunk(s) not found", true);
                    }
                }
                return 3;
            }
        }
        switch (n2) {
            case 1347179589: 
            case 1649100612: 
            case 1665684045: 
            case 1732332865: 
            case 1749635924: 
            case 1766015824: 
            case 1866876531: 
            case 1883455820: 
            case 1883789683: 
            case 1933723988: 
            case 1933787468: 
            case 1934642260: 
            case 1934772034: 
            case 1934902610: 
            case 1951551059: {
                throw new PngException(PngConstants.getChunkName(n2) + " cannot appear after IDAT", true);
            }
            case 1229278788: {
                return 6;
            }
            case 1229209940: {
                if (n == 4) {
                    return 4;
                }
                throw new PngException("IDAT chunks must be consecutive", true);
            }
        }
        return 5;
    }

    private static void errorIfPaletted(PngImage pngImage) throws PngException {
        if (pngImage.getColorType() == 3) {
            throw new PngException("Required PLTE chunk not found", true);
        }
    }
}

