/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;

final class SourceRegionDestination
extends Destination {
    private final Destination dst;
    private final int xoff;
    private final int yoff;
    private final int xlen;
    private final int ylen;
    private final int samples;

    public SourceRegionDestination(Destination destination, Rectangle rectangle) {
        this.dst = destination;
        this.xoff = rectangle.x;
        this.yoff = rectangle.y;
        this.xlen = rectangle.width;
        this.ylen = rectangle.height;
        this.samples = destination.getRaster().getNumBands();
    }

    @Override
    public void setPixels(int n, int n2, int n3, int[] nArray) {
        if (n2 >= this.yoff && n2 < this.yoff + this.ylen) {
            int n4 = Math.max(n, this.xoff);
            int n5 = Math.min(n + n3, this.xoff + this.xlen) - n4;
            if (n5 > 0) {
                if (n4 > n) {
                    System.arraycopy(nArray, n4 * this.samples, nArray, 0, n5 * this.samples);
                }
                this.dst.setPixels(n4 - this.xoff, n2 - this.yoff, n5, nArray);
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray) {
        if ((n -= this.xoff) >= 0 && (n2 -= this.yoff) >= 0 && n < this.xlen && n2 < this.ylen) {
            this.dst.setPixel(n, n2, nArray);
        }
    }

    @Override
    public void getPixel(int n, int n2, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WritableRaster getRaster() {
        return this.dst.getRaster();
    }

    @Override
    public int getSourceWidth() {
        return this.dst.getSourceWidth();
    }

    @Override
    public void done() {
        this.dst.done();
    }
}

