/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Integers;
import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import com.sixlegs.png.PngImage;
import com.sixlegs.png.SuggestedPalette;
import com.sixlegs.png.SuggestedPaletteImpl;
import com.sixlegs.png.TextChunkImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class RegisteredChunks {
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String US_ASCII = "US-ASCII";
    private static final String UTF_8 = "UTF-8";

    RegisteredChunks() {
    }

    public static boolean read(int n, DataInput dataInput, int n2, PngImage pngImage) throws IOException {
        Map map = pngImage.getProperties();
        switch (n) {
            case 1229472850: {
                RegisteredChunks.read_IHDR(dataInput, n2, map);
                break;
            }
            case 1229278788: {
                RegisteredChunks.checkLength(1229278788, n2, 0);
                break;
            }
            case 1347179589: {
                RegisteredChunks.read_PLTE(dataInput, n2, map, pngImage);
                break;
            }
            case 1649100612: {
                RegisteredChunks.read_bKGD(dataInput, n2, map, pngImage);
                break;
            }
            case 1951551059: {
                RegisteredChunks.read_tRNS(dataInput, n2, map, pngImage);
                break;
            }
            case 1933723988: {
                RegisteredChunks.read_sBIT(dataInput, n2, map, pngImage);
                break;
            }
            case 1749635924: {
                RegisteredChunks.read_hIST(dataInput, n2, map, pngImage);
                break;
            }
            case 1934642260: {
                RegisteredChunks.read_sPLT(dataInput, n2, map, pngImage);
                break;
            }
            case 1665684045: {
                RegisteredChunks.read_cHRM(dataInput, n2, map);
                break;
            }
            case 1732332865: {
                RegisteredChunks.read_gAMA(dataInput, n2, map);
                break;
            }
            case 1766015824: {
                RegisteredChunks.read_iCCP(dataInput, n2, map);
                break;
            }
            case 1883789683: {
                RegisteredChunks.read_pHYs(dataInput, n2, map);
                break;
            }
            case 1934772034: {
                RegisteredChunks.read_sRGB(dataInput, n2, map);
                break;
            }
            case 1950960965: {
                RegisteredChunks.read_tIME(dataInput, n2, map);
                break;
            }
            case 1732855399: {
                RegisteredChunks.read_gIFg(dataInput, n2, map);
                break;
            }
            case 1866876531: {
                RegisteredChunks.read_oFFs(dataInput, n2, map);
                break;
            }
            case 1933787468: {
                RegisteredChunks.read_sCAL(dataInput, n2, map);
                break;
            }
            case 1934902610: {
                RegisteredChunks.read_sTER(dataInput, n2, map);
                break;
            }
            case 1767135348: 
            case 1950701684: 
            case 2052348020: {
                RegisteredChunks.readText(n, dataInput, n2, map, pngImage);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void read_IHDR(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1229472850, n, 13);
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        if (n2 <= 0 || n3 <= 0) {
            throw new PngException("Bad image size: " + n2 + "x" + n3, true);
        }
        byte by = dataInput.readByte();
        switch (by) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                throw new PngException("Bad bit depth: " + by, true);
            }
        }
        Object var6_6 = null;
        int n4 = dataInput.readUnsignedByte();
        switch (n4) {
            case 0: 
            case 2: {
                break;
            }
            case 3: {
                if (by != 16) break;
                throw new PngException("Bad bit depth for color type " + n4 + ": " + by, true);
            }
            case 4: 
            case 6: {
                if (by > 4) break;
                throw new PngException("Bad bit depth for color type " + n4 + ": " + by, true);
            }
            default: {
                throw new PngException("Bad color type: " + n4, true);
            }
        }
        int n5 = dataInput.readUnsignedByte();
        if (n5 != 0) {
            throw new PngException("Unrecognized compression method: " + n5, true);
        }
        int n6 = dataInput.readUnsignedByte();
        if (n6 != 0) {
            throw new PngException("Unrecognized filter method: " + n6, true);
        }
        int n7 = dataInput.readUnsignedByte();
        switch (n7) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new PngException("Unrecognized interlace method: " + n7, true);
            }
        }
        map.put("width", Integers.valueOf(n2));
        map.put("height", Integers.valueOf(n3));
        map.put("bit_depth", Integers.valueOf(by));
        map.put("interlace", Integers.valueOf(n7));
        map.put("compression", Integers.valueOf(n5));
        map.put("filter", Integers.valueOf(n6));
        map.put("color_type", Integers.valueOf(n4));
    }

    private static void read_PLTE(DataInput dataInput, int n, Map map, PngImage pngImage) throws IOException {
        if (n == 0) {
            throw new PngException("PLTE chunk cannot be empty", true);
        }
        if (n % 3 != 0) {
            throw new PngException("PLTE chunk length indivisible by 3: " + n, true);
        }
        int n2 = n / 3;
        if (n2 > 256) {
            throw new PngException("Too many palette entries: " + n2, true);
        }
        switch (pngImage.getColorType()) {
            case 3: {
                if (n2 <= 2 << pngImage.getBitDepth() - 1) break;
                throw new PngException("Too many palette entries: " + n2, true);
            }
            case 0: 
            case 4: {
                throw new PngException("PLTE chunk found in grayscale image", false);
            }
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        map.put("palette", byArray);
    }

    private static void read_tRNS(DataInput dataInput, int n, Map map, PngImage pngImage) throws IOException {
        switch (pngImage.getColorType()) {
            case 0: {
                RegisteredChunks.checkLength(1951551059, n, 2);
                map.put("transparency", new int[]{dataInput.readUnsignedShort()});
                break;
            }
            case 2: {
                RegisteredChunks.checkLength(1951551059, n, 6);
                map.put("transparency", new int[]{dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort()});
                break;
            }
            case 3: {
                int n2 = ((byte[])pngImage.getProperty("palette", byte[].class, true)).length / 3;
                if (n > n2) {
                    throw new PngException("Too many transparency palette entries (" + n + " > " + n2 + ")", true);
                }
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                map.put("palette_alpha", byArray);
                break;
            }
            default: {
                throw new PngException("tRNS prohibited for color type " + pngImage.getColorType(), true);
            }
        }
    }

    private static void read_bKGD(DataInput dataInput, int n, Map map, PngImage pngImage) throws IOException {
        map.put("background_rgb", switch (pngImage.getColorType()) {
            case 3 -> {
                RegisteredChunks.checkLength(1649100612, n, 1);
                yield new int[]{dataInput.readUnsignedByte()};
            }
            case 0, 4 -> {
                RegisteredChunks.checkLength(1649100612, n, 2);
                yield new int[]{dataInput.readUnsignedShort()};
            }
            default -> {
                RegisteredChunks.checkLength(1649100612, n, 6);
                yield new int[]{dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort()};
            }
        });
    }

    private static void read_cHRM(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1665684045, n, 32);
        float[] fArray = new float[8];
        for (int i = 0; i < 8; ++i) {
            fArray[i] = (float)dataInput.readInt() / 100000.0f;
        }
        if (!map.containsKey("chromaticity")) {
            map.put("chromaticity", fArray);
        }
    }

    private static void read_gAMA(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1732332865, n, 4);
        int n2 = dataInput.readInt();
        if (n2 == 0) {
            throw new PngException("Meaningless zero gAMA chunk value", false);
        }
        if (!map.containsKey("rendering_intent")) {
            map.put("gamma", new Float((float)n2 / 100000.0f));
        }
    }

    private static void read_hIST(DataInput dataInput, int n, Map map, PngImage pngImage) throws IOException {
        int n2 = ((byte[])pngImage.getProperty("palette", byte[].class, true)).length / 3;
        RegisteredChunks.checkLength(1749635924, n, n2 * 2);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInput.readUnsignedShort();
        }
        map.put("histogram", nArray);
    }

    private static void read_iCCP(DataInput dataInput, int n, Map map) throws IOException {
        String string = RegisteredChunks.readKeyword(dataInput, n);
        byte[] byArray = RegisteredChunks.readCompressed(dataInput, n - string.length() - 1, true);
        map.put("icc_profile_name", string);
        map.put("icc_profile", byArray);
    }

    private static void read_pHYs(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1883789683, n, 9);
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int n4 = dataInput.readUnsignedByte();
        if (n4 != 0 && n4 != 1) {
            throw new PngException("Illegal pHYs chunk unit specifier: " + n4, false);
        }
        map.put("pixels_per_unit_x", Integers.valueOf(n2));
        map.put("pixels_per_unit_y", Integers.valueOf(n3));
        map.put("unit", Integers.valueOf(n4));
    }

    private static void read_sBIT(DataInput dataInput, int n, Map map, PngImage pngImage) throws IOException {
        boolean bl = pngImage.getColorType() == 3;
        int n2 = bl ? 3 : pngImage.getSamples();
        RegisteredChunks.checkLength(1933723988, n, n2);
        int n3 = bl ? 8 : pngImage.getBitDepth();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            int n4 = dataInput.readByte();
            if (n4 <= 0 || n4 > n3) {
                throw new PngException("Illegal sBIT sample depth", false);
            }
            byArray[i] = n4;
        }
        map.put("significant_bits", byArray);
    }

    private static void read_sRGB(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1934772034, n, 1);
        byte by = dataInput.readByte();
        map.put("rendering_intent", Integers.valueOf(by));
        map.put("gamma", new Float(0.45455));
        map.put("chromaticity", new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f});
    }

    private static void read_tIME(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1950960965, n, 7);
        Calendar calendar = Calendar.getInstance(TIME_ZONE);
        calendar.set(dataInput.readUnsignedShort(), RegisteredChunks.check(dataInput.readUnsignedByte(), 1, 12, "month") - 1, RegisteredChunks.check(dataInput.readUnsignedByte(), 1, 31, "day"), RegisteredChunks.check(dataInput.readUnsignedByte(), 0, 23, "hour"), RegisteredChunks.check(dataInput.readUnsignedByte(), 0, 59, "minute"), RegisteredChunks.check(dataInput.readUnsignedByte(), 0, 60, "second"));
        map.put("time", calendar.getTime());
    }

    private static int check(int n, int n2, int n3, String string) throws PngException {
        if (n < n2 || n > n3) {
            throw new PngException("tIME " + string + " value " + n + " is out of bounds (" + n2 + "-" + n3 + ")", false);
        }
        return n;
    }

    private static void read_sPLT(DataInput dataInput, int n, Map map, PngImage pngImage) throws IOException {
        String string = RegisteredChunks.readKeyword(dataInput, n);
        byte by = dataInput.readByte();
        if (by != 8 && by != 16) {
            throw new PngException("Sample depth must be 8 or 16", false);
        }
        if ((n -= string.length() + 2) % (by == 8 ? 6 : 10) != 0) {
            throw new PngException("Incorrect sPLT data length for given sample depth", false);
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        ArrayList<SuggestedPaletteImpl> arrayList = (ArrayList<SuggestedPaletteImpl>)pngImage.getProperty("suggested_palettes", List.class, false);
        if (arrayList == null) {
            arrayList = new ArrayList<SuggestedPaletteImpl>();
            map.put("suggested_palettes", arrayList);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!string.equals(((SuggestedPalette)iterator.next()).getName())) continue;
            throw new PngException("Duplicate suggested palette name " + string, false);
        }
        arrayList.add(new SuggestedPaletteImpl(string, by, byArray));
    }

    private static void readText(int n, DataInput dataInput, int n2, Map map, PngImage pngImage) throws IOException {
        byte[] byArray = new byte[n2];
        dataInput.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = RegisteredChunks.readKeyword(dataInputStream, n2);
        String string2 = ISO_8859_1;
        boolean bl = false;
        boolean bl2 = true;
        String string3 = null;
        String string4 = null;
        switch (n) {
            case 1950701684: {
                break;
            }
            case 2052348020: {
                bl = true;
                break;
            }
            case 1767135348: {
                string2 = UTF_8;
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                if (by == 1) {
                    bl = true;
                    bl2 = false;
                    if (by2 != 0) {
                        throw new PngException("Unrecognized " + PngConstants.getChunkName(n) + " compression method: " + by2, false);
                    }
                } else if (by != 0) {
                    throw new PngException("Illegal " + PngConstants.getChunkName(n) + " compression flag: " + by, false);
                }
                string3 = RegisteredChunks.readString(dataInputStream, dataInputStream.available(), US_ASCII);
                string4 = RegisteredChunks.readString(dataInputStream, dataInputStream.available(), UTF_8);
            }
        }
        String string5 = bl ? new String(RegisteredChunks.readCompressed(dataInputStream, dataInputStream.available(), bl2), string2) : new String(byArray, byArray.length - dataInputStream.available(), dataInputStream.available(), string2);
        if (string5.indexOf(0) >= 0) {
            throw new PngException("Text value contains null", false);
        }
        ArrayList<TextChunkImpl> arrayList = (ArrayList<TextChunkImpl>)pngImage.getProperty("text_chunks", List.class, false);
        if (arrayList == null) {
            arrayList = new ArrayList<TextChunkImpl>();
            map.put("text_chunks", arrayList);
        }
        arrayList.add(new TextChunkImpl(string, string5, string3, string4, n));
    }

    private static void read_gIFg(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1732855399, n, 4);
        int n2 = dataInput.readUnsignedByte();
        int n3 = dataInput.readUnsignedByte();
        int n4 = dataInput.readUnsignedShort();
        map.put("gif_disposal_method", Integers.valueOf(n2));
        map.put("gif_user_input_flag", Integers.valueOf(n3));
        map.put("gif_delay_time", Integers.valueOf(n4));
    }

    private static void read_oFFs(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1866876531, n, 9);
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        byte by = dataInput.readByte();
        if (by != 0 && by != 1) {
            throw new PngException("Illegal oFFs chunk unit specifier: " + by, false);
        }
        map.put("position_x", Integers.valueOf(n2));
        map.put("position_y", Integers.valueOf(n3));
        map.put("position_unit", Integers.valueOf(by));
    }

    private static void read_sCAL(DataInput dataInput, int n, Map map) throws IOException {
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        byte by = dataInputStream.readByte();
        if (by != 1 && by != 2) {
            throw new PngException("Illegal sCAL chunk unit specifier: " + by, false);
        }
        double d = RegisteredChunks.readFloatingPoint(dataInputStream, dataInputStream.available());
        double d2 = RegisteredChunks.readFloatingPoint(dataInputStream, dataInputStream.available());
        if (d <= 0.0 || d2 <= 0.0) {
            throw new PngException("sCAL measurements must be >= 0", false);
        }
        map.put("scale_unit", Integers.valueOf(by));
        map.put("pixel_width", new Double(d));
        map.put("pixel_height", new Double(d2));
    }

    private static void read_sTER(DataInput dataInput, int n, Map map) throws IOException {
        RegisteredChunks.checkLength(1934902610, n, 1);
        byte by = dataInput.readByte();
        switch (by) {
            case 0: 
            case 1: {
                map.put("stereo_mode", Integers.valueOf(by));
                break;
            }
            default: {
                throw new PngException("Unknown sTER mode: " + by, false);
            }
        }
    }

    public static void checkLength(int n, int n2, int n3) throws PngException {
        if (n2 != n3) {
            throw new PngException("Bad " + PngConstants.getChunkName(n) + " chunk length: " + n2 + " (expected " + n3 + ")", true);
        }
    }

    private static byte[] readCompressed(DataInput dataInput, int n, boolean bl) throws IOException {
        if (bl) {
            byte by = dataInput.readByte();
            if (by != 0) {
                throw new PngException("Unrecognized compression method: " + by, false);
            }
            --n;
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        byte[] byArray2 = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Inflater inflater = new Inflater();
        inflater.reset();
        inflater.setInput(byArray, 0, n);
        try {
            while (!inflater.needsInput()) {
                byteArrayOutputStream.write(byArray2, 0, inflater.inflate(byArray2));
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new PngException("Error reading compressed data", dataFormatException, false);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String readString(DataInput dataInput, int n, String string) throws IOException {
        return new String(RegisteredChunks.readToNull(dataInput, n), string);
    }

    private static String readKeyword(DataInput dataInput, int n) throws IOException {
        String string = RegisteredChunks.readString(dataInput, n, ISO_8859_1);
        if (string.length() == 0 || string.length() > 79) {
            throw new PngException("Invalid keyword length: " + string.length(), false);
        }
        return string;
    }

    private static byte[] readToNull(DataInput dataInput, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readUnsignedByte();
            if (n2 == 0) {
                return byteArrayOutputStream.toByteArray();
            }
            byteArrayOutputStream.write(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static double readFloatingPoint(DataInput dataInput, int n) throws IOException {
        String string;
        int n2 = Math.max((string = RegisteredChunks.readString(dataInput, n, US_ASCII)).indexOf(101), string.indexOf(69));
        double d = Double.valueOf(string.substring(0, n2 < 0 ? string.length() : n2));
        if (n2 >= 0) {
            d *= Math.pow(10.0, Double.valueOf(string.substring(n2 + 1)));
        }
        return d;
    }
}

