/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import com.sixlegs.png.PixelProcessor;

final class ProgressivePixelProcessor
extends PixelProcessor {
    private final PixelProcessor pp;
    private final int imgWidth;
    private final int imgHeight;
    private final Destination dst;
    private final int samples;
    private final int[] pixels;

    public ProgressivePixelProcessor(Destination destination, PixelProcessor pixelProcessor, int n, int n2) {
        this.pp = pixelProcessor;
        this.imgWidth = n;
        this.imgHeight = n2;
        this.dst = destination;
        this.samples = destination.getRaster().getNumBands();
        this.pixels = new int[this.samples * 8];
    }

    @Override
    public boolean process(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        this.pp.process(nArray, n, n2, n3, n4, n5);
        int n6 = n2;
        int n7 = n2 - n;
        if (n7 > 1 || n6 > 1) {
            int n8 = Math.min(n4 + n6, this.imgHeight);
            int n9 = n;
            for (int i = 0; i < n5; ++i) {
                int n10;
                this.dst.getPixel(n9, n4, this.pixels);
                int n11 = Math.min(n9 + n7, this.imgWidth);
                int n12 = n11 - n9;
                int n13 = n12 * this.samples;
                for (n10 = this.samples; n10 < n13; ++n10) {
                    this.pixels[n10] = this.pixels[n10 - this.samples];
                }
                for (n10 = n4; n10 < n8; ++n10) {
                    this.dst.setPixels(n9, n10, n12, this.pixels);
                }
                n9 += n2;
            }
        }
        return true;
    }
}

