/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PixelProcessor;
import com.sixlegs.png.PngImage;
import java.awt.image.BufferedImage;

final class ProgressUpdater
extends PixelProcessor {
    private static final int STEP_PERCENT = 5;
    private final PngImage png;
    private final BufferedImage image;
    private final PixelProcessor pp;
    private final int total;
    private final int step;
    private int count;
    private int mod;

    public ProgressUpdater(PngImage pngImage, BufferedImage bufferedImage, PixelProcessor pixelProcessor) {
        this.png = pngImage;
        this.image = bufferedImage;
        this.pp = pixelProcessor;
        this.total = pngImage.getWidth() * pngImage.getHeight();
        this.step = Math.max(1, this.total * 5 / 100);
    }

    @Override
    public boolean process(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.pp.process(nArray, n, n2, n3, n4, n5);
        this.mod += n5;
        this.count += n5;
        if (this.mod > this.step) {
            this.mod %= this.step;
            bl = bl && this.png.handleProgress(this.image, 100.0f * (float)this.count / (float)this.total);
        }
        return bl;
    }
}

