/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

final class PngInputStream
extends InputStream
implements DataInput {
    private final CRC32 crc = new CRC32();
    private final InputStream in;
    private final DataInputStream data;
    private final byte[] tmp = new byte[4096];
    private long total;
    private int length;
    private int left;

    public PngInputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.data = new DataInputStream(this);
        this.left = 8;
        long l = this.readLong();
        if (l != -8552249625308161526L) {
            throw new PngException("Improper signature, expected 0x" + Long.toHexString(-8552249625308161526L) + ", got 0x" + Long.toHexString(l), true);
        }
        this.total += 8L;
    }

    public int startChunk() throws IOException {
        this.left = 8;
        this.length = this.readInt();
        if (this.length < 0) {
            throw new PngException("Bad chunk length: " + (0xFFFFFFFFL & (long)this.length), true);
        }
        this.crc.reset();
        int n = this.readInt();
        this.left = this.length;
        this.total += 8L;
        return n;
    }

    public int endChunk(int n) throws IOException {
        int n2;
        if (this.getRemaining() != 0) {
            throw new PngException(PngConstants.getChunkName(n) + " read " + (this.length - this.left) + " bytes, expected " + this.length, true);
        }
        this.left = 4;
        int n3 = (int)this.crc.getValue();
        if (n3 != (n2 = this.readInt())) {
            throw new PngException("Bad CRC value for " + PngConstants.getChunkName(n) + " chunk", true);
        }
        this.total += (long)(this.length + 4);
        return n3;
    }

    @Override
    public int read() throws IOException {
        if (this.left == 0) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            this.crc.update(n);
            --this.left;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.left == 0) {
            return -1;
        }
        int n3 = this.in.read(byArray, n, Math.min(this.left, n2));
        if (n3 != -1) {
            this.crc.update(byArray, n, n3);
            this.left -= n3;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        int n = this.read(this.tmp, 0, (int)Math.min((long)this.tmp.length, l));
        return n < 0 ? 0L : (long)n;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("do not close me");
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    @Override
    public long readLong() throws IOException {
        return (0xFFFFFFFFL & (long)this.readInt()) << 32 | 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.data.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.data.readFully(byArray, n, n2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.data.skipBytes(n);
    }

    @Override
    public String readLine() throws IOException {
        return this.data.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.data.readUTF();
    }

    public int getRemaining() {
        return this.left;
    }

    public long getOffset() {
        return this.total;
    }
}

