/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import java.awt.Rectangle;

public final class PngConfig {
    public static final int READ_ALL = 0;
    public static final int READ_HEADER = 1;
    public static final int READ_UNTIL_DATA = 2;
    public static final int READ_EXCEPT_DATA = 3;
    public static final int READ_EXCEPT_METADATA = 4;
    final int readLimit;
    final float defaultGamma;
    final float displayExponent;
    final boolean warningsFatal;
    final boolean progressive;
    final boolean reduce16;
    final boolean gammaCorrect;
    final Rectangle sourceRegion;
    final int[] subsampling;
    final boolean convertIndexed;

    PngConfig(Builder builder) {
        boolean bl;
        this.readLimit = builder.readLimit;
        this.defaultGamma = builder.defaultGamma;
        this.displayExponent = builder.displayExponent;
        this.warningsFatal = builder.warningsFatal;
        this.progressive = builder.progressive;
        this.reduce16 = builder.reduce16;
        this.gammaCorrect = builder.gammaCorrect;
        this.sourceRegion = builder.sourceRegion;
        this.subsampling = builder.subsampling;
        this.convertIndexed = builder.convertIndexed;
        boolean bl2 = bl = this.getSourceXSubsampling() != 1 || this.getSourceYSubsampling() != 1;
        if (this.progressive && (bl || this.getSourceRegion() != null)) {
            throw new IllegalStateException("Progressive rendering cannot be used with source regions or subsampling");
        }
    }

    public boolean getConvertIndexed() {
        return this.convertIndexed;
    }

    public boolean getReduce16() {
        return this.reduce16;
    }

    public float getDefaultGamma() {
        return this.defaultGamma;
    }

    public boolean getGammaCorrect() {
        return this.gammaCorrect;
    }

    public boolean getProgressive() {
        return this.progressive;
    }

    public float getDisplayExponent() {
        return this.displayExponent;
    }

    public int getReadLimit() {
        return this.readLimit;
    }

    public boolean getWarningsFatal() {
        return this.warningsFatal;
    }

    public Rectangle getSourceRegion() {
        return this.sourceRegion != null ? new Rectangle(this.sourceRegion) : null;
    }

    public int getSourceXSubsampling() {
        return this.subsampling[0];
    }

    public int getSourceYSubsampling() {
        return this.subsampling[1];
    }

    public int getSubsamplingXOffset() {
        return this.subsampling[2];
    }

    public int getSubsamplingYOffset() {
        return this.subsampling[3];
    }

    public static final class Builder {
        private static final int[] DEFAULT_SUBSAMPLING = new int[]{1, 1, 0, 0};
        int readLimit = 0;
        float defaultGamma = 0.45455f;
        float displayExponent = 2.2f;
        boolean warningsFatal;
        boolean progressive;
        boolean reduce16 = true;
        boolean gammaCorrect = true;
        Rectangle sourceRegion;
        int[] subsampling = DEFAULT_SUBSAMPLING;
        boolean convertIndexed;

        public Builder() {
        }

        public Builder(PngConfig pngConfig) {
            this.readLimit = pngConfig.readLimit;
            this.defaultGamma = pngConfig.defaultGamma;
            this.displayExponent = pngConfig.displayExponent;
            this.warningsFatal = pngConfig.warningsFatal;
            this.progressive = pngConfig.progressive;
            this.reduce16 = pngConfig.reduce16;
            this.gammaCorrect = pngConfig.gammaCorrect;
            this.subsampling = pngConfig.subsampling;
        }

        public PngConfig build() {
            return new PngConfig(this);
        }

        public Builder reduce16(boolean bl) {
            this.reduce16 = bl;
            return this;
        }

        public Builder defaultGamma(float f) {
            this.defaultGamma = f;
            return this;
        }

        public Builder displayExponent(float f) {
            this.displayExponent = f;
            return this;
        }

        public Builder gammaCorrect(boolean bl) {
            this.gammaCorrect = bl;
            return this;
        }

        public Builder progressive(boolean bl) {
            this.progressive = bl;
            return this;
        }

        public Builder readLimit(int n) {
            this.readLimit = n;
            return this;
        }

        public Builder warningsFatal(boolean bl) {
            this.warningsFatal = bl;
            return this;
        }

        public Builder sourceRegion(Rectangle rectangle) {
            if (rectangle != null) {
                if (rectangle.x < 0 || rectangle.y < 0 || rectangle.width <= 0 || rectangle.height <= 0) {
                    throw new IllegalArgumentException("invalid source region: " + rectangle);
                }
                this.sourceRegion = new Rectangle(rectangle);
            } else {
                this.sourceRegion = null;
            }
            return this;
        }

        public Builder sourceSubsampling(int n, int n2, int n3, int n4) {
            if (n <= 0 || n2 <= 0 || n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
                throw new IllegalArgumentException("invalid subsampling values");
            }
            this.subsampling = new int[]{n, n2, n3, n4};
            return this;
        }

        public Builder convertIndexed(boolean bl) {
            this.convertIndexed = bl;
            return this;
        }
    }
}

