/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.BasicPixelProcessor;
import com.sixlegs.png.ConvertIndexedDestination;
import com.sixlegs.png.Defilterer;
import com.sixlegs.png.Destination;
import com.sixlegs.png.GammaPixelProcessor;
import com.sixlegs.png.PixelProcessor;
import com.sixlegs.png.PngConfig;
import com.sixlegs.png.PngException;
import com.sixlegs.png.PngImage;
import com.sixlegs.png.ProgressUpdater;
import com.sixlegs.png.ProgressivePixelProcessor;
import com.sixlegs.png.RasterDestination;
import com.sixlegs.png.SourceRegionDestination;
import com.sixlegs.png.SubsamplingDestination;
import com.sixlegs.png.TransGammaPixelProcessor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class ImageFactory {
    private static short[] GAMMA_TABLE_45455 = PngImage.createGammaTable(0.45455f, 2.2f, false);
    private static short[] GAMMA_TABLE_100000 = PngImage.createGammaTable(1.0f, 2.2f, false);

    ImageFactory() {
    }

    public static BufferedImage createImage(PngImage pngImage, InputStream inputStream) throws IOException {
        return ImageFactory.createImage(pngImage, inputStream, new Dimension(pngImage.getWidth(), pngImage.getHeight()));
    }

    public static BufferedImage createImage(PngImage pngImage, InputStream inputStream, Dimension dimension) throws IOException {
        Destination destination;
        int n;
        PngConfig pngConfig = pngImage.getConfig();
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = pngImage.getBitDepth();
        int n5 = pngImage.getSamples();
        boolean bl = pngImage.isInterlaced();
        boolean bl2 = ImageFactory.isIndexed(pngImage);
        boolean bl3 = bl2 && pngConfig.getConvertIndexed();
        short[] sArray = pngConfig.getGammaCorrect() ? ImageFactory.getGammaTable(pngImage) : null;
        ColorModel colorModel = ImageFactory.createColorModel(pngImage, sArray, bl3);
        int n6 = n2;
        int n7 = n3;
        Rectangle rectangle = pngConfig.getSourceRegion();
        if (rectangle != null) {
            if (!new Rectangle(n6, n7).contains(rectangle)) {
                throw new IllegalStateException("Source region " + rectangle + " falls outside of " + n2 + "x" + n3 + " image");
            }
            n6 = rectangle.width;
            n7 = rectangle.height;
        }
        int n8 = pngConfig.getSourceXSubsampling();
        int n9 = pngConfig.getSourceYSubsampling();
        if (n8 != 1 || n9 != 1) {
            int n10 = pngConfig.getSubsamplingXOffset();
            int n11 = pngConfig.getSubsamplingYOffset();
            int n12 = ImageFactory.calcSubsamplingSize(n6, n8, n10, 'X');
            n = ImageFactory.calcSubsamplingSize(n7, n9, n11, 'Y');
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n12, n);
            destination = new SubsamplingDestination(writableRaster, n2, n8, n9, n10, n11);
        } else {
            destination = new RasterDestination(colorModel.createCompatibleWritableRaster(n6, n7), n2);
        }
        if (rectangle != null) {
            destination = new SourceRegionDestination(destination, rectangle);
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, destination.getRaster(), false, null);
        PixelProcessor pixelProcessor = null;
        if (!bl2) {
            int[] nArray = (int[])pngImage.getProperty("transparency", int[].class, false);
            int n13 = n = n4 == 16 && pngConfig.getReduce16() ? 8 : 0;
            if (n != 0 || nArray != null || sArray != null) {
                if (sArray == null) {
                    sArray = ImageFactory.getIdentityTable(n4 - n);
                }
                pixelProcessor = nArray != null ? new TransGammaPixelProcessor(destination, sArray, nArray, n) : new GammaPixelProcessor(destination, sArray, n);
            }
        }
        if (bl3) {
            IndexColorModel indexColorModel = (IndexColorModel)ImageFactory.createColorModel(pngImage, sArray, false);
            destination = new ConvertIndexedDestination(destination, n2, indexColorModel, (ComponentColorModel)colorModel);
        }
        if (pixelProcessor == null) {
            pixelProcessor = new BasicPixelProcessor(destination, n5);
        }
        if (pngConfig.getProgressive() && bl && !bl3) {
            pixelProcessor = new ProgressivePixelProcessor(destination, pixelProcessor, n2, n3);
        }
        pixelProcessor = new ProgressUpdater(pngImage, bufferedImage, pixelProcessor);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream, new Inflater(), 4096);
        Defilterer defilterer = new Defilterer(inflaterInputStream, n4, n5, n2, pixelProcessor);
        if (bl) {
            boolean bl4 = defilterer.defilter(0, 0, 8, 8, (n2 + 7) / 8, (n3 + 7) / 8) && pngImage.handlePass(bufferedImage, 0) && defilterer.defilter(4, 0, 8, 8, (n2 + 3) / 8, (n3 + 7) / 8) && pngImage.handlePass(bufferedImage, 1) && defilterer.defilter(0, 4, 4, 8, (n2 + 3) / 4, (n3 + 3) / 8) && pngImage.handlePass(bufferedImage, 2) && defilterer.defilter(2, 0, 4, 4, (n2 + 1) / 4, (n3 + 3) / 4) && pngImage.handlePass(bufferedImage, 3) && defilterer.defilter(0, 2, 2, 4, (n2 + 1) / 2, (n3 + 1) / 4) && pngImage.handlePass(bufferedImage, 4) && defilterer.defilter(1, 0, 2, 2, n2 / 2, (n3 + 1) / 2) && pngImage.handlePass(bufferedImage, 5) && defilterer.defilter(0, 1, 1, 2, n2, n3 / 2) && pngImage.handlePass(bufferedImage, 6);
        } else {
            boolean bl5 = defilterer.defilter(0, 0, 1, 1, n2, n3) && pngImage.handlePass(bufferedImage, 0);
        }
        destination.done();
        return bufferedImage;
    }

    private static short[] getGammaTable(PngImage pngImage) {
        PngConfig pngConfig = pngImage.getConfig();
        if ((pngImage.getBitDepth() != 16 || pngConfig.getReduce16()) && pngConfig.getDisplayExponent() == 2.2f) {
            float f = pngImage.getGamma();
            if (f == 0.45455f) {
                return GAMMA_TABLE_45455;
            }
            if (f == 1.0f) {
                return GAMMA_TABLE_100000;
            }
        }
        return pngImage.getGammaTable();
    }

    private static int calcSubsamplingSize(int n, int n2, int n3, char c) {
        int n4 = (n - n3 + n2 - 1) / n2;
        if (n4 == 0) {
            throw new IllegalStateException("Source " + c + " subsampling " + n2 + ", offset " + n3 + " is invalid for image dimension " + n);
        }
        return n4;
    }

    private static boolean isIndexed(PngImage pngImage) {
        int n = pngImage.getColorType();
        return n == 3 || n == 0 && pngImage.getBitDepth() < 16;
    }

    private static ColorModel createColorModel(PngImage pngImage, short[] sArray, boolean bl) throws PngException {
        int n;
        Map map = pngImage.getProperties();
        int n2 = pngImage.getColorType();
        int n3 = pngImage.getBitDepth();
        int n4 = n = n3 == 16 && pngImage.getConfig().getReduce16() ? 8 : n3;
        if (ImageFactory.isIndexed(pngImage) && !bl) {
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            if (n2 == 3) {
                byArray4 = (byte[])pngImage.getProperty("palette", byte[].class, true);
                var11_10 = byArray4.length / 3;
                byArray3 = new byte[var11_10];
                byArray2 = new byte[var11_10];
                byArray = new byte[var11_10];
                int n5 = 0;
                for (int i = 0; i < var11_10; ++i) {
                    byArray3[i] = byArray4[n5++];
                    byArray2[i] = byArray4[n5++];
                    byArray[i] = byArray4[n5++];
                }
                ImageFactory.applyGamma(byArray3, sArray);
                ImageFactory.applyGamma(byArray2, sArray);
                ImageFactory.applyGamma(byArray, sArray);
            } else {
                int n6 = 1 << n3;
                byArray2 = byArray = new byte[n6];
                byArray3 = byArray;
                for (var11_10 = 0; var11_10 < n6; ++var11_10) {
                    byArray3[var11_10] = (byte)(var11_10 * 255 / (n6 - 1));
                }
                ImageFactory.applyGamma(byArray3, sArray);
            }
            if (map.containsKey("palette_alpha")) {
                byArray4 = (byte[])pngImage.getProperty("palette_alpha", byte[].class, true);
                byte[] byArray5 = new byte[byArray3.length];
                Arrays.fill(byArray5, byArray4.length, byArray3.length, (byte)-1);
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                return new IndexColorModel(n, byArray3.length, byArray3, byArray2, byArray, byArray5);
            }
            int n7 = -1;
            if (map.containsKey("transparency")) {
                n7 = ((int[])pngImage.getProperty("transparency", int[].class, true))[0];
            }
            return new IndexColorModel(n, byArray3.length, byArray3, byArray2, byArray, n7);
        }
        int n8 = n == 16 ? 1 : 0;
        int n9 = n2 == 0 || n2 == 4 ? 1003 : 1000;
        int n10 = pngImage.getTransparency();
        return new ComponentColorModel(ColorSpace.getInstance(n9), null, n10 != 1, false, n10, n8);
    }

    private static void applyGamma(byte[] byArray, short[] sArray) {
        if (sArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)sArray[0xFF & byArray[i]];
            }
        }
    }

    private static short[] getIdentityTable(int n) {
        int n2 = 1 << n;
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = (short)i;
        }
        return sArray;
    }
}

