/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngInputStream;
import com.sixlegs.png.StateMachine;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class ImageDataInputStream
extends InputStream {
    private final PngInputStream in;
    private final StateMachine machine;
    private final byte[] onebyte = new byte[1];
    private boolean done;

    public ImageDataInputStream(PngInputStream pngInputStream, StateMachine stateMachine) {
        this.in = pngInputStream;
        this.machine = stateMachine;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.onebyte, 0, 1) == -1 ? -1 : 0xFF & this.onebyte[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.done) {
            return -1;
        }
        try {
            int n3 = 0;
            while (n3 != n2 && !this.done) {
                while (n3 != n2 && this.in.getRemaining() > 0) {
                    int n4 = Math.min(n2 - n3, this.in.getRemaining());
                    this.in.readFully(byArray, n + n3, n4);
                    n3 += n4;
                }
                if (this.in.getRemaining() > 0) continue;
                this.in.endChunk(this.machine.getType());
                this.machine.nextState(this.in.startChunk());
                this.done = this.machine.getType() != 1229209940;
            }
            return n3;
        }
        catch (EOFException eOFException) {
            this.done = true;
            return -1;
        }
    }
}

